/*
 * $Id: //depot/prod/newport_news/main/modules/autozapi-annotations/src/main/java/com/netapp/common/zapi/annotation/Range.java#3 $
 *
 * Copyright (c) 2007 Network Appliance, Inc.
 * All rights reserved.
 */
package com.netapp.common.zapi.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;

/**
 * Document the valid range of an integer.
 * Valid on @{link Api} {@link Input} or {@link Output} parameters
 * and {@link Typedef} {@link Element} fields and methods.
 * <p>
 * A range is defined as either a literal integer value
 * or a power of two written as <samp>2^31</samp> or <samp>2^31-1</samp>
 *
 * @author sunday
 * @version $Revision: #3 $ $Date: 2011/06/24 $
 */
@Target(ElementType.METHOD)
@Documented
public @interface Range {
    /** Minumum legal value for this field */
    String min();
    /** Maximum legal value for this field */
    String max();
}
