/*
 * $Id: //depot/prod/newport_news/main/modules/autozapi-annotations/src/main/java/com/netapp/common/zapi/annotation/Status.java#2 $
 *
 * Copyright (c) 2007 Network Appliance, Inc.
 * All rights reserved.
 */
package com.netapp.common.zapi.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;


/**
 * Document the support status of a Zephyr {@link Api} for external users.
 * Valid only on classes zapi api call classes annotated with {@link Api}
 *
 * @see StatusEnum
 * @see Api
 * @author sunday
 * @version $Revision: #2 $ $Date: 2011/06/24 $
 */
@Target({ElementType.TYPE, ElementType.METHOD})
@Documented
public @interface Status {
    /** The support status of this api */
    StatusEnum value();
}
