/*
 * $Id: //depot/prod/newport_news/main/modules/autozapi-annotations/src/main/java/com/netapp/common/zapi/annotation/StatusEnum.java#4 $
 *
 * Copyright (c) 2007 Network Appliance, Inc.
 * All rights reserved.
 */
package com.netapp.common.zapi.annotation;



/**
 * Document the support status of this Zephyr api for external users.
 *
 * @see Status
 * @see Api
 * @author sunday
 * @version $Revision: #4 $ $Date: 2011/06/24 $
 */
public enum StatusEnum {
    /*
     * If we ever add a new value to this enum, place it in
     * in this list in order of external supportability / visibility,
     * with the most public Status last.
     */
    /** This zapi is proposed for a future product release */
    PROPOSED("proposed"),
    /** This zapi is for internal netapp use only */
    INTERNAL("internal"),
    /** This zapi is for testing purposes only*/
    TEST("test"),
    /** This zapi is for debug use only */
    DEBUG("debug"),
    /** This zapi is not supported for external use */
    UNSUPPORTED("unsupported"),
    /** This zapi is publicly documented and supported for external use */
    PUBLIC("supported");


    private final String value;

    private StatusEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static StatusEnum parse(String statusString) {
        statusString = statusString.trim().toUpperCase();
        if (statusString.equals("SUPPORTED")) {
            statusString = "PUBLIC";
        }
        return StatusEnum.valueOf(statusString);

    }
}
