/*
 * $Id: //depot/prod/newport_news/main/modules/autozapi-annotations/src/main/java/com/netapp/common/zapi/annotation/Typedef.java#2 $
 *
 * Copyright (c) 2007 Network Appliance, Inc.
 * All rights reserved.
 */
package com.netapp.common.zapi.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Define a class as representing a Zephyr api typedef struct.
 * @see Element
 * @author sunday
 * @version $Revision: #2 $ $Date: 2011/06/24 $
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
public @interface Typedef {
    /**
     * The zapi name for this typedef. If not specified,
     * the name will be guessed from class.getSimpleName()
     */
    String value() default "";
}
