"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getOptionM = exports.alt = exports.flatMap = exports.chain = exports.ap = exports.map = exports.getOrElse = exports.matchE = exports.match = exports.fromEither = exports.fromPredicate = exports.chainOptionK = exports.fromOptionK = exports.chainNullableK = exports.fromNullableK = exports.fromNullable = exports.fromF = exports.zero = exports.some = void 0;
var Apply_1 = require("./Apply");
var function_1 = require("./function");
var Functor_1 = require("./Functor");
var O = __importStar(require("./Option"));
function some(F) {
    return (0, function_1.flow)(O.some, F.of);
}
exports.some = some;
function zero(F) {
    return (0, function_1.constant)(F.of(O.none));
}
exports.zero = zero;
function fromF(F) {
    return function (ma) { return F.map(ma, O.some); };
}
exports.fromF = fromF;
function fromNullable(F) {
    return (0, function_1.flow)(O.fromNullable, F.of);
}
exports.fromNullable = fromNullable;
function fromNullableK(F) {
    var fromNullableF = fromNullable(F);
    return function (f) { return (0, function_1.flow)(f, fromNullableF); };
}
exports.fromNullableK = fromNullableK;
function chainNullableK(M) {
    var chainM = chain(M);
    var fromNullableKM = fromNullableK(M);
    return function (f) { return chainM(fromNullableKM(f)); };
}
exports.chainNullableK = chainNullableK;
function fromOptionK(F) {
    return function (f) { return (0, function_1.flow)(f, F.of); };
}
exports.fromOptionK = fromOptionK;
function chainOptionK(M) {
    var chainM = chain(M);
    var fromOptionKM = fromOptionK(M);
    return function (f) { return chainM(fromOptionKM(f)); };
}
exports.chainOptionK = chainOptionK;
function fromPredicate(F) {
    return function (predicate) {
        return function (a) {
            return F.of(O.fromPredicate(predicate)(a));
        };
    };
}
exports.fromPredicate = fromPredicate;
function fromEither(F) {
    return (0, function_1.flow)(O.fromEither, F.of);
}
exports.fromEither = fromEither;
function match(F) {
    return function (onNone, onSome) { return function (ma) { return F.map(ma, O.match(onNone, onSome)); }; };
}
exports.match = match;
function matchE(M) {
    return function (onNone, onSome) { return function (ma) { return M.chain(ma, O.match(onNone, onSome)); }; };
}
exports.matchE = matchE;
function getOrElse(M) {
    return function (onNone) { return function (fa) { return M.chain(fa, O.match(onNone, M.of)); }; };
}
exports.getOrElse = getOrElse;
function map(F) {
    return (0, Functor_1.map)(F, O.Functor);
}
exports.map = map;
function ap(F) {
    return (0, Apply_1.ap)(F, O.Apply);
}
exports.ap = ap;
function chain(M) {
    var flatMapM = flatMap(M);
    return function (f) { return function (ma) { return flatMapM(ma, f); }; };
}
exports.chain = chain;
/** @internal */
function flatMap(M) {
    var zeroM = zero(M);
    return function (ma, f) {
        return M.chain(ma, O.match(function () { return zeroM(); }, f));
    };
}
exports.flatMap = flatMap;
function alt(M) {
    var _some = some(M);
    return function (second) { return function (first) { return M.chain(first, O.match(second, _some)); }; };
}
exports.alt = alt;
/** @deprecated */
function getOptionM(M) {
    var apM = ap(M);
    var mapM = map(M);
    var chainM = chain(M);
    var altM = alt(M);
    var foldM = matchE(M);
    var getOrElseM = getOrElse(M);
    var zeroM = zero(M);
    return {
        map: function (fa, f) { return (0, function_1.pipe)(fa, mapM(f)); },
        ap: function (fab, fa) { return (0, function_1.pipe)(fab, apM(fa)); },
        of: some(M),
        chain: function (ma, f) { return (0, function_1.pipe)(ma, chainM(f)); },
        alt: function (fa, that) { return (0, function_1.pipe)(fa, altM(that)); },
        fold: function (fa, onNone, onSome) { return (0, function_1.pipe)(fa, foldM(onNone, onSome)); },
        getOrElse: function (fa, onNone) { return (0, function_1.pipe)(fa, getOrElseM(onNone)); },
        fromM: fromF(M),
        none: function () { return zeroM(); }
    };
}
exports.getOptionM = getOptionM;
