# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/)
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [v1.7.0](https://github.com/inspect-js/is-equal/compare/v1.6.5...v1.7.0) - 2023-10-20

## [v1.6.5](https://github.com/inspect-js/is-equal/compare/v1.6.4...v1.6.5) - 2023-10-20

### Commits

- [New] compare `.toString`, `.valueOf`, and `[Symbol.toPrimitive]` completions [`fa8d0ae`](https://github.com/inspect-js/is-equal/commit/fa8d0aeed446cf0ea4900743171afbbe4294ad45)
- [meta] use `npmignore` to autogenerate an npmignore file [`919afcd`](https://github.com/inspect-js/is-equal/commit/919afcddd8bb6b4513c3a4837b7491ae395ce8cf)
- [Tests] increase coverage [`bbe8513`](https://github.com/inspect-js/is-equal/commit/bbe8513ab9a40c54c313b5957ad1ee78deb8dfd4)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `aud`, `auto-changelog`, `es-value-fixtures`, `foreach`, `object.assign`, `tape` [`157a4fe`](https://github.com/inspect-js/is-equal/commit/157a4feec8343aa0f72912440bab6b580d561f54)
- [Refactor] use `hasown` instead of `has` [`590f3f6`](https://github.com/inspect-js/is-equal/commit/590f3f67419a02a43f1f6b87cd7f8e1a44b02d27)
- [Fix] improve error message when callability is mismatched [`dc0f577`](https://github.com/inspect-js/is-equal/commit/dc0f5776e33b64e4cda78795ab973ecdde3f4a2e)
- [Deps] update `functions-have-names`, `has-bigints`, `has-symbols`, `is-callable`, `is-number-object`, `object-inspect` [`c066c94`](https://github.com/inspect-js/is-equal/commit/c066c9418d96c1b2b23342c2c1045ebaad2072b7)
- [actions] update rebase action to use reusable workflow [`34eeaf5`](https://github.com/inspect-js/is-equal/commit/34eeaf5072253d470ab5f8a13d0788f0f0f282b9)
- [Deps] update `es-get-iterator`, `object-inspect`, `object.entries`, `object.getprototypeof` [`8ce483c`](https://github.com/inspect-js/is-equal/commit/8ce483cbd006c9bb3880784bec21f5c46d0ec236)
- [Dev Deps] update `@ljharb/eslint-config`, `aud`, `es6-shim`, `tape` [`b140b08`](https://github.com/inspect-js/is-equal/commit/b140b080e82cc8746c819a3970f63644abcf3013)
- [Tests] use `for-each` instead of `foreach` [`8baba96`](https://github.com/inspect-js/is-equal/commit/8baba968df07d2fd48ec0f7a3ca895e4058a5a9f)
- [Deps] update `object-inspect` [`65f0b06`](https://github.com/inspect-js/is-equal/commit/65f0b06bb800d81b1f26b88fea417c814edaccca)
- [Dev Deps] update `tape` [`dca5479`](https://github.com/inspect-js/is-equal/commit/dca54796c8f3ea85f970403f3df1b81e7cf4025e)

## [v1.6.4](https://github.com/inspect-js/is-equal/compare/v1.6.3...v1.6.4) - 2022-01-10

### Commits

- [actions] reuse common workflows [`c8e9a71`](https://github.com/inspect-js/is-equal/commit/c8e9a716715788f472ee84ba55f21b775eb1247f)
- [Fix] still check own properties on Dates, RegExps, and Functions [`3295149`](https://github.com/inspect-js/is-equal/commit/32951490626e3b4e6929bd0b06e50f4f4d82ebda)
- [actions] update codecov uploader [`3157da9`](https://github.com/inspect-js/is-equal/commit/3157da9afdaabc6fb2423eea484aa47b75caf6e5)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `safe-publish-latest`, `tape` [`ee76f73`](https://github.com/inspect-js/is-equal/commit/ee76f7362b3b6d19fe908cf8f9f3b1510aa68dd6)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `tape` [`0653181`](https://github.com/inspect-js/is-equal/commit/0653181b78aedcc4f596c8e159e3cb0ff0962208)
- [Deps] update `is-bigint`, `object.entries`, `object.getprototypeof` [`282a4e6`](https://github.com/inspect-js/is-equal/commit/282a4e68fceba7d8ce1d42b41fac4056a4eb97df)
- [Deps] update `object-inspect` [`b084bdf`](https://github.com/inspect-js/is-equal/commit/b084bdfaea7dd5b5cf04ef77dbeaa3e0785137a8)

## [v1.6.3](https://github.com/inspect-js/is-equal/compare/v1.6.2...v1.6.3) - 2021-08-06

### Commits

- [Refactor] increase coverage; remove redundant branches [`c6b6672`](https://github.com/inspect-js/is-equal/commit/c6b66729d9acfafcdeabf519091bc645a30d91ad)
- [Deps] update `is-bigint`, `is-boolean-object`, `is-callable`, `is-date-object`, `is-generator-function`, `is-number-object`, `is-regex`, `is-string`, `is-symbol`, `object-inspect`, `object.entries` [`a3b5498`](https://github.com/inspect-js/is-equal/commit/a3b54982402e4af97be541b4321e1f22073ba1b4)
- [Tests] `tape` v5.3 exposed a bug in corejs tests; use `--require` instead [`a1e004e`](https://github.com/inspect-js/is-equal/commit/a1e004e13537e2bc8ed1adc1f02336777b832a52)
- [Refactor] use `has-symbols/shams` and `has-bigints` to more robustly detect these things [`4f3aee4`](https://github.com/inspect-js/is-equal/commit/4f3aee40f5791b20a7302f10c5566f17a12ca38d)
- [Dev Deps] update `auto-changelog`, `core-js`, `eslint`, `tape` [`d6a7b8e`](https://github.com/inspect-js/is-equal/commit/d6a7b8ecc0a8672405d501661eff372d70b83586)
- [readme] fix usage code sample [`04ce4d0`](https://github.com/inspect-js/is-equal/commit/04ce4d063880b441db57056c35d79e0b5a909549)

## [v1.6.2](https://github.com/inspect-js/is-equal/compare/v1.6.1...v1.6.2) - 2021-05-08

### Commits

- [Tests] increase coverage [`18f85ad`](https://github.com/inspect-js/is-equal/commit/18f85ad1e0529eb5c5ce4f30c704f696aa5bf2e7)
- [Tests] migrate tests to Github Actions [`61f82f7`](https://github.com/inspect-js/is-equal/commit/61f82f73825d6014aa95197ec873d1f6707de704)
- [Tests] run core-js tests on v2 and v3 [`aaa111d`](https://github.com/inspect-js/is-equal/commit/aaa111dd432dbc6a74e8a0832c73f95aeda08d1b)
- [actions] use `node/install` instead of `node/run`; use `codecov` action [`db83237`](https://github.com/inspect-js/is-equal/commit/db83237b8b787b8fc4d204e7036847141761cfbb)
- [meta] remove unused Makefile and associated utilities [`cb9cf3f`](https://github.com/inspect-js/is-equal/commit/cb9cf3f9171e9790a5b8127757814bca50f5ff9e)
- [Tests] run `nyc` on all tests [`6a55013`](https://github.com/inspect-js/is-equal/commit/6a55013564996c87e9c5566570495a8b99b85fc5)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `tape`, `make-arrow-function`, `make-generator-function` [`adf932c`](https://github.com/inspect-js/is-equal/commit/adf932c8961591d6eec8ab72653225b0246fb614)
- [Refactor] use `object.getprototypeof` [`ed3445b`](https://github.com/inspect-js/is-equal/commit/ed3445b90bacfc6cf69a981dee4e6a1a09416eaf)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `aud`, `auto-changelog`, `es6-shim` [`abd29fa`](https://github.com/inspect-js/is-equal/commit/abd29fa8aedfe277f2651daf6ea191d12a3b3b0a)
- [Deps] update `es-get-iterator`, `functions-have-names`, `is-boolean-object`, `is-callable`, `is-date-object`, `is-number-object`, `is-regex`, `is-symbol`, `is-string`, `object.entries`, `which-collection` [`fbdb778`](https://github.com/inspect-js/is-equal/commit/fbdb778805e03bf6a3af261768b4a4be17308d48)
- [Fix] `why`: compare two numbers properly [`297b810`](https://github.com/inspect-js/is-equal/commit/297b810144fe6f8f15d99a9ad346be55d59ac61e)
- [Deps] update `is-boolean-object`, `is-date-object`, `is-generator-function`, `is-number-object`, `is-regex`, `is-string`, `object-inspect` [`60aef5e`](https://github.com/inspect-js/is-equal/commit/60aef5e1d4a159f7e573d2acd54a47148a5c3502)
- [Deps] update `es-get-iterator`, `is-bigint`, `is-callable`, `is-generator-function`, `is-regex`, `object-inspect`, `object.entries` [`25cc9cb`](https://github.com/inspect-js/is-equal/commit/25cc9cb8b7aa7535e1328223494564dc1831ddd4)
- [patch] "arrow function" should not be capitalized; "Generator function" is the proper term [`4fa31c7`](https://github.com/inspect-js/is-equal/commit/4fa31c7d4463555e9803f564aacad167511445a6)
- [actions] add "Allow Edits" workflow [`227f80e`](https://github.com/inspect-js/is-equal/commit/227f80ec4f1f1944e9879e3cb1f09923b4bae138)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `aud`, `has-symbols`, `tape` [`4bd6461`](https://github.com/inspect-js/is-equal/commit/4bd64617ee644f576ce0f71cf7cefc0245ae9594)
- [Deps] update `es-get-iterator`, `functions-have-names`, `is-boolean-object`, `is-callable`, `which-boxed-primitive` [`b9bdb70`](https://github.com/inspect-js/is-equal/commit/b9bdb7021ecb7b2381fc2062215b4a91fcb49913)
- [readme] fix broken URLs [`1d39cbf`](https://github.com/inspect-js/is-equal/commit/1d39cbf4a3d8070a075e0d82ad9a832958e260f4)
- [Deps] update `is-bigint`, `is-date-object`, `is-regex`, `object-inspect` [`020835e`](https://github.com/inspect-js/is-equal/commit/020835e1a0d4524950510d278f805ad0cc4c5652)
- [readme] use https URLs [`fd35312`](https://github.com/inspect-js/is-equal/commit/fd353127a454f6ca4e110ebac9a28a9121313eed)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `has-bigints`, `tape` [`3a58efc`](https://github.com/inspect-js/is-equal/commit/3a58efc39c9ee1c3863c8d49dee6036bf7ef5b54)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `tape`, `aud` [`733f027`](https://github.com/inspect-js/is-equal/commit/733f0272faa4f2b8cfdc90e8a8a0b7825da38e1f)
- [readme] add actions and codecov badges [`a53d5e4`](https://github.com/inspect-js/is-equal/commit/a53d5e47f96c0793f51a57c30a3b302cf0ee2f71)
- [Tests] exclude deprecated, unused files from coverage [`bdd471b`](https://github.com/inspect-js/is-equal/commit/bdd471b54169121dfbcd1ac0fdfa243dd5af140a)
- [actions] switch Automatic Rebase workflow to `pull_request_target` event [`115392b`](https://github.com/inspect-js/is-equal/commit/115392b8ca3efba6a9721c4435bb72d60167ce70)
- [Dev Deps] update `aud`, `tape` [`5e6018c`](https://github.com/inspect-js/is-equal/commit/5e6018c435ee11810c94c5c7445afe6a4bf98439)
- [Dev Deps] update `auto-changelog`, `tape` [`c4fde3a`](https://github.com/inspect-js/is-equal/commit/c4fde3abd8699e6389b245483e68a3b69352f8b0)
- [meta] use `prepublishOnly` script for npm 7+ [`143ba39`](https://github.com/inspect-js/is-equal/commit/143ba39689d249c89bf0e0fdb67dfbd2f397b1e6)
- [readme] remove travis badge [`0583b0f`](https://github.com/inspect-js/is-equal/commit/0583b0f4ad865db21d9e4cbdf7f77b152b25d90a)
- [Dev Deps] update `auto-changelog`; add `aud` [`afb177b`](https://github.com/inspect-js/is-equal/commit/afb177b9ccdae24ac94f7c52deac19bf6fd72d8b)
- [Dev Deps] unpin `core-js` v3 [`d44ccc0`](https://github.com/inspect-js/is-equal/commit/d44ccc0b095c6c2e60e77ed635ec1c4008c09522)
- [Dev Deps] pin `core-js` v3 to &lt; v3.9 [`63fd454`](https://github.com/inspect-js/is-equal/commit/63fd454dadd3319194384b7bfa90d4f2d3b4f4fc)
- [Deps] update `object.entries` [`e5adb39`](https://github.com/inspect-js/is-equal/commit/e5adb39ed305c9b9ad95df780fa2b665711fc9bf)
- [Tests] only audit prod deps [`5e285d5`](https://github.com/inspect-js/is-equal/commit/5e285d5fae8e24b5be5c8b473d5f416a9357fd99)
- [actions] update workflows [`7945708`](https://github.com/inspect-js/is-equal/commit/794570862c0531e11eab62e05eef4bed5bd1e0e5)

## [v1.6.1](https://github.com/inspect-js/is-equal/compare/v1.6.0...v1.6.1) - 2019-11-28

### Commits

- [Refactor] use `es-get-iterator` internally [`09dac2f`](https://github.com/inspect-js/is-equal/commit/09dac2fd7a02385dddf9c09e3a1d27d5abf0622b)
- [Fix] `getSymbolIterator`: make sure it can handle core-js also [`d9d9198`](https://github.com/inspect-js/is-equal/commit/d9d91980c2b396060cba4cba7ef4934565d56fb7)
- [readme] fix repo URLs, remove testling [`35e5e37`](https://github.com/inspect-js/is-equal/commit/35e5e375a7319c0e515e5e8830c0c605637e199d)
- [actions] add automatic rebasing / merge commit blocking [`6ddd2fc`](https://github.com/inspect-js/is-equal/commit/6ddd2fc90d3c9c7226f9a84a33093f80ec9d274b)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `has-symbols` [`4a3bb24`](https://github.com/inspect-js/is-equal/commit/4a3bb24d1ad2b0f00babcc54b25e2526513837aa)
- [Deps] update `is-symbol` [`083c8b6`](https://github.com/inspect-js/is-equal/commit/083c8b60954848911f1fe4e2e1be3580cd9fbaa0)
- docs: fix header syntax [`8142a3b`](https://github.com/inspect-js/is-equal/commit/8142a3be6663260e4a83c8dfd7f18a90390d152b)

## [v1.6.0](https://github.com/inspect-js/is-equal/compare/v1.5.5...v1.6.0) - 2019-11-11

### Commits

- [meta] add `auto-changelog` [`968f3e5`](https://github.com/inspect-js/is-equal/commit/968f3e5335363d18416048f029f519bc1f8a9720)
- [Tests] use shared travis-ci configs [`600f4b3`](https://github.com/inspect-js/is-equal/commit/600f4b3417a8937c730dbd9e087af1e44fff6612)
- [Dev Deps] remove `jscs` [`23c2e2e`](https://github.com/inspect-js/is-equal/commit/23c2e2e5a548871e4afb478f9f2da25b2c7247f1)
- [New] add support for BigInts [`bf31461`](https://github.com/inspect-js/is-equal/commit/bf3146197599bd6248cf05fd2825d8aa736ba3f4)
- [Tests] up to `node` `v11.6`, `v10.15`, `v8.15`, `v6.16` [`6145b4e`](https://github.com/inspect-js/is-equal/commit/6145b4e2224127aeb45655251e374bb31ba424cb)
- [Tests] up to `node` `v8.2`, `v7.10`, `v6.11`, `v4.8`; newer npm breaks on older nodes [`48cf16d`](https://github.com/inspect-js/is-equal/commit/48cf16dda943fbb63459a2a83bf5ba06658c0abe)
- [Tests] up to `node` `v10.1`, `v9.11`, `v8.11`, `v6.14`, `v4.9` [`94c2b86`](https://github.com/inspect-js/is-equal/commit/94c2b86e9e2d8c510218dc1e2dd6f9929c81c11e)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`; add `safe-publish-latest` [`5809415`](https://github.com/inspect-js/is-equal/commit/58094154837a7111b27895a5ffea8d7325f03503)
- [Tests] up to `node` `v9.2`, `v8.9`, `v6.12`; use `nvm install-latest-npm`; pin included builds to LTS [`7c6528d`](https://github.com/inspect-js/is-equal/commit/7c6528dca09a3a81b5ea1a7169e5288465835cf6)
- [Tests] up to `node` `v12.9`, `v11.15`, `v10.16`, `v8.16` [`2ea3e84`](https://github.com/inspect-js/is-equal/commit/2ea3e84ea3e52c96e6863d40a3530bb17b9fb0ba)
- [Tests] up to `node` `v11.13`, `v6.17` [`41b48e8`](https://github.com/inspect-js/is-equal/commit/41b48e8ab3f1690ddbfbd35b163f683fd765d0cc)
- [Dev Deps] update `@ljharb/eslint-config`, `eslint`, `nsp`, `semver`, `tape` [`4eacf82`](https://github.com/inspect-js/is-equal/commit/4eacf8227a70423403653bcf82ef4668e2628755)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `core-js`, `covert`, `es6-shim`, `replace`, `semver`, `tape` [`e5a6848`](https://github.com/inspect-js/is-equal/commit/e5a6848e063be9ecd84d09ffd2046f285f4ca1a7)
- [meta] create FUNDING.yml [`fbce9ee`](https://github.com/inspect-js/is-equal/commit/fbce9ee494e27f0028bf55b9486837ab7b3a3d50)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `core-js`, `es6-shim`, `replace`, `semver` [`298d528`](https://github.com/inspect-js/is-equal/commit/298d528f7649e58d73e89da8819d95bf8083e93e)
- [Dev Deps] update `replace`, `semver, `tape`, `nsp`, `eslint`, `core-js`, `@ljharb/eslint-config` [`8ee88e7`](https://github.com/inspect-js/is-equal/commit/8ee88e78ebed836a78495418435950d2de7cd58e)
- [Tests] use `has-symbols` [`da43e4d`](https://github.com/inspect-js/is-equal/commit/da43e4d9a1a4e43b4808b4741a245982abff8c0c)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `replace`, `semver`, `tape` [`0db9191`](https://github.com/inspect-js/is-equal/commit/0db9191cf102a211a77fbafa2f42680683645b4b)
- [Tests] use `npm audit` instead of `nsp` [`3a93636`](https://github.com/inspect-js/is-equal/commit/3a9363678cd44801622fc1b17c2ddf28912e1d34)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `semver` [`f35a03a`](https://github.com/inspect-js/is-equal/commit/f35a03a04199ea064fa9d82a56b33ad4d1cdacbe)
- [Dev Deps] update `eslint`, `nsp`, `@ljharb/eslint-config`, `core-js` [`63967ba`](https://github.com/inspect-js/is-equal/commit/63967ba2ab25bb430769bd51eb717a99e508b1b8)
- [Tests] test on both core-js 3 and 2 [`9c4e491`](https://github.com/inspect-js/is-equal/commit/9c4e491acdd06c5fee5e85e8f1214c83f6da6135)
- [Tests] use `npx aud` instead of `npm audit` with hoops [`494ba19`](https://github.com/inspect-js/is-equal/commit/494ba198c2b615407dfa966edb82443d6851424a)
- Only apps should have lockfiles [`8dbdcc6`](https://github.com/inspect-js/is-equal/commit/8dbdcc68e7d4f80ac85c7c77ee935fc65b3991a2)
- [meta] add `funding` field [`e350d2f`](https://github.com/inspect-js/is-equal/commit/e350d2fbc779ec8e1313cadbb049d2d863170300)
- [Tests] fix linting [`f31ff12`](https://github.com/inspect-js/is-equal/commit/f31ff1227017abd2606994a1a525164f50e0004a)
- [Deps] update `is-callable`, `is-symbol` [`65c9e04`](https://github.com/inspect-js/is-equal/commit/65c9e046d1a07537ac3e8dd9854449006a563a75)
- [Dev Deps] update `core-js`, `tape` [`87e23ee`](https://github.com/inspect-js/is-equal/commit/87e23ee2b0899731b95715d2ce63c6dce293b9de)
- [Tests] fix linting errors [`54f3476`](https://github.com/inspect-js/is-equal/commit/54f3476bd508d6d0b3801af80c10f250ac464eaa)
- [meta] remove unused `nsp` [`826e6f2`](https://github.com/inspect-js/is-equal/commit/826e6f25b68996724bff0ff1307bfcc0dca4ee46)
- [Deps] update `object.entries` [`fce1776`](https://github.com/inspect-js/is-equal/commit/fce17764c498058a38b788378d39ae39223d2cce)
- [Deps] update `has` [`a3443e1`](https://github.com/inspect-js/is-equal/commit/a3443e1230b3795fc087422e558b17741d8ecb39)
- [Deps] update `is-generator-function` [`d11429a`](https://github.com/inspect-js/is-equal/commit/d11429a405444dfc511638c0077341b089d6f62a)
- [Deps] update `is-regex` [`9257a28`](https://github.com/inspect-js/is-equal/commit/9257a281ac6b0f9e7a0f800e1e1089be3d751dde)

## [v1.5.5](https://github.com/inspect-js/is-equal/compare/v1.5.4...v1.5.5) - 2017-02-05

### Fixed

- [Fix] remove early failure for stringified arrays, to handle Symbols in arrays. [`#194`](https://github.com/mjackson/expect/issues/194)

### Commits

- [Dev Deps] update `eslint`, `@ljharb/eslint-config` [`35549f1`](https://github.com/inspect-js/is-equal/commit/35549f10eacef3a927caf39faa9a64a71c4e72d4)

## [v1.5.4](https://github.com/inspect-js/is-equal/compare/v1.5.3...v1.5.4) - 2017-01-25

### Fixed

- Exclude `html` files, which were never intentionally added to the package. [`#34`](https://github.com/inspect-js/is-equal/issues/34)

### Commits

- [Tests] up to `node` `v7.4`, `v4.7`; improve test matrix [`6f20b3d`](https://github.com/inspect-js/is-equal/commit/6f20b3dc5c8a497626dc6a37c9cbdd7273b74984)
- [Tests] pass functions through `Object` to avoid function name inference in node 7. [`99ba6de`](https://github.com/inspect-js/is-equal/commit/99ba6decfe53553e92f25f15fea4fcb9f42a1fd9)
- [Tests] up to `node` `v7.0`, `v6.9`, `v4.6`; improve test matrix [`f834855`](https://github.com/inspect-js/is-equal/commit/f834855c8a303bb5d9082703870b12ae3749bdb9)
- [Dev Deps] update `tape`, `jscs`, `semver`, `eslint`, `@ljharb/eslint-config`, `nsp` [`a53cc6f`](https://github.com/inspect-js/is-equal/commit/a53cc6f637337940bed40793eeb072b4f1cf9534)
- [Dev Deps] update `tape`, `eslint`, `@ljharb/eslint-config` [`d42d423`](https://github.com/inspect-js/is-equal/commit/d42d42380935f19f94544982823675ee98c3166e)
- [Dev Deps] update `tape`, `jscs`, `semver`, `eslint`, `@ljharb/eslint-config`, `nsp`, `core-js` [`c064e99`](https://github.com/inspect-js/is-equal/commit/c064e99cce802ae23944d24aba376b123135aada)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config` [`5139dd8`](https://github.com/inspect-js/is-equal/commit/5139dd8260ece6e58bfe28eeb54f30b231562501)
- [Dev Deps] update `eslint` [`e5e9d91`](https://github.com/inspect-js/is-equal/commit/e5e9d91bd7833bf5f5f9ef2f584b5d1fea927d77)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `es6-shim` [`f6de73d`](https://github.com/inspect-js/is-equal/commit/f6de73d09119d0007165a9443ebde3dece8ec29e)
- [Dev Deps] remove extra `object.entries`; update `eslint`, `es6-shim` [`fdcdbe5`](https://github.com/inspect-js/is-equal/commit/fdcdbe5f743a22d028da1e16dcadf2d7887067d3)
- [Deps] update `object-entries`, `is-generator-function` [`c1bc768`](https://github.com/inspect-js/is-equal/commit/c1bc76858cd37fca8c97cdb7782fa2eaaa91c330)
- [Tests] up to `node` `v7.2` [`90aa4ea`](https://github.com/inspect-js/is-equal/commit/90aa4eaa37e826ffd2a219b042aff4573801a157)
- [Tests] on `node` `v6.2`, `v5.12` [`3ee66c5`](https://github.com/inspect-js/is-equal/commit/3ee66c539b750652813a491a6870cfc32823680e)

## [v1.5.3](https://github.com/inspect-js/is-equal/compare/v1.5.2...v1.5.3) - 2016-05-24

### Fixed

- [Fix] avoid false circular reference positives with falsy values in nested objects. [`#24`](https://github.com/inspect-js/is-equal/issues/24)

## [v1.5.2](https://github.com/inspect-js/is-equal/compare/v1.5.1...v1.5.2) - 2016-05-18

### Commits

- [Dev Deps] update `tape`, `jscs`, `eslint`, `@ljharb/eslint-config`, `nsp`, `core-js` [`ed25637`](https://github.com/inspect-js/is-equal/commit/ed25637b92e864bab4cd75412c9d9739e91e6557)
- [Dev Deps] update `jscs`, `eslint`, `nsp`, `core-js` [`043d51c`](https://github.com/inspect-js/is-equal/commit/043d51cb4736c62c29b9b89029b2400bc64ba19f)
- fix `Object.prototype.toString()` comparison [`ce2ca36`](https://github.com/inspect-js/is-equal/commit/ce2ca3634d96fb41b2e5aaac58819fb3288a3492)
- [Dev Deps] update `jscs`, `eslint`, `@ljharb/eslint-config`, `nsp`, `es6-shim`, `core-js` [`6034d56`](https://github.com/inspect-js/is-equal/commit/6034d56bafadb0b3b6799cd3b270a5594554df8f)
- [Tests] use pretest/posttest for linting/security [`82c3c9d`](https://github.com/inspect-js/is-equal/commit/82c3c9ddc383155a2199b4c4ea94e9c382af49c8)
- [Tests] up to `node` `v5.9`, `v4.4` [`be477e9`](https://github.com/inspect-js/is-equal/commit/be477e9c38fef4e9d108c392162562f2b314c9fa)
- [Dev Deps] update `eslint`, `es6-shim`, `core-js` [`ac1e3ac`](https://github.com/inspect-js/is-equal/commit/ac1e3ac9a12c828b04d2805ebb6f7722fe6952b2)
- [Tests] up to `node` `v6.1` [`9cb7c69`](https://github.com/inspect-js/is-equal/commit/9cb7c696aa92ba085d974ba91ace765d28303724)
- [Tests] on `node` `v5.10` [`c798cfe`](https://github.com/inspect-js/is-equal/commit/c798cfee255af0f6dfa9c05ba01c41197d7751b9)
- [Deps] update `is-callable` [`9b8e53b`](https://github.com/inspect-js/is-equal/commit/9b8e53b74fd8238ae7bda66ae9131956f4d35a5f)
- [Tests] on `node` `v5.7` [`01c52fa`](https://github.com/inspect-js/is-equal/commit/01c52fa13e59bd08a2b7f144ad34c6701400dc9d)

## [v1.5.1](https://github.com/inspect-js/is-equal/compare/v1.5.0...v1.5.1) - 2016-02-22

### Merged

- [Fix] fix "why" message for circular reference inequality [`#12`](https://github.com/inspect-js/is-equal/pull/12)

### Commits

- [Refactor] Delete unreachable code. [`8af4f70`](https://github.com/inspect-js/is-equal/commit/8af4f7048ef096166ad42e437fd552ab1a4235b3)
- Add tests for circular reference inequality. [`fd8bdfa`](https://github.com/inspect-js/is-equal/commit/fd8bdfa8193e7f499b6048ed4681a3a3b8fb0a9f)
- [Tests] fix assertion message (followup to #11) [`adc9c0a`](https://github.com/inspect-js/is-equal/commit/adc9c0a5deaf43390f080a177c3935b8089307b6)
- Fix error message sense. [`b2faa62`](https://github.com/inspect-js/is-equal/commit/b2faa6207a99d5dac325b01783fe09672726ad2e)
- Fix example [`d701069`](https://github.com/inspect-js/is-equal/commit/d7010693d86876e4098223fbc4a084dc5f6e8d0b)
- Fix err msg for inequal circ ref (+second, -first). [`6b9e478`](https://github.com/inspect-js/is-equal/commit/6b9e478132b5a41cc41767afc2a4629d98b37ec0)

## [v1.5.0](https://github.com/inspect-js/is-equal/compare/v1.4.2...v1.5.0) - 2016-02-15

### Commits

- [New] add “whyNotEqual” at `require(‘is-equal/why’)` to provide an inequality reason. [`fd7a11d`](https://github.com/inspect-js/is-equal/commit/fd7a11dac27a8e1e6007eef85134e79ad1ab61ec)
- [Refactor] use `whyNotEqual` internally in `isEqual` [`692f0a5`](https://github.com/inspect-js/is-equal/commit/692f0a52eaccb27c80fd20d8c3b4b0fd17e77ab5)
- [Tests] add some more tests. [`06f434f`](https://github.com/inspect-js/is-equal/commit/06f434f8ca65103f4cd812936fd57af598bb0113)
- [Dev Deps] update `tape`, `jscs`, `eslint`, `@ljharb/eslint-config`, `core-js`, `es6-shim` [`f0fc78c`](https://github.com/inspect-js/is-equal/commit/f0fc78c8c01537194da2f53f6f76609dedd79f13)
- [Tests] up to `node` `v5.6`, `v4.3` [`087c8e6`](https://github.com/inspect-js/is-equal/commit/087c8e64515de723b4ba971aaae9f085828beddd)
- [Dev Deps] update `jscs`, `eslint`, `@ljharb/eslint-config` [`637fa7c`](https://github.com/inspect-js/is-equal/commit/637fa7cf3c197c430639ac7685ecb0ef40eb64ea)
- [Tests] use `getSymbolIterator` internal module. [`8f47efa`](https://github.com/inspect-js/is-equal/commit/8f47efaf85e63c08b4a2117852f1ced499381aaf)
- [Dev Deps] update `tape`, `nsp`, `core-js` [`e246264`](https://github.com/inspect-js/is-equal/commit/e246264fc89f9338c1ed8775912fca52ee1d6a88)
- [Deps] update `is-callable` [`2766a04`](https://github.com/inspect-js/is-equal/commit/2766a04ac6dc1196d7f854571155e28998c60ba9)
- [Dev Deps] update `es6-shim` [`e6f5e76`](https://github.com/inspect-js/is-equal/commit/e6f5e769e96ef08ec2ff3555dc57645f94c605cf)

## [v1.4.2](https://github.com/inspect-js/is-equal/compare/v1.4.1...v1.4.2) - 2015-12-16

### Fixed

- [Fix] avoid false positives when the first items in two arrays are not equal. [`#5`](https://github.com/inspect-js/is-equal/issues/5)

## [v1.4.1](https://github.com/inspect-js/is-equal/compare/v1.4.0...v1.4.1) - 2015-12-15

### Merged

- [Tests] add tests to ensure proper key ordering [`#3`](https://github.com/inspect-js/is-equal/pull/3)

### Commits

- [Fix] ensure that https://github.com/zloirock/core-js/issues/144 doesn't cause false positives. [`61c73ca`](https://github.com/inspect-js/is-equal/commit/61c73ca97b8a1762bfcc4bc27b598ee69bda5b34)
- Factor out "get Symbol.iterator" logic. [`8546880`](https://github.com/inspect-js/is-equal/commit/854688074c8e589ca3912c07828142de21399bb1)
- [Tests] Add more `Set` tests, per #4. [`ca2e21f`](https://github.com/inspect-js/is-equal/commit/ca2e21f064e76128cb828f500374286c46af4b4e)
- [Refactor] move `Map`/`Set` `forEach` method detection to a separate module. [`815dfbe`](https://github.com/inspect-js/is-equal/commit/815dfbef8165a13db1326bf77c82038487218ea7)
- [Tests] Fix new tests from ca2e21f064e76128cb828f500374286c46af4b4e in node 0.12 [`778f77f`](https://github.com/inspect-js/is-equal/commit/778f77f6e9d894bcd4b943270d5fd1e94788615b)
- [Robustness] cache `Object#isPrototypeOf` [`a22c35f`](https://github.com/inspect-js/is-equal/commit/a22c35f684cea23af337a4af72b9000736d99bef)
- [Tests] add test cases from #4. [`3d65d78`](https://github.com/inspect-js/is-equal/commit/3d65d78a50e80d6d2b6909c1c74e7f6bd0bff316)
- [lint] add missing 'use strict' directive [`c6e098e`](https://github.com/inspect-js/is-equal/commit/c6e098e859f376c1639a71c71b2b4440bde76546)

## [v1.4.0](https://github.com/inspect-js/is-equal/compare/v1.3.1...v1.4.0) - 2015-12-10

### Fixed

- [New / Fix] Restore basic circular reference support. [`#2`](https://github.com/inspect-js/is-equal/issues/2)

### Commits

- [Deps] use `has` instead of relying on `Function#call`. [`0eeda8f`](https://github.com/inspect-js/is-equal/commit/0eeda8f2ffb1f7362996f59a75f2532d3adfda1b)

## [v1.3.1](https://github.com/inspect-js/is-equal/compare/v1.3.0...v1.3.1) - 2015-12-10

### Fixed

- [Fix] Partially revert 2517c2151d57451f7f7009df065bf1601316ee46, since object key ordering shouldn't matter. [`#3`](https://github.com/ljharb/is-equal/issues/3)
- [Fix] handle `Map`/`Set` in Safari 8, which lacks `Symbol.iterator`. [`#3`](https://github.com/inspect-js/is-equal/issues/3)
- [Tests] add tests for circular references. [`#2`](https://github.com/inspect-js/is-equal/issues/2)

### Commits

- [Refactor] don't attempt to run iterable comparisons when there's no Symbol.iterator. [`8e34291`](https://github.com/inspect-js/is-equal/commit/8e342914fdbd1a93e813cb9a2556afcc4bea0405)
- [Fix] ignore function name when comparing in engines that lack the "name" property (IE) [`d222ba0`](https://github.com/inspect-js/is-equal/commit/d222ba08bc3abfcdfe4ca51a2a6bbaf45d554719)
- [Tests] relocate native tests. [`504a8cb`](https://github.com/inspect-js/is-equal/commit/504a8cbdbe7db62acfdd8eff3dd63da23d16b098)
- [Tests] Separate shimmed from native tests. [`078e64a`](https://github.com/inspect-js/is-equal/commit/078e64af29dfa95f67a53fe7f828b692e65929e0)
- [Fix] normalize function signature whitespace, for IE 9. [`3e0df7b`](https://github.com/inspect-js/is-equal/commit/3e0df7b568f4c0ba933a79e0d2d94ff3f8c2619d)
- [Tests] Only skip generic iterable tests when there's no Symbol.iterator. [`b8ef004`](https://github.com/inspect-js/is-equal/commit/b8ef004dc3e7d0632239d8b36b649b921b1b2faf)

## [v1.3.0](https://github.com/inspect-js/is-equal/compare/v1.2.4...v1.3.0) - 2015-12-09

### Fixed

- [New] add support for comparing iterables, including native or `es6-shim`med `Map` and `Set`. [`#1`](https://github.com/inspect-js/is-equal/issues/1)

### Commits

- [Dev Deps] update `tape`, `jscs`, `semver`, `eslint`, `@ljharb/eslint-config`, `nsp` [`8bbacb7`](https://github.com/inspect-js/is-equal/commit/8bbacb701f8ec9dfad7d4e0a3bee3d3c48d86919)
- [Refactor] Use `object.entries` to compare objects instead of for loops. [`2517c21`](https://github.com/inspect-js/is-equal/commit/2517c2151d57451f7f7009df065bf1601316ee46)
- [Dev Deps] update `tape`, `jscs`, `eslint`, `@ljharb/eslint-config` [`e4b11ef`](https://github.com/inspect-js/is-equal/commit/e4b11ef255d26441d6d29c58e97fc8eed85f6128)
- [Tests] fix npm upgrades for older nodes [`cb98523`](https://github.com/inspect-js/is-equal/commit/cb98523be0292f533f04e6eb98f4d7a3d19b5959)
- [Dev Deps] update `jscs`, `eslint`, `nsp` [`f1f2b1b`](https://github.com/inspect-js/is-equal/commit/f1f2b1be740bf3202470817d49371fcec2516fbd)
- [Tests] up to `node` `v5.1` [`2093e30`](https://github.com/inspect-js/is-equal/commit/2093e302805b7ec47486f98b5330550b8087319f)
- [Deps] update `is-callable` [`c3c0669`](https://github.com/inspect-js/is-equal/commit/c3c066929cfa6460604c62f6429f9925bead9054)
- [Deps] update `is-callable` [`241f8e5`](https://github.com/inspect-js/is-equal/commit/241f8e519f762dc6e889d0d23a51ba01151a207e)
- [Tests] ensure node 0.8 doesn't fail. [`6ac38fe`](https://github.com/inspect-js/is-equal/commit/6ac38fe53d30b8a17261022129892ad2ac290a6a)

## [v1.2.4](https://github.com/inspect-js/is-equal/compare/v1.2.3...v1.2.4) - 2015-09-27

### Commits

- Update `tape`, `jscs`, `semver`. Add `npm run eslint` and `npm run security`. [`539df80`](https://github.com/inspect-js/is-equal/commit/539df80e588b21983da6fd6b1784719c46a23aaf)
- Update `eslint`, `tape`, `semver`; use my personal shared `eslint` config. [`d20d796`](https://github.com/inspect-js/is-equal/commit/d20d79672b9842d8f0e8f4592b273ca61dbd1248)
- Update `eslint` [`114b87b`](https://github.com/inspect-js/is-equal/commit/114b87b1026b526890fba3ce7cd8f8364b44a50b)
- All grade A-supported `node`/`iojs` versions now ship with an `npm` that understands `^`. [`da9eedf`](https://github.com/inspect-js/is-equal/commit/da9eedf938a5faa16030090c3657654d485e4026)
- Update `tape`, `jscs`, `eslint`, `@ljharb/eslint-config` [`8a1b2b9`](https://github.com/inspect-js/is-equal/commit/8a1b2b9e0b44bade537ee8557c59748d02bedb5d)
- Update `covert`, `jscs`, `eslint`, `semver` [`6ad9c2b`](https://github.com/inspect-js/is-equal/commit/6ad9c2b95d31b1a46d5d763482f51e20eba80972)
- [Dev Deps] update `tape`, `jscs`, `make-arrow-function`, `semver`, `eslint`, `@ljharb/eslint-config`, `nsp` [`2829e84`](https://github.com/inspect-js/is-equal/commit/2829e84020531c89e9dcec452290c1b5de92da2a)
- Update `eslint`, `semver`, `nsp` [`00c1c6c`](https://github.com/inspect-js/is-equal/commit/00c1c6ccc30678bf29c0d3c64f5dc0820fd26ec9)
- [Fix] Boxed Symbols should be coerced to primitives before testing for equality. [`0ed5277`](https://github.com/inspect-js/is-equal/commit/0ed527787ba3f7e483f38dbff5032e05c6350c43)
- Use `is-boolean-object`. [`ba4dcee`](https://github.com/inspect-js/is-equal/commit/ba4dcee60b511f0d6d324c078625affb06835d15)
- Test on latest `io.js` [`e7ee752`](https://github.com/inspect-js/is-equal/commit/e7ee7524e656903525b5f7d14a2b81ee625a0ab8)
- [Tests] up to `io.js` `v3.3`, `node` `v4.1` [`41489a0`](https://github.com/inspect-js/is-equal/commit/41489a0a3a20ea5a93a38920b2c917a4b2e911bb)
- [Dev Deps] update `jscs` [`393bf3f`](https://github.com/inspect-js/is-equal/commit/393bf3fbbbdc082e136c97fcff25bca19b4e9113)
- Test up to `io.js` `v2.3` [`cdbc4e0`](https://github.com/inspect-js/is-equal/commit/cdbc4e0316fcc3d559df5e990a439936069699b9)
- Test up to `io.js` `v2.1` [`2a86466`](https://github.com/inspect-js/is-equal/commit/2a86466a5ab4f5947c1bcdc410bf37d9c9bbba50)
- [Deps] update `is-arrow-function`, `is-date-object` [`c598d44`](https://github.com/inspect-js/is-equal/commit/c598d44b5a38faa58976289b951fa1daf30617c8)
- [Dev Deps] Update `tape`, `eslint` [`63da2af`](https://github.com/inspect-js/is-equal/commit/63da2af84bbe1e677ecc40ac9078877d00890847)
- Update `make-generator-function`, `semver` [`ff5ee98`](https://github.com/inspect-js/is-equal/commit/ff5ee988360ad82635543789ae32866d4ce1604e)
- Fix `make release` [`4ac1349`](https://github.com/inspect-js/is-equal/commit/4ac1349c3f3b73fa07de16dac361576c46e470e3)
- [Dev Deps] update `tape` [`b9caa6b`](https://github.com/inspect-js/is-equal/commit/b9caa6b8499edc6208335b975f6d34f305ecd57b)
- Switch from vb.teelaun.ch to versionbadg.es for the npm version badge SVG. [`8f3fcaa`](https://github.com/inspect-js/is-equal/commit/8f3fcaac89954bde63a55421a5a39f5659f64cc7)
- Test on `io.js` `v2.5` [`3503609`](https://github.com/inspect-js/is-equal/commit/350360969ce5c41d74fc5553b60c190bf4417f22)
- Test on `io.js` `v2.4` [`3b41559`](https://github.com/inspect-js/is-equal/commit/3b41559b05cedaa6e805731bd8e845fa9e5d297d)
- Updating `semver` [`52706a3`](https://github.com/inspect-js/is-equal/commit/52706a374178d409eee2e35b0dba218497cb63f6)
- Test on `io.js` `v3.0` [`2e14995`](https://github.com/inspect-js/is-equal/commit/2e14995f3c6dbeb6764e6c9af08a44b16b4ef827)

## [v1.2.3](https://github.com/inspect-js/is-equal/compare/v1.2.2...v1.2.3) - 2015-02-06

### Commits

- Update `is-callable`, `is-number-object`, `is-regex`, `is-string` [`314891e`](https://github.com/inspect-js/is-equal/commit/314891ea3ee328f2f06c5d99e6c5a3aaf7a389a4)
- Run `travis-ci` tests on `iojs` and `node` v0.12; speed up builds; allow 0.8 failures. [`6d78102`](https://github.com/inspect-js/is-equal/commit/6d7810255b16772dbbefe4b51b9fe9b6de2ed284)
- Update `is-generator-function`, `tape`, `jscs` [`2fa7c6f`](https://github.com/inspect-js/is-equal/commit/2fa7c6f4c80a8d6b290cd74c5c5a129d369f7438)

## [v1.2.2](https://github.com/inspect-js/is-equal/compare/v1.2.1...v1.2.2) - 2015-01-29

### Commits

- Update `is-arrow-function`, `is-callable`, `is-number-object`, `is-string` [`bf05888`](https://github.com/inspect-js/is-equal/commit/bf05888154ce33c495d22a064a7b9d23c5514041)

## [v1.2.1](https://github.com/inspect-js/is-equal/compare/v1.2.0...v1.2.1) - 2015-01-29

### Commits

- Use `is-string` and `is-callable` modules. [`0769199`](https://github.com/inspect-js/is-equal/commit/0769199f676387acb7e0e7d4bb8d1d9d1a771690)

## [v1.2.0](https://github.com/inspect-js/is-equal/compare/v1.1.1...v1.2.0) - 2015-01-28

### Commits

- `make release` [`c6186d4`](https://github.com/inspect-js/is-equal/commit/c6186d48d1010b1098394e4498129a8e2b054290)
- Use `is-regex`/`is-date-object`/`is-number-object` to properly check RegExps/Dates/Numbers, despite `@@toStringTag`. [`c0be34d`](https://github.com/inspect-js/is-equal/commit/c0be34dbe014b2e85ce97685036220d0c39de4c7)
- Use try/catch for a more reliable isFunction check, even with ES6 @@toStringTag [`c7c47c1`](https://github.com/inspect-js/is-equal/commit/c7c47c15f0c81e0f929a6045dfe6c831cde81f86)
- Use try/catch for a more reliable isString check, even with ES6 @@toStringTag [`2e64fe6`](https://github.com/inspect-js/is-equal/commit/2e64fe62aa9f941dc96dd5c6d67b823b5bfb3a03)
- Use try/catch for a more reliable isBoolean check, even with ES6 @@toStringTag [`612bf6b`](https://github.com/inspect-js/is-equal/commit/612bf6bb6708ecd09a9159a53d0edda625247796)
- Improve Array checks to avoid checking Object#toString when possible. [`4617222`](https://github.com/inspect-js/is-equal/commit/46172220bd11215076b91fff76d7942ca1cdcbdc)
- Remove `[object Object]` checking. [`bc96071`](https://github.com/inspect-js/is-equal/commit/bc96071ea80893c5664622e2a53ff3813aeb39db)
- Add an early return for `null`/`undefined` [`f00381b`](https://github.com/inspect-js/is-equal/commit/f00381ba060a9b715aad52318ae177894daefd61)

## [v1.1.1](https://github.com/inspect-js/is-equal/compare/v1.1.0...v1.1.1) - 2015-01-20

### Commits

- Fix generator functions in newer v8 / io.js. [`9e907dd`](https://github.com/inspect-js/is-equal/commit/9e907dd58ff946116d59928c7a24910bb58214ae)
- Update `is-generator-function`, `tape`, `jscs` [`b1828a6`](https://github.com/inspect-js/is-equal/commit/b1828a6ff6dca9a0f093da2fde2c433bb0cc998c)
- toString is a reserved word in older browsers. [`c9577e4`](https://github.com/inspect-js/is-equal/commit/c9577e490877fd2eed832754950edcdaaaf83338)
- Update `jscs` [`aeb3ff8`](https://github.com/inspect-js/is-equal/commit/aeb3ff8ae71a1b750a4eec30df57b7b0b8263b38)
- Update `is-arrow-function`, `is-generator-function` [`64676e4`](https://github.com/inspect-js/is-equal/commit/64676e441a7720461884cfe6dedf4098403dd950)

## [v1.1.0](https://github.com/inspect-js/is-equal/compare/v1.0.0...v1.1.0) - 2014-12-15

### Commits

- Using my standard jscs.json file [`e180beb`](https://github.com/inspect-js/is-equal/commit/e180bebfb5282ad0527307ab452b7e808a13430b)
- Adding `npm run lint` [`69d590e`](https://github.com/inspect-js/is-equal/commit/69d590e0c8c1e68c44d3754f25120f0363d8683c)
- Adding tests and support for comparing generators. [`fb03635`](https://github.com/inspect-js/is-equal/commit/fb03635e6d1a0a9760b7752147689805f82df5ed)
- Adding tests and support for comparing arrow functions. [`57c719d`](https://github.com/inspect-js/is-equal/commit/57c719d89e13e8f0d7e9f0b9c5e31f3389974749)
- Consider functions "equal" if type, name, arity, and body are equal. [`6622d56`](https://github.com/inspect-js/is-equal/commit/6622d563f306cd3a17670ffe27cc515a83c03e55)
- Add tests for Symbols. [`5aea5b6`](https://github.com/inspect-js/is-equal/commit/5aea5b6c6067b2264c5d2a2f53870038f2f3a1b1)
- Adding license and downloads badges [`815cdda`](https://github.com/inspect-js/is-equal/commit/815cddac102063c651ab4f5450150bc8cafddc62)
- Adding forEach and copyFunction helpers for tests. [`f5d7190`](https://github.com/inspect-js/is-equal/commit/f5d71907fe724788b62d357fdeb2932f1173d0b5)
- Using consistent quotes [`e756817`](https://github.com/inspect-js/is-equal/commit/e7568171e344eeb0fc419bb9698867c45e713ecc)
- Use SVG instead of PNG badges [`8f7995f`](https://github.com/inspect-js/is-equal/commit/8f7995fc4d9ca4a01a95c6987b5af629133c363f)
- Removing this unnecessary test line, and refactoring up `hasSymbols`. [`95218d6`](https://github.com/inspect-js/is-equal/commit/95218d6d8082da7bef417b61f1f80f24ae0f953f)
- Update `tape`, `jscs` [`3f254eb`](https://github.com/inspect-js/is-equal/commit/3f254eb8aa7d4668a8370b78ce95ab76eddc1345)
- Update `tape`, `jscs` [`080a913`](https://github.com/inspect-js/is-equal/commit/080a913d68fc7df9abb57957d8f1038cd43f1a6d)
- Run tests with --harmony. [`5311996`](https://github.com/inspect-js/is-equal/commit/5311996db7a34f992aeb98251ed3e714fcb612b8)
- Update `tape` [`0f81bc4`](https://github.com/inspect-js/is-equal/commit/0f81bc4e9bc852283641da22aaf15ff1ad3214af)
- Lock covert to v1.0.0. [`39c0281`](https://github.com/inspect-js/is-equal/commit/39c028102ec615bf31cca3bb4243fda8478b3bef)
- Updating `tape` [`d31472d`](https://github.com/inspect-js/is-equal/commit/d31472dacf7ca1d97e66654987729c117fe33bc6)
- Update jscs [`aea1c63`](https://github.com/inspect-js/is-equal/commit/aea1c631d8cfd156e8514e8f7aa6879ab71dba17)
- Updating jscs [`34fe2e3`](https://github.com/inspect-js/is-equal/commit/34fe2e36a457a77109398e16acd8948ec195ddbf)
- Run linter as part of tests [`4c7efb0`](https://github.com/inspect-js/is-equal/commit/4c7efb0555be28b8cdd74c840b3e53cda5200c82)
- Updating covert [`cd6abb5`](https://github.com/inspect-js/is-equal/commit/cd6abb5a480a64f9a12b25cd66bb4a8d337c956f)

## [v1.0.0](https://github.com/inspect-js/is-equal/compare/v0.1.0...v1.0.0) - 2014-08-08

### Commits

- Make sure old and unstable nodes don't break Travis [`f33db37`](https://github.com/inspect-js/is-equal/commit/f33db3704d814ba4129d91f58c2439f78e999e5a)
- Updating tape [`a28ec09`](https://github.com/inspect-js/is-equal/commit/a28ec099d9a123f0ef9206239d3df1469435471b)
- Updating tape [`b15cd46`](https://github.com/inspect-js/is-equal/commit/b15cd4645124e4088e28f73fad6a2897e3d15be0)
- Updating covert [`8d443f3`](https://github.com/inspect-js/is-equal/commit/8d443f35bf4c1b4ba5acb72ce5630dfb350f6193)
- Updating tape [`f231d59`](https://github.com/inspect-js/is-equal/commit/f231d59d370942a6a9e3926ac4c60fd45d430a15)

## [v0.1.0](https://github.com/inspect-js/is-equal/compare/v0.0.0...v0.1.0) - 2014-03-23

### Commits

- Adding support for boxed primitives [`a074e04`](https://github.com/inspect-js/is-equal/commit/a074e04baca96e2072f40dc19862ff634d886956)
- Use hasOwnProperty instead of "in". [`909f259`](https://github.com/inspect-js/is-equal/commit/909f2592f68ba227d0fcc5159869cdabb947a8e8)
- Trying the parent/child disqualification again. [`34aa425`](https://github.com/inspect-js/is-equal/commit/34aa425d204b40497a0f82d3083f85757de296e8)
- __proto__ may be a reserved word in ES3 [`ebe9113`](https://github.com/inspect-js/is-equal/commit/ebe9113db296e43114e9d87ed99e9ad5998a4e84)
- Updating dependencies [`675fc60`](https://github.com/inspect-js/is-equal/commit/675fc608a8532321b70829d93fd3887d38fcffbb)
- Oops, fixing mixed spaces and tabs [`34f6860`](https://github.com/inspect-js/is-equal/commit/34f68603d20dff7cddd3f47b3199a26b654a681a)
- Updating tape [`5d52e87`](https://github.com/inspect-js/is-equal/commit/5d52e873524bd8d956dc746b3e2b626f816f4626)
- Testing node 0.6 again [`6feb16d`](https://github.com/inspect-js/is-equal/commit/6feb16dddafa7b92a6f2f13a6baa3efc4adb7179)
- Faking the constructor. Yay JS inheritance! [`b899f88`](https://github.com/inspect-js/is-equal/commit/b899f88cc6b801091eb7a5486705f9cb2393e6d4)

## v0.0.0 - 2014-01-19

### Commits

- Tests. [`a52f527`](https://github.com/inspect-js/is-equal/commit/a52f527c80512aecb39e21e9b82dc683549876ae)
- Implementation. [`2669d7e`](https://github.com/inspect-js/is-equal/commit/2669d7ecbac17c8c3b30d0a7d848d0ec773fcd12)
- package.json [`6608349`](https://github.com/inspect-js/is-equal/commit/6608349a4994d1934eb5dc7e3fab51b5d63bea40)
- read me [`6626f5d`](https://github.com/inspect-js/is-equal/commit/6626f5da0c40eb2b7a896f8d694dcadc6d37c79c)
- Initial commit [`16dea8f`](https://github.com/inspect-js/is-equal/commit/16dea8f76683c95d7a4bef9677938498ad0dde3f)
- Adding a getPrototypeOf shim [`3c59ef9`](https://github.com/inspect-js/is-equal/commit/3c59ef9aa5ec0268a988c1edad568b49c4468e1c)
- Firefox &lt;= 16 elides comments from a function's string representation. [`35d22cf`](https://github.com/inspect-js/is-equal/commit/35d22cff8b816763ce9c5d4728b141ccdc903180)
- Check function lengths as well for equality. [`e944591`](https://github.com/inspect-js/is-equal/commit/e94459185adb86a1c223cfcab894a8b0fec23537)
- Travis CI [`dd86cc1`](https://github.com/inspect-js/is-equal/commit/dd86cc1a4b6fa99fba9435b8fe88a69e1580db89)
- Trying to return Object.prototype in IE when none is found [`233aca3`](https://github.com/inspect-js/is-equal/commit/233aca37f61e3900c190ca19acd5d9bb0f757d8c)
- Temporarily commenting out this test. [`a0d3efd`](https://github.com/inspect-js/is-equal/commit/a0d3efd7124e305734363516c592f3e80d365c75)
- Trying to ensure later Opera versions are tested [`cc1ff14`](https://github.com/inspect-js/is-equal/commit/cc1ff1408ad9a8a8de369cbf968f90bbc61de459)
- Instead of relying on "this", check an empty object. [`fbf110a`](https://github.com/inspect-js/is-equal/commit/fbf110aed96bfb2bf230514b98f475f5a10e87ef)
- Optimization for array comparison [`0169b55`](https://github.com/inspect-js/is-equal/commit/0169b559a2ba3d2d64e92fd30b2c13206ed348ab)
