"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Phase = exports.Scope = exports.MergeFileScope = exports.RootMergeFileScope = exports.MergeObjectScope = exports.RootMergeObjectScope = exports.GlobalScope = exports.ScopeBase = void 0;
var ScopeBase = (function () {
    function ScopeBase(parent, localVariables, phase) {
        this.phase = "merge";
        this.registeredPhases = {};
        this.propertyPath = [];
        this.scopeVariables = {};
        this.localVariables = localVariables;
        if (parent) {
            this.parent = parent;
            this.phase = parent.phase;
            this.scopeVariables = __assign({}, this.parent.scopeVariables);
            this.scopeVariables.$parent = this.parent.scopeVariables;
        }
        if (this.localVariables) {
            this.scopeVariables = __assign(__assign({}, this.scopeVariables), this.localVariables);
        }
        if (phase) {
            this.deregisterPhase(phase);
            this.phase = phase;
        }
    }
    ScopeBase.prototype.enterProperty = function (propertyName) {
        if (propertyName !== undefined) {
            this.propertyPath.push(propertyName);
        }
    };
    ScopeBase.prototype.leaveProperty = function () {
        this.propertyPath.pop();
    };
    ScopeBase.prototype.registerPhase = function (phase) {
        var scope = this;
        while (scope) {
            scope.registeredPhases[phase] = true;
            scope = scope.parent;
        }
    };
    ScopeBase.prototype.deregisterPhase = function (phase) {
        var scope = this;
        while (scope) {
            scope.registeredPhases[phase] = false;
            scope = scope.parent;
        }
    };
    ScopeBase.prototype.hasRegisteredPhase = function (phase) {
        return this.registeredPhases[phase] === true;
    };
    return ScopeBase;
}());
exports.ScopeBase = ScopeBase;
var GlobalScope = (function (_super) {
    __extends(GlobalScope, _super);
    function GlobalScope() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return GlobalScope;
}(ScopeBase));
exports.GlobalScope = GlobalScope;
var RootMergeObjectScope = (function (_super) {
    __extends(RootMergeObjectScope, _super);
    function RootMergeObjectScope(source, target, parent, localVariables, phase) {
        var _this = _super.call(this, parent, localVariables, phase) || this;
        _this.root = _this;
        _this.source = source;
        _this.target = target;
        _this.scopeVariables.$root = _this.root.scopeVariables;
        _this.scopeVariables.$source = _this.source;
        _this.scopeVariables.$target = _this.target;
        return _this;
    }
    return RootMergeObjectScope;
}(ScopeBase));
exports.RootMergeObjectScope = RootMergeObjectScope;
var MergeObjectScope = (function (_super) {
    __extends(MergeObjectScope, _super);
    function MergeObjectScope(source, target, parent, localVariables, phase) {
        var _this = _super.call(this, parent, localVariables, phase) || this;
        _this.root = parent.root;
        _this.source = source;
        _this.target = target;
        _this.scopeVariables.$root = _this.root.scopeVariables;
        _this.scopeVariables.$source = _this.source;
        _this.scopeVariables.$target = _this.target;
        return _this;
    }
    return MergeObjectScope;
}(ScopeBase));
exports.MergeObjectScope = MergeObjectScope;
var RootMergeFileScope = (function (_super) {
    __extends(RootMergeFileScope, _super);
    function RootMergeFileScope(sourceFilePath, source, target, parent, localVariables, phase) {
        var _this = _super.call(this, parent, localVariables, phase) || this;
        _this.root = _this;
        _this.source = source;
        _this.target = target;
        _this.sourceFilePath = sourceFilePath;
        _this.sourceFileName = _this.sourceFilePath
            .replace(/^.*[\\\/:]/, "")
            .replace(/\.[^/.]+$/, "");
        _this.scopeVariables.$root = _this.root.scopeVariables;
        _this.scopeVariables.$source = _this.source;
        _this.scopeVariables.$target = _this.target;
        _this.scopeVariables.$sourceFilePath = _this.sourceFilePath;
        _this.scopeVariables.$sourceFileName = _this.sourceFileName;
        return _this;
    }
    return RootMergeFileScope;
}(ScopeBase));
exports.RootMergeFileScope = RootMergeFileScope;
var MergeFileScope = (function (_super) {
    __extends(MergeFileScope, _super);
    function MergeFileScope(sourceFilePath, source, target, parent, localVariables, phase) {
        var _this = _super.call(this, parent, localVariables, phase) || this;
        _this.sourceFilePath = sourceFilePath;
        _this.source = source;
        _this.target = target;
        _this.scopeVariables = __assign({}, localVariables);
        _this.root = _this;
        _this.sourceFileName = _this.sourceFilePath
            .replace(/^.*[\\\/:]/, "")
            .replace(/\.[^/.]+$/, "");
        _this.scopeVariables.$root = _this.root.scopeVariables;
        _this.scopeVariables.$source = _this.source;
        _this.scopeVariables.$target = _this.target;
        _this.scopeVariables.$sourceFilePath = _this.sourceFilePath;
        _this.scopeVariables.$sourceFileName = _this.sourceFileName;
        return _this;
    }
    return MergeFileScope;
}(ScopeBase));
exports.MergeFileScope = MergeFileScope;
var Scope = (function (_super) {
    __extends(Scope, _super);
    function Scope(parent, localVariables, phase) {
        var _this = _super.call(this, parent, localVariables, phase) || this;
        _this.root = parent.root;
        _this.scopeVariables.$root = _this.root.scopeVariables;
        return _this;
    }
    return Scope;
}(ScopeBase));
exports.Scope = Scope;
var Phase;
(function (Phase) {
    Phase["AfterMerge"] = "afterMerge";
    Phase["AfterMerges"] = "afterMerges";
    Phase["Merge"] = "merge";
})(Phase = exports.Phase || (exports.Phase = {}));
//# sourceMappingURL=Scope.js.map