<!-- Please do not edit this file. Edit the `blah` field in the `package.json` instead. If in doubt, open an issue. -->


















# parse-path

 [![Support me on Patreon][badge_patreon]][patreon] [![Buy me a book][badge_amazon]][amazon] [![PayPal][badge_paypal_donate]][paypal-donations] [![Ask me anything](https://img.shields.io/badge/ask%20me-anything-1abc9c.svg)](https://github.com/IonicaBizau/ama) [![Travis](https://img.shields.io/travis/IonicaBizau/parse-path.svg)](https://travis-ci.org/IonicaBizau/parse-path/) [![Version](https://img.shields.io/npm/v/parse-path.svg)](https://www.npmjs.com/package/parse-path) [![Downloads](https://img.shields.io/npm/dt/parse-path.svg)](https://www.npmjs.com/package/parse-path) [![Get help on Codementor](https://cdn.codementor.io/badges/get_help_github.svg)](https://www.codementor.io/johnnyb?utm_source=github&utm_medium=button&utm_term=johnnyb&utm_campaign=github)

<a href="https://www.buymeacoffee.com/H96WwChMy" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/yellow_img.png" alt="Buy Me A Coffee"></a>







> Parse paths (local paths, urls: ssh/git/etc)

















## :cloud: Installation

```sh
# Using npm
npm install --save parse-path

# Using yarn
yarn add parse-path
```













## :clipboard: Example



```js
// Dependencies
const parsePath = require("parse-path")

console.log(parsePath("http://ionicabizau.net/blog"))
// { protocols: [ 'http' ],
//   protocol: 'http',
//   port: null,
//   resource: 'ionicabizau.net',
//   user: '',
//   pathname: '/blog',
//   hash: '',
//   search: '',
//   href: 'http://ionicabizau.net/blog' }

console.log(parsePath("http://domain.com/path/name?foo=bar&bar=42#some-hash"))
// { protocols: [ 'http' ],
//   protocol: 'http',
//   port: null,
//   resource: 'domain.com',
//   user: '',
//   pathname: '/path/name',
//   hash: 'some-hash',
//   search: 'foo=bar&bar=42',
//   href: 'http://domain.com/path/name?foo=bar&bar=42#some-hash' }

console.log(parsePath("git+ssh://git@host.xz/path/name.git"))
// { protocols: [ 'git', 'ssh' ],
//   protocol: 'git',
//   port: null,
//   resource: 'host.xz',
//   user: 'git',
//   pathname: '/path/name.git',
//   hash: '',
//   search: '',
//   href: 'git+ssh://git@host.xz/path/name.git' }

console.log(parsePath("git@github.com:IonicaBizau/git-stats.git"))
// { protocols: [],
//   protocol: 'ssh',
//   port: null,
//   resource: 'github.com',
//   user: 'git',
//   pathname: '/IonicaBizau/git-stats.git',
//   hash: '',
//   search: '',
//   href: 'git@github.com:IonicaBizau/git-stats.git' }
```











## :question: Get Help

There are few ways to get help:



 1. Please [post questions on Stack Overflow](https://stackoverflow.com/questions/ask). You can open issues with questions, as long you add a link to your Stack Overflow question.
 2. For bug reports and feature requests, open issues. :bug:
 3. For direct and quick help, you can [use Codementor](https://www.codementor.io/johnnyb). :rocket:





## :memo: Documentation


### `parsePath(url)`
Parses the input url.

#### Params

- **String** `url`: The input url.

#### Return
- **Object** An object containing the following fields:
 - `protocols` (Array): An array with the url protocols (usually it has one element).
 - `protocol` (String): The first protocol, `"ssh"` (if the url is a ssh url) or `"file"`.
 - `port` (null|Number): The domain port.
 - `resource` (String): The url domain (including subdomains).
 - `user` (String): The authentication user (usually for ssh urls).
 - `pathname` (String): The url pathname.
 - `hash` (String): The url hash.
 - `search` (String): The url querystring value.
 - `href` (String): The input url.
 - `query` (Object): The url querystring, parsed as object.














## :yum: How to contribute
Have an idea? Found a bug? See [how to contribute][contributing].


## :sparkling_heart: Support my projects
I open-source almost everything I can, and I try to reply to everyone needing help using these projects. Obviously,
this takes time. You can integrate and use these projects in your applications *for free*! You can even change the source code and redistribute (even resell it).

However, if you get some profit from this or just want to encourage me to continue creating stuff, there are few ways you can do it:


 - Starring and sharing the projects you like :rocket:
 - [![Buy me a book][badge_amazon]][amazon]—I love books! I will remember you after years if you buy me one. :grin: :book:
 - [![PayPal][badge_paypal]][paypal-donations]—You can make one-time donations via PayPal. I'll probably buy a ~~coffee~~ tea. :tea:
 - [![Support me on Patreon][badge_patreon]][patreon]—Set up a recurring monthly donation and you will get interesting news about what I'm doing (things that I don't share with everyone).
 - **Bitcoin**—You can send me bitcoins at this address (or scanning the code below): `1P9BRsmazNQcuyTxEqveUsnf5CERdq35V6`

    ![](https://i.imgur.com/z6OQI95.png)


Thanks! :heart:
















## :dizzy: Where is this library used?
If you are using this library in one of your projects, add it in this list. :sparkles:

 - `parse-url`
 - `@semantic-release/gitlab`
 - `@pvm/gitlab`
 - `eleventy-plugin-embed-soundcloud`
 - `@enkeledi/react-native-week-month-date-picker`
 - `@hemith/react-native-tnk`
 - `npm_one_1_2_3`
 - `native-kakao-login`
 - `rn-adyen-dropin`
 - `react-fsm-router`
 - `react-native-contact-list`
 - `react-native-biometric-authenticate`
 - `react-native-arunmeena1987`
 - `react-native-is7`
 - `react-native-kakao-maps`
 - `react-native-my-first-try-arun-ramya`
 - `react-native-payu-payment-testing`
 - `react-native-ytximkit`
 - `tria-prima`
 - `sm-versioning`
 - `@corelmax/react-native-my2c2p-sdk`
 - `@datalogic/react-native-datalogic-module`
 - `@felipesimmi/react-native-datalogic-module`
 - `@hawkingnetwork/react-native-tab-view`
 - `drowl-base-theme-iconset`
 - `native-apple-login`
 - `react-native-cplus`
 - `npm_qwerty`
 - `react-native-arunjeyam1987`
 - `react-native-bubble-chart`
 - `react-native-flyy`
 - `@alphy11/semantic-release-gitlab`
 - `@apardellass/react-native-audio-stream`
 - `@fgreinacher/semantic-release-gitlab`
 - `@geeky-apo/react-native-advanced-clipboard`
 - `@j4s0n/semantic-release-gitlab`
 - `@saad27/react-native-bottom-tab-tour`
 - `@xudong/semantic-release-gitlab`
 - `candlelabssdk`
 - `react-native-dsphoto-module`
 - `react-native-responsive-size`
 - `react-native-sayhello-module`
 - `@flareapp/ignition-ui`
 - `react-feedback-sdk`
 - `npm_one_12_34_1_`
 - `npm_one_2_2`
 - `payutesting`
 - `semantic-release-gitee`
 - `semantic-release-gitlab-plugin`
 - `@pvm/github`
 - `@pvm/plugin-conventional-changelog`
 - `@devdiary/semantic-devdiary-release`
 - `birken-react-native-community-image-editor`
 - `luojia-cli-dev`
 - `reac-native-arun-ramya-test`
 - `react-native-plugpag-wrapper`
 - `react-native-pulsator-native`
 - `react-native-arun-ramya-test`
 - `react-native-arunramya151`
 - `react-native-transtracker-library`
 - `semantic-release-version`
 - `@screeb/react-native`
 - `@cloudoki/donderflow`
 - `@buganto/client`
 - `@tjoussen/semantic-release-gitlab-mr`
 - `astra-ufo-sdk`
 - `react-native-syan-photo-picker`
 - `@wecraftapps/react-native-use-keyboard`
 - `electron-info`
 - `l2forlerna`
 - `native-google-login`
 - `raact-native-arunramya151`
 - `react-native-test-module-hhh`
 - `reddit-title-has-verbatim-quote`
 - `react-native-badge-control`
 - `rn-tm-notify`
 - `react-native-jsi-device-info`











## :scroll: License

[MIT][license] © [Ionică Bizău][website]






[license]: /LICENSE
[website]: https://ionicabizau.net
[contributing]: /CONTRIBUTING.md
[docs]: /DOCUMENTATION.md
[badge_patreon]: https://ionicabizau.github.io/badges/patreon.svg
[badge_amazon]: https://ionicabizau.github.io/badges/amazon.svg
[badge_paypal]: https://ionicabizau.github.io/badges/paypal.svg
[badge_paypal_donate]: https://ionicabizau.github.io/badges/paypal_donate.svg
[patreon]: https://www.patreon.com/ionicabizau
[amazon]: http://amzn.eu/hRo9sIZ
[paypal-donations]: https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=RVXDDLKKLQRJW
