import _concatInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/concat";
import _toConsumableArray from "@babel/runtime-corejs3/helpers/toConsumableArray";
import _objectSpread from "@babel/runtime-corejs3/helpers/objectSpread2";
import _forEachInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/for-each";
import _Array$isArray from "@babel/runtime-corejs3/core-js-stable/array/is-array";
import _sliceInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/slice";
import { isFreelyNamed, generateAbsoluteRefPatches } from '../helpers';
export default {
  key: 'allOf',
  plugin: function plugin(val, key, fullPath, specmap, patch) {
    // Ignore replace patches created by $ref because the changes will
    // occur in the original "add" patch and we don't want this plugin
    // to redundantly processes those "relace" patches.
    if (patch.meta && patch.meta.$$ref) {
      return undefined;
    }

    var parent = _sliceInstanceProperty(fullPath).call(fullPath, 0, -1);

    if (isFreelyNamed(parent)) {
      return undefined;
    }

    if (!_Array$isArray(val)) {
      var err = new TypeError('allOf must be an array');
      err.fullPath = fullPath; // This is an array

      return err;
    }

    var alreadyAddError = false; // Find the original definition from the `patch.value` object
    // Remove the `allOf` property so it doesn't get added to the result of the `allOf` plugin

    var originalDefinitionObj = patch.value;

    _forEachInstanceProperty(parent).call(parent, function (part) {
      if (!originalDefinitionObj) return; // bail out if we've lost sight of our target

      originalDefinitionObj = originalDefinitionObj[part];
    });

    originalDefinitionObj = _objectSpread({}, originalDefinitionObj);
    delete originalDefinitionObj.allOf;
    var patches = []; // remove existing content

    patches.push(specmap.replace(parent, {}));

    _forEachInstanceProperty(val).call(val, function (toMerge, i) {
      if (!specmap.isObject(toMerge)) {
        if (alreadyAddError) {
          return null;
        }

        alreadyAddError = true;

        var _err = new TypeError('Elements in allOf must be objects');

        _err.fullPath = fullPath; // This is an array

        return patches.push(_err);
      } // Deeply merge the member's contents onto the parent location


      patches.push(specmap.mergeDeep(parent, toMerge)); // Generate patches that migrate $ref values based on ContextTree information
      // remove ["allOf"], which will not be present when these patches are applied

      var collapsedFullPath = _sliceInstanceProperty(fullPath).call(fullPath, 0, -1);

      var absoluteRefPatches = generateAbsoluteRefPatches(toMerge, collapsedFullPath, {
        getBaseUrlForNodePath: function getBaseUrlForNodePath(nodePath) {
          var _context;

          return specmap.getContext(_concatInstanceProperty(_context = []).call(_context, _toConsumableArray(fullPath), [i], _toConsumableArray(nodePath))).baseDoc;
        },
        specmap: specmap
      });
      patches.push.apply(patches, _toConsumableArray(absoluteRefPatches));
      return undefined;
    }); // Merge back the values from the original definition


    patches.push(specmap.mergeDeep(parent, originalDefinitionObj)); // If there was not an original $$ref value, make sure to remove
    // any $$ref value that may exist from the result of `allOf` merges

    if (!originalDefinitionObj.$$ref) {
      var _context2;

      patches.push(specmap.remove(_concatInstanceProperty(_context2 = []).call(_context2, parent, '$$ref')));
    }

    return patches;
  }
};