'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
var fs = require("fs");
var path = require("path");
var sizeTree = require("./size_tree");
var WebpackBundleSizeAnalyzerPlugin = /** @class */ (function () {
    function WebpackBundleSizeAnalyzerPlugin(filepath, statsOptions) {
        if (filepath === void 0) { filepath = ''; }
        if (statsOptions === void 0) { statsOptions = {}; }
        this.filepath = filepath;
        this.statsOptions = statsOptions;
    }
    WebpackBundleSizeAnalyzerPlugin.prototype.apply = function (compiler) {
        var _this = this;
        compiler.hooks.done.tap('WebpackBundleSizeAnalyzerPlugin', function (stats) {
            var filepath = _this.filepath;
            if (filepath.length > 0) {
                stats = stats.toJson(_this.statsOptions);
                if (!path.isAbsolute(filepath)) {
                    filepath = path.resolve(compiler.outputPath, filepath);
                }
                var depTrees = sizeTree.dependencySizeTree(stats);
                var output_1 = '';
                depTrees.forEach(function (tree) {
                    return sizeTree.printDependencySizeTree(tree, true, 0, function (out) {
                        output_1 += out + "\n";
                    });
                });
                fs.writeFile(filepath, output_1, 'utf8', function () { });
            }
        });
    };
    return WebpackBundleSizeAnalyzerPlugin;
}());
exports.WebpackBundleSizeAnalyzerPlugin = WebpackBundleSizeAnalyzerPlugin;
