"use strict";

var Luci = Luci || {};

Luci.Tabs = function() {
  const tabNavLinks = document.querySelectorAll('.luci-tab__nav .luci-tab__list-item');
  const nestedTabTitles = document.querySelectorAll('.luci-tab__list--nested .luci-tab__list-item');
  const tabTitleActiveClass = 'luci-tab__list-item--is-active';
  const tabPanelActiveClass = 'luci-tab__panel--is-active';

  function updateLinkAttributes(tabTitle) {
    const tabLink = tabTitle.querySelector('.luci-link');
    tabLink.setAttribute("aria-selected", false);
    tabLink.setAttribute("tab-index", "-1");
  }

  function closeAllTabs(tabTitles, tabPanels) {
    tabTitles.forEach(function (tabTitle) {
      updateLinkAttributes(tabTitle);
      tabTitle.classList.remove(tabTitleActiveClass);
    });

    tabPanels.forEach(function (tabPanel) {
      tabPanel.classList.remove(tabPanelActiveClass);
    });
  }

  function setLinkAttributes(tabTitle) {
    const tabLink = tabTitle.querySelector('.luci-link');

    tabLink.setAttribute("aria-selected", true);
    tabLink.setAttribute("tab-index", "0");
  }

  function openTab(event) {
    event.preventDefault();
    const tabId = this.querySelector('.luci-link').getAttribute('href');
    const tabPanel = document.querySelector(tabId + '.luci-tab__panel');
    const tab = Luci.Utils.getClosestParent(this, '.luci-tab');
    const tabTitles = tab.querySelectorAll('.luci-tab__list-item');
    const tabPanels = tab.querySelectorAll('.luci-tab__panel, .luci-tab__panel--nested');

    closeAllTabs(tabTitles, tabPanels);
    setLinkAttributes(this);
    this.classList.add(tabTitleActiveClass);
    tabPanel.classList.add(tabPanelActiveClass);

    if (tabPanel.querySelector('.luci-tab__panel--nested')) {
      const firstNestedTabListItem = tabPanel.querySelector('.luci-tab__list--nested .luci-tab__list-item');
      const firstNestedTabPanel = tabPanel.querySelector('.luci-tab__panel--nested');
      firstNestedTabListItem.classList.add(tabTitleActiveClass);
      firstNestedTabPanel.classList.add(tabPanelActiveClass);
    }
  }

  function openNestedTab(event) {
    event.preventDefault();
    const tabId = this.querySelector('.luci-link').getAttribute('href');
    const tabPanel = document.querySelector(tabId + '.luci-tab__panel--nested');
    const tab = Luci.Utils.getClosestParent(this, '.luci-tab__panel');
    const tabTitles = tab.querySelectorAll('.luci-tab__list-item');
    const tabPanels = tab.querySelectorAll('.luci-tab__panel--nested');

    closeAllTabs(tabTitles, tabPanels);
    setLinkAttributes(this);
    this.classList.add(tabTitleActiveClass);
    tabPanel.classList.add(tabPanelActiveClass);
  }

  const init = function init() {
    tabNavLinks.forEach(function (tabTitle) {
      setLinkAttributes(tabTitle);
      tabTitle.addEventListener('click', openTab);
    });

    nestedTabTitles.forEach(function (tabTitle) {
      setLinkAttributes(tabTitle);
      tabTitle.addEventListener('click', openNestedTab);
    });
  };

  return {
    init: init
  };
}();

document.addEventListener('DOMContentLoaded', function () {
  Luci.Tabs.init();
});
