"use strict";

var Luci = Luci || {};

Luci.Masthead = function() {
    const mastheadMenuButton = document.querySelectorAll('.luci-masthead__menu-button:not(.luci-doc-prevent-js)'),
        navContainerWrapper = document.querySelector('.luci-navigation-container__navigation-vertical-wrapper'),
        mastheadMenuActiveClass = 'luci-masthead__menu-button--is-active',
        navContainerNavigationVerticalActiveClass = 'luci-navigation-container--navigation-vertical-is-active',
        mastheadMobileSearchButton = document.querySelectorAll('.luci-masthead__mobile-search-button'),
        mastheadMobileSearchVisibleClass = 'luci-masthead--mobile-search-is-visible',
        mastheadPreventLinkDefault = document.querySelectorAll('.luci-doc-prevent-link-default a');

    function applyMastheadState() {
        let nav_container = document.querySelector('.luci-navigation-container');
        if (nav_container) {
            if (localStorage.getItem('navigation-container-expanded') === 'false') {
                nav_container.classList.add('luci-navigation-container--prevent-transition');
                nav_container.classList.remove(navContainerNavigationVerticalActiveClass);
                setTimeout(function(){
                    nav_container.classList.remove('luci-navigation-container--prevent-transition');
                    if (localStorage.getItem('navigation-container-scrolltop')) {
                        navContainerWrapper.scrollTop = localStorage.getItem('navigation-container-scrolltop');
                    }
                }, 500);
            } else {
                if (nav_container.classList.contains(navContainerNavigationVerticalActiveClass)) {
                    localStorage.setItem('navigation-container-expanded', true);
                }
            }
            let navMenuButton = nav_container.querySelector('.luci-masthead__menu-button');
            let nav_container_navigation_vertical = nav_container.querySelector('.luci-navigation-container__navigation-vertical');
            if (localStorage.getItem('navigation-container-expanded') === 'true') {
                nav_container.classList.add('luci-navigation-container--prevent-transition');
                nav_container.classList.add(navContainerNavigationVerticalActiveClass);
                if (navMenuButton) {
                    navMenuButton.classList.add(mastheadMenuActiveClass);
                    navMenuButton.setAttribute('aria-expanded', true);
                }
                if (nav_container_navigation_vertical) {
                    nav_container_navigation_vertical.setAttribute('aria-hidden', false);
                }
                setTimeout(function(){
                    nav_container.classList.remove('luci-navigation-container--prevent-transition');
                    if (navContainerWrapper && localStorage.getItem('navigation-container-scrolltop')) {
                        navContainerWrapper.scrollTop = localStorage.getItem('navigation-container-scrolltop');
                    }
                }, 500);
            }
        }
    }

    function handleMastheadMenuButtonClick(e) {
        let nav_container = this.closest('.luci-navigation-container');
        if (nav_container) {
            let nav_container_navigation_vertical = nav_container.querySelector('.luci-navigation-container__navigation-vertical');
            nav_container.classList.toggle(navContainerNavigationVerticalActiveClass);
            if (nav_container.classList.contains(navContainerNavigationVerticalActiveClass)) {
                nav_container_navigation_vertical.setAttribute('aria-hidden', false);
            } else {
                nav_container_navigation_vertical.setAttribute('aria-hidden', true);
            }
            localStorage.setItem('navigation-container-expanded', nav_container.classList.contains(navContainerNavigationVerticalActiveClass));
        }
        this.classList.toggle(mastheadMenuActiveClass);
        if (this.classList.contains(mastheadMenuActiveClass)) {
            this.setAttribute('aria-expanded', true);
        } else {
            this.setAttribute('aria-expanded', false);
        }
    }

    function handleNavContainerWrapperScroll() {
        localStorage.setItem('navigation-container-scrolltop', this.scrollTop);
    }

    function handleMasteadMobileSearchButtonClick() {
        let masthead = this.closest('.luci-masthead');
        let searchInput = masthead.querySelector('.luci-search__form-input');
        let clearSearch = masthead.querySelector('.luci-search__button-close');

        masthead.classList.toggle(mastheadMobileSearchVisibleClass);

        if (masthead.classList.contains(mastheadMobileSearchVisibleClass)) {
            this.setAttribute('aria-expanded', true);
            setTimeout(function(){
                searchInput.focus();
            }, 300);
        } else {
            this.setAttribute('aria-expanded', false);
            clearSearch.click();
            this.focus();
        }
    }

    function handleMastheadPreventLinkDefault(e) {
        e.preventDefault();
    }

    const init = function init() {
        applyMastheadState();

        mastheadMenuButton.forEach(function(e){
            e.addEventListener('click', handleMastheadMenuButtonClick);
        });

        mastheadMobileSearchButton.forEach(function(e){
            e.addEventListener('click', handleMasteadMobileSearchButtonClick);
        });

        if (navContainerWrapper) {
            navContainerWrapper.addEventListener('scroll', handleNavContainerWrapperScroll);
        }

        mastheadPreventLinkDefault.forEach(function(e){
            e.addEventListener('click', handleMastheadPreventLinkDefault);
        });
    };

    return {
        init: init
    };
}();

document.addEventListener('DOMContentLoaded', function() {
    Luci.Masthead.init();
});
