"use strict";

function luciMenu() {
    const menuObject = document.querySelectorAll('.luci-menu'),
        menuButton = document.querySelectorAll('.luci-menu__trigger'),
        menuContent = document.querySelectorAll('.luci-menu__content'),
        menuOpenClass = 'luci-menu--is-open',
        menuLink = document.querySelectorAll('.luci-menu .luci-link');

    var i;

    function closeAllMenus() {
        for (i = 0; i < menuObject.length; i++) {
            menuObject[i].classList.remove(menuOpenClass);
        }
        if (menuLink.length) {
            for (i = 0; i < menuLink.length; i++) {
                menuLink[i].blur();
            }
        }
        for (i = 0; i < menuButton.length; i++) {
            menuButton[i].setAttribute('aria-expanded', false);
        }
        for (i = 0; i < menuContent.length; i++) {
            menuContent[i].setAttribute('aria-hidden', true);
        }
    }

    function toggleMenu(menu) {
        var target = menu.closest('.luci-menu');
        var content = target.querySelector('.luci-menu__content');

        if (target.classList.contains(menuOpenClass)) {
            closeAllMenus();
        } else {
            closeAllMenus();
            target.classList.add(menuOpenClass);
            menu.setAttribute('aria-expanded', true);
            content.setAttribute('aria-hidden', false);
        }
    }

    function handleMenuButtonClick(e) {
        e.preventDefault();
        toggleMenu(this);
    }

    menuButton.forEach(function(e){
        e.addEventListener('click', handleMenuButtonClick);
    });

    //Stop Propagation on Menu Button and Content elements
    for (i = 0; i < menuButton.length; i++) {
        menuButton[i].addEventListener('click', function(e){e.stopPropagation();});
    }

    for (i = 0; i < menuContent.length; i++) {
        menuContent[i].addEventListener('click', function(e){e.stopPropagation();});
    }

    //Close All Menus on body click
    document.addEventListener('click', function(event) {
      closeAllMenus();
    });

    function handleDocumentKeydown(e) {
        //Esc key pressed
        if (e.keyCode === 27) {
            closeAllMenus();
        }
    }

    document.addEventListener('keydown', handleDocumentKeydown);
}

document.addEventListener('DOMContentLoaded', function() {
    luciMenu();
});
