/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * Creates a small alerts notifications on the page to provide feedback messages.
 * @param type - success | info | warning | error
 * @param dismissable - true | false
 *
 * @returns void
 *
 * The color of the alert should be set according to the type and dismissable is false by default.
 * @remarks Link to Scaffolding example - http://web.rtp.netapp.com/~peters1/nwfjs_scaffolding/#/components/alert
 */
import { Component, EventEmitter, Input, Output } from '@angular/core';
export class AlertComponent {
    constructor() {
        this.type = 'warning'; // this matches bootstrap's default which is warning.
        // this matches bootstrap's default which is warning.
        /* I just proxy these straight from ng-bootstrap/alert */
        this.dismissable = false;
        this.level = '';
        this.close = new EventEmitter();
    }
    /**
     * @return {?}
     */
    onClose() {
        this.close.emit();
    }
    /**
     * @param {?} changes
     * @return {?}
     */
    ngOnChanges(changes) {
        if (changes.type && changes.type.currentValue === 'error') {
            this.type = 'critical';
        }
    }
}
AlertComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-alert',
                template: `
    <ngb-alert [dismissible]="dismissable" [type]="type" (close)="onClose()" [ngClass]="{ 'is-page-level': level == 'page' }">
      <div class="d-flex">
        <div *ngIf="type">
          <nwf-icon [severity]="type"></nwf-icon>
        </div>
        <div class="flex-grow-1 ml-2">
          <ng-content></ng-content>
        </div>
      </div>
    </ngb-alert>
  `,
                styles: [":host .alert{border:none;color:#252525;border-radius:0;font-size:14px;line-height:1.5;padding:10px 12px}:host .alert.is-page-level{box-shadow:none;border-left:none;border-right:none}:host .alert ::ng-deep h2,:host .alert ::ng-deep h3,:host .alert ::ng-deep h4,:host .alert ::ng-deep h5{font-size:16px;font-weight:600;margin:0}:host .alert ::ng-deep a{color:#252525;text-decoration:underline}:host .alert ::ng-deep .close{font-size:32px;line-height:.5;margin:0;min-height:32px;overflow:hidden;padding:4px 8px;top:4px;right:4px}:host .alert.alert-success ::ng-deep #base-layer{fill:#498128}:host .alert.alert-success ::ng-deep #glyph{fill:#b4e697!important}:host .alert.alert-success ::ng-deep .close:hover{color:#b4e697;background:#498128}:host .alert.alert-info ::ng-deep #base-layer{fill:#2d6dde}:host .alert.alert-info ::ng-deep #glyph{fill:#eff4ff!important}:host .alert.alert-info ::ng-deep .close:hover{color:#eff4ff;background:#252525}:host .alert.alert-error ::ng-deep #base-layer{fill:#da1e21}:host .alert.alert-error ::ng-deep #glyph{fill:#fccdce!important}:host .alert.alert-error ::ng-deep .close:hover{color:#fccdce;background:#da1e21}:host .alert.alert-warning ::ng-deep #base-layer{fill:#f88402}:host .alert.alert-warning ::ng-deep #glyph{fill:#ffe1a1!important}:host .alert.alert-warning ::ng-deep .close:hover{color:#ffe1a1;background:#f88402}:host .alert.alert-critical ::ng-deep #base-layer{fill:#da1e21}:host .alert.alert-critical ::ng-deep #glyph{fill:#fccdce!important}:host .alert.alert-critical ::ng-deep .close:hover{color:#fccdce;background:#da1e21}"]
            }] }
];
/** @nocollapse */
AlertComponent.ctorParameters = () => [];
AlertComponent.propDecorators = {
    type: [{ type: Input }],
    dismissable: [{ type: Input }],
    level: [{ type: Input }],
    close: [{ type: Output }]
};
if (false) {
    /** @type {?} */
    AlertComponent.prototype.type;
    /** @type {?} */
    AlertComponent.prototype.dismissable;
    /** @type {?} */
    AlertComponent.prototype.level;
    /** @type {?} */
    AlertComponent.prototype.close;
}
//# sourceMappingURL=data:application/json;base64,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