/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
import { share } from 'rxjs/operators';
import { NwfColumnsChangingService } from '../grid-columns-changing.service';
export class NwfElipsizerResizeService {
    /**
     * @param {?} columnsChangingService
     */
    constructor(columnsChangingService) {
        this.columnsChangingService = columnsChangingService;
        this.resizeEvent = new Subject();
        this.resizeEvent$ = this.resizeEvent.asObservable().pipe(share());
        this.columnsChangingService.columnsChanging$.subscribe(this.resizeEvent);
    }
    /**
     * @return {?}
     */
    resize() {
        this.resizeEvent.next();
    }
}
NwfElipsizerResizeService.decorators = [
    { type: Injectable }
];
/** @nocollapse */
NwfElipsizerResizeService.ctorParameters = () => [
    { type: NwfColumnsChangingService }
];
if (false) {
    /** @type {?} */
    NwfElipsizerResizeService.prototype.resizeEvent;
    /** @type {?} */
    NwfElipsizerResizeService.prototype.resizeEvent$;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizerResizeService.prototype.columnsChangingService;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWxpcHNpemVyLXJlc2l6ZS5zZXJ2aWNlLmpzIiwic291cmNlUm9vdCI6Im5nOi8vQG5ldGFwcC9ud2Zqc19hbmd1bGFyX2NvbXBvbmVudHMvIiwic291cmNlcyI6WyJsaWIvY29tcG9uZW50cy9lbGlwc2l6ZXIvZWxpcHNpemVyLXJlc2l6ZS5zZXJ2aWNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSxPQUFPLEVBQUUsVUFBVSxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBQzNDLE9BQU8sRUFBRSxPQUFPLEVBQUUsTUFBTSxNQUFNLENBQUM7QUFDL0IsT0FBTyxFQUFnQixLQUFLLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQztBQUNyRCxPQUFPLEVBQUUseUJBQXlCLEVBQUUsTUFBTSxrQ0FBa0MsQ0FBQztBQUc3RSxNQUFNLE9BQU8seUJBQXlCOzs7O0lBS2xDLFlBQW9CLHNCQUFpRDtRQUFqRCwyQkFBc0IsR0FBdEIsc0JBQXNCLENBQTJCO1FBSjlELGdCQUFXLEdBQWlCLElBQUksT0FBTyxFQUFFLENBQUM7UUFFMUMsaUJBQVksR0FBUSxJQUFJLENBQUMsV0FBVyxDQUFDLFlBQVksRUFBRSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDO1FBR3JFLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxnQkFBZ0IsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzdFLENBQUM7Ozs7SUFFTSxNQUFNO1FBQ1QsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUM1QixDQUFDOzs7WUFaSixVQUFVOzs7O1lBRkYseUJBQXlCOzs7O0lBSTlCLGdEQUFpRDs7SUFFakQsaURBQXlFOzs7OztJQUU3RCwyREFBeUQiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJbmplY3RhYmxlIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBTdWJqZWN0IH0gZnJvbSAncnhqcyc7XG5pbXBvcnQgeyBkZWJvdW5jZVRpbWUsIHNoYXJlIH0gZnJvbSAncnhqcy9vcGVyYXRvcnMnO1xuaW1wb3J0IHsgTndmQ29sdW1uc0NoYW5naW5nU2VydmljZSB9IGZyb20gJy4uL2dyaWQtY29sdW1ucy1jaGFuZ2luZy5zZXJ2aWNlJztcblxuQEluamVjdGFibGUoKVxuZXhwb3J0IGNsYXNzIE53ZkVsaXBzaXplclJlc2l6ZVNlcnZpY2Uge1xuICAgIHB1YmxpYyByZXNpemVFdmVudDogU3ViamVjdDxhbnk+ID0gbmV3IFN1YmplY3QoKTtcblxuICAgIHB1YmxpYyByZXNpemVFdmVudCQ6IGFueSA9IHRoaXMucmVzaXplRXZlbnQuYXNPYnNlcnZhYmxlKCkucGlwZShzaGFyZSgpKTtcblxuICAgIGNvbnN0cnVjdG9yKHByaXZhdGUgY29sdW1uc0NoYW5naW5nU2VydmljZTogTndmQ29sdW1uc0NoYW5naW5nU2VydmljZSkge1xuICAgICAgICB0aGlzLmNvbHVtbnNDaGFuZ2luZ1NlcnZpY2UuY29sdW1uc0NoYW5naW5nJC5zdWJzY3JpYmUodGhpcy5yZXNpemVFdmVudCk7XG4gICAgfVxuXG4gICAgcHVibGljIHJlc2l6ZSgpIHtcbiAgICAgICAgdGhpcy5yZXNpemVFdmVudC5uZXh0KCk7XG4gICAgfVxufVxuIl19