/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Directive, ElementRef } from '@angular/core';
import { HelpService } from './help.service';
export class HelpDirective {
    /**
     * @param {?} element
     * @param {?} helpService
     */
    constructor(element, helpService) {
        this.element = element;
        this.helpService = helpService;
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        /** @type {?} */
        const showIcon = this.showIcon == 'false' ? false : true;
        if (showIcon) {
            /** @type {?} */
            const icon = `

<svg width="18px" height="18px" viewBox="0 0 18 18" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <g id="icon-info-help" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <path d="M9,1 C4.6,1 1,4.6 1,9 C1,13.4 4.6,17 9,17 C13.4,17 17,13.4 17,9 C17,4.6 13.4,1 9,1 Z" id="base-layer" fill="#0067C5"></path>
        <path d="M9,2.75 C5.5625,2.75 2.75,5.5625 2.75,9 C2.75,12.4375 5.5625,15.25 9,15.25 C12.4375,15.25 15.25,12.4375 15.25,9 C15.25,5.5625 12.4375,2.75 9,2.75 Z" id="background" fill="#FFFFFF"></path>
        <path d="M8.204,12.375 L9.946,12.375 L9.946,14 L8.204,14 L8.204,12.375 Z M6.137,7.669 C6.137,7.19233095 6.20849928,6.75900195 6.3515,6.369 C6.49450071,5.97899805 6.70249864,5.64533472 6.9755,5.368 C7.24850137,5.09066528 7.57783141,4.87616743 7.9635,4.7245 C8.3491686,4.57283258 8.78033095,4.497 9.257,4.497 C9.65566866,4.497 10.026165,4.55549941 10.3685,4.6725 C10.710835,4.78950058 11.0098321,4.95849889 11.2655,5.1795 C11.5211679,5.4005011 11.7226659,5.67566502 11.87,6.005 C12.0173341,6.33433498 12.091,6.70699792 12.091,7.123 C12.091,7.42633485 12.0585003,7.6884989 11.9935,7.9095 C11.9284997,8.13050111 11.8418339,8.32116587 11.7335,8.4815 C11.6251661,8.64183414 11.5016674,8.7848327 11.363,8.9105 C11.2243326,9.0361673 11.0856674,9.15966606 10.947,9.281 C10.7823325,9.41966736 10.6306674,9.55399935 10.492,9.684 C10.3533326,9.81400065 10.2320005,9.95916586 10.128,10.1195 C10.0239995,10.2798341 9.94383361,10.4683323 9.8875,10.685 C9.83116638,10.9016678 9.803,11.1659984 9.803,11.478 L8.399,11.478 C8.399,11.0966648 8.41849981,10.7738347 8.4575,10.5095 C8.4965002,10.2451653 8.5593329,10.0133343 8.646,9.814 C8.7326671,9.61466567 8.8388327,9.43916742 8.9645,9.2875 C9.0901673,9.13583257 9.2396658,8.98633407 9.413,8.839 C9.55166736,8.71766606 9.6838327,8.60500052 9.8095,8.501 C9.9351673,8.39699948 10.0478328,8.28216729 10.1475,8.1565 C10.2471672,8.0308327 10.3251664,7.89000078 10.3815,7.734 C10.4378336,7.57799922 10.466,7.39166775 10.466,7.175 C10.466,6.9149987 10.4205005,6.69183427 10.3295,6.5055 C10.2384995,6.31916574 10.1280006,6.16966723 9.998,6.057 C9.86799935,5.94433277 9.72933407,5.86200026 9.582,5.81 C9.43466593,5.75799974 9.30466723,5.732 9.192,5.732 C8.65466398,5.732 8.25816794,5.90749824 8.0025,6.2585 C7.74683205,6.60950175 7.619,7.07966372 7.619,7.669 L6.137,7.669 Z" id="glyph" fill="#0067C5"></path>
    </g>
</svg>
  `;
            this.element.nativeElement.innerHTML += icon;
        }
    }
    /**
     * @param {?} element
     * @return {?}
     */
    onClick(element) {
        // element.setAttribute('launchUrl', baseContextId);
        if (typeof (this.guid) != 'undefined' && typeof (this.context) != 'undefined') {
            // Launch context sesitive help topic.
            this.helpService.helpDirectiveWindow.fDisplayHelpWithContents(this.context, this.guid);
        }
        else if (typeof (this.guid) != 'undefined') {
            this.helpService.helpDirectiveWindow.fDisplayHelpWithNavigation(null, this.guid);
        }
        else {
            this.helpService.helpDirectiveWindow.fDisplayHelpContents();
        }
    }
}
HelpDirective.decorators = [
    { type: Directive, args: [{
                selector: '[nwf-help],nwf-help',
                host: {
                    '(click)': 'onClick($event.target)',
                },
                inputs: ['guid', 'context', 'showIcon'],
                providers: [HelpService],
            },] }
];
/** @nocollapse */
HelpDirective.ctorParameters = () => [
    { type: ElementRef },
    { type: HelpService }
];
if (false) {
    /**
     * @type {?}
     * @private
     */
    HelpDirective.prototype.guid;
    /**
     * @type {?}
     * @private
     */
    HelpDirective.prototype.context;
    /**
     * @type {?}
     * @private
     */
    HelpDirective.prototype.showIcon;
    /**
     * @type {?}
     * @private
     */
    HelpDirective.prototype.element;
    /**
     * @type {?}
     * @private
     */
    HelpDirective.prototype.helpService;
}
//# sourceMappingURL=data:application/json;base64,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