/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { DomSanitizer } from '@angular/platform-browser';
import { icons } from '@netapp/nwfjs_theme/icons/icons';
export class IconComponent {
    /**
     * @param {?} sanitizer
     */
    constructor(sanitizer) {
        this.sanitizer = sanitizer;
        this.iconClass = ''; // they hand in kabob-case
        // they hand in kabob-case
        this.ontapSeverity = ''; // this flags me as ontap severity style icon.
        this.class = ''; // an optional classname they just want passed through.
        // an optional classname they just want passed through.
        this.hasLoggedDep = false;
        this.ontapSeverityCls = '';
        this.stateMap = {
            ok: 'icon-status-ok-circlecheck',
            success: 'icon-status-ok-circlecheck',
            warning: 'icon-status-warning',
            critical: 'icon-status-critical',
            error: 'icon-status-error-full',
            info: 'icon-status-info',
        };
    }
    /**
     * @return {?}
     */
    get svgContent() {
        /* if I have a severity, we load the right one */
        /** @type {?} */
        let isSeverity = false;
        if (this.severity && this.severity.toLowerCase() in this.stateMap) {
            this.iconClass = this.stateMap[this.severity.toLowerCase()];
            isSeverity = true;
        }
        // its possible that we get iconClass null
        if (!this.iconClass) {
            return '';
        }
        /* I set a flag so I don't log over and over */
        if (!this.hasLoggedDep && !isSeverity) {
            /* If they have sent me a key that I don't have warn them */
            if (!(this.iconClass in icons)) {
                console.error(`You tried to load <nwf-icon iconClass="${this.iconClass}"> but it has been deprecated.`);
                this.hasLoggedDep = true;
            }
        }
        /* return the actual html from the icons.js */
        return this.sanitizer.bypassSecurityTrustHtml(icons[this.iconClass]);
    }
    /**
     * @param {?} changes
     * @return {?}
     */
    ngOnChanges(changes) {
        if (changes && changes.ontapSeverity) {
            this.ontapSeverityCls = 'ontap-severity';
        }
        this.processedSvg = this.svgContent;
    }
}
IconComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-icon',
                template: `
    <div [ngClass]="[iconClass, class, ontapSeverityCls]" class="nwf-icon" [innerHTML]="processedSvg"></div>
  `,
                styles: [":host{display:inline-block;line-height:0;pointer-events:none}:host+.nwf-icon-label{display:inline-block;vertical-align:top;margin-left:4px}"]
            }] }
];
/** @nocollapse */
IconComponent.ctorParameters = () => [
    { type: DomSanitizer }
];
IconComponent.propDecorators = {
    iconClass: [{ type: Input }],
    ontapSeverity: [{ type: Input }],
    severity: [{ type: Input }],
    class: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    IconComponent.prototype.iconClass;
    /** @type {?} */
    IconComponent.prototype.ontapSeverity;
    /** @type {?} */
    IconComponent.prototype.severity;
    /** @type {?} */
    IconComponent.prototype.class;
    /** @type {?} */
    IconComponent.prototype.hasLoggedDep;
    /** @type {?} */
    IconComponent.prototype.processedSvg;
    /** @type {?} */
    IconComponent.prototype.ontapSeverityCls;
    /**
     * @type {?}
     * @private
     */
    IconComponent.prototype.stateMap;
    /**
     * @type {?}
     * @private
     */
    IconComponent.prototype.sanitizer;
}
//# sourceMappingURL=data:application/json;base64,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