/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input, TemplateRef } from '@angular/core';
import { NgbActiveModal } from '@ng-bootstrap/ng-bootstrap';
export class NwfConfirmationModalComponent {
    /**
     * @param {?} activeModal
     */
    constructor(activeModal) {
        this.activeModal = activeModal;
        this.status = '';
        this.showCancel = true;
        this.showDimissX = true;
        this.okButtonLabel = 'nwfjs:OK';
    }
}
NwfConfirmationModalComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-confirmation-modal',
                template: "<nwf-modal-header [status]=\"status\" (onDismiss)=\"activeModal.dismiss(false)\" [showDimissX]=\"showDimissX\">\n    {{title | i18next}}\n</nwf-modal-header>\n<div class=\"modal-body\">\n    <ng-template [ngTemplateOutlet]=\"messageTemplate\" *ngIf=\"messageTemplate\"></ng-template>\n    <div *ngIf=\"message\">{{message | i18next}}</div>\n</div>\n<div class=\"modal-footer\">\n    <button data-netapp-id=\"confirmation-modal-cancel-btn\" class=\"btn btn-link\" (click)=\"activeModal.dismiss(false)\" *ngIf=\"showCancel\">{{ 'nwfjs:cancel' | i18next }}</button>\n    <button data-netapp-id=\"confirmation-modal-ok-btn\" class=\"btn btn-primary\" (click)=\"activeModal.close(true)\">{{ okButtonLabel | i18next }}</button>\n</div>"
            }] }
];
/** @nocollapse */
NwfConfirmationModalComponent.ctorParameters = () => [
    { type: NgbActiveModal }
];
NwfConfirmationModalComponent.propDecorators = {
    title: [{ type: Input }],
    status: [{ type: Input }],
    message: [{ type: Input }],
    messageTemplate: [{ type: Input }],
    showCancel: [{ type: Input }],
    showDimissX: [{ type: Input }],
    okButtonLabel: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.title;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.status;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.message;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.messageTemplate;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.showCancel;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.showDimissX;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.okButtonLabel;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.activeModal;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uZmlybWF0aW9uLW1vZGFsLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiJuZzovL0BuZXRhcHAvbndmanNfYW5ndWxhcl9jb21wb25lbnRzLyIsInNvdXJjZXMiOlsibGliL2NvbXBvbmVudHMvbW9kYWxzL2NvbmZpcm1hdGlvbi9jb25maXJtYXRpb24tbW9kYWwuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFFLEtBQUssRUFBRSxXQUFXLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFDOUQsT0FBTyxFQUFFLGNBQWMsRUFBRSxNQUFNLDRCQUE0QixDQUFDO0FBTTVELE1BQU0sT0FBTyw2QkFBNkI7Ozs7SUFVeEMsWUFBbUIsV0FBMkI7UUFBM0IsZ0JBQVcsR0FBWCxXQUFXLENBQWdCO1FBUDlCLFdBQU0sR0FBVyxFQUFFLENBQUM7UUFHcEIsZUFBVSxHQUFZLElBQUksQ0FBQztRQUMzQixnQkFBVyxHQUFZLElBQUksQ0FBQztRQUM1QixrQkFBYSxHQUFXLFVBQVUsQ0FBQztJQUVELENBQUM7OztZQWRwRCxTQUFTLFNBQUM7Z0JBQ1QsUUFBUSxFQUFFLHdCQUF3QjtnQkFDbEMscXVCQUFrRDthQUNuRDs7OztZQUxRLGNBQWM7OztvQkFRcEIsS0FBSztxQkFDTCxLQUFLO3NCQUNMLEtBQUs7OEJBQ0wsS0FBSzt5QkFDTCxLQUFLOzBCQUNMLEtBQUs7NEJBQ0wsS0FBSzs7OztJQU5OLDhDQUE4Qjs7SUFDOUIsK0NBQW9DOztJQUNwQyxnREFBZ0M7O0lBQ2hDLHdEQUFrRDs7SUFDbEQsbURBQTJDOztJQUMzQyxvREFBNEM7O0lBQzVDLHNEQUFtRDs7SUFFdkMsb0RBQWtDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29tcG9uZW50LCBJbnB1dCwgVGVtcGxhdGVSZWYgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IE5nYkFjdGl2ZU1vZGFsIH0gZnJvbSAnQG5nLWJvb3RzdHJhcC9uZy1ib290c3RyYXAnO1xuXG5AQ29tcG9uZW50KHtcbiAgc2VsZWN0b3I6ICdud2YtY29uZmlybWF0aW9uLW1vZGFsJyxcbiAgdGVtcGxhdGVVcmw6ICcuL2NvbmZpcm1hdGlvbi1tb2RhbC5jb21wb25lbnQuaHRtbCcsXG59KVxuZXhwb3J0IGNsYXNzIE53ZkNvbmZpcm1hdGlvbk1vZGFsQ29tcG9uZW50IHtcblxuICBASW5wdXQoKSBwdWJsaWMgdGl0bGU6IHN0cmluZztcbiAgQElucHV0KCkgcHVibGljIHN0YXR1czogc3RyaW5nID0gJyc7XG4gIEBJbnB1dCgpIHB1YmxpYyBtZXNzYWdlOiBzdHJpbmc7XG4gIEBJbnB1dCgpIHB1YmxpYyBtZXNzYWdlVGVtcGxhdGU6IFRlbXBsYXRlUmVmPGFueT47XG4gIEBJbnB1dCgpIHB1YmxpYyBzaG93Q2FuY2VsOiBib29sZWFuID0gdHJ1ZTtcbiAgQElucHV0KCkgcHVibGljIHNob3dEaW1pc3NYOiBib29sZWFuID0gdHJ1ZTtcbiAgQElucHV0KCkgcHVibGljIG9rQnV0dG9uTGFiZWw6IHN0cmluZyA9ICdud2ZqczpPSyc7XG5cbiAgY29uc3RydWN0b3IocHVibGljIGFjdGl2ZU1vZGFsOiBOZ2JBY3RpdmVNb2RhbCkgeyB9XG5cbn1cbiJdfQ==