/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { DomSanitizer } from '@angular/platform-browser';
import { TransitionService } from '@uirouter/angular';
import { NwfPageAlertService } from './page-alert.service';
export class PageAlertComponent {
    /**
     * @param {?} pageAlertService
     * @param {?} sanitizer
     * @param {?} transitionService
     */
    constructor(pageAlertService, sanitizer, transitionService) {
        this.sanitizer = sanitizer;
        this.transitionService = transitionService;
        this.message = '';
        this.severity = 'success';
        this.isShowing = false;
        this.subscription = pageAlertService.pageAlert$.subscribe((/**
         * @param {?} data
         * @return {?}
         */
        (data) => {
            // TO check whether show is called or hide is called
            if (data.type === 'show') {
                this.show(data.config);
            }
            else {
                this.close();
            }
        }));
    }
    /**
     * @return {?}
     */
    ngOnDestroy() {
        // unsubscribe to ensure no memory leaks
        this.subscription.unsubscribe();
    }
    /**
     * @param {?} __0
     * @return {?}
     */
    show({ message, severity, fade }) {
        this.message = this.sanitizer.bypassSecurityTrustHtml(message);
        if (severity == 'ok') {
            severity = 'success';
        }
        if (severity == 'error') {
            severity = 'critical';
        }
        this.severity = severity;
        this.isShowing = true;
        if (fade) {
            setTimeout((/**
             * @return {?}
             */
            () => this.close()), fade);
        }
        /* I want to close when I exit this route */
        this._trans = this.transitionService.onBefore({}, this.close.bind(this));
    }
    /**
     * @return {?}
     */
    close() {
        this.isShowing = false;
        if (this._trans) {
            this._trans();
        }
    }
}
PageAlertComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-page-alert',
                template: `
    <ngb-alert [type]="severity" *ngIf="isShowing" (close)="close()" class="is-page-level">
      <div class="d-flex">
        <div *ngIf="severity">
          <nwf-icon [severity]="severity"></nwf-icon>
        </div>
        <div class="flex-grow-1 ml-2" [innerHTML]="message"></div>
      </div>
    </ngb-alert>
  `,
                styles: [""]
            }] }
];
/** @nocollapse */
PageAlertComponent.ctorParameters = () => [
    { type: NwfPageAlertService },
    { type: DomSanitizer },
    { type: TransitionService }
];
PageAlertComponent.propDecorators = {
    message: [{ type: Input }],
    severity: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    PageAlertComponent.prototype.message;
    /** @type {?} */
    PageAlertComponent.prototype.severity;
    /** @type {?} */
    PageAlertComponent.prototype.isShowing;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype.subscription;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype._trans;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype.sanitizer;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype.transitionService;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGFnZS1hbGVydC5jb21wb25lbnQuanMiLCJzb3VyY2VSb290Ijoibmc6Ly9AbmV0YXBwL253ZmpzX2FuZ3VsYXJfY29tcG9uZW50cy8iLCJzb3VyY2VzIjpbImxpYi9jb21wb25lbnRzL3BhZ2UtYWxlcnQvcGFnZS1hbGVydC5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7OztBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQUUsS0FBSyxFQUFhLE1BQU0sZUFBZSxDQUFDO0FBQzVELE9BQU8sRUFBRSxZQUFZLEVBQUUsTUFBTSwyQkFBMkIsQ0FBQztBQUN6RCxPQUFPLEVBQUUsaUJBQWlCLEVBQUUsTUFBTSxtQkFBbUIsQ0FBQztBQUN0RCxPQUFPLEVBQUUsbUJBQW1CLEVBQUUsTUFBTSxzQkFBc0IsQ0FBQztBQWdCM0QsTUFBTSxPQUFPLGtCQUFrQjs7Ozs7O0lBUzdCLFlBQVksZ0JBQXFDLEVBQVUsU0FBdUIsRUFBVSxpQkFBb0M7UUFBckUsY0FBUyxHQUFULFNBQVMsQ0FBYztRQUFVLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBbUI7UUFSaEgsWUFBTyxHQUFRLEVBQUUsQ0FBQztRQUNsQixhQUFRLEdBQVcsU0FBUyxDQUFDO1FBRXRDLGNBQVMsR0FBRyxLQUFLLENBQUM7UUFNdkIsSUFBSSxDQUFDLFlBQVksR0FBRyxnQkFBZ0IsQ0FBQyxVQUFVLENBQUMsU0FBUzs7OztRQUFDLENBQUMsSUFBSSxFQUFFLEVBQUU7WUFDakUsb0RBQW9EO1lBQ3BELElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxNQUFNLEVBQUU7Z0JBQ3hCLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO2FBQ3hCO2lCQUFNO2dCQUNMLElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQzthQUNkO1FBQ0gsQ0FBQyxFQUFDLENBQUM7SUFDTCxDQUFDOzs7O0lBRU0sV0FBVztRQUNoQix3Q0FBd0M7UUFDeEMsSUFBSSxDQUFDLFlBQVksQ0FBQyxXQUFXLEVBQUUsQ0FBQztJQUNsQyxDQUFDOzs7OztJQUVNLElBQUksQ0FBQyxFQUFFLE9BQU8sRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFO1FBQ3JDLElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyx1QkFBdUIsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUMvRCxJQUFJLFFBQVEsSUFBSSxJQUFJLEVBQUU7WUFDcEIsUUFBUSxHQUFHLFNBQVMsQ0FBQztTQUN0QjtRQUNELElBQUksUUFBUSxJQUFJLE9BQU8sRUFBRTtZQUN2QixRQUFRLEdBQUcsVUFBVSxDQUFDO1NBQ3ZCO1FBQ0QsSUFBSSxDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUM7UUFDekIsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUM7UUFFdEIsSUFBSSxJQUFJLEVBQUU7WUFDUixVQUFVOzs7WUFBQyxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLEdBQUUsSUFBSSxDQUFDLENBQUM7U0FDdEM7UUFDRCw0Q0FBNEM7UUFDNUMsSUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsaUJBQWlCLENBQUMsUUFBUSxDQUFDLEVBQUUsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQzNFLENBQUM7Ozs7SUFFTSxLQUFLO1FBQ1YsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUM7UUFDdkIsSUFBSSxJQUFJLENBQUMsTUFBTSxFQUFFO1lBQ2YsSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDO1NBQ2Y7SUFDSCxDQUFDOzs7WUE5REYsU0FBUyxTQUFDO2dCQUNULFFBQVEsRUFBRSxnQkFBZ0I7Z0JBQzFCLFFBQVEsRUFBRTs7Ozs7Ozs7O0dBU1Q7O2FBRUY7Ozs7WUFmUSxtQkFBbUI7WUFGbkIsWUFBWTtZQUNaLGlCQUFpQjs7O3NCQWtCdkIsS0FBSzt1QkFDTCxLQUFLOzs7O0lBRE4scUNBQWtDOztJQUNsQyxzQ0FBNkM7O0lBRTdDLHVDQUF5Qjs7Ozs7SUFFekIsMENBQXFCOzs7OztJQUNyQixvQ0FBZTs7Ozs7SUFFb0MsdUNBQStCOzs7OztJQUFFLCtDQUE0QyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCwgSW5wdXQsIE9uQ2hhbmdlcyB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgRG9tU2FuaXRpemVyIH0gZnJvbSAnQGFuZ3VsYXIvcGxhdGZvcm0tYnJvd3Nlcic7XG5pbXBvcnQgeyBUcmFuc2l0aW9uU2VydmljZSB9IGZyb20gJ0B1aXJvdXRlci9hbmd1bGFyJztcbmltcG9ydCB7IE53ZlBhZ2VBbGVydFNlcnZpY2UgfSBmcm9tICcuL3BhZ2UtYWxlcnQuc2VydmljZSc7XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ253Zi1wYWdlLWFsZXJ0JyxcbiAgdGVtcGxhdGU6IGBcbiAgICA8bmdiLWFsZXJ0IFt0eXBlXT1cInNldmVyaXR5XCIgKm5nSWY9XCJpc1Nob3dpbmdcIiAoY2xvc2UpPVwiY2xvc2UoKVwiIGNsYXNzPVwiaXMtcGFnZS1sZXZlbFwiPlxuICAgICAgPGRpdiBjbGFzcz1cImQtZmxleFwiPlxuICAgICAgICA8ZGl2ICpuZ0lmPVwic2V2ZXJpdHlcIj5cbiAgICAgICAgICA8bndmLWljb24gW3NldmVyaXR5XT1cInNldmVyaXR5XCI+PC9ud2YtaWNvbj5cbiAgICAgICAgPC9kaXY+XG4gICAgICAgIDxkaXYgY2xhc3M9XCJmbGV4LWdyb3ctMSBtbC0yXCIgW2lubmVySFRNTF09XCJtZXNzYWdlXCI+PC9kaXY+XG4gICAgICA8L2Rpdj5cbiAgICA8L25nYi1hbGVydD5cbiAgYCxcbiAgc3R5bGVVcmxzOiBbJy4vcGFnZS1hbGVydC5jb21wb25lbnQuc2NzcyddLFxufSlcbmV4cG9ydCBjbGFzcyBQYWdlQWxlcnRDb21wb25lbnQge1xuICBASW5wdXQoKSBwdWJsaWMgbWVzc2FnZTogYW55ID0gJyc7XG4gIEBJbnB1dCgpIHB1YmxpYyBzZXZlcml0eTogc3RyaW5nID0gJ3N1Y2Nlc3MnO1xuXG4gIHB1YmxpYyBpc1Nob3dpbmcgPSBmYWxzZTtcblxuICBwcml2YXRlIHN1YnNjcmlwdGlvbjtcbiAgcHJpdmF0ZSBfdHJhbnM7XG5cbiAgY29uc3RydWN0b3IocGFnZUFsZXJ0U2VydmljZTogTndmUGFnZUFsZXJ0U2VydmljZSwgcHJpdmF0ZSBzYW5pdGl6ZXI6IERvbVNhbml0aXplciwgcHJpdmF0ZSB0cmFuc2l0aW9uU2VydmljZTogVHJhbnNpdGlvblNlcnZpY2UpIHtcbiAgICB0aGlzLnN1YnNjcmlwdGlvbiA9IHBhZ2VBbGVydFNlcnZpY2UucGFnZUFsZXJ0JC5zdWJzY3JpYmUoKGRhdGEpID0+IHtcbiAgICAgIC8vIFRPIGNoZWNrIHdoZXRoZXIgc2hvdyBpcyBjYWxsZWQgb3IgaGlkZSBpcyBjYWxsZWRcbiAgICAgIGlmIChkYXRhLnR5cGUgPT09ICdzaG93Jykge1xuICAgICAgICB0aGlzLnNob3coZGF0YS5jb25maWcpO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgdGhpcy5jbG9zZSgpO1xuICAgICAgfVxuICAgIH0pO1xuICB9XG5cbiAgcHVibGljIG5nT25EZXN0cm95KCkge1xuICAgIC8vIHVuc3Vic2NyaWJlIHRvIGVuc3VyZSBubyBtZW1vcnkgbGVha3NcbiAgICB0aGlzLnN1YnNjcmlwdGlvbi51bnN1YnNjcmliZSgpO1xuICB9XG5cbiAgcHVibGljIHNob3coeyBtZXNzYWdlLCBzZXZlcml0eSwgZmFkZSB9KSB7XG4gICAgdGhpcy5tZXNzYWdlID0gdGhpcy5zYW5pdGl6ZXIuYnlwYXNzU2VjdXJpdHlUcnVzdEh0bWwobWVzc2FnZSk7XG4gICAgaWYgKHNldmVyaXR5ID09ICdvaycpIHtcbiAgICAgIHNldmVyaXR5ID0gJ3N1Y2Nlc3MnO1xuICAgIH1cbiAgICBpZiAoc2V2ZXJpdHkgPT0gJ2Vycm9yJykge1xuICAgICAgc2V2ZXJpdHkgPSAnY3JpdGljYWwnO1xuICAgIH1cbiAgICB0aGlzLnNldmVyaXR5ID0gc2V2ZXJpdHk7XG4gICAgdGhpcy5pc1Nob3dpbmcgPSB0cnVlO1xuXG4gICAgaWYgKGZhZGUpIHtcbiAgICAgIHNldFRpbWVvdXQoKCkgPT4gdGhpcy5jbG9zZSgpLCBmYWRlKTtcbiAgICB9XG4gICAgLyogSSB3YW50IHRvIGNsb3NlIHdoZW4gSSBleGl0IHRoaXMgcm91dGUgKi9cbiAgICB0aGlzLl90cmFucyA9IHRoaXMudHJhbnNpdGlvblNlcnZpY2Uub25CZWZvcmUoe30sIHRoaXMuY2xvc2UuYmluZCh0aGlzKSk7XG4gIH1cblxuICBwdWJsaWMgY2xvc2UoKSB7XG4gICAgdGhpcy5pc1Nob3dpbmcgPSBmYWxzZTtcbiAgICBpZiAodGhpcy5fdHJhbnMpIHtcbiAgICAgIHRoaXMuX3RyYW5zKCk7XG4gICAgfVxuICB9XG59XG4iXX0=