/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
export class NwfPageAlertService {
    constructor() {
        this.pageAlert = new Subject();
        this.pageAlert$ = this.pageAlert.asObservable();
    }
    // Method to Show Page Alert
    /**
     * @param {?} message
     * @param {?} severity
     * @param {?=} fade
     * @return {?}
     */
    show(message, severity, fade) {
        this.pageAlert.next({ type: 'show', config: { message, severity, fade } });
    }
    // Method to Hide Page Alert
    /**
     * @return {?}
     */
    hide() {
        this.pageAlert.next({ type: 'hide' });
    }
}
NwfPageAlertService.decorators = [
    { type: Injectable }
];
/** @nocollapse */
NwfPageAlertService.ctorParameters = () => [];
if (false) {
    /** @type {?} */
    NwfPageAlertService.prototype.pageAlert$;
    /**
     * @type {?}
     * @private
     */
    NwfPageAlertService.prototype.pageAlert;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGFnZS1hbGVydC5zZXJ2aWNlLmpzIiwic291cmNlUm9vdCI6Im5nOi8vQG5ldGFwcC9ud2Zqc19hbmd1bGFyX2NvbXBvbmVudHMvIiwic291cmNlcyI6WyJsaWIvY29tcG9uZW50cy9wYWdlLWFsZXJ0L3BhZ2UtYWxlcnQuc2VydmljZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7O0FBQUEsT0FBTyxFQUFFLFVBQVUsRUFBRSxNQUFNLGVBQWUsQ0FBQztBQUMzQyxPQUFPLEVBQUUsT0FBTyxFQUFFLE1BQU0sTUFBTSxDQUFDO0FBRy9CLE1BQU0sT0FBTyxtQkFBbUI7SUFNNUI7UUFGUSxjQUFTLEdBQWlCLElBQUksT0FBTyxFQUFFLENBQUM7UUFHNUMsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFlBQVksRUFBRSxDQUFDO0lBQ3BELENBQUM7Ozs7Ozs7O0lBR00sSUFBSSxDQUFDLE9BQU8sRUFBRSxRQUFRLEVBQUUsSUFBYTtRQUN4QyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksRUFBRSxNQUFNLEVBQUUsTUFBTSxFQUFFLEVBQUUsT0FBTyxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsRUFBRSxDQUFDLENBQUM7SUFDL0UsQ0FBQzs7Ozs7SUFHTSxJQUFJO1FBQ1AsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsRUFBRSxJQUFJLEVBQUUsTUFBTSxFQUFFLENBQUMsQ0FBQztJQUMxQyxDQUFDOzs7WUFuQkosVUFBVTs7Ozs7O0lBR1AseUNBQXVCOzs7OztJQUV2Qix3Q0FBZ0QiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJbmplY3RhYmxlIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBTdWJqZWN0IH0gZnJvbSAncnhqcyc7XG5cbkBJbmplY3RhYmxlKClcbmV4cG9ydCBjbGFzcyBOd2ZQYWdlQWxlcnRTZXJ2aWNlIHtcblxuICAgIHB1YmxpYyBwYWdlQWxlcnQkOiBhbnk7XG5cbiAgICBwcml2YXRlIHBhZ2VBbGVydDogU3ViamVjdDxhbnk+ID0gbmV3IFN1YmplY3QoKTtcblxuICAgIGNvbnN0cnVjdG9yKCkge1xuICAgICAgICB0aGlzLnBhZ2VBbGVydCQgPSB0aGlzLnBhZ2VBbGVydC5hc09ic2VydmFibGUoKTtcbiAgICB9XG5cbiAgICAvLyBNZXRob2QgdG8gU2hvdyBQYWdlIEFsZXJ0XG4gICAgcHVibGljIHNob3cobWVzc2FnZSwgc2V2ZXJpdHksIGZhZGU/OiBudW1iZXIpOiB2b2lkIHtcbiAgICAgICAgdGhpcy5wYWdlQWxlcnQubmV4dCh7IHR5cGU6ICdzaG93JywgY29uZmlnOiB7IG1lc3NhZ2UsIHNldmVyaXR5LCBmYWRlIH0gfSk7XG4gICAgfVxuXG4gICAgLy8gTWV0aG9kIHRvIEhpZGUgUGFnZSBBbGVydFxuICAgIHB1YmxpYyBoaWRlKCk6IHZvaWQge1xuICAgICAgICB0aGlzLnBhZ2VBbGVydC5uZXh0KHsgdHlwZTogJ2hpZGUnIH0pO1xuICAgIH1cbn1cbiJdfQ==