/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { StateService } from '@uirouter/core';
import { Chart } from 'angular-highcharts';
import { I18NextFormatPipe, I18NextPipe } from 'angular-i18next';
import { template } from 'lodash-es';
export class StackedChartComponent {
    /**
     * @param {?} stateService
     * @param {?} i18next
     * @param {?} i18NextFormatPipe
     */
    constructor(stateService, i18next, i18NextFormatPipe) {
        this.stateService = stateService;
        this.i18next = i18next;
        this.i18NextFormatPipe = i18NextFormatPipe;
        this.height = 40;
        this.marginTop = 0;
        this.marginBottom = 0;
        this.max = 100;
        this.chartTitle = '';
        this.legendsEnabled = false;
        this.axisLabelsEnabled = false;
    }
    /**
     * @return {?}
     */
    reflow() {
        this.chart.ref.reflow();
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        /** @type {?} */
        const scope = this;
        // adjusting the chart configuration according to the legends being enabled or not
        /** @type {?} */
        const noOfSeries = this.axisLabels ? this.axisLabels.length : 1;
        // This sets the default height to 50 pixels in case we have no data so the no data to display label shows
        this.height = noOfSeries === 0 ? 50 : this.height * noOfSeries;
        if (this.chartTitle != '') {
            this.height += 20;
            this.marginTop += 20;
        }
        if (this.legendsEnabled) {
            if (this.legendsLayout === 'horizontal') {
                this.height += 30;
                this.marginBottom += 30;
                this.alignment = 'center';
            }
            else if (this.legendsLayout === 'vertical') {
                this.height += 60;
                this.marginBottom += 60;
            }
        }
        if (this.axisLabelsEnabled) {
            this.max = 120;
        }
        // chart configurations
        this.chartConfig = {
            chart: {
                type: 'bar',
                height: this.height,
                marginTop: this.marginTop,
                marginBottom: this.marginBottom,
                spacing: [0, 0, 0, 0],
                animation: false,
                styledMode: true,
                events: {
                    /**
                     * @return {?}
                     */
                    load() {
                        /** @type {?} */
                        const chart = this;
                        chart.series.forEach((/**
                         * @param {?} s
                         * @return {?}
                         */
                        (s) => {
                            s.points.forEach((/**
                             * @param {?} p
                             * @return {?}
                             */
                            (p) => {
                                // update the color of the bar labelled as 'UNASSIGNED'
                                if (p.category.toString().includes('Unassigned')) {
                                    p.update({
                                        colorIndex: 3,
                                    });
                                }
                            }));
                        }));
                    },
                },
            },
            title: {
                text: this.chartTitle,
                align: 'left',
            },
            subtitle: {
                text: '',
            },
            xAxis: {
                visible: this.axisLabelsEnabled,
                categories: this.axisLabels,
                title: {
                    text: null,
                },
                labels: {
                    enabled: true,
                },
            },
            yAxis: {
                visible: this.axisLabelsEnabled,
                min: 0,
                max: this.max,
                endOnTick: false,
                labels: {
                    enabled: false,
                },
                title: {
                    text: null,
                },
                /* Stacklabels are the labels to the right of the charts
                                We want the labels outside the plot area, and crop and overflow should do that according to the api doc.
                                */
                stackLabels: {
                    enabled: true,
                    useHTML: true,
                    allowOverlap: true,
                    overflow: 'allow',
                    crop: false,
                    /**
                     * @return {?}
                     */
                    formatter() {
                        return scope.stackLabelsFormatter(scope, this);
                    },
                },
            },
            plotOptions: {
                series: {
                    stacking: 'percent',
                    borderWidth: 0,
                    events: {
                        /**
                         * @return {?}
                         */
                        legendItemClick() {
                            return false;
                        },
                    },
                },
                bar: {
                    className: 'nwf-is-link-like',
                    events: {
                        /**
                         * @param {?} event
                         * @return {?}
                         */
                        click(event) {
                            return scope.clickEvent(scope, event, this);
                        },
                    },
                },
            },
            legend: {
                enabled: this.legendsEnabled,
                reversed: true,
                useHTML: true,
                align: this.alignment,
                x: 0,
                layout: this.legendsLayout,
                floating: true,
                symbolRadius: 1,
                padding: 0,
                itemDistance: 3,
                itemMarginBottom: 5,
                /**
                 * @return {?}
                 */
                labelFormatter() {
                    return scope.legendFormatter(this);
                },
            },
            lang: {
                noData: this.i18next.transform('nwfjs:noData'),
            },
            tooltip: {
                enabled: true,
                outside: true,
                useHTML: true,
                /**
                 * @return {?}
                 */
                formatter() {
                    /** @type {?} */
                    const templateData = {
                        seriesName: this.series.name,
                        tooltipCurrentValue: scope.i18NextFormatPipe.transform(this.point.y, 'number'),
                        pointColor: this.point.graphic.getStyle('fill'),
                    };
                    /** @type {?} */
                    const tooltipBody = '${seriesName}: ${tooltipCurrentValue}';
                    /** @type {?} */
                    const tooltip = template(`<div class="nwf-highcharts-tooltip popover uib-popover-bottom">
                    <div class="popover-body">${tooltipBody}</div>
                    </div>
                    `);
                    if (this.key.toString().includes(scope.i18next.transform('nwfjs:unassigned'))) {
                        return false;
                    }
                    else {
                        return tooltip(templateData);
                    }
                },
            },
            series: this.seriesData ? this.seriesData : [(/** @type {?} */ ({
                    type: 'bar',
                    animation: false,
                    data: this.seriesData,
                }))],
        };
        this.chart = new Chart(this.chartConfig);
    }
    /**
     * @return {?}
     */
    ngOnChanges() {
        if (this.chart) {
            this.chartConfig.series = this.seriesData ? this.seriesData : [(/** @type {?} */ ({
                    type: 'bar',
                    animation: false,
                    data: this.seriesData,
                }))];
            this.chart = new Chart(this.chartConfig);
        }
    }
    /**
     * @param {?} stateParams
     * @return {?}
     */
    getLink(stateParams) {
        /** @type {?} */
        let stateParamsString = '';
        for (const key of Object.keys(stateParams)) {
            if (key != 'fromState') {
                stateParamsString = stateParamsString.concat(key + '=' + stateParams[key] + '&');
            }
        }
        stateParamsString = stateParamsString[stateParamsString.length - 1] === '&' ? stateParamsString.slice(0, -1) : stateParamsString;
        return stateParams['fromState'] + '?' + stateParamsString;
    }
}
StackedChartComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-stacked-bar-chart',
                template: "<div [chart]=\"chart\"></div>",
                styles: [":host ::ng-deep .highcharts-background{fill:none}:host ::ng-deep .highcharts-axis-line{stroke:transparent}:host ::ng-deep .highcharts-grid-line{stroke:transparent}:host ::ng-deep .highcharts-title{fill:grey;font-family:\"Source Sans Pro\",Arial,\"Helvetica Neue\",Helvetica,sans-serif;font-size:1rem}:host ::ng-deep .highcharts-axis-labels{font-family:\"Source Sans Pro\",Arial,\"Helvetica Neue\",Helvetica,sans-serif;font-size:14px}:host ::ng-deep .highcharts-legend-item.highcharts-color-0 .highcharts-point,:host ::ng-deep .highcharts-point.highcharts-color-0,:host ::ng-deep .highcharts-tooltip .highcharts-color-0{fill:#ff4548;stroke:#fff}:host ::ng-deep .highcharts-legend-item.highcharts-color-1 .highcharts-point,:host ::ng-deep .highcharts-point.highcharts-color-1,:host ::ng-deep .highcharts-tooltip .highcharts-color-1{fill:#ffac00;stroke:#fff}:host ::ng-deep .highcharts-legend-item.highcharts-color-2 .highcharts-point,:host ::ng-deep .highcharts-point.highcharts-color-2,:host ::ng-deep .highcharts-tooltip .highcharts-color-2{fill:#58c27a;stroke:#fff}:host ::ng-deep .highcharts-color-3{fill:#d7d7d7;stroke:#d7d7d7;cursor:default!important}:host .highcharts-legend-item:hover{cursor:default!important}"]
            }] }
];
/** @nocollapse */
StackedChartComponent.ctorParameters = () => [
    { type: StateService },
    { type: I18NextPipe },
    { type: I18NextFormatPipe }
];
StackedChartComponent.propDecorators = {
    seriesData: [{ type: Input }],
    chartTitle: [{ type: Input }],
    legendsEnabled: [{ type: Input }],
    legendsLayout: [{ type: Input }],
    legendFormatter: [{ type: Input }],
    stackLabelsFormatter: [{ type: Input }],
    clickEvent: [{ type: Input }],
    axisLabelsEnabled: [{ type: Input }],
    axisLabels: [{ type: Input }],
    stackLabels: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    StackedChartComponent.prototype.chart;
    /** @type {?} */
    StackedChartComponent.prototype.height;
    /** @type {?} */
    StackedChartComponent.prototype.marginTop;
    /** @type {?} */
    StackedChartComponent.prototype.marginBottom;
    /** @type {?} */
    StackedChartComponent.prototype.max;
    /** @type {?} */
    StackedChartComponent.prototype.chartConfig;
    /** @type {?} */
    StackedChartComponent.prototype.alignment;
    /** @type {?} */
    StackedChartComponent.prototype.seriesData;
    /** @type {?} */
    StackedChartComponent.prototype.chartTitle;
    /** @type {?} */
    StackedChartComponent.prototype.legendsEnabled;
    /** @type {?} */
    StackedChartComponent.prototype.legendsLayout;
    /** @type {?} */
    StackedChartComponent.prototype.legendFormatter;
    /** @type {?} */
    StackedChartComponent.prototype.stackLabelsFormatter;
    /** @type {?} */
    StackedChartComponent.prototype.clickEvent;
    /** @type {?} */
    StackedChartComponent.prototype.axisLabelsEnabled;
    /** @type {?} */
    StackedChartComponent.prototype.axisLabels;
    /** @type {?} */
    StackedChartComponent.prototype.stackLabels;
    /** @type {?} */
    StackedChartComponent.prototype.stateService;
    /**
     * @type {?}
     * @private
     */
    StackedChartComponent.prototype.i18next;
    /**
     * @type {?}
     * @private
     */
    StackedChartComponent.prototype.i18NextFormatPipe;
}
//# sourceMappingURL=data:application/json;base64,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