/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * Sets the date-time range as provided by the user. The widget has 2 calendars for selecting a set of fromDate and toDate.
 */
import { Component, Input, ViewChild } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { NgbDropdown } from '@ng-bootstrap/ng-bootstrap';
/** @type {?} */
const currentDate = new Date();
/** @type {?} */
const last13MonthsDate = new Date(currentDate.getTime() - (395 * 24 * 60 * 60 * 1000));
export class NwfDatetimeRangePicker {
    constructor() {
        this.minDate = last13MonthsDate.toISOString();
        this.maxDate = currentDate.toISOString();
    }
    /**
     * @return {?}
     */
    ngOnInit() { }
    /**
     * @param {?} changes
     * @return {?}
     */
    ngOnChanges(changes) { }
    /**
     * writeValue() - Sets the fromDate and toDate according to the input.
     * @param {?} datetimeRangeValue - any
     * @return {?} void
     */
    writeValue(datetimeRangeValue) {
        if (datetimeRangeValue) {
            [this.fromDateISOString, this.toDateISOString] = datetimeRangeValue.split('~');
            // setting visible value.
            this.setVisibleValue();
        }
    }
    /**
     * @param {?} fn
     * @return {?}
     */
    registerOnChange(fn) { this._onChange = fn; }
    /**
     * @param {?} fn
     * @return {?}
     */
    registerOnTouched(fn) { }
    /**
     * setDatetimeRange() - Sets the fromDate and toDate from the ISOStrings
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @return {?} void
     */
    setDatetimeRange() {
        // setting visible value.
        this.setVisibleValue();
        if (!this.emitChangeOnApply) {
            this.emitChange();
        }
    }
    /**
     * @return {?}
     */
    setVisibleValue() {
        this.fromDate = new Date(this.fromDateISOString);
        this.toDate = new Date(this.toDateISOString);
    }
    /**
     * Emits the new range on click of apply btn , and close the dropdown
     * @return {?}
     */
    emitChangeOnApplyClick() {
        this.emitChange();
        this.ngbDropDown.close();
    }
    /**
     * Emits the new timerange to the subscriber
     * @private
     * @return {?}
     */
    emitChange() {
        /** @type {?} */
        const newDatetimeRange = `${this.fromDateISOString}~${this.toDateISOString}`;
        // calling callback with sending the datetime range.
        this._onChange(newDatetimeRange);
    }
}
NwfDatetimeRangePicker.decorators = [
    { type: Component, args: [{
                selector: 'nwf-datetime-range-picker',
                template: "<div ngbDropdown class=\"d-inline-block\" autoClose=\"outside\" [container]=\"null\" display=\"dynamic\">\n    <button type=\"button\" class=\"btn btn-secondary btn-icon datetime-range-picker-button\" data-netapp-id=\"dateTimePicker-range-btn\"\n        id=\"nwf-grid-filtering\" ngbDropdownToggle>\n        <nwf-icon iconClass=\"icon-action-calendar\"></nwf-icon>\n        <span class=\"btn-icon-label\" data-netapp-id=\"dateTimePicker-widget-label\">\n            {{ fromDate | i18nextFormat: { format: 'datetime' } }} to\n            {{ toDate | i18nextFormat: { format: 'datetime' } }}\n        </span>\n    </button>\n    <div ngbDropdownMenu aria-labelledby=\"nwf-grid-filtering\" class=\"popover-body bg-white\">\n        <nwf-popover-title (onDismiss)=\"ngbDropDown.close()\"></nwf-popover-title>\n        <div class=\"d-flex\" data-netapp-id=\"datetime-range-picker\">\n            <div class=\"p-2 d-flex flex-column\" (click)=\"$event.stopPropagation()\"\n                data-netapp-id=\"datetime-from-picker\">\n                {{'nwfjs:from' | i18next}}\n                <nwf-datetime-picker [(ngModel)]=\"fromDateISOString\" [minDate]=\"minDate\" [maxDate]=\"toDateISOString\"\n                    (ngModelChange)=\"setDatetimeRange()\"></nwf-datetime-picker>\n            </div>\n            <div class=\"p-2 d-flex flex-column\" (click)=\"$event.stopPropagation()\" data-netapp-id=\"datetime-to-picker\">\n                {{'nwfjs:to' | i18next}}\n                <nwf-datetime-picker [(ngModel)]=\"toDateISOString\" [minDate]=\"fromDateISOString\" [maxDate]=\"maxDate\"\n                    (ngModelChange)=\"setDatetimeRange()\"></nwf-datetime-picker>\n            </div>\n        </div>\n        <button *ngIf=\"emitChangeOnApply\" class=\"btn btn-primary float-right\" data-netapp-id=\"datetime-range-picker-apply-btn\" (click)=\"emitChangeOnApplyClick()\">{{'nwfjs:apply' | i18next}}</button>\n    </div>\n</div>",
                providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: NwfDatetimeRangePicker,
                        multi: true,
                    }],
                styles: [".datetime-range-picker-button{min-width:400px}"]
            }] }
];
/** @nocollapse */
NwfDatetimeRangePicker.ctorParameters = () => [];
NwfDatetimeRangePicker.propDecorators = {
    ngbDropDown: [{ type: ViewChild, args: [NgbDropdown, { static: false },] }],
    minDate: [{ type: Input }],
    maxDate: [{ type: Input }],
    emitChangeOnApply: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.ngbDropDown;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.minDate;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.maxDate;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.emitChangeOnApply;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.fromDateISOString;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.toDateISOString;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.fromDate;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.toDate;
    /**
     * @type {?}
     * @private
     */
    NwfDatetimeRangePicker.prototype._onChange;
}
//# sourceMappingURL=data:application/json;base64,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