/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, EventEmitter, Output } from '@angular/core';
/* TODO - the 'nwf*cellTemplate' stuff should really be constants since they are shared in the../schema/schema' */
/* nwf-grid-cell-templates
 this component contains all the templates that are common across all the grids.
 Currently it contains templates for checkboxTemplate, metricCellTemplate, dateCellTemplate, statusCellTemplate, and a headerCell template for the view menu
 metric, date cellTemplates are i18n compliant.
*/
export class CellsComponent {
    constructor() {
        // Output Event handler. This selects a row on the grid.
        this.onRowSelect = new EventEmitter();
    }
    /**
     * @param {?} data
     * @return {?}
     */
    onSelect(data) {
        // emit the onRowSelect event containing rowData.
        // This event is handled by the consumer.
        this.onRowSelect.emit(data);
    }
}
CellsComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-grid-cell-templates',
                template: "<div *dxTemplate=\"let cellInfo of 'nwfRadioBoxCellTemplate'\">\n    <div class=\"custom-control custom-radio\">\n        <input type=\"radio\" id=\"dx-data-grid-checkid-{{cellInfo.value}}\" data-netapp-id=\"cell-radiobtn\"\n            class=\"custom-control-input\" [value]=\"cellInfo.value\"\n            [checked]=\"cellInfo.component.isRowSelected(cellInfo.key) ? true : null\" (click)=\"onSelect(cellInfo)\">\n        <label class=\"custom-control-label\" for=\"dx-data-grid-checkid-{{cellInfo.value}}\"></label>\n    </div>\n</div>\n\n<div *dxTemplate=\"let cellInfo of 'nwfNumberCellTemplate'\" [attr.title]=\"cellInfo.value\"\n     attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n    {{cellInfo.value | i18nextFormat : { format: 'number'} }}\n</div>\n\n<div *dxTemplate=\"let cellInfo of 'nwfDateCellTemplate'\" [attr.title]=\"cellInfo.value\"\n     attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n    {{cellInfo.value | i18nextFormat : { format: 'datetime' } }}\n</div>\n\n<div *dxTemplate=\"let cellInfo of 'nwfStatusCellTemplate'\"\n     attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n    <nwf-icon ontapSeverity=\"true\" [severity]=\"cellInfo.value\"></nwf-icon>\n</div>\n\n<div *dxTemplate=\"let cellInfo of 'nwfMetricCellTemplate'\" [attr.title]=\"cellInfo.value\"\n     attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n    {{cellInfo.value | NwfRoundUnit : {unit: cellInfo.column.unit, statType: cellInfo.column.name} }}\n</div>\n\n<div *dxTemplate=\"let cellInfo of 'nwfDefaultCellTemplate'\" [attr.title]=\"cellInfo.value\"\n    attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n    {{cellInfo.value}}\n</div>\n"
            }] }
];
/** @nocollapse */
CellsComponent.ctorParameters = () => [];
CellsComponent.propDecorators = {
    onRowSelect: [{ type: Output }]
};
if (false) {
    /** @type {?} */
    CellsComponent.prototype.onRowSelect;
}
//# sourceMappingURL=data:application/json;base64,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