/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { I18NextPipe } from 'angular-i18next';
import { DxDataGridComponent } from 'devextreme-angular';
import { isPromise } from 'rxjs/internal/util/isPromise';
export class FooterComponent {
    /**
     * @param {?} i18NextPipe
     */
    constructor(i18NextPipe) {
        this.i18NextPipe = i18NextPipe;
        this.usePagination = true;
        this.isSelectionEnabled = false;
        this.isFiltered = false;
    }
    /**
     * @return {?}
     */
    ngOnChanges() {
        this.setPaginatorI18n();
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        this.dataGrid.onContentReady.subscribe((/**
         * @param {?} data
         * @return {?}
         */
        (data) => {
            /** @type {?} */
            const gridInstance = data.component.instance();
            /** @type {?} */
            const pageIndex = gridInstance.pageIndex();
            this.currentPage = pageIndex + 1;
            this.limit = gridInstance.pageSize();
            this.offset = this.limit * pageIndex;
            this.totalRecords = gridInstance.totalCount();
            this.isFiltered = !!gridInstance.getCombinedFilter();
            this.setPaginatorI18n();
            this.setSelectedI18n(data);
        }));
        // we listen to onSelectionChanged event and update the selected rows count based on that.
        this.dataGrid.onSelectionChanged.subscribe((/**
         * @param {?} data
         * @return {?}
         */
        (data) => {
            this.setSelectedI18n(data);
        }));
    }
    /**
     * @param {?} newPageNumber
     * @return {?}
     */
    pageChangeHandler(newPageNumber) {
        this.dataGrid.instance.pageIndex(newPageNumber - 1);
    }
    /**
     * @private
     * @return {?}
     */
    setPaginatorI18n() {
        /** @type {?} */
        const title = this.getTitle(this.totalRecords);
        this.isFilteredI18n = { totalRecords: this.totalRecords, title };
        /** @type {?} */
        const offLimit = this.offset + this.limit;
        this.paginatorI18n = {
            pageStart: this.offset + 1,
            pageEnd: offLimit > this.totalRecords ? this.totalRecords : offLimit,
            totalRecords: this.totalRecords,
            title,
        };
    }
    /**
     * @private
     * @param {?} data
     * @return {?}
     */
    setSelectedI18n(data) {
        /** @type {?} */
        const getSelectedRows = data.component.instance().getSelectedRowKeys();
        /** @type {?} */
        const setRows = (/**
         * @param {?} count
         * @return {?}
         */
        (count) => {
            this.selectedRowsCount = count;
            this.selectedI18n = { title: this.getTitle(count), count };
        });
        if (isPromise(getSelectedRows)) {
            getSelectedRows.then((/**
             * @param {?} rows
             * @return {?}
             */
            (rows) => {
                setRows(rows.length);
            }));
        }
        else {
            setRows(getSelectedRows.length);
        }
    }
    /**
     * @private
     * @param {?} count
     * @return {?}
     */
    getTitle(count) {
        return this.i18NextPipe.transform(this.titleKey, { count });
    }
}
FooterComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-grid-footer',
                template: `
    <nav class="navbar navbar-expand-lg pt-2 pb-2 px-0" *ngIf="totalRecords">
      <div class="w-100 navbar-text" *ngIf="isSelectionEnabled">
        <div data-netapp-id="grid-footer-row-selected-count" *ngIf="selectedRowsCount">
          {{ "nwfjs:gridFooterSelectedCount" | i18next: selectedI18n }}
        </div>
      </div>
      <div class="w-100 navbar-text" [ngClass]="{ 'text-center': isSelectionEnabled }">
        <div *ngIf="usePagination" class="paginator-page-info" data-netapp-id="paginator-count-message">
          {{ "nwfjs:paginatorShowRecords" | i18next: paginatorI18n }}
        </div>
      </div>
      <div class="w-100 d-flex justify-content-end navbar-text">
        <ng-content *ngIf="!usePagination"></ng-content>
        <div *ngIf="!usePagination" class="paginator-page-info" data-netapp-id="paginator-count-message">
          <span *ngIf="!isFiltered">{{ "nwfjs:paginatorShowRecordsNoPagination" | i18next: isFilteredI18n }}</span>
          <span *ngIf="isFiltered">{{ "nwfjs:paginatorShowRecordsNoPaginationFiltered" | i18next: isFilteredI18n }}</span>
        </div>
        <ngb-pagination
          *ngIf="usePagination && totalRecords > 0"
          [maxSize]="5"
          [pageSize]="limit"
          (pageChange)="pageChangeHandler($event)"
          [collectionSize]="totalRecords"
          [(page)]="currentPage"
          class="pagination"
        >
          <ng-template ngbPaginationPrevious>
            <nwf-icon [iconClass]="'icon-misc-arrowleft'"></nwf-icon><span class="ml-1">{{ "nwfjs:previous" | i18next }}</span>
          </ng-template>
          <ng-template ngbPaginationNext>
            <span class="mr-1">{{ "nwfjs:next" | i18next }}</span
            ><nwf-icon [iconClass]="'icon-misc-arrowright'"></nwf-icon>
          </ng-template>
        </ngb-pagination>
      </div>
    </nav>
  `,
                styles: [".paginator-page-info{white-space:nowrap}:host ::ng-deep .pagination{align-items:center;color:#454545;display:flex;font-size:16px;list-style:none;padding:0;margin-bottom:0}:host ::ng-deep .page-link{background:0 0!important;border:none;align-items:center;display:flex;padding:8px 12px}:host ::ng-deep .page-item.active>.page-link{color:#454545;font-weight:700;pointer-events:none;background:0 0}:host ::ng-deep .page-item.disabled{color:#c2c2c2;pointer-events:none}:host ::ng-deep .page-item.disabled:hover{color:#c2c2c2;text-decoration:none}:host ::ng-deep .page-item.disabled:hover nwf-icon{color:#c2c2c2}:host ::ng-deep .navbar-text{padding:0 0 8px}"]
            }] }
];
/** @nocollapse */
FooterComponent.ctorParameters = () => [
    { type: I18NextPipe }
];
FooterComponent.propDecorators = {
    dataGrid: [{ type: Input }],
    titleKey: [{ type: Input }],
    usePagination: [{ type: Input }],
    isSelectionEnabled: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    FooterComponent.prototype.dataGrid;
    /** @type {?} */
    FooterComponent.prototype.titleKey;
    /** @type {?} */
    FooterComponent.prototype.usePagination;
    /** @type {?} */
    FooterComponent.prototype.isSelectionEnabled;
    /** @type {?} */
    FooterComponent.prototype.currentPage;
    /** @type {?} */
    FooterComponent.prototype.limit;
    /** @type {?} */
    FooterComponent.prototype.offset;
    /** @type {?} */
    FooterComponent.prototype.totalRecords;
    /** @type {?} */
    FooterComponent.prototype.selectedRowsCount;
    /** @type {?} */
    FooterComponent.prototype.isFiltered;
    /** @type {?} */
    FooterComponent.prototype.isFilteredI18n;
    /** @type {?} */
    FooterComponent.prototype.paginatorI18n;
    /** @type {?} */
    FooterComponent.prototype.selectedI18n;
    /** @type {?} */
    FooterComponent.prototype.i18NextPipe;
}
//# sourceMappingURL=data:application/json;base64,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