/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
import DataGrid from 'devextreme/ui/data_grid';
import TreeList from 'devextreme/ui/tree_list';
import { merge } from 'lodash-es';
import { NwfColumnsChangingService } from '../components/grid-columns-changing.service';
export class NwfGridOptionsService {
    /**
     * @param {?} columnsChangingService
     */
    constructor(columnsChangingService) {
        this.columnsChangingService = columnsChangingService;
    }
    /**
     * Set the global options on the DxDataGrid with defaults from nwfjs and passed in values
     * @param {?=} dataGridOptions
     * @return {?}
     */
    setGridDefaultOptions(dataGridOptions = {}) {
        // TreeList Options
        TreeList.defaultOptions({
            options: {
                // This disables right click context menus.
                /**
                 * @param {?} e
                 * @return {?}
                 */
                onContextMenuPreparing(e) {
                    e.items = [];
                },
                scrolling: {
                    useNative: false,
                },
            },
        });
        // DataGrid Options
        DataGrid.defaultOptions(merge({
            options: {
                // following options are standard for all nwfjs grids.
                allowColumnResizing: true,
                allowColumnReordering: true,
                showColumnLines: false,
                showRowLines: true,
                hoverStateEnabled: true,
                // this property synchronize the filter row, header filter, and filter builder.
                // The synchronized filter expression is stored in the filterValue option.
                filterSyncEnabled: true,
                // This disables right click context menus.
                /**
                 * @param {?} e
                 * @return {?}
                 */
                onContextMenuPreparing(e) {
                    e.items = [];
                },
                onInitialized: (/**
                 * @param {?} e
                 * @return {?}
                 */
                (e) => {
                    // Wire onColumnsChanging event to service observable
                    e.component.option('onColumnsChanging', (/**
                     * @param {?} columnChangeEvent
                     * @return {?}
                     */
                    (columnChangeEvent) => {
                        this.columnsChangingService.onColumnsChanging(columnChangeEvent);
                    }));
                }),
                pager: {
                    visible: false,
                },
                scrolling: {
                    useNative: false,
                },
            },
        }, dataGridOptions));
    }
}
NwfGridOptionsService.decorators = [
    { type: Injectable }
];
/** @nocollapse */
NwfGridOptionsService.ctorParameters = () => [
    { type: NwfColumnsChangingService }
];
if (false) {
    /**
     * @type {?}
     * @private
     */
    NwfGridOptionsService.prototype.columnsChangingService;
}
//# sourceMappingURL=data:application/json;base64,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