/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
import { TransitionService } from '@uirouter/core';
import { interval, merge, of, Subject, zip } from 'rxjs';
import { concatMap, filter, map, share, takeUntil } from 'rxjs/operators';
import { NwfBeaconConfig } from './beacon.config.service';
export class NwfBeaconService {
    /**
     * @param {?} transitionService
     * @param {?} config
     */
    constructor(transitionService, config) {
        this.transitionService = transitionService;
        this.config = config;
        // Reset beacon on transition
        this.transitionService.onBefore({}, (/**
         * @return {?}
         */
        () => {
            this.ngOnDestroy();
            this.ngOnInit();
        }));
        // Initial construction of the beacon service
        this.ngOnInit();
    }
    /**
     * @param {?} pollInterval
     * @return {?}
     */
    setInterval(pollInterval) {
        this.resetTrigger();
        this.pollingInterval = pollInterval;
        // Polling interval and signal to start the next request
        /** @type {?} */
        const pollIntervalObs = interval(pollInterval);
        // Wait for previous poll to complete before starting another poll
        /** @type {?} */
        const polling = zip(pollIntervalObs, this.nextPoll.pipe(takeUntil(this.destroyTrigger)));
        // triggerLoad is a subject that subscribes to polling as a way to pipe polling to triggerLoad
        // the reason we use function call to next is because we dont want the observables error and complete to leak through
        polling.pipe(takeUntil(this.destroyTrigger)).subscribe((/**
         * @return {?}
         */
        () => this.triggerLoad.next()));
    }
    /**
     * @param {?} trigger
     * @return {?}
     */
    setTrigger(trigger) {
        this.resetTrigger();
        this.trigger = trigger;
        trigger.pipe(takeUntil(this.destroyTrigger), takeUntil(this.destroy)).subscribe((/**
         * @return {?}
         */
        () => this.triggerLoad.next()));
    }
    // Trigger interval data request
    /**
     * @return {?}
     */
    start() {
        this.triggerLoad.next();
    }
    /**
     * @return {?}
     */
    stop() {
        if (this.trigger) {
            this.setTrigger(this.trigger);
        }
        else if (this.pollingInterval) {
            this.setInterval(this.pollingInterval);
        }
    }
    // Trigger manual data request
    /**
     * @return {?}
     */
    refresh() {
        this.manualLoad.next();
    }
    // Register service call to load data and return observable that emits the data
    /**
     * @template T
     * @param {?} serviceCall
     * @return {?}
     */
    register(serviceCall) {
        // load data observable emission gets mapped to the service method call
        // the emmission of serviceCall observable gets emmited in the serviceObservable stream
        /**
         * This is the middle of the cycle of the beacon
         * @type {?}
         */
        const serviceObservable = this.loadData.pipe(takeUntil(this.destroy), concatMap(serviceCall), share());
        // save the service call into the services list for checking complete
        this.services.push(serviceObservable);
        // the return is the serviceCalls data as an observable
        return serviceObservable;
    }
    /**
     * @private
     * @return {?}
     */
    ngOnInit() {
        this.services = [];
        this.destroy = new Subject();
        this.manualLoad = new Subject();
        this.nextPoll = new Subject();
        this.triggerLoad = new Subject();
        this.destroyTrigger = new Subject();
        /** @type {?} */
        const beaconInterval = this.config.interval;
        if (beaconInterval) {
            this.setInterval(beaconInterval);
        }
        /**
         * This is the beggining cycle of the beacon
         */
        // Load data triggers all the service calls
        this.loadData = merge(this.triggerLoad.pipe(map((/**
         * @return {?}
         */
        () => NwfBeaconService.TRIGGER))), this.manualLoad.pipe(map((/**
         * @return {?}
         */
        () => NwfBeaconService.MANUAL))))
            .pipe(takeUntil(this.destroy), // complete all subscriptions on destroy
        share());
        /**
         * This is the end cycle of the beacon
         */
        // We want to wait until all request are complete before firing off the next poll request
        this.loadComplete = this.loadData.pipe(concatMap((/**
         * @param {?} value
         * @return {?}
         */
        (value) => zip(of(value), ...this.services))), share());
        this.loadComplete.pipe(filter((/**
         * @param {?} __0
         * @return {?}
         */
        ([val]) => val === NwfBeaconService.TRIGGER))).subscribe(this.nextPoll);
    }
    /**
     * @private
     * @return {?}
     */
    resetTrigger() {
        if (this.destroyTrigger) {
            this.destroyTrigger.next();
            this.destroyTrigger.complete();
        }
        this.destroyTrigger = new Subject();
    }
    // Clean up subjects
    /**
     * @private
     * @return {?}
     */
    ngOnDestroy() {
        this.destroy.next();
        this.destroy.complete();
        this.destroyTrigger.next();
        this.destroyTrigger.complete();
        this.nextPoll.complete();
        this.manualLoad.complete();
        this.triggerLoad.complete();
    }
}
// Types of triggers to trigger is the automatic one and manual is a method call
NwfBeaconService.MANUAL = 'manual';
NwfBeaconService.TRIGGER = 'trigger';
NwfBeaconService.decorators = [
    { type: Injectable }
];
/** @nocollapse */
NwfBeaconService.ctorParameters = () => [
    { type: TransitionService },
    { type: NwfBeaconConfig }
];
if (false) {
    /** @type {?} */
    NwfBeaconService.MANUAL;
    /** @type {?} */
    NwfBeaconService.TRIGGER;
    /** @type {?} */
    NwfBeaconService.prototype.loadData;
    /** @type {?} */
    NwfBeaconService.prototype.loadComplete;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.triggerLoad;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.manualLoad;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.trigger;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.nextPoll;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.destroyTrigger;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.destroy;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.services;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.pollingInterval;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.transitionService;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.config;
}
//# sourceMappingURL=data:application/json;base64,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