/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { StateService, TransitionService } from '@uirouter/core';
import { forEach, isMatch, reduce } from 'lodash-es';
import { NwfLeftnavService } from './leftnav.service';
export class LeftnavComponent {
    /**
     * @param {?} leftnavService
     * @param {?} transitionService
     * @param {?} stateService
     */
    constructor(leftnavService, transitionService, stateService) {
        this.leftnavService = leftnavService;
        this.transitionService = transitionService;
        this.stateService = stateService;
        this.keepOtherSectionsOpen = true;
    }
    /**
     * @return {?}
     */
    repaintStateHighlight() {
        const { current, params } = this.stateService;
        setTimeout((/**
         * @return {?}
         */
        () => { this.markActiveState(this.navData, current, params); }), 0);
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        // Set my navData on the leftnavService so others (like feature tour ) can open a tree of items programatically.
        this.leftnavService.navData = this.navData;
        /* On Enter I recurse to find out what to highlight */
        this.transitionService.onSuccess({}, (/**
         * @param {?} trans
         * @return {?}
         */
        (trans) => {
            this.repaintStateHighlight();
        }));
    }
    /**
     * @param {?} changes
     * @return {?}
     */
    ngOnChanges(changes) {
        if (changes.navData && changes.navData.currentValue) {
            this.loadLeftNav(changes.navData.currentValue);
        }
    }
    /**
     * @param {?} navData
     * @return {?}
     */
    loadLeftNav(navData) {
        this.closeAll(navData);
        /* I have to find out on load where I am as well */
        this.repaintStateHighlight();
    }
    /*
       * Recurse through the navData, marking the active state, and
       * all its parents. Return true if we found a match.
       * An item is active if it's name and params matches
       * An item is also active if any of it's child is active.
       */
    /**
     * @param {?} navData
     * @param {?} state
     * @param {?=} params
     * @return {?}
     */
    markActiveState(navData, state, params = null) {
        return reduce(navData, (/**
         * @param {?} matched
         * @param {?} item
         * @return {?}
         */
        (matched, item) => {
            /** @type {?} */
            let matchesChild = false;
            if (item.children) {
                matchesChild = this.markActiveState(item.children, state, params);
            }
            if (this.keepOtherSectionsOpen) {
                /* If it's already open leave if; if it needs to be open, do it */
                if (matchesChild) {
                    item.isCollapsed = false;
                }
            }
            else {
                item.isCollapsed = !matchesChild;
            }
            /** @type {?} */
            const hasNameMatch = (item.sref !== undefined && ((state.name === item.sref) || (state.parent === item.sref)));
            /** @type {?} */
            const hasParamMatch = isMatch(params, item.srefParams || {});
            item.isActive = matchesChild || (hasNameMatch && hasParamMatch);
            matched = matched || item.isActive;
            return matched;
        }), false);
    }
    /**
     * @param {?} navData
     * @return {?}
     */
    closeAll(navData) {
        forEach(navData, (/**
         * @param {?} item
         * @return {?}
         */
        (item) => {
            item.isCollapsed = true;
            if (navData.children) {
                this.closeAll(navData.children);
            }
        }));
    }
}
LeftnavComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-left-nav',
                template: `
  <dx-scroll-view>
  <nav class="leftnav" role="navigation">
  <ul class="nwf-leftnav-items p-0 m-0">
      <li class="nwf-leftnav-item d-block" *ngFor="let item of navData" nwfLeftnavItem isTopLevel="true" [item]="item" [attr.data-netapp-id]="'leftnav-item-' + item.label | lowercase"></li>
  </ul>
  </nav>
  </dx-scroll-view>
  `,
                styles: ["nav.leftnav{display:flex;flex-direction:column;font-size:90%;top:0;padding-top:25px;overflow-x:hidden;overflow-y:auto;position:-webkit-sticky;position:sticky}"]
            }] }
];
/** @nocollapse */
LeftnavComponent.ctorParameters = () => [
    { type: NwfLeftnavService },
    { type: TransitionService },
    { type: StateService }
];
LeftnavComponent.propDecorators = {
    navData: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    LeftnavComponent.prototype.navData;
    /**
     * @type {?}
     * @private
     */
    LeftnavComponent.prototype.keepOtherSectionsOpen;
    /** @type {?} */
    LeftnavComponent.prototype.leftnavService;
    /**
     * @type {?}
     * @private
     */
    LeftnavComponent.prototype.transitionService;
    /**
     * @type {?}
     * @private
     */
    LeftnavComponent.prototype.stateService;
}
//# sourceMappingURL=data:application/json;base64,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