/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
import { BehaviorSubject } from 'rxjs';
import * as i0 from "@angular/core";
export class NwfLeftnavService {
    constructor() {
        this.navData = [];
        this.leftnavIsCollapsed = false;
        this.leftNav = new BehaviorSubject(false);
        this.leftNav$ = this.leftNav.asObservable();
    }
    /**
     * @return {?}
     */
    toggle() {
        this.leftnavIsCollapsed = !this.leftnavIsCollapsed;
        this.leftNav.next(this.leftnavIsCollapsed);
        /* This is nasty, but issuing this sends a reflow signal to highcharts that might need to resize when I toggle */
        setTimeout((/**
         * @return {?}
         */
        () => window.dispatchEvent(new Event('resize'))), 500);
    }
    /* This is used in the feature tour */
    /**
     * @param {?} callback
     * @return {?}
     */
    recurseNavData(callback) {
        /**
         * @param {?} currentNode
         * @return {?}
         */
        function recurse(currentNode) {
            if (currentNode.children) {
                for (const child of currentNode.children) {
                    recurse(child);
                }
                callback(currentNode);
            }
        }
        for (const data of this.navData) {
            recurse(data);
        }
    }
}
NwfLeftnavService.decorators = [
    { type: Injectable, args: [{
                providedIn: 'root',
            },] }
];
/** @nocollapse */
NwfLeftnavService.ctorParameters = () => [];
/** @nocollapse */ NwfLeftnavService.ngInjectableDef = i0.ɵɵdefineInjectable({ factory: function NwfLeftnavService_Factory() { return new NwfLeftnavService(); }, token: NwfLeftnavService, providedIn: "root" });
if (false) {
    /** @type {?} */
    NwfLeftnavService.prototype.navData;
    /** @type {?} */
    NwfLeftnavService.prototype.leftnavIsCollapsed;
    /** @type {?} */
    NwfLeftnavService.prototype.leftNav$;
    /**
     * @type {?}
     * @private
     */
    NwfLeftnavService.prototype.leftNav;
}
//# sourceMappingURL=data:application/json;base64,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