/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, HostListener, Inject, Input, TemplateRef, ViewChild } from '@angular/core';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { StateService } from '@uirouter/angular';
import { I18NextPipe } from 'angular-i18next';
import { NwfConfirmationModalComponent } from '../../components/modals/confirmation/confirmation-modal.component';
export class LogoutComponent {
    /**
     * @param {?} NwfAuthService
     * @param {?} modalService
     * @param {?} $state
     * @param {?} i18NextPipe
     */
    constructor(NwfAuthService, modalService, $state, i18NextPipe) {
        this.NwfAuthService = NwfAuthService;
        this.modalService = modalService;
        this.$state = $state;
        this.i18NextPipe = i18NextPipe;
    }
    /**
     * @return {?}
     */
    logout() {
        /** @type {?} */
        const showError = (/**
         * @return {?}
         */
        () => {
            /** @type {?} */
            const failedModal = this.modalService.open(NwfConfirmationModalComponent).componentInstance;
            failedModal.title = this.i18NextPipe.transform('nwfjs:error');
            failedModal.messageTemplate = this.failedMsg;
            failedModal.showCancel = false;
            failedModal.status = 'error';
        });
        /** @type {?} */
        const returnToOriginalState = (/**
         * @return {?}
         */
        () => {
            this.$state.go(this.returnState, undefined, { location: false });
        });
        return this.NwfAuthService.logout().then(returnToOriginalState).catch(showError);
    }
}
LogoutComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-logout',
                host: {
                    'class': 'dropdown-item',
                    'data-netapp-id': 'nav-logOut-link',
                },
                template: `
{{'nwfjs:logout' | i18next}}
<ng-template #failedMsg>
<strong>{{'nwfjs:logoutFailed' | i18next}}</strong>
<br>
<p>{{'nwfjs:logoutSignOutNow' | i18next}}</p>
</ng-template>
  `
            }] }
];
/** @nocollapse */
LogoutComponent.ctorParameters = () => [
    { type: undefined, decorators: [{ type: Inject, args: ['NwfAuthService',] }] },
    { type: NgbModal },
    { type: StateService },
    { type: I18NextPipe }
];
LogoutComponent.propDecorators = {
    returnState: [{ type: Input }],
    failedMsg: [{ type: ViewChild, args: ['failedMsg', { static: false },] }],
    logout: [{ type: HostListener, args: ['click',] }]
};
if (false) {
    /** @type {?} */
    LogoutComponent.prototype.returnState;
    /** @type {?} */
    LogoutComponent.prototype.failedMsg;
    /**
     * @type {?}
     * @private
     */
    LogoutComponent.prototype.NwfAuthService;
    /**
     * @type {?}
     * @private
     */
    LogoutComponent.prototype.modalService;
    /**
     * @type {?}
     * @private
     */
    LogoutComponent.prototype.$state;
    /**
     * @type {?}
     * @private
     */
    LogoutComponent.prototype.i18NextPipe;
}
//# sourceMappingURL=data:application/json;base64,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