/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { NwfLeftnavService } from '../leftnav/leftnav.service';
export class MainbodyComponent {
    /**
     * @param {?} leftnavService
     */
    constructor(leftnavService) {
        this.leftnavService = leftnavService;
        this.top = '53px';
        this.asideWidth = '300px';
        this.leftnavWidth = '200px';
        this.isLeftnavVisible = true;
        this.isAsideVisible = false;
        this.leftnavConfig = null;
        this.zeroPx = '0px';
    }
    /**
     * @private
     * @return {?}
     */
    get mainPaddingTop() {
        return parseInt(this.top) + 15 + 'px';
    }
    /**
     * @private
     * @return {?}
     */
    get mainMarginLeft() {
        /** @type {?} */
        let marginLeft = this.zeroPx;
        if (this.isLeftnavVisible) {
            marginLeft = this.leftnavWidth;
        }
        return marginLeft;
    }
    /**
     * @private
     * @return {?}
     */
    get mainMarginRight() {
        /** @type {?} */
        let marginRight = this.zeroPx;
        if (this.isAsideVisible) {
            marginRight = this.asideWidth;
        }
        return marginRight;
    }
    /**
     * @return {?}
     */
    ngOnDestroy() {
        if (this.subscription) {
            this.subscription.unsubscribe();
        }
    }
    /**
     * @return {?}
     */
    ngOnChanges() {
        this.setStyles();
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        this.setStyles();
        this.subscription = this.leftnavService.leftNav$.subscribe((/**
         * @param {?} hideLeftNav
         * @return {?}
         */
        (hideLeftNav) => {
            /** @type {?} */
            let isLeftnavVisible = true;
            if (hideLeftNav) {
                isLeftnavVisible = false;
            }
            this.isLeftnavVisible = isLeftnavVisible;
            this.setStyles();
        }));
    }
    /**
     * @private
     * @return {?}
     */
    setStyles() {
        this.mainStyles = { marginLeft: this.mainMarginLeft, marginRight: this.mainMarginRight, paddingTop: this.mainPaddingTop };
        this.sidebarStyles = { paddingTop: this.top, width: this.leftnavWidth };
        this.asideStyles = { paddingTop: this.top, width: this.asideWidth };
    }
}
MainbodyComponent.decorators = [
    { type: Component, args: [{
                template: `
    <div class="l-nwf-mainbody" [ngClass]="{ 'leftnav-is-open': isLeftnavVisible }">
      <nwf-page-alert></nwf-page-alert>
      <nav class="nwf-sidebar" [hidden]="!isLeftnavVisible" [ngStyle]="sidebarStyles">
        <ng-content *ngIf="!leftnavConfig" select="nwf-left-nav"></ng-content>
        <nwf-left-nav *ngIf="leftnavConfig" [navData]="leftnavConfig"></nwf-left-nav>
      </nav>
      <main class="px-4" [ngStyle]="mainStyles" ui-view></main>
      <aside class="" [hidden]="!isAsideVisible" [ngStyle]="asideStyles"><ng-content select=".aside"></ng-content></aside>
    </div>
  `,
                selector: 'nwf-mainbody',
                host: {
                    class: 'w-100',
                },
                styles: [".nwf-sidebar{position:fixed;top:0;bottom:0;left:0;z-index:100;background-color:#0a2d6c;box-shadow:3px 0 0 0 rgba(0,0,0,.1)}aside{position:fixed;top:0;bottom:0;right:0;background-color:#0a2d6c}[hidden]{display:none!important}"]
            }] }
];
/** @nocollapse */
MainbodyComponent.ctorParameters = () => [
    { type: NwfLeftnavService }
];
MainbodyComponent.propDecorators = {
    top: [{ type: Input }],
    asideWidth: [{ type: Input }],
    leftnavWidth: [{ type: Input }],
    isLeftnavVisible: [{ type: Input }],
    isAsideVisible: [{ type: Input }],
    leftnavConfig: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    MainbodyComponent.prototype.top;
    /** @type {?} */
    MainbodyComponent.prototype.asideWidth;
    /** @type {?} */
    MainbodyComponent.prototype.leftnavWidth;
    /** @type {?} */
    MainbodyComponent.prototype.isLeftnavVisible;
    /** @type {?} */
    MainbodyComponent.prototype.isAsideVisible;
    /** @type {?} */
    MainbodyComponent.prototype.leftnavConfig;
    /** @type {?} */
    MainbodyComponent.prototype.mainStyles;
    /** @type {?} */
    MainbodyComponent.prototype.asideStyles;
    /** @type {?} */
    MainbodyComponent.prototype.sidebarStyles;
    /** @type {?} */
    MainbodyComponent.prototype.subscription;
    /**
     * @type {?}
     * @private
     */
    MainbodyComponent.prototype.zeroPx;
    /** @type {?} */
    MainbodyComponent.prototype.leftnavService;
}
//# sourceMappingURL=data:application/json;base64,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