/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { DOCUMENT } from '@angular/common';
import { Inject, Injectable, Optional } from '@angular/core';
import { Title } from '@angular/platform-browser';
import { I18NextPipe } from 'angular-i18next';
import { APP_TITLE_ROOT } from '../../../tokens';
import * as i0 from "@angular/core";
import * as i1 from "angular-i18next";
import * as i2 from "@angular/common";
import * as i3 from "../../../tokens";
export class NwfTitleService extends Title {
    /**
     * @param {?} i18nextPipe
     * @param {?} doc
     * @param {?} appTitleRoot
     */
    constructor(i18nextPipe, doc, appTitleRoot) {
        super(doc);
        this.i18nextPipe = i18nextPipe;
        this.appTitleRoot = appTitleRoot;
        this.firstTitleSegment = this.appTitleRoot || '';
        this.sep = ' | ';
    }
    /**
     * @param {?} title
     * @return {?}
     */
    setTitle(title) {
        /** @type {?} */
        let titlesPipeSep = '';
        /** @type {?} */
        let titles = [];
        /* If I have a firstTitle, I push it on first */
        if (this.firstTitleSegment != '') {
            titles.push(this.firstTitleSegment);
        }
        /* If I am an array, I concatenate that array, otherwise I am a string and I just push it on */
        if (title instanceof Array) {
            titles = [...titles, ...title];
        }
        else {
            titles.push(title);
        }
        /* finally produce my pipe sep string, passing each over the i18next pipe so they can pass me i18n:keys */
        titlesPipeSep = titles.filter((/**
         * @param {?} item
         * @return {?}
         */
        (item) => item !== '')).map((/**
         * @param {?} item
         * @return {?}
         */
        (item) => {
            return this.i18nextPipe.transform(item);
        })).join(this.sep);
        /* Call the regular super for setTitle, now we just have a normal string */
        return super.setTitle(titlesPipeSep);
    }
}
NwfTitleService.decorators = [
    { type: Injectable, args: [{
                providedIn: 'root',
            },] }
];
/** @nocollapse */
NwfTitleService.ctorParameters = () => [
    { type: I18NextPipe },
    { type: undefined, decorators: [{ type: Inject, args: [DOCUMENT,] }] },
    { type: undefined, decorators: [{ type: Optional }, { type: Inject, args: [APP_TITLE_ROOT,] }] }
];
/** @nocollapse */ NwfTitleService.ngInjectableDef = i0.ɵɵdefineInjectable({ factory: function NwfTitleService_Factory() { return new NwfTitleService(i0.ɵɵinject(i1.I18NextPipe), i0.ɵɵinject(i2.DOCUMENT), i0.ɵɵinject(i3.APP_TITLE_ROOT, 8)); }, token: NwfTitleService, providedIn: "root" });
if (false) {
    /** @type {?} */
    NwfTitleService.prototype.firstTitleSegment;
    /**
     * @type {?}
     * @private
     */
    NwfTitleService.prototype.sep;
    /**
     * @type {?}
     * @private
     */
    NwfTitleService.prototype.i18nextPipe;
    /**
     * @type {?}
     * @private
     */
    NwfTitleService.prototype.appTitleRoot;
}
//# sourceMappingURL=data:application/json;base64,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