/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * Creates a small alerts notifications on the page to provide feedback messages.
 * @param type - success | info | warning | error
 * @param dismissable - true | false
 *
 * @returns void
 *
 * The color of the alert should be set according to the type and dismissable is false by default.
 * @remarks Link to Scaffolding example - http://web.rtp.netapp.com/~peters1/nwfjs_scaffolding/#/components/alert
 */
import { Component, EventEmitter, Input, Output } from '@angular/core';
var AlertComponent = /** @class */ (function () {
    function AlertComponent() {
        this.type = 'warning'; // this matches bootstrap's default which is warning.
        // this matches bootstrap's default which is warning.
        /* I just proxy these straight from ng-bootstrap/alert */
        this.dismissable = false;
        this.level = '';
        this.close = new EventEmitter();
    }
    /**
     * @return {?}
     */
    AlertComponent.prototype.onClose = /**
     * @return {?}
     */
    function () {
        this.close.emit();
    };
    /**
     * @param {?} changes
     * @return {?}
     */
    AlertComponent.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) {
        if (changes.type && changes.type.currentValue === 'error') {
            this.type = 'critical';
        }
    };
    AlertComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-alert',
                    template: "\n    <ngb-alert [dismissible]=\"dismissable\" [type]=\"type\" (close)=\"onClose()\" [ngClass]=\"{ 'is-page-level': level == 'page' }\">\n      <div class=\"d-flex\">\n        <div *ngIf=\"type\">\n          <nwf-icon [severity]=\"type\"></nwf-icon>\n        </div>\n        <div class=\"flex-grow-1 ml-2\">\n          <ng-content></ng-content>\n        </div>\n      </div>\n    </ngb-alert>\n  ",
                    styles: [":host .alert{border:none;color:#252525;border-radius:0;font-size:14px;line-height:1.5;padding:10px 12px}:host .alert.is-page-level{box-shadow:none;border-left:none;border-right:none}:host .alert ::ng-deep h2,:host .alert ::ng-deep h3,:host .alert ::ng-deep h4,:host .alert ::ng-deep h5{font-size:16px;font-weight:600;margin:0}:host .alert ::ng-deep a{color:#252525;text-decoration:underline}:host .alert ::ng-deep .close{font-size:32px;line-height:.5;margin:0;min-height:32px;overflow:hidden;padding:4px 8px;top:4px;right:4px}:host .alert.alert-success ::ng-deep #base-layer{fill:#498128}:host .alert.alert-success ::ng-deep #glyph{fill:#b4e697!important}:host .alert.alert-success ::ng-deep .close:hover{color:#b4e697;background:#498128}:host .alert.alert-info ::ng-deep #base-layer{fill:#2d6dde}:host .alert.alert-info ::ng-deep #glyph{fill:#eff4ff!important}:host .alert.alert-info ::ng-deep .close:hover{color:#eff4ff;background:#252525}:host .alert.alert-error ::ng-deep #base-layer{fill:#da1e21}:host .alert.alert-error ::ng-deep #glyph{fill:#fccdce!important}:host .alert.alert-error ::ng-deep .close:hover{color:#fccdce;background:#da1e21}:host .alert.alert-warning ::ng-deep #base-layer{fill:#f88402}:host .alert.alert-warning ::ng-deep #glyph{fill:#ffe1a1!important}:host .alert.alert-warning ::ng-deep .close:hover{color:#ffe1a1;background:#f88402}:host .alert.alert-critical ::ng-deep #base-layer{fill:#da1e21}:host .alert.alert-critical ::ng-deep #glyph{fill:#fccdce!important}:host .alert.alert-critical ::ng-deep .close:hover{color:#fccdce;background:#da1e21}"]
                }] }
    ];
    /** @nocollapse */
    AlertComponent.ctorParameters = function () { return []; };
    AlertComponent.propDecorators = {
        type: [{ type: Input }],
        dismissable: [{ type: Input }],
        level: [{ type: Input }],
        close: [{ type: Output }]
    };
    return AlertComponent;
}());
export { AlertComponent };
if (false) {
    /** @type {?} */
    AlertComponent.prototype.type;
    /** @type {?} */
    AlertComponent.prototype.dismissable;
    /** @type {?} */
    AlertComponent.prototype.level;
    /** @type {?} */
    AlertComponent.prototype.close;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWxlcnQuY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6Im5nOi8vQG5ldGFwcC9ud2Zqc19hbmd1bGFyX2NvbXBvbmVudHMvIiwic291cmNlcyI6WyJsaWIvY29tcG9uZW50cy9hbGVydC9hbGVydC5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7QUFXQSxPQUFPLEVBQUUsU0FBUyxFQUFFLFlBQVksRUFBRSxLQUFLLEVBQWEsTUFBTSxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBRWxGO0lBdUJFO1FBTmdCLFNBQUksR0FBMEQsU0FBUyxDQUFDLENBQUMscURBQXFEOzs7UUFFOUgsZ0JBQVcsR0FBRyxLQUFLLENBQUM7UUFDcEIsVUFBSyxHQUFHLEVBQUUsQ0FBQztRQUNWLFVBQUssR0FBRyxJQUFJLFlBQVksRUFBUSxDQUFDO0lBRW5DLENBQUM7Ozs7SUFFVCxnQ0FBTzs7O0lBQWQ7UUFDRSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ3BCLENBQUM7Ozs7O0lBRU0sb0NBQVc7Ozs7SUFBbEIsVUFBbUIsT0FBTztRQUN4QixJQUFJLE9BQU8sQ0FBQyxJQUFJLElBQUksT0FBTyxDQUFDLElBQUksQ0FBQyxZQUFZLEtBQUssT0FBTyxFQUFFO1lBQ3pELElBQUksQ0FBQyxJQUFJLEdBQUcsVUFBVSxDQUFDO1NBQ3hCO0lBQ0gsQ0FBQzs7Z0JBakNGLFNBQVMsU0FBQztvQkFDVCxRQUFRLEVBQUUsV0FBVztvQkFFckIsUUFBUSxFQUFFLDhZQVdUOztpQkFDRjs7Ozs7dUJBRUUsS0FBSzs4QkFFTCxLQUFLO3dCQUNMLEtBQUs7d0JBQ0wsTUFBTTs7SUFhVCxxQkFBQztDQUFBLEFBbENELElBa0NDO1NBbEJZLGNBQWM7OztJQUN6Qiw4QkFBd0Y7O0lBRXhGLHFDQUFvQzs7SUFDcEMsK0JBQTJCOztJQUMzQiwrQkFBa0QiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIENyZWF0ZXMgYSBzbWFsbCBhbGVydHMgbm90aWZpY2F0aW9ucyBvbiB0aGUgcGFnZSB0byBwcm92aWRlIGZlZWRiYWNrIG1lc3NhZ2VzLlxuICogQHBhcmFtIHR5cGUgLSBzdWNjZXNzIHwgaW5mbyB8IHdhcm5pbmcgfCBlcnJvclxuICogQHBhcmFtIGRpc21pc3NhYmxlIC0gdHJ1ZSB8IGZhbHNlXG4gKlxuICogQHJldHVybnMgdm9pZFxuICpcbiAqIFRoZSBjb2xvciBvZiB0aGUgYWxlcnQgc2hvdWxkIGJlIHNldCBhY2NvcmRpbmcgdG8gdGhlIHR5cGUgYW5kIGRpc21pc3NhYmxlIGlzIGZhbHNlIGJ5IGRlZmF1bHQuXG4gKiBAcmVtYXJrcyBMaW5rIHRvIFNjYWZmb2xkaW5nIGV4YW1wbGUgLSBodHRwOi8vd2ViLnJ0cC5uZXRhcHAuY29tL35wZXRlcnMxL253ZmpzX3NjYWZmb2xkaW5nLyMvY29tcG9uZW50cy9hbGVydFxuICovXG5cbmltcG9ydCB7IENvbXBvbmVudCwgRXZlbnRFbWl0dGVyLCBJbnB1dCwgT25DaGFuZ2VzLCBPdXRwdXQgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcblxuQENvbXBvbmVudCh7XG4gIHNlbGVjdG9yOiAnbndmLWFsZXJ0JyxcbiAgc3R5bGVVcmxzOiBbJy4vYWxlcnQuY29tcG9uZW50LnNjc3MnXSxcbiAgdGVtcGxhdGU6IGBcbiAgICA8bmdiLWFsZXJ0IFtkaXNtaXNzaWJsZV09XCJkaXNtaXNzYWJsZVwiIFt0eXBlXT1cInR5cGVcIiAoY2xvc2UpPVwib25DbG9zZSgpXCIgW25nQ2xhc3NdPVwieyAnaXMtcGFnZS1sZXZlbCc6IGxldmVsID09ICdwYWdlJyB9XCI+XG4gICAgICA8ZGl2IGNsYXNzPVwiZC1mbGV4XCI+XG4gICAgICAgIDxkaXYgKm5nSWY9XCJ0eXBlXCI+XG4gICAgICAgICAgPG53Zi1pY29uIFtzZXZlcml0eV09XCJ0eXBlXCI+PC9ud2YtaWNvbj5cbiAgICAgICAgPC9kaXY+XG4gICAgICAgIDxkaXYgY2xhc3M9XCJmbGV4LWdyb3ctMSBtbC0yXCI+XG4gICAgICAgICAgPG5nLWNvbnRlbnQ+PC9uZy1jb250ZW50PlxuICAgICAgICA8L2Rpdj5cbiAgICAgIDwvZGl2PlxuICAgIDwvbmdiLWFsZXJ0PlxuICBgLFxufSlcbmV4cG9ydCBjbGFzcyBBbGVydENvbXBvbmVudCBpbXBsZW1lbnRzIE9uQ2hhbmdlcyB7XG4gIEBJbnB1dCgpIHB1YmxpYyB0eXBlOiAnc3VjY2VzcycgfCAnaW5mbycgfCAnd2FybmluZycgfCAnZXJyb3InIHwgJ2NyaXRpY2FsJyA9ICd3YXJuaW5nJzsgLy8gdGhpcyBtYXRjaGVzIGJvb3RzdHJhcCdzIGRlZmF1bHQgd2hpY2ggaXMgd2FybmluZy5cbiAgLyogSSBqdXN0IHByb3h5IHRoZXNlIHN0cmFpZ2h0IGZyb20gbmctYm9vdHN0cmFwL2FsZXJ0ICovXG4gIEBJbnB1dCgpIHB1YmxpYyBkaXNtaXNzYWJsZSA9IGZhbHNlO1xuICBASW5wdXQoKSBwdWJsaWMgbGV2ZWwgPSAnJztcbiAgQE91dHB1dCgpIHB1YmxpYyBjbG9zZSA9IG5ldyBFdmVudEVtaXR0ZXI8dm9pZD4oKTtcblxuICBjb25zdHJ1Y3RvcigpIHt9XG5cbiAgcHVibGljIG9uQ2xvc2UoKSB7XG4gICAgdGhpcy5jbG9zZS5lbWl0KCk7XG4gIH1cblxuICBwdWJsaWMgbmdPbkNoYW5nZXMoY2hhbmdlcykge1xuICAgIGlmIChjaGFuZ2VzLnR5cGUgJiYgY2hhbmdlcy50eXBlLmN1cnJlbnRWYWx1ZSA9PT0gJ2Vycm9yJykge1xuICAgICAgdGhpcy50eXBlID0gJ2NyaXRpY2FsJztcbiAgICB9XG4gIH1cbn1cbiJdfQ==