/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Directive, ElementRef, HostListener, Input, Renderer2 } from '@angular/core';
import { Subject } from 'rxjs';
import { takeUntil } from 'rxjs/operators';
import { NwfElipsizerResizeService } from './elipsizer-resize.service';
var NwfElipsizer = /** @class */ (function () {
    function NwfElipsizer(el, renderer, elipsizerResizeService) {
        this.el = el;
        this.renderer = renderer;
        this.elipsizerResizeService = elipsizerResizeService;
        this.originalText = '';
        this.destroy = new Subject();
    }
    /**
     * @param {?} event
     * @return {?}
     */
    NwfElipsizer.prototype.windowResize = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        this.elipsize(false);
    };
    /**
     * @return {?}
     */
    NwfElipsizer.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        // subscribe to service to get resize calls
        this.elipsizerResizeService.resizeEvent$.pipe(takeUntil(this.destroy)).subscribe((/**
         * @return {?}
         */
        function () {
            _this.elipsize(false);
        }));
    };
    /**
     * @return {?}
     */
    NwfElipsizer.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        // Complete subject
        this.destroy.next();
        this.destroy.complete();
        // Remove element created off screen
        this.renderer.removeChild(document.body, this.tempElement);
    };
    /**
     * @param {?} changes
     * @return {?}
     */
    NwfElipsizer.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) {
        // Create temporary node on intialization
        if (!this.parentNode) {
            this.parentNode = this.renderer.parentNode(this.el.nativeElement);
            // Create element off screen
            this.textElement = this.renderer.createText(this.originalText);
            this.tempElement = this.renderer.createElement(this.el.nativeElement.tagName.toLowerCase());
            this.renderer.appendChild(this.tempElement, this.textElement);
            // Clone styles from native element
            /** @type {?} */
            var elementStyle = window.getComputedStyle(this.el.nativeElement);
            this.tempElement.style = elementStyle.cssText;
            this.renderer.setStyle(this.tempElement, 'width', 'auto');
            this.renderer.setStyle(this.tempElement, 'white-space', 'nowrap');
            this.renderer.setStyle(this.tempElement, 'overflow', 'visible');
            this.renderer.setStyle(this.tempElement, 'position', 'absolute');
            this.renderer.setStyle(this.tempElement, 'left', '-10000px');
            this.renderer.appendChild(document.body, this.tempElement);
        }
        this.elipsize(true);
    };
    // Elipsize text by creating a dom element off screen, measuring it and removing text character by character.
    // ignoreSizeCheck - ignores the optimization that checkes for element size change and doesnt update the elipsized text if the size hasn't changed.
    // Elipsize text by creating a dom element off screen, measuring it and removing text character by character.
    // ignoreSizeCheck - ignores the optimization that checkes for element size change and doesnt update the elipsized text if the size hasn't changed.
    /**
     * @param {?} ignoreSizeCheck
     * @return {?}
     */
    NwfElipsizer.prototype.elipsize = 
    // Elipsize text by creating a dom element off screen, measuring it and removing text character by character.
    // ignoreSizeCheck - ignores the optimization that checkes for element size change and doesnt update the elipsized text if the size hasn't changed.
    /**
     * @param {?} ignoreSizeCheck
     * @return {?}
     */
    function (ignoreSizeCheck) {
        /** @type {?} */
        var computedStyle = window.getComputedStyle(this.parentNode);
        /** @type {?} */
        var myLeftPad = parseInt(computedStyle.getPropertyValue('padding-left'));
        /** @type {?} */
        var myRightPad = parseInt(computedStyle.getPropertyValue('padding-right'));
        /** @type {?} */
        var theBiggestICanBe = this.parentNode.offsetWidth - myLeftPad - myRightPad;
        if (this.originalText !== undefined && theBiggestICanBe !== 0 && (ignoreSizeCheck || this.currentSizeOfElement !== theBiggestICanBe)) {
            this.currentSizeOfElement = theBiggestICanBe;
            // Loop of length of text removing one character at a time until its the proper size
            /** @type {?} */
            var finalName = this.originalText;
            this.textElement.textContent = finalName;
            // Total length of string
            /** @type {?} */
            var index = this.textElement.textContent.length;
            /** @type {?} */
            var start = 0;
            /** @type {?} */
            var end = index;
            if (this.tempElement.offsetWidth > theBiggestICanBe) {
                while (end !== start) {
                    /** @type {?} */
                    var size = Math.floor((start + end) / 2.0);
                    finalName = this.ellipsisString(this.originalText, size);
                    this.textElement.textContent = finalName;
                    /** @type {?} */
                    var width = this.tempElement.offsetWidth;
                    // Text is too big for container
                    if (width > theBiggestICanBe) {
                        end = size;
                    }
                    else {
                        // If text is smaller than container check that the ellipsis text plus one additional character is bigger than container
                        // if it is then we are at the correct size
                        this.textElement.textContent = this.ellipsisString(this.originalText, size + 1);
                        if (this.tempElement.offsetWidth > theBiggestICanBe) {
                            break;
                            // Text is too small for container
                        }
                        else {
                            start = size;
                        }
                    }
                }
            }
            // Set final elipsized text
            this.el.nativeElement.innerText = finalName;
        }
    };
    /**
     * @param {?} text
     * @param {?} size
     * @return {?}
     */
    NwfElipsizer.prototype.ellipsisString = /**
     * @param {?} text
     * @param {?} size
     * @return {?}
     */
    function (text, size) {
        if (text.length !== size) {
            text = text.slice(0, Math.ceil(size / 2.0)) + String.fromCharCode(8230) + text.slice(text.length - Math.floor(size / 2.0));
        }
        return text;
    };
    NwfElipsizer.decorators = [
        { type: Directive, args: [{
                    selector: '[nwfElipsizer]',
                    host: {
                        '[style.white-space]': '"nowrap"',
                        '[style.display]': '"inline-block"',
                    },
                },] }
    ];
    /** @nocollapse */
    NwfElipsizer.ctorParameters = function () { return [
        { type: ElementRef },
        { type: Renderer2 },
        { type: NwfElipsizerResizeService }
    ]; };
    NwfElipsizer.propDecorators = {
        originalText: [{ type: Input, args: ['nwfElipsizer',] }],
        windowResize: [{ type: HostListener, args: ['window:resize', ['$event'],] }]
    };
    return NwfElipsizer;
}());
export { NwfElipsizer };
if (false) {
    /** @type {?} */
    NwfElipsizer.prototype.originalText;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.currentSizeOfElement;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.destroy;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.parentNode;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.textElement;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.tempElement;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.el;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.renderer;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.elipsizerResizeService;
}
//# sourceMappingURL=data:application/json;base64,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