/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
import { Component, Input } from '@angular/core';
import { StateService } from '@uirouter/core';
import { Chart } from 'angular-highcharts';
import { I18NextPipe } from 'angular-i18next';
import { template } from 'lodash-es';
import { isUndefined } from 'lodash-es';
import { merge, Subject } from 'rxjs';
import { delay, takeUntil } from 'rxjs/operators';
import { NwfLeftnavService } from '../../shell/leftnav/leftnav.service';
import { NwfColumnsChangingService } from '../grid-columns-changing.service';
var HorizontalBarChartComponent = /** @class */ (function () {
    function HorizontalBarChartComponent(i18next, leftNavService, columnsChangingService, stateService) {
        this.i18next = i18next;
        this.leftNavService = leftNavService;
        this.columnsChangingService = columnsChangingService;
        this.stateService = stateService;
        this.totalValue = 100; // This bar can represent a value out of any totalValue given
        // This bar can represent a value out of any totalValue given
        this.seriesName = 'Value';
        // chart needs a unique identifier when we have multiple charts. This is used for on click navigation
        this.showTooltip = true;
        // @Input() width = 300;
        this.height = 20;
        // Enables color zones for soft/hard limits values given
        this.zones = false;
        // Enables y-axis labels for bar chart to show range info like 25%, 50%, 100%
        this.axisLabels = false;
        this.axisUnit = '';
        this.legendsEnabled = false;
        this.plotLinesConfig = [];
        this.destroy = new Subject();
        this.isUndefined = isUndefined;
        this.className = 'none';
        this.minWidth = 2;
    }
    /**
     * @return {?}
     */
    HorizontalBarChartComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var e_1, _a;
        var _this = this;
        /** @type {?} */
        var scope = this;
        // If soft,hard limits are passed, we show plot lines on the bar chart accordingly
        if (this.softLimit) {
            this.plotLinesConfig.push({
                value: this.softLimit,
                width: 2,
                zIndex: 5,
                className: 'nwf-soft-limit',
            });
        }
        if (this.hardLimit) {
            this.plotLinesConfig.push({
                value: this.hardLimit,
                width: 2,
                zIndex: 5,
                className: 'nwf-hard-limit',
            });
        }
        // If 'zones' is true, we set default, soft & hard limit zones
        if (this.zones && this.softLimit && this.hardLimit) {
            this.zonesConfig = [
                {
                    value: this.softLimit >= this.currentValue ? this.softLimit - 1 : 0,
                    className: 'nwf-default-zone',
                },
                {
                    value: this.hardLimit,
                    className: 'nwf-soft-limit-zone',
                }, {
                    className: 'nwf-hard-limit-zone',
                },
            ];
        }
        // Calculate chart height
        // when axis labels are shown, chart requires additional height i.e. +21 to current value:20
        if (this.axisLabels) {
            this.height += 21;
        }
        if (this.legendsEnabled) {
            this.height += 40;
        }
        // We allow only one bar for now with seriesData
        if (this.seriesData) {
            try {
                for (var _b = tslib_1.__values(this.seriesData), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var series = _c.value;
                    series.pointPadding = 0;
                    series.groupPadding = 0;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        // // when tooltip is formatted by consumer set outside to false
        if (this.onClickFunction) {
            this.className = 'nwf-is-link-like';
        }
        if (this.currentValue === 0) {
            this.minWidth = 0;
        }
        this.chart = new Chart({
            chart: {
                type: 'bar',
                height: this.height,
                spacing: [0, 0, 0, 0],
                styledMode: true,
            },
            tooltip: this.toolTipObj ? this.toolTipObj : {
                outside: true,
                enabled: this.showTooltip,
                useHTML: true,
                formatter: /**
                 * @return {?}
                 */
                function () {
                    if (scope.tooltipFormatter) {
                        return scope.tooltipFormatter(scope, this);
                    }
                    else {
                        /** @type {?} */
                        var templateData = {
                            seriesName: this.series.name,
                            tooltipCurrentValue: this.point['tooltipCurrentValue'],
                            tooltipSoftLimitValue: this.point['tooltipSoftLimitValue'],
                            tooltipHardLimitValue: this.point['tooltipHardLimitValue'],
                            softLimit: this.point['i18nRef'] ? this.point['i18nRef'].transform('nwfjs:softLimit') : '',
                            hardLimit: this.point['i18nRef'] ? this.point['i18nRef'].transform('nwfjs:hardLimit') : '',
                            exceedsHardLimit: this.point['i18nRef'] ? this.point['i18nRef'].transform('nwfjs:exceedsHardLimit') : '',
                            exceedsSoftLimit: this.point['i18nRef'] ? this.point['i18nRef'].transform('nwfjs:exceedsSoftLimit') : '',
                        };
                        /** @type {?} */
                        var tooltipBody = '<span class="tooltip-current-series">\u25CF </span>${seriesName}: ${tooltipCurrentValue}';
                        if (this.point['softLimit'] || this.point['hardLimit']) {
                            // If limits exceeded, show an additional header message about the breach
                            if (this.point.y > this.point['hardLimit']) {
                                tooltipBody = '${seriesName} ${exceedsHardLimit}<br\>' + tooltipBody;
                            }
                            else if (this.point.y > this.point['softLimit']) {
                                tooltipBody = '${seriesName} ${exceedsSoftLimit}<br\>' + tooltipBody;
                            }
                            // Appends Soft Limit, Hard Limit values to the tooltip
                            tooltipBody += '<br><span class="tooltip-soft-limit-series">\u25CF </span>${softLimit}: ${tooltipSoftLimitValue}';
                            tooltipBody += '<br><span class="tooltip-hard-limit-series">\u25CF </span>${hardLimit}: ${tooltipHardLimitValue}';
                        }
                        /** @type {?} */
                        var tooltip = template("<div class=\"nwf-highcharts-tooltip popover uib-popover-bottom\">\n                    <div class=\"arrow\"></div>\n                    <div class=\"popover-body\">" + tooltipBody + "</div>\n                    </div>\n                    ");
                        return tooltip(templateData);
                    }
                },
            },
            title: {
                text: '',
            },
            subtitle: {
                text: '',
            },
            xAxis: {
                gridLineColor: 'transparent',
                visible: false,
                title: {
                    text: null,
                },
                labels: {
                    enabled: false,
                },
            },
            yAxis: {
                max: this.totalValue,
                endOnTick: false,
                visible: true,
                title: {
                    text: null,
                },
                labels: {
                    enabled: this.axisLabels,
                    format: '{value}' + this.axisUnit,
                    style: {
                        textOverflow: 'none',
                    },
                },
                plotLines: !this.zones ? this.plotLinesConfig : undefined,
                reversedStacks: this.seriesData ? false : true,
            },
            plotOptions: {
                bar: {
                    minPointLength: this.minWidth,
                    dataLabels: {
                        enabled: false,
                    },
                    className: this.className,
                    events: {
                        click: /**
                         * @param {?} event
                         * @return {?}
                         */
                        function (event) {
                            if (scope.onClickFunction) {
                                return scope.onClickFunction(scope, event);
                            }
                            else {
                                return false;
                            }
                        },
                    },
                },
                series: {
                    zones: this.zonesConfig,
                    stacking: this.seriesData ? 'normal' : undefined,
                },
            },
            legend: {
                enabled: this.legendsEnabled,
            },
            credits: {
                enabled: false,
            },
            series: this.seriesData ? this.seriesData : [(/** @type {?} */ ({
                    pointPadding: 0,
                    groupPadding: 0,
                    animation: false,
                    name: this.seriesName,
                    data: [{
                            y: this.currentValue,
                            softLimit: this.softLimit,
                            hardLimit: this.hardLimit,
                            // If we need to show custom strings in the tooltip, we use below values
                            tooltipSoftLimitValue: this.tooltipSoftLimitValue ? this.tooltipSoftLimitValue : this.softLimit,
                            tooltipHardLimitValue: this.tooltipHardLimitValue ? this.tooltipHardLimitValue : this.hardLimit,
                            tooltipCurrentValue: this.tooltipCurrentValue ? this.tooltipCurrentValue : this.currentValue,
                            i18nRef: this.i18next,
                        }],
                }))],
        });
        merge(this.leftNavService.leftNav$, this.columnsChangingService.columnsChanging$)
            .pipe(takeUntil(this.destroy), delay(10))
            .subscribe((/**
         * @return {?}
         */
        function () {
            if (_this.chart && _this.chart.ref) {
                _this.chart.ref.reflow();
            }
        }));
    };
    /**
     * @return {?}
     */
    HorizontalBarChartComponent.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        // Signal end of subscription to observables
        this.destroy.next();
        this.destroy.complete();
    };
    HorizontalBarChartComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-horizontal-bar-chart',
                    template: "<div class=\"row no-gutters\">\n\n    <div class=\"col align-middle\" [chart]=\"chart\" [ngClass]=\"{ 'pr-1 col-lg-7 col-sm-12' : !isUndefined(labelPrimary) || !isUndefined(labelSecondary)}\">\n    </div>\n\n    <div class=\"col-lg-5 col-sm-12 d-flex flex-row align-items-center flex-wrap\"\n        *ngIf=\"!isUndefined(labelPrimary) || !isUndefined(labelSecondary)\">\n\n        <div class=\"inline-label pr-1\" [ngClass]=\"{ 'border-right-custom': !isUndefined(labelSecondary)}\"\n            *ngIf=\"!isUndefined(labelPrimary)\">\n            {{labelPrimary}}\n        </div>\n        <div class=\"px-1 inline-label\" *ngIf=\"!isUndefined(labelSecondary)\">\n            {{ labelSecondary}}\n        </div>\n\n    </div>\n</div>",
                    styles: ["::ng-deep .tooltip-current-series{color:#61dce8}::ng-deep .tooltip-soft-limit-series{color:#f88402}::ng-deep .tooltip-hard-limit-series{color:#da1e21}:host ::ng-deep .highcharts-background{fill:none}:host ::ng-deep .highcharts-plot-background{fill:#d7d7d7}:host ::ng-deep .highcharts-plot-line.nwf-soft-limit{stroke:#f88402;stroke-width:2px}:host ::ng-deep .highcharts-plot-line.nwf-hard-limit{stroke:#da1e21;stroke-width:2px}:host ::ng-deep .highcharts-point.nwf-default-zone{fill:#61dce8;stroke:#61dce8}:host ::ng-deep .highcharts-point.nwf-soft-limit-zone{fill:#f88402;stroke:#f88402}:host ::ng-deep .highcharts-point.nwf-hard-limit-zone{fill:#da1e21;stroke:#da1e21}:host ::ng-deep .highcharts-grid-line{stroke:transparent}:host ::ng-deep .highcharts-container{width:100%!important}:host ::ng-deep .highcharts-container>svg:first-child{width:100%!important}:host .inline-label{font-size:12px;font-weight:600}:host .border-right-custom{border-right:1px solid #000}"]
                }] }
    ];
    /** @nocollapse */
    HorizontalBarChartComponent.ctorParameters = function () { return [
        { type: I18NextPipe },
        { type: NwfLeftnavService },
        { type: NwfColumnsChangingService },
        { type: StateService }
    ]; };
    HorizontalBarChartComponent.propDecorators = {
        currentValue: [{ type: Input }],
        totalValue: [{ type: Input }],
        seriesName: [{ type: Input }],
        seriesId: [{ type: Input }],
        showTooltip: [{ type: Input }],
        labelPrimary: [{ type: Input }],
        labelSecondary: [{ type: Input }],
        softLimit: [{ type: Input }],
        hardLimit: [{ type: Input }],
        tooltipSoftLimitValue: [{ type: Input }],
        tooltipHardLimitValue: [{ type: Input }],
        tooltipCurrentValue: [{ type: Input }],
        zones: [{ type: Input }],
        axisLabels: [{ type: Input }],
        axisUnit: [{ type: Input }],
        seriesData: [{ type: Input }],
        legendsEnabled: [{ type: Input }],
        toolTipObj: [{ type: Input }],
        onClickFunction: [{ type: Input }],
        tooltipFormatter: [{ type: Input }]
    };
    return HorizontalBarChartComponent;
}());
export { HorizontalBarChartComponent };
if (false) {
    /** @type {?} */
    HorizontalBarChartComponent.prototype.currentValue;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.totalValue;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.seriesName;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.seriesId;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.showTooltip;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.labelPrimary;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.labelSecondary;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.softLimit;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.hardLimit;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.tooltipSoftLimitValue;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.tooltipHardLimitValue;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.tooltipCurrentValue;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.height;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.zones;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.axisLabels;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.axisUnit;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.seriesData;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.legendsEnabled;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.toolTipObj;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.onClickFunction;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.tooltipFormatter;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.chart;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.chartWithPlotLines;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.plotLinesConfig;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.zonesConfig;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.destroy;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.isUndefined;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.className;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.minWidth;
    /**
     * @type {?}
     * @private
     */
    HorizontalBarChartComponent.prototype.i18next;
    /**
     * @type {?}
     * @private
     */
    HorizontalBarChartComponent.prototype.leftNavService;
    /**
     * @type {?}
     * @private
     */
    HorizontalBarChartComponent.prototype.columnsChangingService;
    /**
     * @type {?}
     * @private
     */
    HorizontalBarChartComponent.prototype.stateService;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaG9yaXpvbnRhbC1iYXItY2hhcnQuY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6Im5nOi8vQG5ldGFwcC9ud2Zqc19hbmd1bGFyX2NvbXBvbmVudHMvIiwic291cmNlcyI6WyJsaWIvY29tcG9uZW50cy9ob3Jpem9udGFsLWJhci1jaGFydC9ob3Jpem9udGFsLWJhci1jaGFydC5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxPQUFPLEVBQVksU0FBUyxFQUFFLEtBQUssRUFBcUIsTUFBTSxlQUFlLENBQUM7QUFDOUUsT0FBTyxFQUFFLFlBQVksRUFBRSxNQUFNLGdCQUFnQixDQUFDO0FBQzlDLE9BQU8sRUFBRSxLQUFLLEVBQUUsTUFBTSxvQkFBb0IsQ0FBQztBQUMzQyxPQUFPLEVBQUUsV0FBVyxFQUFFLE1BQU0saUJBQWlCLENBQUM7QUFFOUMsT0FBTyxFQUFFLFFBQVEsRUFBRSxNQUFNLFdBQVcsQ0FBQztBQUNyQyxPQUFPLEVBQUUsV0FBVyxFQUFFLE1BQU0sV0FBVyxDQUFDO0FBQ3hDLE9BQU8sRUFBRSxLQUFLLEVBQUUsT0FBTyxFQUFFLE1BQU0sTUFBTSxDQUFDO0FBQ3RDLE9BQU8sRUFBRSxLQUFLLEVBQUUsU0FBUyxFQUFFLE1BQU0sZ0JBQWdCLENBQUM7QUFDbEQsT0FBTyxFQUFFLGlCQUFpQixFQUFFLE1BQU0scUNBQXFDLENBQUM7QUFDeEUsT0FBTyxFQUFFLHlCQUF5QixFQUFFLE1BQU0sa0NBQWtDLENBQUM7QUFFN0U7SUF1REkscUNBQW9CLE9BQW9CLEVBQVUsY0FBaUMsRUFBVSxzQkFBaUQsRUFBVSxZQUEwQjtRQUE5SixZQUFPLEdBQVAsT0FBTyxDQUFhO1FBQVUsbUJBQWMsR0FBZCxjQUFjLENBQW1CO1FBQVUsMkJBQXNCLEdBQXRCLHNCQUFzQixDQUEyQjtRQUFVLGlCQUFZLEdBQVosWUFBWSxDQUFjO1FBL0NsSyxlQUFVLEdBQUcsR0FBRyxDQUFDLENBQUMsNkRBQTZEOztRQUMvRSxlQUFVLEdBQUcsT0FBTyxDQUFDOztRQUdyQixnQkFBVyxHQUFHLElBQUksQ0FBQzs7UUFlNUIsV0FBTSxHQUFHLEVBQUUsQ0FBQzs7UUFHSCxVQUFLLEdBQUcsS0FBSyxDQUFDOztRQUdkLGVBQVUsR0FBRyxLQUFLLENBQUM7UUFDbkIsYUFBUSxHQUFHLEVBQUUsQ0FBQztRQUlkLG1CQUFjLEdBQUcsS0FBSyxDQUFDO1FBU2hDLG9CQUFlLEdBQTRCLEVBQUUsQ0FBQztRQUc5QyxZQUFPLEdBQWlCLElBQUksT0FBTyxFQUFFLENBQUM7UUFDdEMsZ0JBQVcsR0FBRyxXQUFXLENBQUM7UUFDMUIsY0FBUyxHQUFHLE1BQU0sQ0FBQztRQUNuQixhQUFRLEdBQUcsQ0FBQyxDQUFDO0lBRWtLLENBQUM7Ozs7SUFFaEwsOENBQVE7OztJQUFmOztRQUFBLGlCQTBNQzs7WUF4TVMsS0FBSyxHQUFHLElBQUk7UUFDbEIsa0ZBQWtGO1FBQ2xGLElBQUksSUFBSSxDQUFDLFNBQVMsRUFBRTtZQUNoQixJQUFJLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQztnQkFDdEIsS0FBSyxFQUFFLElBQUksQ0FBQyxTQUFTO2dCQUNyQixLQUFLLEVBQUUsQ0FBQztnQkFDUixNQUFNLEVBQUUsQ0FBQztnQkFDVCxTQUFTLEVBQUUsZ0JBQWdCO2FBQzlCLENBQUMsQ0FBQztTQUNOO1FBQ0QsSUFBSSxJQUFJLENBQUMsU0FBUyxFQUFFO1lBQ2hCLElBQUksQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDO2dCQUN0QixLQUFLLEVBQUUsSUFBSSxDQUFDLFNBQVM7Z0JBQ3JCLEtBQUssRUFBRSxDQUFDO2dCQUNSLE1BQU0sRUFBRSxDQUFDO2dCQUNULFNBQVMsRUFBRSxnQkFBZ0I7YUFDOUIsQ0FBQyxDQUFDO1NBQ047UUFFRCw4REFBOEQ7UUFDOUQsSUFBSSxJQUFJLENBQUMsS0FBSyxJQUFJLElBQUksQ0FBQyxTQUFTLElBQUksSUFBSSxDQUFDLFNBQVMsRUFBRTtZQUNoRCxJQUFJLENBQUMsV0FBVyxHQUFHO2dCQUNmO29CQUNJLEtBQUssRUFBRSxJQUFJLENBQUMsU0FBUyxJQUFJLElBQUksQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxTQUFTLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO29CQUNuRSxTQUFTLEVBQUUsa0JBQWtCO2lCQUNoQztnQkFDRDtvQkFDSSxLQUFLLEVBQUUsSUFBSSxDQUFDLFNBQVM7b0JBQ3JCLFNBQVMsRUFBRSxxQkFBcUI7aUJBQ25DLEVBQUU7b0JBQ0MsU0FBUyxFQUFFLHFCQUFxQjtpQkFDbkM7YUFDSixDQUFDO1NBQ0w7UUFFRCx5QkFBeUI7UUFDekIsNEZBQTRGO1FBQzVGLElBQUksSUFBSSxDQUFDLFVBQVUsRUFBRTtZQUNqQixJQUFJLENBQUMsTUFBTSxJQUFJLEVBQUUsQ0FBQztTQUNyQjtRQUNELElBQUksSUFBSSxDQUFDLGNBQWMsRUFBRTtZQUNyQixJQUFJLENBQUMsTUFBTSxJQUFJLEVBQUUsQ0FBQztTQUNyQjtRQUNELGdEQUFnRDtRQUNoRCxJQUFJLElBQUksQ0FBQyxVQUFVLEVBQUU7O2dCQUNqQixLQUFxQixJQUFBLEtBQUEsaUJBQUEsSUFBSSxDQUFDLFVBQVUsQ0FBQSxnQkFBQSw0QkFBRTtvQkFBakMsSUFBTSxNQUFNLFdBQUE7b0JBQ2IsTUFBTSxDQUFDLFlBQVksR0FBRyxDQUFDLENBQUM7b0JBQ3hCLE1BQU0sQ0FBQyxZQUFZLEdBQUcsQ0FBQyxDQUFDO2lCQUMzQjs7Ozs7Ozs7O1NBQ0o7UUFFRCxnRUFBZ0U7UUFDaEUsSUFBSSxJQUFJLENBQUMsZUFBZSxFQUFFO1lBQ3RCLElBQUksQ0FBQyxTQUFTLEdBQUcsa0JBQWtCLENBQUM7U0FDdkM7UUFFRCxJQUFJLElBQUksQ0FBQyxZQUFZLEtBQUssQ0FBQyxFQUFFO1lBQ3pCLElBQUksQ0FBQyxRQUFRLEdBQUcsQ0FBQyxDQUFDO1NBQ3JCO1FBRUQsSUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLEtBQUssQ0FBQztZQUNuQixLQUFLLEVBQUU7Z0JBQ0gsSUFBSSxFQUFFLEtBQUs7Z0JBQ1gsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNO2dCQUNuQixPQUFPLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUM7Z0JBQ3JCLFVBQVUsRUFBRSxJQUFJO2FBQ25CO1lBQ0QsT0FBTyxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO2dCQUN6QyxPQUFPLEVBQUUsSUFBSTtnQkFDYixPQUFPLEVBQUUsSUFBSSxDQUFDLFdBQVc7Z0JBQ3pCLE9BQU8sRUFBRSxJQUFJO2dCQUNiLFNBQVM7Ozs7b0JBRUwsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLEVBQUU7d0JBQ3hCLE9BQU8sS0FBSyxDQUFDLGdCQUFnQixDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsQ0FBQztxQkFDOUM7eUJBQU07OzRCQUVELFlBQVksR0FBRzs0QkFDakIsVUFBVSxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSTs0QkFDNUIsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQzs0QkFDdEQscUJBQXFCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyx1QkFBdUIsQ0FBQzs0QkFDMUQscUJBQXFCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyx1QkFBdUIsQ0FBQzs0QkFDMUQsU0FBUyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUMsU0FBUyxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7NEJBQzFGLFNBQVMsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFOzRCQUMxRixnQkFBZ0IsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFOzRCQUN4RyxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO3lCQUMzRzs7NEJBRUcsV0FBVyxHQUFHLDBGQUEwRjt3QkFFNUcsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsV0FBVyxDQUFDLEVBQUU7NEJBQ3BELHlFQUF5RTs0QkFDekUsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxFQUFFO2dDQUN4QyxXQUFXLEdBQUcsd0NBQXdDLEdBQUcsV0FBVyxDQUFDOzZCQUN4RTtpQ0FBTSxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsV0FBVyxDQUFDLEVBQUU7Z0NBQy9DLFdBQVcsR0FBRyx3Q0FBd0MsR0FBRyxXQUFXLENBQUM7NkJBQ3hFOzRCQUVELHVEQUF1RDs0QkFDdkQsV0FBVyxJQUFJLGtHQUFrRyxDQUFDOzRCQUNsSCxXQUFXLElBQUksa0dBQWtHLENBQUM7eUJBQ3JIOzs0QkFDSyxPQUFPLEdBQUcsUUFBUSxDQUFDLHlLQUVHLFdBQVcsNkRBRXRDLENBQUM7d0JBRUYsT0FBTyxPQUFPLENBQUMsWUFBWSxDQUFDLENBQUM7cUJBQ2hDO2dCQUNELENBQUM7YUFDSjtZQUNELEtBQUssRUFBRTtnQkFDSCxJQUFJLEVBQUUsRUFBRTthQUNYO1lBQ0QsUUFBUSxFQUFFO2dCQUNOLElBQUksRUFBRSxFQUFFO2FBQ1g7WUFDRCxLQUFLLEVBQUU7Z0JBQ0gsYUFBYSxFQUFFLGFBQWE7Z0JBQzVCLE9BQU8sRUFBRSxLQUFLO2dCQUNkLEtBQUssRUFBRTtvQkFDSCxJQUFJLEVBQUUsSUFBSTtpQkFDYjtnQkFDRCxNQUFNLEVBQUU7b0JBQ0osT0FBTyxFQUFFLEtBQUs7aUJBQ2pCO2FBQ0o7WUFDRCxLQUFLLEVBQUU7Z0JBQ0gsR0FBRyxFQUFFLElBQUksQ0FBQyxVQUFVO2dCQUNwQixTQUFTLEVBQUUsS0FBSztnQkFDaEIsT0FBTyxFQUFFLElBQUk7Z0JBQ2IsS0FBSyxFQUFFO29CQUNILElBQUksRUFBRSxJQUFJO2lCQUNiO2dCQUNELE1BQU0sRUFBRTtvQkFDSixPQUFPLEVBQUUsSUFBSSxDQUFDLFVBQVU7b0JBQ3hCLE1BQU0sRUFBRSxTQUFTLEdBQUcsSUFBSSxDQUFDLFFBQVE7b0JBQ2pDLEtBQUssRUFBRTt3QkFDSCxZQUFZLEVBQUUsTUFBTTtxQkFDdkI7aUJBQ0o7Z0JBQ0QsU0FBUyxFQUFFLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUMsU0FBUztnQkFDekQsY0FBYyxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSTthQUNqRDtZQUNELFdBQVcsRUFBRTtnQkFDVCxHQUFHLEVBQUU7b0JBQ0QsY0FBYyxFQUFFLElBQUksQ0FBQyxRQUFRO29CQUM3QixVQUFVLEVBQUU7d0JBQ1IsT0FBTyxFQUFFLEtBQUs7cUJBQ2pCO29CQUNELFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztvQkFDekIsTUFBTSxFQUFFO3dCQUNKLEtBQUs7Ozs7a0NBQUMsS0FBSzs0QkFDUCxJQUFJLEtBQUssQ0FBQyxlQUFlLEVBQUU7Z0NBQ3ZCLE9BQU8sS0FBSyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7NkJBQzlDO2lDQUFNO2dDQUNILE9BQU8sS0FBSyxDQUFDOzZCQUNoQjt3QkFDTCxDQUFDO3FCQUNKO2lCQUNKO2dCQUNELE1BQU0sRUFBRTtvQkFDSixLQUFLLEVBQUUsSUFBSSxDQUFDLFdBQVc7b0JBQ3ZCLFFBQVEsRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLFNBQVM7aUJBQ25EO2FBQ0o7WUFDRCxNQUFNLEVBQUU7Z0JBQ0osT0FBTyxFQUFFLElBQUksQ0FBQyxjQUFjO2FBQy9CO1lBQ0QsT0FBTyxFQUFFO2dCQUNMLE9BQU8sRUFBRSxLQUFLO2FBQ2pCO1lBQ0QsTUFBTSxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUMsbUJBQUE7b0JBQ3pDLFlBQVksRUFBRSxDQUFDO29CQUNmLFlBQVksRUFBRSxDQUFDO29CQUNmLFNBQVMsRUFBRSxLQUFLO29CQUNoQixJQUFJLEVBQUUsSUFBSSxDQUFDLFVBQVU7b0JBQ3JCLElBQUksRUFBRSxDQUFDOzRCQUNILENBQUMsRUFBRSxJQUFJLENBQUMsWUFBWTs0QkFDcEIsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTOzRCQUN6QixTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7OzRCQUV6QixxQkFBcUIsRUFBRSxJQUFJLENBQUMscUJBQXFCLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLFNBQVM7NEJBQy9GLHFCQUFxQixFQUFFLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsU0FBUzs0QkFDL0YsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxZQUFZOzRCQUU1RixPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87eUJBQ3hCLENBQUM7aUJBQ0wsRUFBTyxDQUFDO1NBQ1osQ0FBQyxDQUFDO1FBRUgsS0FBSyxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsUUFBUSxFQUFFLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxnQkFBZ0IsQ0FBQzthQUM1RSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsRUFDekIsS0FBSyxDQUFDLEVBQUUsQ0FBQyxDQUFDO2FBQ2IsU0FBUzs7O1FBQUM7WUFDUCxJQUFJLEtBQUksQ0FBQyxLQUFLLElBQUksS0FBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUU7Z0JBQzlCLEtBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLE1BQU0sRUFBRSxDQUFDO2FBQzNCO1FBQ0wsQ0FBQyxFQUFDLENBQUM7SUFDWCxDQUFDOzs7O0lBRU0saURBQVc7OztJQUFsQjtRQUNJLDRDQUE0QztRQUM1QyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksRUFBRSxDQUFDO1FBQ3BCLElBQUksQ0FBQyxPQUFPLENBQUMsUUFBUSxFQUFFLENBQUM7SUFDNUIsQ0FBQzs7Z0JBelFKLFNBQVMsU0FBQztvQkFDUCxRQUFRLEVBQUUsMEJBQTBCO29CQUNwQyx3dUJBQW9EOztpQkFFdkQ7Ozs7Z0JBYlEsV0FBVztnQkFNWCxpQkFBaUI7Z0JBQ2pCLHlCQUF5QjtnQkFUekIsWUFBWTs7OytCQWtCaEIsS0FBSzs2QkFDTCxLQUFLOzZCQUNMLEtBQUs7MkJBQ0wsS0FBSzs4QkFFTCxLQUFLOytCQUVMLEtBQUs7aUNBQ0wsS0FBSzs0QkFFTCxLQUFLOzRCQUNMLEtBQUs7d0NBSUwsS0FBSzt3Q0FDTCxLQUFLO3NDQUNMLEtBQUs7d0JBTUwsS0FBSzs2QkFHTCxLQUFLOzJCQUNMLEtBQUs7NkJBR0wsS0FBSztpQ0FDTCxLQUFLOzZCQUVMLEtBQUs7a0NBQ0wsS0FBSzttQ0FDTCxLQUFLOztJQWdPVixrQ0FBQztDQUFBLEFBMVFELElBMFFDO1NBclFZLDJCQUEyQjs7O0lBRXBDLG1EQUE2Qjs7SUFDN0IsaURBQWlDOztJQUNqQyxpREFBcUM7O0lBQ3JDLCtDQUEwQjs7SUFFMUIsa0RBQW1DOztJQUVuQyxtREFBNkI7O0lBQzdCLHFEQUErQjs7SUFFL0IsZ0RBQTBCOztJQUMxQixnREFBMEI7O0lBSTFCLDREQUFzQzs7SUFDdEMsNERBQXNDOztJQUN0QywwREFBb0M7O0lBR3BDLDZDQUFtQjs7SUFHbkIsNENBQThCOztJQUc5QixpREFBbUM7O0lBQ25DLCtDQUE4Qjs7SUFHOUIsaURBQTJCOztJQUMzQixxREFBdUM7O0lBRXZDLGlEQUEyQjs7SUFDM0Isc0RBQWlDOztJQUNqQyx1REFBa0M7O0lBRWxDLDRDQUFvQjs7SUFDcEIseURBQWlDOztJQUVqQyxzREFBcUQ7O0lBQ3JELGtEQUFtQjs7SUFFbkIsOENBQTZDOztJQUM3QyxrREFBaUM7O0lBQ2pDLGdEQUEwQjs7SUFDMUIsK0NBQW9COzs7OztJQUVSLDhDQUE0Qjs7Ozs7SUFBRSxxREFBeUM7Ozs7O0lBQUUsNkRBQXlEOzs7OztJQUFFLG1EQUFrQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBpbGVyLCBDb21wb25lbnQsIElucHV0LCBPbkRlc3Ryb3ksIE9uSW5pdCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgU3RhdGVTZXJ2aWNlIH0gZnJvbSAnQHVpcm91dGVyL2NvcmUnO1xuaW1wb3J0IHsgQ2hhcnQgfSBmcm9tICdhbmd1bGFyLWhpZ2hjaGFydHMnO1xuaW1wb3J0IHsgSTE4TmV4dFBpcGUgfSBmcm9tICdhbmd1bGFyLWkxOG5leHQnO1xuaW1wb3J0IHsgWUF4aXNQbG90TGluZXNPcHRpb25zIH0gZnJvbSAnaGlnaGNoYXJ0cyc7XG5pbXBvcnQgeyB0ZW1wbGF0ZSB9IGZyb20gJ2xvZGFzaC1lcyc7XG5pbXBvcnQgeyBpc1VuZGVmaW5lZCB9IGZyb20gJ2xvZGFzaC1lcyc7XG5pbXBvcnQgeyBtZXJnZSwgU3ViamVjdCB9IGZyb20gJ3J4anMnO1xuaW1wb3J0IHsgZGVsYXksIHRha2VVbnRpbCB9IGZyb20gJ3J4anMvb3BlcmF0b3JzJztcbmltcG9ydCB7IE53ZkxlZnRuYXZTZXJ2aWNlIH0gZnJvbSAnLi4vLi4vc2hlbGwvbGVmdG5hdi9sZWZ0bmF2LnNlcnZpY2UnO1xuaW1wb3J0IHsgTndmQ29sdW1uc0NoYW5naW5nU2VydmljZSB9IGZyb20gJy4uL2dyaWQtY29sdW1ucy1jaGFuZ2luZy5zZXJ2aWNlJztcblxuQENvbXBvbmVudCh7XG4gICAgc2VsZWN0b3I6ICdud2YtaG9yaXpvbnRhbC1iYXItY2hhcnQnLFxuICAgIHRlbXBsYXRlVXJsOiAnLi9ob3Jpem9udGFsLWJhci1jaGFydC5jb21wb25lbnQuaHRtbCcsXG4gICAgc3R5bGVVcmxzOiBbJy4vaG9yaXpvbnRhbC1iYXItY2hhcnQuY29tcG9uZW50LnNjc3MnXSxcbn0pXG5leHBvcnQgY2xhc3MgSG9yaXpvbnRhbEJhckNoYXJ0Q29tcG9uZW50IGltcGxlbWVudHMgT25Jbml0LCBPbkRlc3Ryb3kge1xuXG4gICAgQElucHV0KCkgcHVibGljIGN1cnJlbnRWYWx1ZTtcbiAgICBASW5wdXQoKSBwdWJsaWMgdG90YWxWYWx1ZSA9IDEwMDsgLy8gVGhpcyBiYXIgY2FuIHJlcHJlc2VudCBhIHZhbHVlIG91dCBvZiBhbnkgdG90YWxWYWx1ZSBnaXZlblxuICAgIEBJbnB1dCgpIHB1YmxpYyBzZXJpZXNOYW1lID0gJ1ZhbHVlJztcbiAgICBASW5wdXQoKSBwdWJsaWMgc2VyaWVzSWQ/OyAvLyBjaGFydCBuZWVkcyBhIHVuaXF1ZSBpZGVudGlmaWVyIHdoZW4gd2UgaGF2ZSBtdWx0aXBsZSBjaGFydHMuIFRoaXMgaXMgdXNlZCBmb3Igb24gY2xpY2sgbmF2aWdhdGlvblxuXG4gICAgQElucHV0KCkgcHVibGljIHNob3dUb29sdGlwID0gdHJ1ZTtcblxuICAgIEBJbnB1dCgpIHB1YmxpYyBsYWJlbFByaW1hcnk7XG4gICAgQElucHV0KCkgcHVibGljIGxhYmVsU2Vjb25kYXJ5O1xuXG4gICAgQElucHV0KCkgcHVibGljIHNvZnRMaW1pdDtcbiAgICBASW5wdXQoKSBwdWJsaWMgaGFyZExpbWl0O1xuXG4gICAgLy8gVG8gc2hvdyB2YWx1ZXMgb24gYSBkaWZmZXJlbnQgc2NhbGUgbGlrZSBTb2Z0IExpbWl0OiAxODAgTUIgZXRjXG4gICAgLy8gV2hlbiB1c2VyIHdhbnRzIHRoaXMsIHdlIGV4cGVjdCB1c2VyIHRvIHBhc3MgdmFsdWVzIGZvciBjdXJyZW50LCBzb2Z0LCBoYXJkIGxpbWl0c1xuICAgIEBJbnB1dCgpIHB1YmxpYyB0b29sdGlwU29mdExpbWl0VmFsdWU7XG4gICAgQElucHV0KCkgcHVibGljIHRvb2x0aXBIYXJkTGltaXRWYWx1ZTtcbiAgICBASW5wdXQoKSBwdWJsaWMgdG9vbHRpcEN1cnJlbnRWYWx1ZTtcblxuICAgIC8vIEBJbnB1dCgpIHdpZHRoID0gMzAwO1xuICAgIHB1YmxpYyBoZWlnaHQgPSAyMDtcblxuICAgIC8vIEVuYWJsZXMgY29sb3Igem9uZXMgZm9yIHNvZnQvaGFyZCBsaW1pdHMgdmFsdWVzIGdpdmVuXG4gICAgQElucHV0KCkgcHVibGljIHpvbmVzID0gZmFsc2U7XG5cbiAgICAvLyBFbmFibGVzIHktYXhpcyBsYWJlbHMgZm9yIGJhciBjaGFydCB0byBzaG93IHJhbmdlIGluZm8gbGlrZSAyNSUsIDUwJSwgMTAwJVxuICAgIEBJbnB1dCgpIHB1YmxpYyBheGlzTGFiZWxzID0gZmFsc2U7XG4gICAgQElucHV0KCkgcHVibGljIGF4aXNVbml0ID0gJyc7XG5cbiAgICAvLyBDYW4gdXNlIHRoaXMgb25seSBmb3IgYSBzaW5nbGUgaG9yaXpvbnRhbCBzdGFja1xuICAgIEBJbnB1dCgpIHB1YmxpYyBzZXJpZXNEYXRhO1xuICAgIEBJbnB1dCgpIHB1YmxpYyBsZWdlbmRzRW5hYmxlZCA9IGZhbHNlO1xuXG4gICAgQElucHV0KCkgcHVibGljIHRvb2xUaXBPYmo7XG4gICAgQElucHV0KCkgcHVibGljIG9uQ2xpY2tGdW5jdGlvbj87XG4gICAgQElucHV0KCkgcHVibGljIHRvb2x0aXBGb3JtYXR0ZXI/O1xuXG4gICAgcHVibGljIGNoYXJ0OiBDaGFydDtcbiAgICBwdWJsaWMgY2hhcnRXaXRoUGxvdExpbmVzOiBDaGFydDtcblxuICAgIHB1YmxpYyBwbG90TGluZXNDb25maWc6IFlBeGlzUGxvdExpbmVzT3B0aW9uc1tdID0gW107XG4gICAgcHVibGljIHpvbmVzQ29uZmlnO1xuXG4gICAgcHVibGljIGRlc3Ryb3k6IFN1YmplY3Q8YW55PiA9IG5ldyBTdWJqZWN0KCk7XG4gICAgcHVibGljIGlzVW5kZWZpbmVkID0gaXNVbmRlZmluZWQ7XG4gICAgcHVibGljIGNsYXNzTmFtZSA9ICdub25lJztcbiAgICBwdWJsaWMgbWluV2lkdGggPSAyO1xuXG4gICAgY29uc3RydWN0b3IocHJpdmF0ZSBpMThuZXh0OiBJMThOZXh0UGlwZSwgcHJpdmF0ZSBsZWZ0TmF2U2VydmljZTogTndmTGVmdG5hdlNlcnZpY2UsIHByaXZhdGUgY29sdW1uc0NoYW5naW5nU2VydmljZTogTndmQ29sdW1uc0NoYW5naW5nU2VydmljZSwgcHJpdmF0ZSBzdGF0ZVNlcnZpY2U6IFN0YXRlU2VydmljZSkgeyB9XG5cbiAgICBwdWJsaWMgbmdPbkluaXQoKSB7XG5cbiAgICAgICAgY29uc3Qgc2NvcGUgPSB0aGlzO1xuICAgICAgICAvLyBJZiBzb2Z0LGhhcmQgbGltaXRzIGFyZSBwYXNzZWQsIHdlIHNob3cgcGxvdCBsaW5lcyBvbiB0aGUgYmFyIGNoYXJ0IGFjY29yZGluZ2x5XG4gICAgICAgIGlmICh0aGlzLnNvZnRMaW1pdCkge1xuICAgICAgICAgICAgdGhpcy5wbG90TGluZXNDb25maWcucHVzaCh7XG4gICAgICAgICAgICAgICAgdmFsdWU6IHRoaXMuc29mdExpbWl0LFxuICAgICAgICAgICAgICAgIHdpZHRoOiAyLFxuICAgICAgICAgICAgICAgIHpJbmRleDogNSxcbiAgICAgICAgICAgICAgICBjbGFzc05hbWU6ICdud2Ytc29mdC1saW1pdCcsXG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfVxuICAgICAgICBpZiAodGhpcy5oYXJkTGltaXQpIHtcbiAgICAgICAgICAgIHRoaXMucGxvdExpbmVzQ29uZmlnLnB1c2goe1xuICAgICAgICAgICAgICAgIHZhbHVlOiB0aGlzLmhhcmRMaW1pdCxcbiAgICAgICAgICAgICAgICB3aWR0aDogMixcbiAgICAgICAgICAgICAgICB6SW5kZXg6IDUsXG4gICAgICAgICAgICAgICAgY2xhc3NOYW1lOiAnbndmLWhhcmQtbGltaXQnLFxuICAgICAgICAgICAgfSk7XG4gICAgICAgIH1cblxuICAgICAgICAvLyBJZiAnem9uZXMnIGlzIHRydWUsIHdlIHNldCBkZWZhdWx0LCBzb2Z0ICYgaGFyZCBsaW1pdCB6b25lc1xuICAgICAgICBpZiAodGhpcy56b25lcyAmJiB0aGlzLnNvZnRMaW1pdCAmJiB0aGlzLmhhcmRMaW1pdCkge1xuICAgICAgICAgICAgdGhpcy56b25lc0NvbmZpZyA9IFtcbiAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgIHZhbHVlOiB0aGlzLnNvZnRMaW1pdCA+PSB0aGlzLmN1cnJlbnRWYWx1ZSA/IHRoaXMuc29mdExpbWl0IC0gMSA6IDAsXG4gICAgICAgICAgICAgICAgICAgIGNsYXNzTmFtZTogJ253Zi1kZWZhdWx0LXpvbmUnLFxuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICB2YWx1ZTogdGhpcy5oYXJkTGltaXQsXG4gICAgICAgICAgICAgICAgICAgIGNsYXNzTmFtZTogJ253Zi1zb2Z0LWxpbWl0LXpvbmUnLFxuICAgICAgICAgICAgICAgIH0sIHtcbiAgICAgICAgICAgICAgICAgICAgY2xhc3NOYW1lOiAnbndmLWhhcmQtbGltaXQtem9uZScsXG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIF07XG4gICAgICAgIH1cblxuICAgICAgICAvLyBDYWxjdWxhdGUgY2hhcnQgaGVpZ2h0XG4gICAgICAgIC8vIHdoZW4gYXhpcyBsYWJlbHMgYXJlIHNob3duLCBjaGFydCByZXF1aXJlcyBhZGRpdGlvbmFsIGhlaWdodCBpLmUuICsyMSB0byBjdXJyZW50IHZhbHVlOjIwXG4gICAgICAgIGlmICh0aGlzLmF4aXNMYWJlbHMpIHtcbiAgICAgICAgICAgIHRoaXMuaGVpZ2h0ICs9IDIxO1xuICAgICAgICB9XG4gICAgICAgIGlmICh0aGlzLmxlZ2VuZHNFbmFibGVkKSB7XG4gICAgICAgICAgICB0aGlzLmhlaWdodCArPSA0MDtcbiAgICAgICAgfVxuICAgICAgICAvLyBXZSBhbGxvdyBvbmx5IG9uZSBiYXIgZm9yIG5vdyB3aXRoIHNlcmllc0RhdGFcbiAgICAgICAgaWYgKHRoaXMuc2VyaWVzRGF0YSkge1xuICAgICAgICAgICAgZm9yIChjb25zdCBzZXJpZXMgb2YgdGhpcy5zZXJpZXNEYXRhKSB7XG4gICAgICAgICAgICAgICAgc2VyaWVzLnBvaW50UGFkZGluZyA9IDA7XG4gICAgICAgICAgICAgICAgc2VyaWVzLmdyb3VwUGFkZGluZyA9IDA7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cblxuICAgICAgICAvLyAvLyB3aGVuIHRvb2x0aXAgaXMgZm9ybWF0dGVkIGJ5IGNvbnN1bWVyIHNldCBvdXRzaWRlIHRvIGZhbHNlXG4gICAgICAgIGlmICh0aGlzLm9uQ2xpY2tGdW5jdGlvbikge1xuICAgICAgICAgICAgdGhpcy5jbGFzc05hbWUgPSAnbndmLWlzLWxpbmstbGlrZSc7XG4gICAgICAgIH1cblxuICAgICAgICBpZiAodGhpcy5jdXJyZW50VmFsdWUgPT09IDApIHtcbiAgICAgICAgICAgIHRoaXMubWluV2lkdGggPSAwO1xuICAgICAgICB9XG5cbiAgICAgICAgdGhpcy5jaGFydCA9IG5ldyBDaGFydCh7XG4gICAgICAgICAgICBjaGFydDoge1xuICAgICAgICAgICAgICAgIHR5cGU6ICdiYXInLFxuICAgICAgICAgICAgICAgIGhlaWdodDogdGhpcy5oZWlnaHQsXG4gICAgICAgICAgICAgICAgc3BhY2luZzogWzAsIDAsIDAsIDBdLFxuICAgICAgICAgICAgICAgIHN0eWxlZE1vZGU6IHRydWUsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgdG9vbHRpcDogdGhpcy50b29sVGlwT2JqID8gdGhpcy50b29sVGlwT2JqIDoge1xuICAgICAgICAgICAgICAgIG91dHNpZGU6IHRydWUsXG4gICAgICAgICAgICAgICAgZW5hYmxlZDogdGhpcy5zaG93VG9vbHRpcCxcbiAgICAgICAgICAgICAgICB1c2VIVE1MOiB0cnVlLFxuICAgICAgICAgICAgICAgIGZvcm1hdHRlcigpIHtcblxuICAgICAgICAgICAgICAgICAgICBpZiAoc2NvcGUudG9vbHRpcEZvcm1hdHRlcikge1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIHNjb3BlLnRvb2x0aXBGb3JtYXR0ZXIoc2NvcGUsIHRoaXMpO1xuICAgICAgICAgICAgICAgICAgICB9IGVsc2Uge1xuXG4gICAgICAgICAgICAgICAgICAgIGNvbnN0IHRlbXBsYXRlRGF0YSA9IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHNlcmllc05hbWU6IHRoaXMuc2VyaWVzLm5hbWUsXG4gICAgICAgICAgICAgICAgICAgICAgICB0b29sdGlwQ3VycmVudFZhbHVlOiB0aGlzLnBvaW50Wyd0b29sdGlwQ3VycmVudFZhbHVlJ10sXG4gICAgICAgICAgICAgICAgICAgICAgICB0b29sdGlwU29mdExpbWl0VmFsdWU6IHRoaXMucG9pbnRbJ3Rvb2x0aXBTb2Z0TGltaXRWYWx1ZSddLFxuICAgICAgICAgICAgICAgICAgICAgICAgdG9vbHRpcEhhcmRMaW1pdFZhbHVlOiB0aGlzLnBvaW50Wyd0b29sdGlwSGFyZExpbWl0VmFsdWUnXSxcbiAgICAgICAgICAgICAgICAgICAgICAgIHNvZnRMaW1pdDogdGhpcy5wb2ludFsnaTE4blJlZiddID8gdGhpcy5wb2ludFsnaTE4blJlZiddLnRyYW5zZm9ybSgnbndmanM6c29mdExpbWl0JykgOiAnJyxcbiAgICAgICAgICAgICAgICAgICAgICAgIGhhcmRMaW1pdDogdGhpcy5wb2ludFsnaTE4blJlZiddID8gdGhpcy5wb2ludFsnaTE4blJlZiddLnRyYW5zZm9ybSgnbndmanM6aGFyZExpbWl0JykgOiAnJyxcbiAgICAgICAgICAgICAgICAgICAgICAgIGV4Y2VlZHNIYXJkTGltaXQ6IHRoaXMucG9pbnRbJ2kxOG5SZWYnXSA/IHRoaXMucG9pbnRbJ2kxOG5SZWYnXS50cmFuc2Zvcm0oJ253ZmpzOmV4Y2VlZHNIYXJkTGltaXQnKSA6ICcnLFxuICAgICAgICAgICAgICAgICAgICAgICAgZXhjZWVkc1NvZnRMaW1pdDogdGhpcy5wb2ludFsnaTE4blJlZiddID8gdGhpcy5wb2ludFsnaTE4blJlZiddLnRyYW5zZm9ybSgnbndmanM6ZXhjZWVkc1NvZnRMaW1pdCcpIDogJycsXG4gICAgICAgICAgICAgICAgICAgIH07XG5cbiAgICAgICAgICAgICAgICAgICAgbGV0IHRvb2x0aXBCb2R5ID0gJzxzcGFuIGNsYXNzPVwidG9vbHRpcC1jdXJyZW50LXNlcmllc1wiPlxcdTI1Q0YgPC9zcGFuPiR7c2VyaWVzTmFtZX06ICR7dG9vbHRpcEN1cnJlbnRWYWx1ZX0nO1xuXG4gICAgICAgICAgICAgICAgICAgIGlmICh0aGlzLnBvaW50Wydzb2Z0TGltaXQnXSB8fCB0aGlzLnBvaW50WydoYXJkTGltaXQnXSkge1xuICAgICAgICAgICAgICAgICAgICAgICAgLy8gSWYgbGltaXRzIGV4Y2VlZGVkLCBzaG93IGFuIGFkZGl0aW9uYWwgaGVhZGVyIG1lc3NhZ2UgYWJvdXQgdGhlIGJyZWFjaFxuICAgICAgICAgICAgICAgICAgICAgICAgaWYgKHRoaXMucG9pbnQueSA+IHRoaXMucG9pbnRbJ2hhcmRMaW1pdCddKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgdG9vbHRpcEJvZHkgPSAnJHtzZXJpZXNOYW1lfSAke2V4Y2VlZHNIYXJkTGltaXR9PGJyXFw+JyArIHRvb2x0aXBCb2R5O1xuICAgICAgICAgICAgICAgICAgICAgICAgfSBlbHNlIGlmICh0aGlzLnBvaW50LnkgPiB0aGlzLnBvaW50Wydzb2Z0TGltaXQnXSkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRvb2x0aXBCb2R5ID0gJyR7c2VyaWVzTmFtZX0gJHtleGNlZWRzU29mdExpbWl0fTxiclxcPicgKyB0b29sdGlwQm9keTtcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgLy8gQXBwZW5kcyBTb2Z0IExpbWl0LCBIYXJkIExpbWl0IHZhbHVlcyB0byB0aGUgdG9vbHRpcFxuICAgICAgICAgICAgICAgICAgICAgICAgdG9vbHRpcEJvZHkgKz0gJzxicj48c3BhbiBjbGFzcz1cInRvb2x0aXAtc29mdC1saW1pdC1zZXJpZXNcIj5cXHUyNUNGIDwvc3Bhbj4ke3NvZnRMaW1pdH06ICR7dG9vbHRpcFNvZnRMaW1pdFZhbHVlfSc7XG4gICAgICAgICAgICAgICAgICAgICAgICB0b29sdGlwQm9keSArPSAnPGJyPjxzcGFuIGNsYXNzPVwidG9vbHRpcC1oYXJkLWxpbWl0LXNlcmllc1wiPlxcdTI1Q0YgPC9zcGFuPiR7aGFyZExpbWl0fTogJHt0b29sdGlwSGFyZExpbWl0VmFsdWV9JztcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICBjb25zdCB0b29sdGlwID0gdGVtcGxhdGUoYDxkaXYgY2xhc3M9XCJud2YtaGlnaGNoYXJ0cy10b29sdGlwIHBvcG92ZXIgdWliLXBvcG92ZXItYm90dG9tXCI+XG4gICAgICAgICAgICAgICAgICAgIDxkaXYgY2xhc3M9XCJhcnJvd1wiPjwvZGl2PlxuICAgICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzPVwicG9wb3Zlci1ib2R5XCI+JHt0b29sdGlwQm9keX08L2Rpdj5cbiAgICAgICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgICAgICAgIGApO1xuXG4gICAgICAgICAgICAgICAgICAgIHJldHVybiB0b29sdGlwKHRlbXBsYXRlRGF0YSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgdGl0bGU6IHtcbiAgICAgICAgICAgICAgICB0ZXh0OiAnJyxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBzdWJ0aXRsZToge1xuICAgICAgICAgICAgICAgIHRleHQ6ICcnLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIHhBeGlzOiB7XG4gICAgICAgICAgICAgICAgZ3JpZExpbmVDb2xvcjogJ3RyYW5zcGFyZW50JyxcbiAgICAgICAgICAgICAgICB2aXNpYmxlOiBmYWxzZSxcbiAgICAgICAgICAgICAgICB0aXRsZToge1xuICAgICAgICAgICAgICAgICAgICB0ZXh0OiBudWxsLFxuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgbGFiZWxzOiB7XG4gICAgICAgICAgICAgICAgICAgIGVuYWJsZWQ6IGZhbHNlLFxuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgeUF4aXM6IHtcbiAgICAgICAgICAgICAgICBtYXg6IHRoaXMudG90YWxWYWx1ZSxcbiAgICAgICAgICAgICAgICBlbmRPblRpY2s6IGZhbHNlLFxuICAgICAgICAgICAgICAgIHZpc2libGU6IHRydWUsXG4gICAgICAgICAgICAgICAgdGl0bGU6IHtcbiAgICAgICAgICAgICAgICAgICAgdGV4dDogbnVsbCxcbiAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgIGxhYmVsczoge1xuICAgICAgICAgICAgICAgICAgICBlbmFibGVkOiB0aGlzLmF4aXNMYWJlbHMsXG4gICAgICAgICAgICAgICAgICAgIGZvcm1hdDogJ3t2YWx1ZX0nICsgdGhpcy5heGlzVW5pdCxcbiAgICAgICAgICAgICAgICAgICAgc3R5bGU6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHRleHRPdmVyZmxvdzogJ25vbmUnLFxuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgcGxvdExpbmVzOiAhdGhpcy56b25lcyA/IHRoaXMucGxvdExpbmVzQ29uZmlnIDogdW5kZWZpbmVkLFxuICAgICAgICAgICAgICAgIHJldmVyc2VkU3RhY2tzOiB0aGlzLnNlcmllc0RhdGEgPyBmYWxzZSA6IHRydWUsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgcGxvdE9wdGlvbnM6IHtcbiAgICAgICAgICAgICAgICBiYXI6IHtcbiAgICAgICAgICAgICAgICAgICAgbWluUG9pbnRMZW5ndGg6IHRoaXMubWluV2lkdGgsXG4gICAgICAgICAgICAgICAgICAgIGRhdGFMYWJlbHM6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGVuYWJsZWQ6IGZhbHNlLFxuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICBjbGFzc05hbWU6IHRoaXMuY2xhc3NOYW1lLFxuICAgICAgICAgICAgICAgICAgICBldmVudHM6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGNsaWNrKGV2ZW50KSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgaWYgKHNjb3BlLm9uQ2xpY2tGdW5jdGlvbikge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gc2NvcGUub25DbGlja0Z1bmN0aW9uKHNjb3BlLCBldmVudCk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICBzZXJpZXM6IHtcbiAgICAgICAgICAgICAgICAgICAgem9uZXM6IHRoaXMuem9uZXNDb25maWcsXG4gICAgICAgICAgICAgICAgICAgIHN0YWNraW5nOiB0aGlzLnNlcmllc0RhdGEgPyAnbm9ybWFsJyA6IHVuZGVmaW5lZCxcbiAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIGxlZ2VuZDoge1xuICAgICAgICAgICAgICAgIGVuYWJsZWQ6IHRoaXMubGVnZW5kc0VuYWJsZWQsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgY3JlZGl0czoge1xuICAgICAgICAgICAgICAgIGVuYWJsZWQ6IGZhbHNlLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIHNlcmllczogdGhpcy5zZXJpZXNEYXRhID8gdGhpcy5zZXJpZXNEYXRhIDogW3tcbiAgICAgICAgICAgICAgICBwb2ludFBhZGRpbmc6IDAsXG4gICAgICAgICAgICAgICAgZ3JvdXBQYWRkaW5nOiAwLFxuICAgICAgICAgICAgICAgIGFuaW1hdGlvbjogZmFsc2UsXG4gICAgICAgICAgICAgICAgbmFtZTogdGhpcy5zZXJpZXNOYW1lLFxuICAgICAgICAgICAgICAgIGRhdGE6IFt7XG4gICAgICAgICAgICAgICAgICAgIHk6IHRoaXMuY3VycmVudFZhbHVlLFxuICAgICAgICAgICAgICAgICAgICBzb2Z0TGltaXQ6IHRoaXMuc29mdExpbWl0LFxuICAgICAgICAgICAgICAgICAgICBoYXJkTGltaXQ6IHRoaXMuaGFyZExpbWl0LFxuICAgICAgICAgICAgICAgICAgICAvLyBJZiB3ZSBuZWVkIHRvIHNob3cgY3VzdG9tIHN0cmluZ3MgaW4gdGhlIHRvb2x0aXAsIHdlIHVzZSBiZWxvdyB2YWx1ZXNcbiAgICAgICAgICAgICAgICAgICAgdG9vbHRpcFNvZnRMaW1pdFZhbHVlOiB0aGlzLnRvb2x0aXBTb2Z0TGltaXRWYWx1ZSA/IHRoaXMudG9vbHRpcFNvZnRMaW1pdFZhbHVlIDogdGhpcy5zb2Z0TGltaXQsXG4gICAgICAgICAgICAgICAgICAgIHRvb2x0aXBIYXJkTGltaXRWYWx1ZTogdGhpcy50b29sdGlwSGFyZExpbWl0VmFsdWUgPyB0aGlzLnRvb2x0aXBIYXJkTGltaXRWYWx1ZSA6IHRoaXMuaGFyZExpbWl0LFxuICAgICAgICAgICAgICAgICAgICB0b29sdGlwQ3VycmVudFZhbHVlOiB0aGlzLnRvb2x0aXBDdXJyZW50VmFsdWUgPyB0aGlzLnRvb2x0aXBDdXJyZW50VmFsdWUgOiB0aGlzLmN1cnJlbnRWYWx1ZSxcblxuICAgICAgICAgICAgICAgICAgICBpMThuUmVmOiB0aGlzLmkxOG5leHQsXG4gICAgICAgICAgICAgICAgfV0sXG4gICAgICAgICAgICB9IGFzIGFueV0sXG4gICAgICAgIH0pO1xuXG4gICAgICAgIG1lcmdlKHRoaXMubGVmdE5hdlNlcnZpY2UubGVmdE5hdiQsIHRoaXMuY29sdW1uc0NoYW5naW5nU2VydmljZS5jb2x1bW5zQ2hhbmdpbmckKVxuICAgICAgICAgICAgLnBpcGUodGFrZVVudGlsKHRoaXMuZGVzdHJveSksXG4gICAgICAgICAgICAgICAgZGVsYXkoMTApKVxuICAgICAgICAgICAgLnN1YnNjcmliZSgoKSA9PiB7XG4gICAgICAgICAgICAgICAgaWYgKHRoaXMuY2hhcnQgJiYgdGhpcy5jaGFydC5yZWYpIHtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5jaGFydC5yZWYucmVmbG93KCk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSk7XG4gICAgfVxuXG4gICAgcHVibGljIG5nT25EZXN0cm95KCkge1xuICAgICAgICAvLyBTaWduYWwgZW5kIG9mIHN1YnNjcmlwdGlvbiB0byBvYnNlcnZhYmxlc1xuICAgICAgICB0aGlzLmRlc3Ryb3kubmV4dCgpO1xuICAgICAgICB0aGlzLmRlc3Ryb3kuY29tcGxldGUoKTtcbiAgICB9XG59XG4iXX0=