/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input, TemplateRef } from '@angular/core';
import { NgbActiveModal } from '@ng-bootstrap/ng-bootstrap';
var NwfConfirmationModalComponent = /** @class */ (function () {
    function NwfConfirmationModalComponent(activeModal) {
        this.activeModal = activeModal;
        this.status = '';
        this.showCancel = true;
        this.showDimissX = true;
        this.okButtonLabel = 'nwfjs:OK';
    }
    NwfConfirmationModalComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-confirmation-modal',
                    template: "<nwf-modal-header [status]=\"status\" (onDismiss)=\"activeModal.dismiss(false)\" [showDimissX]=\"showDimissX\">\n    {{title | i18next}}\n</nwf-modal-header>\n<div class=\"modal-body\">\n    <ng-template [ngTemplateOutlet]=\"messageTemplate\" *ngIf=\"messageTemplate\"></ng-template>\n    <div *ngIf=\"message\">{{message | i18next}}</div>\n</div>\n<div class=\"modal-footer\">\n    <button data-netapp-id=\"confirmation-modal-cancel-btn\" class=\"btn btn-link\" (click)=\"activeModal.dismiss(false)\" *ngIf=\"showCancel\">{{ 'nwfjs:cancel' | i18next }}</button>\n    <button data-netapp-id=\"confirmation-modal-ok-btn\" class=\"btn btn-primary\" (click)=\"activeModal.close(true)\">{{ okButtonLabel | i18next }}</button>\n</div>"
                }] }
    ];
    /** @nocollapse */
    NwfConfirmationModalComponent.ctorParameters = function () { return [
        { type: NgbActiveModal }
    ]; };
    NwfConfirmationModalComponent.propDecorators = {
        title: [{ type: Input }],
        status: [{ type: Input }],
        message: [{ type: Input }],
        messageTemplate: [{ type: Input }],
        showCancel: [{ type: Input }],
        showDimissX: [{ type: Input }],
        okButtonLabel: [{ type: Input }]
    };
    return NwfConfirmationModalComponent;
}());
export { NwfConfirmationModalComponent };
if (false) {
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.title;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.status;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.message;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.messageTemplate;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.showCancel;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.showDimissX;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.okButtonLabel;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.activeModal;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uZmlybWF0aW9uLW1vZGFsLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiJuZzovL0BuZXRhcHAvbndmanNfYW5ndWxhcl9jb21wb25lbnRzLyIsInNvdXJjZXMiOlsibGliL2NvbXBvbmVudHMvbW9kYWxzL2NvbmZpcm1hdGlvbi9jb25maXJtYXRpb24tbW9kYWwuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFFLEtBQUssRUFBRSxXQUFXLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFDOUQsT0FBTyxFQUFFLGNBQWMsRUFBRSxNQUFNLDRCQUE0QixDQUFDO0FBRTVEO0lBY0UsdUNBQW1CLFdBQTJCO1FBQTNCLGdCQUFXLEdBQVgsV0FBVyxDQUFnQjtRQVA5QixXQUFNLEdBQVcsRUFBRSxDQUFDO1FBR3BCLGVBQVUsR0FBWSxJQUFJLENBQUM7UUFDM0IsZ0JBQVcsR0FBWSxJQUFJLENBQUM7UUFDNUIsa0JBQWEsR0FBVyxVQUFVLENBQUM7SUFFRCxDQUFDOztnQkFkcEQsU0FBUyxTQUFDO29CQUNULFFBQVEsRUFBRSx3QkFBd0I7b0JBQ2xDLHF1QkFBa0Q7aUJBQ25EOzs7O2dCQUxRLGNBQWM7Ozt3QkFRcEIsS0FBSzt5QkFDTCxLQUFLOzBCQUNMLEtBQUs7a0NBQ0wsS0FBSzs2QkFDTCxLQUFLOzhCQUNMLEtBQUs7Z0NBQ0wsS0FBSzs7SUFJUixvQ0FBQztDQUFBLEFBaEJELElBZ0JDO1NBWlksNkJBQTZCOzs7SUFFeEMsOENBQThCOztJQUM5QiwrQ0FBb0M7O0lBQ3BDLGdEQUFnQzs7SUFDaEMsd0RBQWtEOztJQUNsRCxtREFBMkM7O0lBQzNDLG9EQUE0Qzs7SUFDNUMsc0RBQW1EOztJQUV2QyxvREFBa0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIElucHV0LCBUZW1wbGF0ZVJlZiB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgTmdiQWN0aXZlTW9kYWwgfSBmcm9tICdAbmctYm9vdHN0cmFwL25nLWJvb3RzdHJhcCc7XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ253Zi1jb25maXJtYXRpb24tbW9kYWwnLFxuICB0ZW1wbGF0ZVVybDogJy4vY29uZmlybWF0aW9uLW1vZGFsLmNvbXBvbmVudC5odG1sJyxcbn0pXG5leHBvcnQgY2xhc3MgTndmQ29uZmlybWF0aW9uTW9kYWxDb21wb25lbnQge1xuXG4gIEBJbnB1dCgpIHB1YmxpYyB0aXRsZTogc3RyaW5nO1xuICBASW5wdXQoKSBwdWJsaWMgc3RhdHVzOiBzdHJpbmcgPSAnJztcbiAgQElucHV0KCkgcHVibGljIG1lc3NhZ2U6IHN0cmluZztcbiAgQElucHV0KCkgcHVibGljIG1lc3NhZ2VUZW1wbGF0ZTogVGVtcGxhdGVSZWY8YW55PjtcbiAgQElucHV0KCkgcHVibGljIHNob3dDYW5jZWw6IGJvb2xlYW4gPSB0cnVlO1xuICBASW5wdXQoKSBwdWJsaWMgc2hvd0RpbWlzc1g6IGJvb2xlYW4gPSB0cnVlO1xuICBASW5wdXQoKSBwdWJsaWMgb2tCdXR0b25MYWJlbDogc3RyaW5nID0gJ253ZmpzOk9LJztcblxuICBjb25zdHJ1Y3RvcihwdWJsaWMgYWN0aXZlTW9kYWw6IE5nYkFjdGl2ZU1vZGFsKSB7IH1cblxufVxuIl19