/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { CommonModule } from '@angular/common';
import { NgModule } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { NgbAlertModule, NgbModalModule, NgbPopoverModule, NgbProgressbarModule } from '@ng-bootstrap/ng-bootstrap';
import { NgbDropdownModule } from '@ng-bootstrap/ng-bootstrap';
import { UIRouterModule } from '@uirouter/angular';
import { ChartModule } from 'angular-highcharts';
import { I18NextModule } from 'angular-i18next';
import { DxLoadIndicatorModule } from 'devextreme-angular';
import { AlertComponent } from './alert/alert.component';
import { NwfDismissButton } from './dismiss-button/dismiss-button.component';
import { NwfElipsizerResizeService } from './elipsizer/elipsizer-resize.service';
import { NwfElipsizer } from './elipsizer/elipsizer.directive';
import { NwfColumnsChangingService } from './grid-columns-changing.service';
import { NwfHelpConfig } from './help/help.config.service';
import { HelpDirective } from './help/help.directive';
import { HorizontalBarChartComponent } from './horizontal-bar-chart/horizontal-bar-chart.component';
import { IconComponent } from './icon/icon.component';
import { NwfLoadIndicatorComponent } from './load-indicator/load-indicator.component';
import { NwfConfirmationModalComponent } from './modals/confirmation/confirmation-modal.component';
import { HeaderComponent } from './modals/header/header.component';
import { PageAlertComponent } from './page-alert/page-alert.component';
import { NwfPageAlertService } from './page-alert/page-alert.service';
import { NwfPopoverTitle } from './popover-title/popover-title.component';
import { NwfProgressBarComponent } from './progress-bar/progress-bar.component';
import { NwfPropertySheet } from './property-sheet/property-sheet.component';
import { NwfProperty } from './property-sheet/property.component';
import { StackedChartComponent } from './stacked-bar-chart/stacked-bar-chart.component';
/** @type {?} */
var allComponents = [
    IconComponent,
    HelpDirective,
    AlertComponent,
    PageAlertComponent,
    NwfElipsizer,
    HeaderComponent,
    NwfPropertySheet,
    NwfDismissButton,
    NwfPopoverTitle,
    NwfProperty,
    HorizontalBarChartComponent,
    NwfConfirmationModalComponent,
    NwfProgressBarComponent,
    NwfLoadIndicatorComponent,
    StackedChartComponent,
];
var NwfjsSharedComponentsModule = /** @class */ (function () {
    function NwfjsSharedComponentsModule() {
    }
    NwfjsSharedComponentsModule.decorators = [
        { type: NgModule, args: [{
                    imports: [
                        CommonModule,
                        ChartModule,
                        FormsModule,
                        DxLoadIndicatorModule,
                        NgbAlertModule,
                        NgbModalModule,
                        NgbPopoverModule,
                        NgbProgressbarModule,
                        I18NextModule,
                        UIRouterModule,
                        NgbDropdownModule,
                    ],
                    declarations: allComponents,
                    entryComponents: [NwfConfirmationModalComponent],
                    providers: [NwfPageAlertService, NwfElipsizerResizeService, NwfHelpConfig, NwfColumnsChangingService],
                    exports: allComponents,
                },] }
    ];
    return NwfjsSharedComponentsModule;
}());
export { NwfjsSharedComponentsModule };
//# sourceMappingURL=data:application/json;base64,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