/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { DomSanitizer } from '@angular/platform-browser';
import { TransitionService } from '@uirouter/angular';
import { NwfPageAlertService } from './page-alert.service';
var PageAlertComponent = /** @class */ (function () {
    function PageAlertComponent(pageAlertService, sanitizer, transitionService) {
        var _this = this;
        this.sanitizer = sanitizer;
        this.transitionService = transitionService;
        this.message = '';
        this.severity = 'success';
        this.isShowing = false;
        this.subscription = pageAlertService.pageAlert$.subscribe((/**
         * @param {?} data
         * @return {?}
         */
        function (data) {
            // TO check whether show is called or hide is called
            if (data.type === 'show') {
                _this.show(data.config);
            }
            else {
                _this.close();
            }
        }));
    }
    /**
     * @return {?}
     */
    PageAlertComponent.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        // unsubscribe to ensure no memory leaks
        this.subscription.unsubscribe();
    };
    /**
     * @param {?} __0
     * @return {?}
     */
    PageAlertComponent.prototype.show = /**
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var _this = this;
        var message = _a.message, severity = _a.severity, fade = _a.fade;
        this.message = this.sanitizer.bypassSecurityTrustHtml(message);
        if (severity == 'ok') {
            severity = 'success';
        }
        if (severity == 'error') {
            severity = 'critical';
        }
        this.severity = severity;
        this.isShowing = true;
        if (fade) {
            setTimeout((/**
             * @return {?}
             */
            function () { return _this.close(); }), fade);
        }
        /* I want to close when I exit this route */
        this._trans = this.transitionService.onBefore({}, this.close.bind(this));
    };
    /**
     * @return {?}
     */
    PageAlertComponent.prototype.close = /**
     * @return {?}
     */
    function () {
        this.isShowing = false;
        if (this._trans) {
            this._trans();
        }
    };
    PageAlertComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-page-alert',
                    template: "\n    <ngb-alert [type]=\"severity\" *ngIf=\"isShowing\" (close)=\"close()\" class=\"is-page-level\">\n      <div class=\"d-flex\">\n        <div *ngIf=\"severity\">\n          <nwf-icon [severity]=\"severity\"></nwf-icon>\n        </div>\n        <div class=\"flex-grow-1 ml-2\" [innerHTML]=\"message\"></div>\n      </div>\n    </ngb-alert>\n  ",
                    styles: [""]
                }] }
    ];
    /** @nocollapse */
    PageAlertComponent.ctorParameters = function () { return [
        { type: NwfPageAlertService },
        { type: DomSanitizer },
        { type: TransitionService }
    ]; };
    PageAlertComponent.propDecorators = {
        message: [{ type: Input }],
        severity: [{ type: Input }]
    };
    return PageAlertComponent;
}());
export { PageAlertComponent };
if (false) {
    /** @type {?} */
    PageAlertComponent.prototype.message;
    /** @type {?} */
    PageAlertComponent.prototype.severity;
    /** @type {?} */
    PageAlertComponent.prototype.isShowing;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype.subscription;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype._trans;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype.sanitizer;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype.transitionService;
}
//# sourceMappingURL=data:application/json;base64,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