/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * Sets the date and time value as provided by the user.
 * When the user selects a date or time using this datetimepicker, setDateTime is called and the value is setted.
 */
import { Component, Input } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
/** @type {?} */
var currentDate = new Date();
/** @type {?} */
var last13MonthsDate = new Date(currentDate.getTime() - (395 * 24 * 60 * 60 * 1000));
var NwfDatetimePicker = /** @class */ (function () {
    function NwfDatetimePicker() {
        this.minDate = { year: last13MonthsDate.getFullYear(), month: last13MonthsDate.getMonth() + 1, day: last13MonthsDate.getDate() };
        this.maxDate = { year: currentDate.getFullYear(), month: currentDate.getMonth() + 1, day: currentDate.getDate() };
        this.navigation = 'arrows';
    }
    /**
     * @return {?}
     */
    NwfDatetimePicker.prototype.ngOnInit = /**
     * @return {?}
     */
    function () { };
    /**
     * Sets the min and max date for the widget. By default, minDate is the exact 13 months ago date and maxDate is the current date.
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @param changes - SimpleChanges
     * @returns void
     */
    /**
     * Sets the min and max date for the widget. By default, minDate is the exact 13 months ago date and maxDate is the current date.
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @param {?} changes - SimpleChanges
     * @return {?} void
     */
    NwfDatetimePicker.prototype.ngOnChanges = /**
     * Sets the min and max date for the widget. By default, minDate is the exact 13 months ago date and maxDate is the current date.
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @param {?} changes - SimpleChanges
     * @return {?} void
     */
    function (changes) {
        // set maxDate, minDate if it exists in changes object.
        // else it takes default values defined above.
        if (changes.maxDate) {
            // converting string to Date object.
            /** @type {?} */
            var maxDateObject = new Date(changes.maxDate.currentValue);
            // creating NgbDateStruct model representation out of regular js date object.
            this.maxDate = { year: maxDateObject.getFullYear(), month: maxDateObject.getMonth() + 1, day: maxDateObject.getDate() };
        }
        if (changes.minDate) {
            // converting string to Date object.
            /** @type {?} */
            var minDateObject = new Date(changes.minDate.currentValue);
            // creating NgbDateStruct model representation out of regular js date object.
            this.minDate = { year: minDateObject.getFullYear(), month: minDateObject.getMonth() + 1, day: minDateObject.getDate() };
        }
    };
    /**
     *
     * writeValue() - Sets the datepickerModel, timePickerModel and startDate according to the date passed in the argument of the function.
     * @param datetimePickerValue - string
     * @returns void
     */
    /**
     *
     * writeValue() - Sets the datepickerModel, timePickerModel and startDate according to the date passed in the argument of the function.
     * @param {?} datetimePickerValue - string
     * @return {?} void
     */
    NwfDatetimePicker.prototype.writeValue = /**
     *
     * writeValue() - Sets the datepickerModel, timePickerModel and startDate according to the date passed in the argument of the function.
     * @param {?} datetimePickerValue - string
     * @return {?} void
     */
    function (datetimePickerValue) {
        if (datetimePickerValue) {
            // converting string to Date object.
            /** @type {?} */
            var dateObject = new Date(datetimePickerValue);
            // creating NgbDateStruct model representation out of regular js date object.
            // we add +1 to month because NgbDateStruct month property takes in value as ISO format ie. month should be between 1-12,
            // whereas getMonth returns month values from 0-11.
            this.datepickerModel = { year: dateObject.getFullYear(), month: dateObject.getMonth() + 1, day: dateObject.getDate() };
            this.startDate = { year: this.datepickerModel.year, month: this.datepickerModel.month };
            // creating NgbTimeStruct model representation out of regular js date object.
            this.timepickerModel = { hour: dateObject.getHours(), minute: dateObject.getMinutes(), second: 0 };
        }
    };
    /**
     * @param {?} fn
     * @return {?}
     */
    NwfDatetimePicker.prototype.registerOnChange = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { this._onChange = fn; };
    /**
     * @param {?} fn
     * @return {?}
     */
    NwfDatetimePicker.prototype.registerOnTouched = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { };
    /**
     * @return {?}
     */
    NwfDatetimePicker.prototype.setDatetime = /**
     * @return {?}
     */
    function () {
        var _a = this.datepickerModel, year = _a.year, month = _a.month, day = _a.day;
        var _b = this.timepickerModel, hour = _b.hour, minute = _b.minute;
        /** @type {?} */
        var newDate = new Date(year, month - 1, day, hour, minute);
        this._onChange(newDate.toISOString());
    };
    NwfDatetimePicker.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-datetime-picker',
                    template: "\n        <ngb-datepicker [(ngModel)]=\"datepickerModel\" [maxDate]=\"maxDate\" [minDate]=\"minDate\" [startDate]=\"startDate\"\n            [navigation]=\"navigation\" firstDayOfWeek=\"7\" (ngModelChange)=\"setDatetime()\"></ngb-datepicker>\n        <div class=\"col my-2 p-0\">\n            <span class=\"label\">{{'nwfjs:time' | i18next}}:</span>\n            <ngb-timepicker [(ngModel)]=\"timepickerModel\" [meridian]=true (ngModelChange)=\"setDatetime()\"></ngb-timepicker>\n        </div>\n    ",
                    providers: [{
                            provide: NG_VALUE_ACCESSOR,
                            useExisting: NwfDatetimePicker,
                            multi: true,
                        }],
                    styles: [".ngb-tp-input-container{color:red}.ngb-tp-input-container .form-control{width:60px}"]
                }] }
    ];
    NwfDatetimePicker.propDecorators = {
        minDate: [{ type: Input }],
        maxDate: [{ type: Input }]
    };
    return NwfDatetimePicker;
}());
export { NwfDatetimePicker };
if (false) {
    /** @type {?} */
    NwfDatetimePicker.prototype.minDate;
    /** @type {?} */
    NwfDatetimePicker.prototype.maxDate;
    /** @type {?} */
    NwfDatetimePicker.prototype.datepickerModel;
    /** @type {?} */
    NwfDatetimePicker.prototype.timepickerModel;
    /** @type {?} */
    NwfDatetimePicker.prototype.navigation;
    /** @type {?} */
    NwfDatetimePicker.prototype.startDate;
    /**
     * @type {?}
     * @private
     */
    NwfDatetimePicker.prototype._onChange;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF0ZXRpbWUtcGlja2VyLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiJuZzovL0BuZXRhcHAvbndmanNfYW5ndWxhcl9jb21wb25lbnRzLyIsInNvdXJjZXMiOlsibGliL2Zvcm0vZGF0ZXRpbWUtcGlja2VyL2RhdGV0aW1lLXBpY2tlci5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7QUFJQSxPQUFPLEVBQUUsU0FBUyxFQUFFLEtBQUssRUFBb0MsTUFBTSxlQUFlLENBQUM7QUFDbkYsT0FBTyxFQUF3QixpQkFBaUIsRUFBRSxNQUFNLGdCQUFnQixDQUFDOztJQUduRSxXQUFXLEdBQVMsSUFBSSxJQUFJLEVBQUU7O0lBQzlCLGdCQUFnQixHQUFHLElBQUksSUFBSSxDQUFDLFdBQVcsQ0FBQyxPQUFPLEVBQUUsR0FBRyxDQUFDLEdBQUcsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxJQUFJLENBQUMsQ0FBQztBQUV0RjtJQUFBO1FBb0JXLFlBQU8sR0FBbUIsRUFBRSxJQUFJLEVBQUUsZ0JBQWdCLENBQUMsV0FBVyxFQUFFLEVBQUUsS0FBSyxFQUFFLGdCQUFnQixDQUFDLFFBQVEsRUFBRSxHQUFHLENBQUMsRUFBRSxHQUFHLEVBQUUsZ0JBQWdCLENBQUMsT0FBTyxFQUFFLEVBQUUsQ0FBQztRQUc1SSxZQUFPLEdBQW1CLEVBQUUsSUFBSSxFQUFFLFdBQVcsQ0FBQyxXQUFXLEVBQUUsRUFBRSxLQUFLLEVBQUUsV0FBVyxDQUFDLFFBQVEsRUFBRSxHQUFHLENBQUMsRUFBRSxHQUFHLEVBQUUsV0FBVyxDQUFDLE9BQU8sRUFBRSxFQUFFLENBQUM7UUFHN0gsZUFBVSxHQUFXLFFBQVEsQ0FBQztJQTBEekMsQ0FBQzs7OztJQXJEVSxvQ0FBUTs7O0lBQWYsY0FBb0IsQ0FBQztJQUVyQjs7Ozs7T0FLRzs7Ozs7OztJQUNJLHVDQUFXOzs7Ozs7SUFBbEIsVUFBbUIsT0FBc0I7UUFDckMsdURBQXVEO1FBQ3ZELDhDQUE4QztRQUM5QyxJQUFJLE9BQU8sQ0FBQyxPQUFPLEVBQUU7OztnQkFFWCxhQUFhLEdBQUcsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUM7WUFDNUQsNkVBQTZFO1lBQzdFLElBQUksQ0FBQyxPQUFPLEdBQUcsRUFBRSxJQUFJLEVBQUUsYUFBYSxDQUFDLFdBQVcsRUFBRSxFQUFFLEtBQUssRUFBRSxhQUFhLENBQUMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxFQUFFLEdBQUcsRUFBRSxhQUFhLENBQUMsT0FBTyxFQUFFLEVBQUUsQ0FBQztTQUMzSDtRQUNELElBQUksT0FBTyxDQUFDLE9BQU8sRUFBRTs7O2dCQUVYLGFBQWEsR0FBRyxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQztZQUM1RCw2RUFBNkU7WUFDN0UsSUFBSSxDQUFDLE9BQU8sR0FBRyxFQUFFLElBQUksRUFBRSxhQUFhLENBQUMsV0FBVyxFQUFFLEVBQUUsS0FBSyxFQUFFLGFBQWEsQ0FBQyxRQUFRLEVBQUUsR0FBRyxDQUFDLEVBQUUsR0FBRyxFQUFFLGFBQWEsQ0FBQyxPQUFPLEVBQUUsRUFBRSxDQUFDO1NBQzNIO0lBQ0wsQ0FBQztJQUVEOzs7OztPQUtHOzs7Ozs7O0lBQ0ksc0NBQVU7Ozs7OztJQUFqQixVQUFrQixtQkFBMkI7UUFDekMsSUFBSSxtQkFBbUIsRUFBRTs7O2dCQUVmLFVBQVUsR0FBRyxJQUFJLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztZQUNoRCw2RUFBNkU7WUFDN0UseUhBQXlIO1lBQ3pILG1EQUFtRDtZQUNuRCxJQUFJLENBQUMsZUFBZSxHQUFHLEVBQUUsSUFBSSxFQUFFLFVBQVUsQ0FBQyxXQUFXLEVBQUUsRUFBRSxLQUFLLEVBQUUsVUFBVSxDQUFDLFFBQVEsRUFBRSxHQUFHLENBQUMsRUFBRSxHQUFHLEVBQUUsVUFBVSxDQUFDLE9BQU8sRUFBRSxFQUFFLENBQUM7WUFDdkgsSUFBSSxDQUFDLFNBQVMsR0FBRyxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsZUFBZSxDQUFDLElBQUksRUFBRSxLQUFLLEVBQUUsSUFBSSxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsQ0FBQztZQUN4Riw2RUFBNkU7WUFDN0UsSUFBSSxDQUFDLGVBQWUsR0FBRyxFQUFFLElBQUksRUFBRSxVQUFVLENBQUMsUUFBUSxFQUFFLEVBQUUsTUFBTSxFQUFFLFVBQVUsQ0FBQyxVQUFVLEVBQUUsRUFBRSxNQUFNLEVBQUUsQ0FBQyxFQUFFLENBQUM7U0FDdEc7SUFDTCxDQUFDOzs7OztJQUNNLDRDQUFnQjs7OztJQUF2QixVQUF3QixFQUFFLElBQUksSUFBSSxDQUFDLFNBQVMsR0FBRyxFQUFFLENBQUMsQ0FBQyxDQUFDOzs7OztJQUM3Qyw2Q0FBaUI7Ozs7SUFBeEIsVUFBeUIsRUFBRSxJQUFJLENBQUM7Ozs7SUFFekIsdUNBQVc7OztJQUFsQjtRQUNVLElBQUEseUJBQTJDLEVBQXpDLGNBQUksRUFBRSxnQkFBSyxFQUFFLFlBQTRCO1FBQzNDLElBQUEseUJBQXVDLEVBQXJDLGNBQUksRUFBRSxrQkFBK0I7O1lBQ3ZDLE9BQU8sR0FBRyxJQUFJLElBQUksQ0FBQyxJQUFJLEVBQUUsS0FBSyxHQUFHLENBQUMsRUFBRSxHQUFHLEVBQUUsSUFBSSxFQUFFLE1BQU0sQ0FBQztRQUM1RCxJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUUsQ0FBQyxDQUFDO0lBQzFDLENBQUM7O2dCQW5GSixTQUFTLFNBQUM7b0JBQ1AsUUFBUSxFQUFFLHFCQUFxQjtvQkFDL0IsUUFBUSxFQUFFLHNmQU9UO29CQUVELFNBQVMsRUFBRSxDQUFDOzRCQUNSLE9BQU8sRUFBRSxpQkFBaUI7NEJBQzFCLFdBQVcsRUFBRSxpQkFBaUI7NEJBQzlCLEtBQUssRUFBRSxJQUFJO3lCQUNkLENBQUM7O2lCQUNMOzs7MEJBR0ksS0FBSzswQkFHTCxLQUFLOztJQThEVix3QkFBQztDQUFBLEFBcEZELElBb0ZDO1NBbkVZLGlCQUFpQjs7O0lBRTFCLG9DQUNtSjs7SUFFbkosb0NBQ29JOztJQUNwSSw0Q0FBc0M7O0lBQ3RDLDRDQUFzQzs7SUFDdEMsdUNBQXFDOztJQUNyQyxzQ0FBc0I7Ozs7O0lBRXRCLHNDQUF1QiIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogU2V0cyB0aGUgZGF0ZSBhbmQgdGltZSB2YWx1ZSBhcyBwcm92aWRlZCBieSB0aGUgdXNlci5cbiAqIFdoZW4gdGhlIHVzZXIgc2VsZWN0cyBhIGRhdGUgb3IgdGltZSB1c2luZyB0aGlzIGRhdGV0aW1lcGlja2VyLCBzZXREYXRlVGltZSBpcyBjYWxsZWQgYW5kIHRoZSB2YWx1ZSBpcyBzZXR0ZWQuXG4gKi9cbmltcG9ydCB7IENvbXBvbmVudCwgSW5wdXQsIE9uQ2hhbmdlcywgT25Jbml0LCBTaW1wbGVDaGFuZ2VzIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBDb250cm9sVmFsdWVBY2Nlc3NvciwgTkdfVkFMVUVfQUNDRVNTT1IgfSBmcm9tICdAYW5ndWxhci9mb3Jtcyc7XG5pbXBvcnQgeyBOZ2JEYXRlU3RydWN0LCBOZ2JUaW1lU3RydWN0IH0gZnJvbSAnQG5nLWJvb3RzdHJhcC9uZy1ib290c3RyYXAnO1xuXG5jb25zdCBjdXJyZW50RGF0ZTogRGF0ZSA9IG5ldyBEYXRlKCk7XG5jb25zdCBsYXN0MTNNb250aHNEYXRlID0gbmV3IERhdGUoY3VycmVudERhdGUuZ2V0VGltZSgpIC0gKDM5NSAqIDI0ICogNjAgKiA2MCAqIDEwMDApKTtcblxuQENvbXBvbmVudCh7XG4gICAgc2VsZWN0b3I6ICdud2YtZGF0ZXRpbWUtcGlja2VyJyxcbiAgICB0ZW1wbGF0ZTogYFxuICAgICAgICA8bmdiLWRhdGVwaWNrZXIgWyhuZ01vZGVsKV09XCJkYXRlcGlja2VyTW9kZWxcIiBbbWF4RGF0ZV09XCJtYXhEYXRlXCIgW21pbkRhdGVdPVwibWluRGF0ZVwiIFtzdGFydERhdGVdPVwic3RhcnREYXRlXCJcbiAgICAgICAgICAgIFtuYXZpZ2F0aW9uXT1cIm5hdmlnYXRpb25cIiBmaXJzdERheU9mV2Vlaz1cIjdcIiAobmdNb2RlbENoYW5nZSk9XCJzZXREYXRldGltZSgpXCI+PC9uZ2ItZGF0ZXBpY2tlcj5cbiAgICAgICAgPGRpdiBjbGFzcz1cImNvbCBteS0yIHAtMFwiPlxuICAgICAgICAgICAgPHNwYW4gY2xhc3M9XCJsYWJlbFwiPnt7J253ZmpzOnRpbWUnIHwgaTE4bmV4dH19Ojwvc3Bhbj5cbiAgICAgICAgICAgIDxuZ2ItdGltZXBpY2tlciBbKG5nTW9kZWwpXT1cInRpbWVwaWNrZXJNb2RlbFwiIFttZXJpZGlhbl09dHJ1ZSAobmdNb2RlbENoYW5nZSk9XCJzZXREYXRldGltZSgpXCI+PC9uZ2ItdGltZXBpY2tlcj5cbiAgICAgICAgPC9kaXY+XG4gICAgYCxcbiAgICBzdHlsZVVybHM6IFsnLi9kYXRldGltZS1waWNrZXIuY29tcG9uZW50LnNjc3MnXSxcbiAgICBwcm92aWRlcnM6IFt7XG4gICAgICAgIHByb3ZpZGU6IE5HX1ZBTFVFX0FDQ0VTU09SLFxuICAgICAgICB1c2VFeGlzdGluZzogTndmRGF0ZXRpbWVQaWNrZXIsXG4gICAgICAgIG11bHRpOiB0cnVlLFxuICAgIH1dLFxufSlcbmV4cG9ydCBjbGFzcyBOd2ZEYXRldGltZVBpY2tlciBpbXBsZW1lbnRzIE9uSW5pdCwgT25DaGFuZ2VzLCBDb250cm9sVmFsdWVBY2Nlc3NvciB7XG5cbiAgICBASW5wdXQoKVxuICAgIHB1YmxpYyBtaW5EYXRlPzogTmdiRGF0ZVN0cnVjdCA9IHsgeWVhcjogbGFzdDEzTW9udGhzRGF0ZS5nZXRGdWxsWWVhcigpLCBtb250aDogbGFzdDEzTW9udGhzRGF0ZS5nZXRNb250aCgpICsgMSwgZGF5OiBsYXN0MTNNb250aHNEYXRlLmdldERhdGUoKSB9O1xuXG4gICAgQElucHV0KClcbiAgICBwdWJsaWMgbWF4RGF0ZT86IE5nYkRhdGVTdHJ1Y3QgPSB7IHllYXI6IGN1cnJlbnREYXRlLmdldEZ1bGxZZWFyKCksIG1vbnRoOiBjdXJyZW50RGF0ZS5nZXRNb250aCgpICsgMSwgZGF5OiBjdXJyZW50RGF0ZS5nZXREYXRlKCkgfTtcbiAgICBwdWJsaWMgZGF0ZXBpY2tlck1vZGVsOiBOZ2JEYXRlU3RydWN0O1xuICAgIHB1YmxpYyB0aW1lcGlja2VyTW9kZWw6IE5nYlRpbWVTdHJ1Y3Q7XG4gICAgcHVibGljIG5hdmlnYXRpb246IHN0cmluZyA9ICdhcnJvd3MnO1xuICAgIHB1YmxpYyBzdGFydERhdGU6IGFueTtcblxuICAgIHByaXZhdGUgX29uQ2hhbmdlOiBhbnk7XG5cbiAgICBwdWJsaWMgbmdPbkluaXQoKSB7IH1cblxuICAgIC8qKlxuICAgICAqIFNldHMgdGhlIG1pbiBhbmQgbWF4IGRhdGUgZm9yIHRoZSB3aWRnZXQuIEJ5IGRlZmF1bHQsIG1pbkRhdGUgaXMgdGhlIGV4YWN0IDEzIG1vbnRocyBhZ28gZGF0ZSBhbmQgbWF4RGF0ZSBpcyB0aGUgY3VycmVudCBkYXRlLlxuICAgICAqIFRoZXNlIGRhdGVzIGFyZSB1cGRhdGVkIGFjY29yZGluZyB0byB0aGUgbWluIGFuZCBtYXggZGF0YSBwcm92aWRlZCBpbiB0aGUgYXJndW1lbnQgb2YgdGhlIGZ1bmN0aW9uLlxuICAgICAqIEBwYXJhbSBjaGFuZ2VzIC0gU2ltcGxlQ2hhbmdlc1xuICAgICAqIEByZXR1cm5zIHZvaWRcbiAgICAgKi9cbiAgICBwdWJsaWMgbmdPbkNoYW5nZXMoY2hhbmdlczogU2ltcGxlQ2hhbmdlcykge1xuICAgICAgICAvLyBzZXQgbWF4RGF0ZSwgbWluRGF0ZSBpZiBpdCBleGlzdHMgaW4gY2hhbmdlcyBvYmplY3QuXG4gICAgICAgIC8vIGVsc2UgaXQgdGFrZXMgZGVmYXVsdCB2YWx1ZXMgZGVmaW5lZCBhYm92ZS5cbiAgICAgICAgaWYgKGNoYW5nZXMubWF4RGF0ZSkge1xuICAgICAgICAgICAgLy8gY29udmVydGluZyBzdHJpbmcgdG8gRGF0ZSBvYmplY3QuXG4gICAgICAgICAgICBjb25zdCBtYXhEYXRlT2JqZWN0ID0gbmV3IERhdGUoY2hhbmdlcy5tYXhEYXRlLmN1cnJlbnRWYWx1ZSk7XG4gICAgICAgICAgICAvLyBjcmVhdGluZyBOZ2JEYXRlU3RydWN0IG1vZGVsIHJlcHJlc2VudGF0aW9uIG91dCBvZiByZWd1bGFyIGpzIGRhdGUgb2JqZWN0LlxuICAgICAgICAgICAgdGhpcy5tYXhEYXRlID0geyB5ZWFyOiBtYXhEYXRlT2JqZWN0LmdldEZ1bGxZZWFyKCksIG1vbnRoOiBtYXhEYXRlT2JqZWN0LmdldE1vbnRoKCkgKyAxLCBkYXk6IG1heERhdGVPYmplY3QuZ2V0RGF0ZSgpIH07XG4gICAgICAgIH1cbiAgICAgICAgaWYgKGNoYW5nZXMubWluRGF0ZSkge1xuICAgICAgICAgICAgLy8gY29udmVydGluZyBzdHJpbmcgdG8gRGF0ZSBvYmplY3QuXG4gICAgICAgICAgICBjb25zdCBtaW5EYXRlT2JqZWN0ID0gbmV3IERhdGUoY2hhbmdlcy5taW5EYXRlLmN1cnJlbnRWYWx1ZSk7XG4gICAgICAgICAgICAvLyBjcmVhdGluZyBOZ2JEYXRlU3RydWN0IG1vZGVsIHJlcHJlc2VudGF0aW9uIG91dCBvZiByZWd1bGFyIGpzIGRhdGUgb2JqZWN0LlxuICAgICAgICAgICAgdGhpcy5taW5EYXRlID0geyB5ZWFyOiBtaW5EYXRlT2JqZWN0LmdldEZ1bGxZZWFyKCksIG1vbnRoOiBtaW5EYXRlT2JqZWN0LmdldE1vbnRoKCkgKyAxLCBkYXk6IG1pbkRhdGVPYmplY3QuZ2V0RGF0ZSgpIH07XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICAvKipcbiAgICAgKlxuICAgICAqIHdyaXRlVmFsdWUoKSAtIFNldHMgdGhlIGRhdGVwaWNrZXJNb2RlbCwgdGltZVBpY2tlck1vZGVsIGFuZCBzdGFydERhdGUgYWNjb3JkaW5nIHRvIHRoZSBkYXRlIHBhc3NlZCBpbiB0aGUgYXJndW1lbnQgb2YgdGhlIGZ1bmN0aW9uLlxuICAgICAqIEBwYXJhbSBkYXRldGltZVBpY2tlclZhbHVlIC0gc3RyaW5nXG4gICAgICogQHJldHVybnMgdm9pZFxuICAgICAqL1xuICAgIHB1YmxpYyB3cml0ZVZhbHVlKGRhdGV0aW1lUGlja2VyVmFsdWU6IHN0cmluZykge1xuICAgICAgICBpZiAoZGF0ZXRpbWVQaWNrZXJWYWx1ZSkge1xuICAgICAgICAgICAgLy8gY29udmVydGluZyBzdHJpbmcgdG8gRGF0ZSBvYmplY3QuXG4gICAgICAgICAgICBjb25zdCBkYXRlT2JqZWN0ID0gbmV3IERhdGUoZGF0ZXRpbWVQaWNrZXJWYWx1ZSk7XG4gICAgICAgICAgICAvLyBjcmVhdGluZyBOZ2JEYXRlU3RydWN0IG1vZGVsIHJlcHJlc2VudGF0aW9uIG91dCBvZiByZWd1bGFyIGpzIGRhdGUgb2JqZWN0LlxuICAgICAgICAgICAgLy8gd2UgYWRkICsxIHRvIG1vbnRoIGJlY2F1c2UgTmdiRGF0ZVN0cnVjdCBtb250aCBwcm9wZXJ0eSB0YWtlcyBpbiB2YWx1ZSBhcyBJU08gZm9ybWF0IGllLiBtb250aCBzaG91bGQgYmUgYmV0d2VlbiAxLTEyLFxuICAgICAgICAgICAgLy8gd2hlcmVhcyBnZXRNb250aCByZXR1cm5zIG1vbnRoIHZhbHVlcyBmcm9tIDAtMTEuXG4gICAgICAgICAgICB0aGlzLmRhdGVwaWNrZXJNb2RlbCA9IHsgeWVhcjogZGF0ZU9iamVjdC5nZXRGdWxsWWVhcigpLCBtb250aDogZGF0ZU9iamVjdC5nZXRNb250aCgpICsgMSwgZGF5OiBkYXRlT2JqZWN0LmdldERhdGUoKSB9O1xuICAgICAgICAgICAgdGhpcy5zdGFydERhdGUgPSB7IHllYXI6IHRoaXMuZGF0ZXBpY2tlck1vZGVsLnllYXIsIG1vbnRoOiB0aGlzLmRhdGVwaWNrZXJNb2RlbC5tb250aCB9O1xuICAgICAgICAgICAgLy8gY3JlYXRpbmcgTmdiVGltZVN0cnVjdCBtb2RlbCByZXByZXNlbnRhdGlvbiBvdXQgb2YgcmVndWxhciBqcyBkYXRlIG9iamVjdC5cbiAgICAgICAgICAgIHRoaXMudGltZXBpY2tlck1vZGVsID0geyBob3VyOiBkYXRlT2JqZWN0LmdldEhvdXJzKCksIG1pbnV0ZTogZGF0ZU9iamVjdC5nZXRNaW51dGVzKCksIHNlY29uZDogMCB9O1xuICAgICAgICB9XG4gICAgfVxuICAgIHB1YmxpYyByZWdpc3Rlck9uQ2hhbmdlKGZuKSB7IHRoaXMuX29uQ2hhbmdlID0gZm47IH1cbiAgICBwdWJsaWMgcmVnaXN0ZXJPblRvdWNoZWQoZm4pIHsgfVxuXG4gICAgcHVibGljIHNldERhdGV0aW1lKCkge1xuICAgICAgICBjb25zdCB7IHllYXIsIG1vbnRoLCBkYXkgfSA9IHRoaXMuZGF0ZXBpY2tlck1vZGVsO1xuICAgICAgICBjb25zdCB7IGhvdXIsIG1pbnV0ZSB9ID0gdGhpcy50aW1lcGlja2VyTW9kZWw7XG4gICAgICAgIGNvbnN0IG5ld0RhdGUgPSBuZXcgRGF0ZSh5ZWFyLCBtb250aCAtIDEsIGRheSwgaG91ciwgbWludXRlKTtcbiAgICAgICAgdGhpcy5fb25DaGFuZ2UobmV3RGF0ZS50b0lTT1N0cmluZygpKTtcbiAgICB9XG59XG4iXX0=