/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
/**
 * Sets the date-time range as provided by the user. The widget has 2 calendars for selecting a set of fromDate and toDate.
 */
import { Component, Input, ViewChild } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { NgbDropdown } from '@ng-bootstrap/ng-bootstrap';
/** @type {?} */
var currentDate = new Date();
/** @type {?} */
var last13MonthsDate = new Date(currentDate.getTime() - (395 * 24 * 60 * 60 * 1000));
var NwfDatetimeRangePicker = /** @class */ (function () {
    function NwfDatetimeRangePicker() {
        this.minDate = last13MonthsDate.toISOString();
        this.maxDate = currentDate.toISOString();
    }
    /**
     * @return {?}
     */
    NwfDatetimeRangePicker.prototype.ngOnInit = /**
     * @return {?}
     */
    function () { };
    /**
     * @param {?} changes
     * @return {?}
     */
    NwfDatetimeRangePicker.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) { };
    /**
     * writeValue() - Sets the fromDate and toDate according to the input.
     * @param datetimeRangeValue - any
     * @returns void
     */
    /**
     * writeValue() - Sets the fromDate and toDate according to the input.
     * @param {?} datetimeRangeValue - any
     * @return {?} void
     */
    NwfDatetimeRangePicker.prototype.writeValue = /**
     * writeValue() - Sets the fromDate and toDate according to the input.
     * @param {?} datetimeRangeValue - any
     * @return {?} void
     */
    function (datetimeRangeValue) {
        var _a;
        if (datetimeRangeValue) {
            _a = tslib_1.__read(datetimeRangeValue.split('~'), 2), this.fromDateISOString = _a[0], this.toDateISOString = _a[1];
            // setting visible value.
            this.setVisibleValue();
        }
    };
    /**
     * @param {?} fn
     * @return {?}
     */
    NwfDatetimeRangePicker.prototype.registerOnChange = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { this._onChange = fn; };
    /**
     * @param {?} fn
     * @return {?}
     */
    NwfDatetimeRangePicker.prototype.registerOnTouched = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { };
    /**
     * setDatetimeRange() - Sets the fromDate and toDate from the ISOStrings
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @param changes - SimpleChanges
     * @returns void
     */
    /**
     * setDatetimeRange() - Sets the fromDate and toDate from the ISOStrings
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @return {?} void
     */
    NwfDatetimeRangePicker.prototype.setDatetimeRange = /**
     * setDatetimeRange() - Sets the fromDate and toDate from the ISOStrings
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @return {?} void
     */
    function () {
        // setting visible value.
        this.setVisibleValue();
        if (!this.emitChangeOnApply) {
            this.emitChange();
        }
    };
    /**
     * @return {?}
     */
    NwfDatetimeRangePicker.prototype.setVisibleValue = /**
     * @return {?}
     */
    function () {
        this.fromDate = new Date(this.fromDateISOString);
        this.toDate = new Date(this.toDateISOString);
    };
    /**
     * Emits the new range on click of apply btn , and close the dropdown
     */
    /**
     * Emits the new range on click of apply btn , and close the dropdown
     * @return {?}
     */
    NwfDatetimeRangePicker.prototype.emitChangeOnApplyClick = /**
     * Emits the new range on click of apply btn , and close the dropdown
     * @return {?}
     */
    function () {
        this.emitChange();
        this.ngbDropDown.close();
    };
    /**
     * Emits the new timerange to the subscriber
     */
    /**
     * Emits the new timerange to the subscriber
     * @private
     * @return {?}
     */
    NwfDatetimeRangePicker.prototype.emitChange = /**
     * Emits the new timerange to the subscriber
     * @private
     * @return {?}
     */
    function () {
        /** @type {?} */
        var newDatetimeRange = this.fromDateISOString + "~" + this.toDateISOString;
        // calling callback with sending the datetime range.
        this._onChange(newDatetimeRange);
    };
    NwfDatetimeRangePicker.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-datetime-range-picker',
                    template: "<div ngbDropdown class=\"d-inline-block\" autoClose=\"outside\" [container]=\"null\" display=\"dynamic\">\n    <button type=\"button\" class=\"btn btn-secondary btn-icon datetime-range-picker-button\" data-netapp-id=\"dateTimePicker-range-btn\"\n        id=\"nwf-grid-filtering\" ngbDropdownToggle>\n        <nwf-icon iconClass=\"icon-action-calendar\"></nwf-icon>\n        <span class=\"btn-icon-label\" data-netapp-id=\"dateTimePicker-widget-label\">\n            {{ fromDate | i18nextFormat: { format: 'datetime' } }} to\n            {{ toDate | i18nextFormat: { format: 'datetime' } }}\n        </span>\n    </button>\n    <div ngbDropdownMenu aria-labelledby=\"nwf-grid-filtering\" class=\"popover-body bg-white\">\n        <nwf-popover-title (onDismiss)=\"ngbDropDown.close()\"></nwf-popover-title>\n        <div class=\"d-flex\" data-netapp-id=\"datetime-range-picker\">\n            <div class=\"p-2 d-flex flex-column\" (click)=\"$event.stopPropagation()\"\n                data-netapp-id=\"datetime-from-picker\">\n                {{'nwfjs:from' | i18next}}\n                <nwf-datetime-picker [(ngModel)]=\"fromDateISOString\" [minDate]=\"minDate\" [maxDate]=\"toDateISOString\"\n                    (ngModelChange)=\"setDatetimeRange()\"></nwf-datetime-picker>\n            </div>\n            <div class=\"p-2 d-flex flex-column\" (click)=\"$event.stopPropagation()\" data-netapp-id=\"datetime-to-picker\">\n                {{'nwfjs:to' | i18next}}\n                <nwf-datetime-picker [(ngModel)]=\"toDateISOString\" [minDate]=\"fromDateISOString\" [maxDate]=\"maxDate\"\n                    (ngModelChange)=\"setDatetimeRange()\"></nwf-datetime-picker>\n            </div>\n        </div>\n        <button *ngIf=\"emitChangeOnApply\" class=\"btn btn-primary float-right\" data-netapp-id=\"datetime-range-picker-apply-btn\" (click)=\"emitChangeOnApplyClick()\">{{'nwfjs:apply' | i18next}}</button>\n    </div>\n</div>",
                    providers: [{
                            provide: NG_VALUE_ACCESSOR,
                            useExisting: NwfDatetimeRangePicker,
                            multi: true,
                        }],
                    styles: [".datetime-range-picker-button{min-width:400px}"]
                }] }
    ];
    /** @nocollapse */
    NwfDatetimeRangePicker.ctorParameters = function () { return []; };
    NwfDatetimeRangePicker.propDecorators = {
        ngbDropDown: [{ type: ViewChild, args: [NgbDropdown, { static: false },] }],
        minDate: [{ type: Input }],
        maxDate: [{ type: Input }],
        emitChangeOnApply: [{ type: Input }]
    };
    return NwfDatetimeRangePicker;
}());
export { NwfDatetimeRangePicker };
if (false) {
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.ngbDropDown;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.minDate;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.maxDate;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.emitChangeOnApply;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.fromDateISOString;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.toDateISOString;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.fromDate;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.toDate;
    /**
     * @type {?}
     * @private
     */
    NwfDatetimeRangePicker.prototype._onChange;
}
//# sourceMappingURL=data:application/json;base64,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