/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
import { Component, forwardRef, Input } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
var MultiselectDropdownComponent = /** @class */ (function () {
    function MultiselectDropdownComponent() {
        this.disabled = false;
        this.required = false;
        this._selectedModel = [];
    }
    /**
     * @return {?}
     */
    MultiselectDropdownComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        /* Clone options array for a private model that represents the internal state */
        this._selectedModel = Object.assign([], this.options);
    };
    /**
     * @param {?} value
     * @return {?}
     */
    MultiselectDropdownComponent.prototype.writeValue = /**
     * @param {?} value
     * @return {?}
     */
    function (value) {
        var e_1, _a;
        if (value !== undefined && value !== null) {
            try {
                for (var _b = tslib_1.__values(this._selectedModel), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var option = _c.value;
                    if (value.includes(option.value)) {
                        option.checked = true;
                    }
                    else {
                        option.checked = false;
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
            this.setLabel();
        }
    };
    /**
     * @param {?} $event
     * @return {?}
     */
    MultiselectDropdownComponent.prototype.onCheckboxChange = /**
     * @param {?} $event
     * @return {?}
     */
    function ($event) {
        var e_2, _a;
        var _b = $event.target, value = _b.value, checked = _b.checked;
        try {
            for (var _c = tslib_1.__values(this._selectedModel), _d = _c.next(); !_d.done; _d = _c.next()) {
                var option = _d.value;
                if (option.value === value) {
                    option.checked = checked;
                    break;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_2) throw e_2.error; }
        }
        /** @type {?} */
        var checkedOpts = this._selectedModel.filter((/**
         * @param {?} option
         * @return {?}
         */
        function (option) { return option.checked; }));
        /** @type {?} */
        var onlyTrueValues = checkedOpts.map((/**
         * @param {?} option
         * @return {?}
         */
        function (option) { return option.value; }));
        this._onChange(onlyTrueValues);
        /* Now set my label */
        this.setLabel();
    };
    /**
     * @return {?}
     */
    MultiselectDropdownComponent.prototype.setLabel = /**
     * @return {?}
     */
    function () {
        /** @type {?} */
        var checkedOpts = this._selectedModel.filter((/**
         * @param {?} option
         * @return {?}
         */
        function (option) { return option.checked; }));
        /** @type {?} */
        var label = 'Select one or more';
        if (checkedOpts.length) {
            label = checkedOpts.map((/**
             * @param {?} option
             * @return {?}
             */
            function (option) { return option.label; })).join(', ');
        }
        this.label = label;
    };
    /**
     * @param {?} fn
     * @return {?}
     */
    MultiselectDropdownComponent.prototype.registerOnChange = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) {
        this._onChange = fn;
    };
    /**
     * @param {?} fn
     * @return {?}
     */
    MultiselectDropdownComponent.prototype.registerOnTouched = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { };
    /**
     * @param {?} isDisabled
     * @return {?}
     */
    MultiselectDropdownComponent.prototype.setDisabledState = /**
     * @param {?} isDisabled
     * @return {?}
     */
    function (isDisabled) {
        this.disabled = isDisabled;
    };
    MultiselectDropdownComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-multiselect-dropdown',
                    template: "<div ngbDropdown placement=\"bottom-left\" autoClose=\"outside\">\n    <button class=\"custom-select\" ngbDropdownToggle [disabled]=\"disabled\">\n      {{label}}\n    </button>\n  <div ngbDropdownMenu style=\"width: 100%\">\n    <div class=\"dropdown-checkbox-item pl-4 mb-1\">\n      <div class=\"custom-control custom-checkbox custom-checkbox-lg\" *ngFor=\"let option of _selectedModel\">\n        <input type=\"checkbox\" (change)=\"onCheckboxChange($event)\" [value]=\"option.value\" [checked]=\"option.checked\" [name]=\"option.label\" [id]=\"option.label | NwfStripWhitespacePipe\" class=\"custom-control-input\">\n        <label class=\"custom-control-label w-100\" [attr.for]=\"option.label | NwfStripWhitespacePipe\">{{option.label}}</label>\n      </div>\n    </div>\n  </div>\n</div>",
                    providers: [
                        {
                            provide: NG_VALUE_ACCESSOR,
                            useExisting: forwardRef((/**
                             * @return {?}
                             */
                            function () { return MultiselectDropdownComponent; })),
                            multi: true,
                        },
                    ],
                    styles: [":host ::ng-deep .dropdown-menu{max-height:calc(100vh - 300px);overflow-y:auto}.custom-select{overflow:hidden;text-overflow:ellipsis;text-align:left}"]
                }] }
    ];
    /** @nocollapse */
    MultiselectDropdownComponent.ctorParameters = function () { return []; };
    MultiselectDropdownComponent.propDecorators = {
        options: [{ type: Input }],
        disabled: [{ type: Input }],
        required: [{ type: Input }]
    };
    return MultiselectDropdownComponent;
}());
export { MultiselectDropdownComponent };
if (false) {
    /** @type {?} */
    MultiselectDropdownComponent.prototype.options;
    /** @type {?} */
    MultiselectDropdownComponent.prototype.disabled;
    /** @type {?} */
    MultiselectDropdownComponent.prototype.required;
    /** @type {?} */
    MultiselectDropdownComponent.prototype._selectedModel;
    /** @type {?} */
    MultiselectDropdownComponent.prototype.label;
    /**
     * @type {?}
     * @private
     */
    MultiselectDropdownComponent.prototype._onChange;
}
/**
 * @record
 */
function IMultiSelectOption() { }
if (false) {
    /** @type {?} */
    IMultiSelectOption.prototype.label;
    /** @type {?} */
    IMultiSelectOption.prototype.value;
}
/**
 * @record
 */
function IMultiSelectModelOption() { }
if (false) {
    /** @type {?} */
    IMultiSelectModelOption.prototype.checked;
}
//# sourceMappingURL=data:application/json;base64,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