/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input, ViewChild } from '@angular/core';
import { NgbDropdown } from '@ng-bootstrap/ng-bootstrap';
import { DxDataGridComponent } from 'devextreme-angular';
import { filter, sortBy } from 'lodash-es';
var ColumnVisibilityComponent = /** @class */ (function () {
    function ColumnVisibilityComponent() {
        this.orderedColumns = []; // our array of the columns in asc order
        // our array of the columns in asc order
        this.visible = {}; // our map of visiblity true / false
    }
    /**
     * @return {?}
     */
    ColumnVisibilityComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
    };
    /**
     * @return {?}
     */
    ColumnVisibilityComponent.prototype.ngAfterViewInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        this.myDrop.openChange.subscribe((/**
         * @param {?} dropdownState
         * @return {?}
         */
        function (dropdownState) {
            // dropdownState = true means dropdown is open.
            if (dropdownState) {
                _this.gridInstance = _this.dataGrid.instance;
                _this.setColumns();
            }
        }));
    };
    /**
     * @return {?}
     */
    ColumnVisibilityComponent.prototype.setColumns = /**
     * @return {?}
     */
    function () {
        var _this = this;
        /** @type {?} */
        var columns = this.getAllColumnsOnDxGrid();
        // Remove all columns that are not shown in the column chooser
        /** @type {?} */
        var shownColumns = filter(columns, (/**
         * @param {?} col
         * @return {?}
         */
        function (col) { return col.hasOwnProperty('showInColumnChooser') ? col.showInColumnChooser : true; }));
        // we sort columns alphabettically for display.
        /** @type {?} */
        var columnsInVisibleIndexOrder = sortBy(shownColumns, [(/**
             * @param {?} dxColumn
             * @return {?}
             */
            function (dxColumn) { return dxColumn.caption; })]);
        columnsInVisibleIndexOrder.forEach((/**
         * @param {?} __0
         * @param {?} index
         * @return {?}
         */
        function (_a, index) {
            var dataField = _a.dataField;
            /** @type {?} */
            var colObj = _this.gridInstance.columnOption(dataField);
            _this.visible[dataField] = colObj.visible;
            /*
            we update visibleIndex to actual index of columns in visibleIndex order.
            this ensures we dont have holes in between as shownColumns might contain columns not in order.
            */
            colObj.visibleIndex = index;
            _this.orderedColumns[colObj.visibleIndex] = colObj;
        }));
        // Below updated required to reset column width if its changed by user
        this.gridInstance.beginUpdate();
        shownColumns.forEach((/**
         * @param {?} colItem
         * @return {?}
         */
        function (colItem) {
            _this.gridInstance.columnOption(colItem.dataField, 'width', null);
        }));
        this.gridInstance.endUpdate();
    };
    /**
     * @param {?} event
     * @param {?} col
     * @return {?}
     */
    ColumnVisibilityComponent.prototype.notify = /**
     * @param {?} event
     * @param {?} col
     * @return {?}
     */
    function (event, col) {
        // we filter out command(eg checkbox column) columns as visibility only operates on non-command columns.
        // This ensures we dont toggle the visibility of checkbox column.
        /** @type {?} */
        var visibleColumns = this.gridInstance.getVisibleColumns().filter((/**
         * @param {?} item
         * @return {?}
         */
        function (item) { return !item.command; }));
        /*
        if we have more than one visible column, or we are showing a column,
        only then we toggle the visibility of the column.
        this ensures we never run into case of having all hidden columns.
        */
        if (visibleColumns.length > 1 || event.target.checked) {
            this.gridInstance.beginUpdate();
            this.gridInstance.columnOption(col, 'visible', event.target.checked);
            this.gridInstance.endUpdate();
        }
        else {
            // this ensures the last checkbox remains checked.
            // so that we can never have all checkbox as unchecked i.e. all columns are unselected/hidden.
            event.target.checked = true;
        }
    };
    /*** We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
       * gridInstance.columnOption gives a complete column object (including default column settings),
       * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
       */
    /**
     * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
     * gridInstance.columnOption gives a complete column object (including default column settings),
     * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
     * @private
     * @return {?}
     */
    ColumnVisibilityComponent.prototype.getAllColumnsOnDxGrid = /**
     * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
     * gridInstance.columnOption gives a complete column object (including default column settings),
     * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
     * @private
     * @return {?}
     */
    function () {
        /** @type {?} */
        var gridInstance = this.gridInstance;
        /** @type {?} */
        var columnsViaOptions = gridInstance && gridInstance.state().columns;
        if (columnsViaOptions) {
            return columnsViaOptions.map((/**
             * @param {?} __0
             * @return {?}
             */
            function (_a) {
                var dataField = _a.dataField;
                return gridInstance.columnOption(dataField);
            }));
        }
        else {
            return;
        }
    };
    ColumnVisibilityComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-column-visibility',
                    template: "<div ngbDropdown class=\"d-inline-block\" placement=\"bottom-right\" display=\"dynamic\" autoClose=\"outside\">\n  <button type=\"button\" class=\"btn btn-flat btn-sm btn-icon\" ngbDropdownToggle>\n    <nwf-icon iconClass=\"icon-view-visible\"></nwf-icon><span\n      class=\"btn-icon-label\">{{'nwfjs:showHide' | i18next}}</span>\n  </button>\n  <div ngbDropdownMenu>\n    <dx-scroll-view>\n      <div class=\"dropdown-checkbox-item pl-4 mb-1\" *ngFor=\"let column of orderedColumns\">\n        <div class=\"custom-control custom-checkbox\" *ngIf=\"column.allowHiding !== false\">\n          <input type=\"checkbox\" [name]=\"column.dataField\" [id]=\"column.dataField\" class=\"custom-control-input\"\n            [(ngModel)]=\"visible[column.dataField]\" (change)=\"notify($event, column.dataField)\">\n          <label class=\"custom-control-label w-100\" [attr.for]=\"column.dataField\" data-netapp-id=\"nwf-column-visibility-option-label\">{{column.caption}}</label>\n        </div>\n      </div>\n    </dx-scroll-view>\n  </div>\n</div>",
                    styles: [":host ::ng-deep .dx-scrollable-container{max-height:50vh}.dropdown-menu{padding-top:20px;padding-bottom:20px;max-height:60vh}.dropdown-checkbox-item{margin-right:20px}.custom-control-label{cursor:pointer;white-space:nowrap}"]
                }] }
    ];
    /** @nocollapse */
    ColumnVisibilityComponent.ctorParameters = function () { return []; };
    ColumnVisibilityComponent.propDecorators = {
        myDrop: [{ type: ViewChild, args: [NgbDropdown, { static: false },] }],
        dataGrid: [{ type: Input }]
    };
    return ColumnVisibilityComponent;
}());
export { ColumnVisibilityComponent };
if (false) {
    /** @type {?} */
    ColumnVisibilityComponent.prototype.myDrop;
    /** @type {?} */
    ColumnVisibilityComponent.prototype.gridInstance;
    /** @type {?} */
    ColumnVisibilityComponent.prototype.orderedColumns;
    /** @type {?} */
    ColumnVisibilityComponent.prototype.visible;
    /** @type {?} */
    ColumnVisibilityComponent.prototype.dataGrid;
}
//# sourceMappingURL=data:application/json;base64,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