/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
import { Component, Input } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { I18NextPipe } from 'angular-i18next';
var NwfFilterCriterionDateComponent = /** @class */ (function () {
    function NwfFilterCriterionDateComponent(i18NextPipe) {
        var e_1, _a;
        this.datetime = '';
        // List of default date selections for the user
        this.dateRangeList = [
            { id: 'LAST_1h', label: '' },
            { id: 'LAST_24h', label: '' },
            { id: 'LAST_72h', label: '' },
            { id: 'LAST_7d', label: '' },
            { id: 'LAST_30d', label: '' },
            { id: 'LAST_390d', label: '' },
        ];
        try {
            // i18n the values (displayed label in the drop down)
            for (var _b = tslib_1.__values(this.dateRangeList), _c = _b.next(); !_c.done; _c = _b.next()) {
                var dateRangeList = _c.value;
                // pop in the the label translated (the key is e.g. last_1h)
                dateRangeList.label = i18NextPipe.transform("nwfjs:" + dateRangeList.id.toLowerCase());
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    /**
     * @param {?} changes
     * @return {?}
     */
    NwfFilterCriterionDateComponent.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) {
        // on every operator change, we set the dateTime, dateTimeVisibleValue based on operator value.
        // we can have 3 types of operator.
        // 1. <=, >=, 2. between, 3. in the last(last)
        if (!changes.operator.isFirstChange()) {
            // if current value is <=, >=, we set dateTimeVisibleValue to current Date
            if (['<=', '>='].indexOf(changes.operator.currentValue) !== -1) {
                this.datetime = new Date().toISOString();
                this.datetimeVisibleValue = new Date();
            }
            else if (changes.operator.currentValue === 'between') {
                this.datetime = new Date().toISOString() + "~" + new Date().toISOString();
            }
            else {
                this.datetime = '';
            }
            // sending out new value.
            this.onValueModelChange(this.datetime);
        }
    };
    /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component.This value is pre-set value to datetime widget.
     * @param value
     */
    /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component.This value is pre-set value to datetime widget.
     * @param {?} value
     * @return {?}
     */
    NwfFilterCriterionDateComponent.prototype.writeValue = /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component.This value is pre-set value to datetime widget.
     * @param {?} value
     * @return {?}
     */
    function (value) {
        // we default datetime to last_72h, in case there is no value set.
        this.datetime = value;
        this.datetimeVisibleValue = new Date(this.datetime);
    };
    /**
     * @param {?} fn
     * @return {?}
     */
    NwfFilterCriterionDateComponent.prototype.registerOnChange = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { this._onChange = fn; };
    /**
     * @param {?} fn
     * @return {?}
     */
    NwfFilterCriterionDateComponent.prototype.registerOnTouched = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { };
    /**
     * This method is called whenever model tied to the component changes.
     * This is outgoing value from this widget.
     * @param newModelValue
     */
    /**
     * This method is called whenever model tied to the component changes.
     * This is outgoing value from this widget.
     * @param {?} newDateValue
     * @return {?}
     */
    NwfFilterCriterionDateComponent.prototype.onValueModelChange = /**
     * This method is called whenever model tied to the component changes.
     * This is outgoing value from this widget.
     * @param {?} newDateValue
     * @return {?}
     */
    function (newDateValue) {
        this.datetimeVisibleValue = new Date(newDateValue);
        this._onChange(newDateValue);
    };
    NwfFilterCriterionDateComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-filter-criterion-date',
                    template: "\n    <select class=\"form-control custom-select mr-2\" required data-netapp-id=\"filter-widget-select-operator\" *ngIf=\"operator === 'lst'\"\n    (change)=\"onValueModelChange($event.target.value)\" [(ngModel)]=\"datetime\">\n        <option [selected]=\"!datetime\" value>{{'nwfjs:choose' | i18next}}</option>\n        <option [selected]=\"datetime == dateRange.id\" *ngFor=\"let dateRange of dateRangeList\" [value]=\"dateRange.id\">{{dateRange.label}}</option>\n    </select>\n\n    <div *ngIf=\"operator === 'between'\" (click)=\"$event.stopPropagation()\">\n        <nwf-datetime-range-picker [(ngModel)]=\"datetime\" (ngModelChange)=\"onValueModelChange($event)\"></nwf-datetime-range-picker>\n    </div>\n\n    <div *ngIf=\"operator === '>=' || operator === '<='\" (click)=\"$event.stopPropagation()\">\n        <ng-template #datetimePickerTemplate>\n            <nwf-datetime-picker [(ngModel)]=\"datetime\" (ngModelChange)=\"onValueModelChange($event)\"></nwf-datetime-picker>\n        </ng-template>\n        <button type=\"button\" class=\"d-flex align-items-center form-control\" [ngbPopover]=\"datetimePickerTemplate\" [popoverClass]=\"'max-width-none is-arrowless'\" placement=\"bottom\" data-netapp-id=\"filter-widget-btn\">\n            <nwf-icon iconClass=\"icon-action-calendar\"></nwf-icon>\n            <label data-netapp-id=\"dateTimePicker-widget-label\">{{ datetimeVisibleValue | i18nextFormat: { format: 'datetime' } }}</label>\n        </button>\n    </div>\n    ",
                    providers: [{
                            provide: NG_VALUE_ACCESSOR,
                            useExisting: NwfFilterCriterionDateComponent,
                            multi: true,
                        }]
                }] }
    ];
    /** @nocollapse */
    NwfFilterCriterionDateComponent.ctorParameters = function () { return [
        { type: I18NextPipe }
    ]; };
    NwfFilterCriterionDateComponent.propDecorators = {
        operator: [{ type: Input }]
    };
    return NwfFilterCriterionDateComponent;
}());
export { NwfFilterCriterionDateComponent };
if (false) {
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.operator;
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.datetime;
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.datetimeVisibleValue;
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.dateRangeList;
    /**
     * @type {?}
     * @private
     */
    NwfFilterCriterionDateComponent.prototype._onChange;
}
//# sourceMappingURL=data:application/json;base64,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