/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { I18NextPipe } from 'angular-i18next';
import { DxDataGridComponent } from 'devextreme-angular';
import { isPromise } from 'rxjs/internal/util/isPromise';
var FooterComponent = /** @class */ (function () {
    function FooterComponent(i18NextPipe) {
        this.i18NextPipe = i18NextPipe;
        this.usePagination = true;
        this.isSelectionEnabled = false;
        this.isFiltered = false;
    }
    /**
     * @return {?}
     */
    FooterComponent.prototype.ngOnChanges = /**
     * @return {?}
     */
    function () {
        this.setPaginatorI18n();
    };
    /**
     * @return {?}
     */
    FooterComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        this.dataGrid.onContentReady.subscribe((/**
         * @param {?} data
         * @return {?}
         */
        function (data) {
            /** @type {?} */
            var gridInstance = data.component.instance();
            /** @type {?} */
            var pageIndex = gridInstance.pageIndex();
            _this.currentPage = pageIndex + 1;
            _this.limit = gridInstance.pageSize();
            _this.offset = _this.limit * pageIndex;
            _this.totalRecords = gridInstance.totalCount();
            _this.isFiltered = !!gridInstance.getCombinedFilter();
            _this.setPaginatorI18n();
            _this.setSelectedI18n(data);
        }));
        // we listen to onSelectionChanged event and update the selected rows count based on that.
        this.dataGrid.onSelectionChanged.subscribe((/**
         * @param {?} data
         * @return {?}
         */
        function (data) {
            _this.setSelectedI18n(data);
        }));
    };
    /**
     * @param {?} newPageNumber
     * @return {?}
     */
    FooterComponent.prototype.pageChangeHandler = /**
     * @param {?} newPageNumber
     * @return {?}
     */
    function (newPageNumber) {
        this.dataGrid.instance.pageIndex(newPageNumber - 1);
    };
    /**
     * @private
     * @return {?}
     */
    FooterComponent.prototype.setPaginatorI18n = /**
     * @private
     * @return {?}
     */
    function () {
        /** @type {?} */
        var title = this.getTitle(this.totalRecords);
        this.isFilteredI18n = { totalRecords: this.totalRecords, title: title };
        /** @type {?} */
        var offLimit = this.offset + this.limit;
        this.paginatorI18n = {
            pageStart: this.offset + 1,
            pageEnd: offLimit > this.totalRecords ? this.totalRecords : offLimit,
            totalRecords: this.totalRecords,
            title: title,
        };
    };
    /**
     * @private
     * @param {?} data
     * @return {?}
     */
    FooterComponent.prototype.setSelectedI18n = /**
     * @private
     * @param {?} data
     * @return {?}
     */
    function (data) {
        var _this = this;
        /** @type {?} */
        var getSelectedRows = data.component.instance().getSelectedRowKeys();
        /** @type {?} */
        var setRows = (/**
         * @param {?} count
         * @return {?}
         */
        function (count) {
            _this.selectedRowsCount = count;
            _this.selectedI18n = { title: _this.getTitle(count), count: count };
        });
        if (isPromise(getSelectedRows)) {
            getSelectedRows.then((/**
             * @param {?} rows
             * @return {?}
             */
            function (rows) {
                setRows(rows.length);
            }));
        }
        else {
            setRows(getSelectedRows.length);
        }
    };
    /**
     * @private
     * @param {?} count
     * @return {?}
     */
    FooterComponent.prototype.getTitle = /**
     * @private
     * @param {?} count
     * @return {?}
     */
    function (count) {
        return this.i18NextPipe.transform(this.titleKey, { count: count });
    };
    FooterComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-footer',
                    template: "\n    <nav class=\"navbar navbar-expand-lg pt-2 pb-2 px-0\" *ngIf=\"totalRecords\">\n      <div class=\"w-100 navbar-text\" *ngIf=\"isSelectionEnabled\">\n        <div data-netapp-id=\"grid-footer-row-selected-count\" *ngIf=\"selectedRowsCount\">\n          {{ \"nwfjs:gridFooterSelectedCount\" | i18next: selectedI18n }}\n        </div>\n      </div>\n      <div class=\"w-100 navbar-text\" [ngClass]=\"{ 'text-center': isSelectionEnabled }\">\n        <div *ngIf=\"usePagination\" class=\"paginator-page-info\" data-netapp-id=\"paginator-count-message\">\n          {{ \"nwfjs:paginatorShowRecords\" | i18next: paginatorI18n }}\n        </div>\n      </div>\n      <div class=\"w-100 d-flex justify-content-end navbar-text\">\n        <ng-content *ngIf=\"!usePagination\"></ng-content>\n        <div *ngIf=\"!usePagination\" class=\"paginator-page-info\" data-netapp-id=\"paginator-count-message\">\n          <span *ngIf=\"!isFiltered\">{{ \"nwfjs:paginatorShowRecordsNoPagination\" | i18next: isFilteredI18n }}</span>\n          <span *ngIf=\"isFiltered\">{{ \"nwfjs:paginatorShowRecordsNoPaginationFiltered\" | i18next: isFilteredI18n }}</span>\n        </div>\n        <ngb-pagination\n          *ngIf=\"usePagination && totalRecords > 0\"\n          [maxSize]=\"5\"\n          [pageSize]=\"limit\"\n          (pageChange)=\"pageChangeHandler($event)\"\n          [collectionSize]=\"totalRecords\"\n          [(page)]=\"currentPage\"\n          class=\"pagination\"\n        >\n          <ng-template ngbPaginationPrevious>\n            <nwf-icon [iconClass]=\"'icon-misc-arrowleft'\"></nwf-icon><span class=\"ml-1\">{{ \"nwfjs:previous\" | i18next }}</span>\n          </ng-template>\n          <ng-template ngbPaginationNext>\n            <span class=\"mr-1\">{{ \"nwfjs:next\" | i18next }}</span\n            ><nwf-icon [iconClass]=\"'icon-misc-arrowright'\"></nwf-icon>\n          </ng-template>\n        </ngb-pagination>\n      </div>\n    </nav>\n  ",
                    styles: [".paginator-page-info{white-space:nowrap}:host ::ng-deep .pagination{align-items:center;color:#454545;display:flex;font-size:16px;list-style:none;padding:0;margin-bottom:0}:host ::ng-deep .page-link{background:0 0!important;border:none;align-items:center;display:flex;padding:8px 12px}:host ::ng-deep .page-item.active>.page-link{color:#454545;font-weight:700;pointer-events:none;background:0 0}:host ::ng-deep .page-item.disabled{color:#c2c2c2;pointer-events:none}:host ::ng-deep .page-item.disabled:hover{color:#c2c2c2;text-decoration:none}:host ::ng-deep .page-item.disabled:hover nwf-icon{color:#c2c2c2}:host ::ng-deep .navbar-text{padding:0 0 8px}"]
                }] }
    ];
    /** @nocollapse */
    FooterComponent.ctorParameters = function () { return [
        { type: I18NextPipe }
    ]; };
    FooterComponent.propDecorators = {
        dataGrid: [{ type: Input }],
        titleKey: [{ type: Input }],
        usePagination: [{ type: Input }],
        isSelectionEnabled: [{ type: Input }]
    };
    return FooterComponent;
}());
export { FooterComponent };
if (false) {
    /** @type {?} */
    FooterComponent.prototype.dataGrid;
    /** @type {?} */
    FooterComponent.prototype.titleKey;
    /** @type {?} */
    FooterComponent.prototype.usePagination;
    /** @type {?} */
    FooterComponent.prototype.isSelectionEnabled;
    /** @type {?} */
    FooterComponent.prototype.currentPage;
    /** @type {?} */
    FooterComponent.prototype.limit;
    /** @type {?} */
    FooterComponent.prototype.offset;
    /** @type {?} */
    FooterComponent.prototype.totalRecords;
    /** @type {?} */
    FooterComponent.prototype.selectedRowsCount;
    /** @type {?} */
    FooterComponent.prototype.isFiltered;
    /** @type {?} */
    FooterComponent.prototype.isFilteredI18n;
    /** @type {?} */
    FooterComponent.prototype.paginatorI18n;
    /** @type {?} */
    FooterComponent.prototype.selectedI18n;
    /** @type {?} */
    FooterComponent.prototype.i18NextPipe;
}
//# sourceMappingURL=data:application/json;base64,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