/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
import DataGrid from 'devextreme/ui/data_grid';
import TreeList from 'devextreme/ui/tree_list';
import { merge } from 'lodash-es';
import { NwfColumnsChangingService } from '../components/grid-columns-changing.service';
var NwfGridOptionsService = /** @class */ (function () {
    function NwfGridOptionsService(columnsChangingService) {
        this.columnsChangingService = columnsChangingService;
    }
    /**
     * Set the global options on the DxDataGrid with defaults from nwfjs and passed in values
     * @param options for overriding the default options
     */
    /**
     * Set the global options on the DxDataGrid with defaults from nwfjs and passed in values
     * @param {?=} dataGridOptions
     * @return {?}
     */
    NwfGridOptionsService.prototype.setGridDefaultOptions = /**
     * Set the global options on the DxDataGrid with defaults from nwfjs and passed in values
     * @param {?=} dataGridOptions
     * @return {?}
     */
    function (dataGridOptions) {
        var _this = this;
        if (dataGridOptions === void 0) { dataGridOptions = {}; }
        // TreeList Options
        TreeList.defaultOptions({
            options: {
                // This disables right click context menus.
                onContextMenuPreparing: 
                // This disables right click context menus.
                /**
                 * @param {?} e
                 * @return {?}
                 */
                function (e) {
                    e.items = [];
                },
                scrolling: {
                    useNative: false,
                },
            },
        });
        // DataGrid Options
        DataGrid.defaultOptions(merge({
            options: {
                // following options are standard for all nwfjs grids.
                allowColumnResizing: true,
                allowColumnReordering: true,
                showColumnLines: false,
                showRowLines: true,
                hoverStateEnabled: true,
                // this property synchronize the filter row, header filter, and filter builder.
                // The synchronized filter expression is stored in the filterValue option.
                filterSyncEnabled: true,
                // This disables right click context menus.
                onContextMenuPreparing: 
                // This disables right click context menus.
                /**
                 * @param {?} e
                 * @return {?}
                 */
                function (e) {
                    e.items = [];
                },
                onInitialized: (/**
                 * @param {?} e
                 * @return {?}
                 */
                function (e) {
                    // Wire onColumnsChanging event to service observable
                    e.component.option('onColumnsChanging', (/**
                     * @param {?} columnChangeEvent
                     * @return {?}
                     */
                    function (columnChangeEvent) {
                        _this.columnsChangingService.onColumnsChanging(columnChangeEvent);
                    }));
                }),
                pager: {
                    visible: false,
                },
                scrolling: {
                    useNative: false,
                },
            },
        }, dataGridOptions));
    };
    NwfGridOptionsService.decorators = [
        { type: Injectable }
    ];
    /** @nocollapse */
    NwfGridOptionsService.ctorParameters = function () { return [
        { type: NwfColumnsChangingService }
    ]; };
    return NwfGridOptionsService;
}());
export { NwfGridOptionsService };
if (false) {
    /**
     * @type {?}
     * @private
     */
    NwfGridOptionsService.prototype.columnsChangingService;
}
//# sourceMappingURL=data:application/json;base64,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