/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Pipe } from '@angular/core';
import { I18NextFormatPipe } from 'angular-i18next';
var NwfRoundUnit = /** @class */ (function () {
    function NwfRoundUnit(i18NextPipeFormatPipe) {
        this.i18NextPipeFormatPipe = i18NextPipeFormatPipe;
        this.units = ['bytes', 'KB', 'MB', 'GB', 'TB', 'PB'];
    }
    /**
     * @param {?} value
     * @param {?} config
     * @return {?}
     */
    NwfRoundUnit.prototype.transform = /**
     * @param {?} value
     * @param {?} config
     * @return {?}
     */
    function (value, config) {
        // tslint:disable-next-line: prefer-const
        var unit = config.unit, statType = config.statType;
        /** @type {?} */
        var isPercent = (unit === '%');
        if (this.units.indexOf(unit) >= 0) {
            var _a = this.getReadable(value, unit), newValue = _a.value, newUnit = _a.unit;
            value = newValue;
            unit = newUnit;
        }
        /** @type {?} */
        var text = this.round(value, isPercent, statType);
        if (text) { // parsing through number locale if value is truthy.if (value !== null) {
            if (!isNaN(parseFloat(text))) {
                // Use i18next formatting for number
                text = this.i18NextPipeFormatPipe.transform(parseFloat(text), { format: 'number' });
            }
            if (unit) { // add unit only if unit is not undefined and not null
                text += (isPercent ? '' : ' ') + unit;
            }
            return text;
        }
        else {
            return 'N/A';
        }
    };
    /**
     * @param {?} value
     * @param {?=} isPercent
     * @param {?=} statType
     * @return {?}
     */
    NwfRoundUnit.prototype.round = /**
     * @param {?} value
     * @param {?=} isPercent
     * @param {?=} statType
     * @return {?}
     */
    function (value, isPercent, statType) {
        if (isPercent === void 0) { isPercent = false; }
        if (statType === void 0) { statType = ''; }
        if (value === null) { //  return null if null
            return null;
        }
        else if (value === 0) {
            return '0';
        }
        if (isPercent) {
            if (value < 1) { // "<1" if < 1
                return '< 1';
            }
            else { // Whole number otherwise
                return parseFloat(value).toFixed();
            }
        }
        else {
            if (value < 1) {
                switch (statType) {
                    case 'latency':
                        return parseFloat(value).toFixed(3); // 3 decimal points between 0 and 1 for Latency
                    default:
                        return '< 1'; // "<1" if < 1 for everything else
                }
            }
            else if (value < 10 && value >= 1) { // 2 decimal points between 1 and 10
                return parseFloat(value).toFixed(2);
            }
            else if (value < 100 && value >= 10) { // 1 decimal point between 10 and  100
                return parseFloat(value).toFixed(1);
            }
            else if (value >= 100) { // Whole number if greater than 100
                return parseFloat(value).toFixed();
            }
            else {
                return value;
            }
        }
    };
    /**
     * @param {?} value
     * @param {?} unit
     * @return {?}
     */
    NwfRoundUnit.prototype.getReadable = /**
     * @param {?} value
     * @param {?} unit
     * @return {?}
     */
    function (value, unit) {
        /** @type {?} */
        var idx = this.units.indexOf(unit);
        /** @type {?} */
        var result;
        // we always need a value handling undefined case
        while (value && !(value >= 1 && value < 1024)) {
            if (value < 1) {
                // The current unit is too big
                if (idx > 0) {
                    // Decrease the unit by one level
                    value *= 1024.0;
                    idx -= 1;
                }
                else {
                    // The current unit is KB, there is no smaller unit, we have the result
                    result = { value: value, unit: this.units[idx] };
                    break;
                }
            }
            if (value >= 1024) {
                // The current unit is too small
                if (idx < this.units.length - 1) {
                    // Increase the unit by one level
                    value /= 1024.0;
                    idx += 1;
                }
                else {
                    // The current unit is PB, there is no bigger unit, we have the result
                    result = { value: value, unit: this.units[idx] };
                    break;
                }
            }
        }
        if (!result) {
            // The give arguments are proper value and unit
            result = { value: value, unit: this.units[idx] };
        }
        return result;
    };
    NwfRoundUnit.decorators = [
        { type: Pipe, args: [{ name: 'NwfRoundUnit' },] }
    ];
    /** @nocollapse */
    NwfRoundUnit.ctorParameters = function () { return [
        { type: I18NextFormatPipe }
    ]; };
    return NwfRoundUnit;
}());
export { NwfRoundUnit };
if (false) {
    /** @type {?} */
    NwfRoundUnit.prototype.units;
    /**
     * @type {?}
     * @private
     */
    NwfRoundUnit.prototype.i18NextPipeFormatPipe;
}
//# sourceMappingURL=data:application/json;base64,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