/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { StateService, TransitionService } from '@uirouter/core';
import { forEach, isMatch, reduce } from 'lodash-es';
import { NwfLeftnavService } from './leftnav.service';
var LeftnavComponent = /** @class */ (function () {
    function LeftnavComponent(leftnavService, transitionService, stateService) {
        this.leftnavService = leftnavService;
        this.transitionService = transitionService;
        this.stateService = stateService;
        this.keepOtherSectionsOpen = true;
    }
    /**
     * @return {?}
     */
    LeftnavComponent.prototype.repaintStateHighlight = /**
     * @return {?}
     */
    function () {
        var _this = this;
        var _a = this.stateService, current = _a.current, params = _a.params;
        setTimeout((/**
         * @return {?}
         */
        function () { _this.markActiveState(_this.navData, current, params); }), 0);
    };
    /**
     * @return {?}
     */
    LeftnavComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        // Set my navData on the leftnavService so others (like feature tour ) can open a tree of items programatically.
        this.leftnavService.navData = this.navData;
        /* On Enter I recurse to find out what to highlight */
        this.transitionService.onSuccess({}, (/**
         * @param {?} trans
         * @return {?}
         */
        function (trans) {
            _this.repaintStateHighlight();
        }));
    };
    /**
     * @param {?} changes
     * @return {?}
     */
    LeftnavComponent.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) {
        if (changes.navData && changes.navData.currentValue) {
            this.loadLeftNav(changes.navData.currentValue);
        }
    };
    /**
     * @param {?} navData
     * @return {?}
     */
    LeftnavComponent.prototype.loadLeftNav = /**
     * @param {?} navData
     * @return {?}
     */
    function (navData) {
        this.closeAll(navData);
        /* I have to find out on load where I am as well */
        this.repaintStateHighlight();
    };
    /*
     * Recurse through the navData, marking the active state, and
     * all its parents. Return true if we found a match.
     * An item is active if it's name and params matches
     * An item is also active if any of it's child is active.
     */
    /*
       * Recurse through the navData, marking the active state, and
       * all its parents. Return true if we found a match.
       * An item is active if it's name and params matches
       * An item is also active if any of it's child is active.
       */
    /**
     * @param {?} navData
     * @param {?} state
     * @param {?=} params
     * @return {?}
     */
    LeftnavComponent.prototype.markActiveState = /*
       * Recurse through the navData, marking the active state, and
       * all its parents. Return true if we found a match.
       * An item is active if it's name and params matches
       * An item is also active if any of it's child is active.
       */
    /**
     * @param {?} navData
     * @param {?} state
     * @param {?=} params
     * @return {?}
     */
    function (navData, state, params) {
        var _this = this;
        if (params === void 0) { params = null; }
        return reduce(navData, (/**
         * @param {?} matched
         * @param {?} item
         * @return {?}
         */
        function (matched, item) {
            /** @type {?} */
            var matchesChild = false;
            if (item.children) {
                matchesChild = _this.markActiveState(item.children, state, params);
            }
            if (_this.keepOtherSectionsOpen) {
                /* If it's already open leave if; if it needs to be open, do it */
                if (matchesChild) {
                    item.isCollapsed = false;
                }
            }
            else {
                item.isCollapsed = !matchesChild;
            }
            /** @type {?} */
            var hasNameMatch = (item.sref !== undefined && ((state.name === item.sref) || (state.parent === item.sref)));
            /** @type {?} */
            var hasParamMatch = isMatch(params, item.srefParams || {});
            item.isActive = matchesChild || (hasNameMatch && hasParamMatch);
            matched = matched || item.isActive;
            return matched;
        }), false);
    };
    /**
     * @param {?} navData
     * @return {?}
     */
    LeftnavComponent.prototype.closeAll = /**
     * @param {?} navData
     * @return {?}
     */
    function (navData) {
        var _this = this;
        forEach(navData, (/**
         * @param {?} item
         * @return {?}
         */
        function (item) {
            item.isCollapsed = true;
            if (navData.children) {
                _this.closeAll(navData.children);
            }
        }));
    };
    LeftnavComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-left-nav',
                    template: "\n  <dx-scroll-view>\n  <nav class=\"leftnav\" role=\"navigation\">\n  <ul class=\"nwf-leftnav-items p-0 m-0\">\n      <li class=\"nwf-leftnav-item d-block\" *ngFor=\"let item of navData\" nwfLeftnavItem isTopLevel=\"true\" [item]=\"item\" [attr.data-netapp-id]=\"'leftnav-item-' + item.label | lowercase\"></li>\n  </ul>\n  </nav>\n  </dx-scroll-view>\n  ",
                    styles: ["nav.leftnav{display:flex;flex-direction:column;font-size:90%;top:0;padding-top:25px;overflow-x:hidden;overflow-y:auto;position:-webkit-sticky;position:sticky}"]
                }] }
    ];
    /** @nocollapse */
    LeftnavComponent.ctorParameters = function () { return [
        { type: NwfLeftnavService },
        { type: TransitionService },
        { type: StateService }
    ]; };
    LeftnavComponent.propDecorators = {
        navData: [{ type: Input }]
    };
    return LeftnavComponent;
}());
export { LeftnavComponent };
if (false) {
    /** @type {?} */
    LeftnavComponent.prototype.navData;
    /**
     * @type {?}
     * @private
     */
    LeftnavComponent.prototype.keepOtherSectionsOpen;
    /** @type {?} */
    LeftnavComponent.prototype.leftnavService;
    /**
     * @type {?}
     * @private
     */
    LeftnavComponent.prototype.transitionService;
    /**
     * @type {?}
     * @private
     */
    LeftnavComponent.prototype.stateService;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGVmdG5hdi5jb21wb25lbnQuanMiLCJzb3VyY2VSb290Ijoibmc6Ly9AbmV0YXBwL253ZmpzX2FuZ3VsYXJfY29tcG9uZW50cy8iLCJzb3VyY2VzIjpbImxpYi9zaGVsbC9sZWZ0bmF2L2xlZnRuYXYuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFFLEtBQUssRUFBa0IsTUFBTSxlQUFlLENBQUM7QUFDakUsT0FBTyxFQUFvQixZQUFZLEVBQWMsaUJBQWlCLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQztBQUMvRixPQUFPLEVBQUUsT0FBTyxFQUFFLE9BQU8sRUFBRSxNQUFNLEVBQUUsTUFBTSxXQUFXLENBQUM7QUFDckQsT0FBTyxFQUFFLGlCQUFpQixFQUFFLE1BQU0sbUJBQW1CLENBQUM7QUFFdEQ7SUFtQkUsMEJBQW1CLGNBQWlDLEVBQVUsaUJBQW9DLEVBQVUsWUFBMEI7UUFBbkgsbUJBQWMsR0FBZCxjQUFjLENBQW1CO1FBQVUsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFtQjtRQUFVLGlCQUFZLEdBQVosWUFBWSxDQUFjO1FBRjlILDBCQUFxQixHQUFHLElBQUksQ0FBQztJQUVxRyxDQUFDOzs7O0lBRXBJLGdEQUFxQjs7O0lBQTVCO1FBQUEsaUJBR0M7UUFGTyxJQUFBLHNCQUF1QyxFQUFyQyxvQkFBTyxFQUFFLGtCQUE0QjtRQUM3QyxVQUFVOzs7UUFBQyxjQUFRLEtBQUksQ0FBQyxlQUFlLENBQUMsS0FBSSxDQUFDLE9BQU8sRUFBRSxPQUFPLEVBQUUsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDLEdBQUUsQ0FBQyxDQUFDLENBQUM7SUFDaEYsQ0FBQzs7OztJQUVNLG1DQUFROzs7SUFBZjtRQUFBLGlCQU9DO1FBTkMsZ0hBQWdIO1FBQ2hILElBQUksQ0FBQyxjQUFjLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUM7UUFDM0Msc0RBQXNEO1FBQ3RELElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLENBQUMsRUFBRTs7OztRQUFFLFVBQUMsS0FBaUI7WUFDckQsS0FBSSxDQUFDLHFCQUFxQixFQUFFLENBQUM7UUFDL0IsQ0FBQyxFQUFDLENBQUM7SUFDTCxDQUFDOzs7OztJQUVNLHNDQUFXOzs7O0lBQWxCLFVBQW1CLE9BQU87UUFDeEIsSUFBSSxPQUFPLENBQUMsT0FBTyxJQUFJLE9BQU8sQ0FBQyxPQUFPLENBQUMsWUFBWSxFQUFFO1lBQ2pELElBQUksQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsQ0FBQztTQUNsRDtJQUNILENBQUM7Ozs7O0lBRU0sc0NBQVc7Ozs7SUFBbEIsVUFBbUIsT0FBWTtRQUM3QixJQUFJLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ3ZCLG1EQUFtRDtRQUNuRCxJQUFJLENBQUMscUJBQXFCLEVBQUUsQ0FBQztJQUMvQixDQUFDO0lBRUQ7Ozs7O09BS0c7Ozs7Ozs7Ozs7Ozs7SUFDSSwwQ0FBZTs7Ozs7Ozs7Ozs7O0lBQXRCLFVBQXVCLE9BQU8sRUFBRSxLQUF1QixFQUFFLE1BQWE7UUFBdEUsaUJBdUJDO1FBdkJ3RCx1QkFBQSxFQUFBLGFBQWE7UUFDcEUsT0FBTyxNQUFNLENBQUMsT0FBTzs7Ozs7UUFBRSxVQUFDLE9BQU8sRUFBRSxJQUFJOztnQkFDL0IsWUFBWSxHQUFHLEtBQUs7WUFFeEIsSUFBSSxJQUFJLENBQUMsUUFBUSxFQUFFO2dCQUNqQixZQUFZLEdBQUcsS0FBSSxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLEtBQUssRUFBRSxNQUFNLENBQUMsQ0FBQzthQUNuRTtZQUVELElBQUksS0FBSSxDQUFDLHFCQUFxQixFQUFFO2dCQUM5QixrRUFBa0U7Z0JBQ2xFLElBQUksWUFBWSxFQUFFO29CQUNoQixJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQztpQkFDMUI7YUFDRjtpQkFBTTtnQkFDTCxJQUFJLENBQUMsV0FBVyxHQUFHLENBQUMsWUFBWSxDQUFDO2FBQ2xDOztnQkFFSyxZQUFZLEdBQUcsQ0FBQyxJQUFJLENBQUMsSUFBSSxLQUFLLFNBQVMsSUFBSSxDQUFDLENBQUMsS0FBSyxDQUFDLElBQUksS0FBSyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxLQUFLLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDOztnQkFDeEcsYUFBYSxHQUFHLE9BQU8sQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLFVBQVUsSUFBSSxFQUFFLENBQUM7WUFDNUQsSUFBSSxDQUFDLFFBQVEsR0FBRyxZQUFZLElBQUksQ0FBQyxZQUFZLElBQUksYUFBYSxDQUFDLENBQUM7WUFDaEUsT0FBTyxHQUFHLE9BQU8sSUFBSSxJQUFJLENBQUMsUUFBUSxDQUFDO1lBQ25DLE9BQU8sT0FBTyxDQUFDO1FBQ2pCLENBQUMsR0FBRSxLQUFLLENBQUMsQ0FBQztJQUNaLENBQUM7Ozs7O0lBRU0sbUNBQVE7Ozs7SUFBZixVQUFnQixPQUFZO1FBQTVCLGlCQU9DO1FBTkMsT0FBTyxDQUFDLE9BQU87Ozs7UUFBRSxVQUFDLElBQUk7WUFDcEIsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUM7WUFDeEIsSUFBSSxPQUFPLENBQUMsUUFBUSxFQUFFO2dCQUNwQixLQUFJLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsQ0FBQzthQUNqQztRQUNILENBQUMsRUFBQyxDQUFDO0lBQ0wsQ0FBQzs7Z0JBckZGLFNBQVMsU0FBQztvQkFDVCxRQUFRLEVBQUUsY0FBYztvQkFDeEIsUUFBUSxFQUFFLHNXQVFUOztpQkFHRjs7OztnQkFmUSxpQkFBaUI7Z0JBRjJCLGlCQUFpQjtnQkFBM0MsWUFBWTs7OzBCQW1CcEMsS0FBSzs7SUF3RVIsdUJBQUM7Q0FBQSxBQXZGRCxJQXVGQztTQXpFWSxnQkFBZ0I7OztJQUMzQixtQ0FBNkI7Ozs7O0lBRTdCLGlEQUFxQzs7SUFFekIsMENBQXdDOzs7OztJQUFFLDZDQUE0Qzs7Ozs7SUFBRSx3Q0FBa0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIElucHV0LCBPbkluaXQsIE91dHB1dCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgU3RhdGVEZWNsYXJhdGlvbiwgU3RhdGVTZXJ2aWNlLCBUcmFuc2l0aW9uLCBUcmFuc2l0aW9uU2VydmljZSB9IGZyb20gJ0B1aXJvdXRlci9jb3JlJztcbmltcG9ydCB7IGZvckVhY2gsIGlzTWF0Y2gsIHJlZHVjZSB9IGZyb20gJ2xvZGFzaC1lcyc7XG5pbXBvcnQgeyBOd2ZMZWZ0bmF2U2VydmljZSB9IGZyb20gJy4vbGVmdG5hdi5zZXJ2aWNlJztcblxuQENvbXBvbmVudCh7XG4gIHNlbGVjdG9yOiAnbndmLWxlZnQtbmF2JyxcbiAgdGVtcGxhdGU6IGBcbiAgPGR4LXNjcm9sbC12aWV3PlxuICA8bmF2IGNsYXNzPVwibGVmdG5hdlwiIHJvbGU9XCJuYXZpZ2F0aW9uXCI+XG4gIDx1bCBjbGFzcz1cIm53Zi1sZWZ0bmF2LWl0ZW1zIHAtMCBtLTBcIj5cbiAgICAgIDxsaSBjbGFzcz1cIm53Zi1sZWZ0bmF2LWl0ZW0gZC1ibG9ja1wiICpuZ0Zvcj1cImxldCBpdGVtIG9mIG5hdkRhdGFcIiBud2ZMZWZ0bmF2SXRlbSBpc1RvcExldmVsPVwidHJ1ZVwiIFtpdGVtXT1cIml0ZW1cIiBbYXR0ci5kYXRhLW5ldGFwcC1pZF09XCInbGVmdG5hdi1pdGVtLScgKyBpdGVtLmxhYmVsIHwgbG93ZXJjYXNlXCI+PC9saT5cbiAgPC91bD5cbiAgPC9uYXY+XG4gIDwvZHgtc2Nyb2xsLXZpZXc+XG4gIGAsXG4gIHN0eWxlVXJsczogWycuL2xlZnRuYXYuc2NzcyddLFxuXG59KVxuZXhwb3J0IGNsYXNzIExlZnRuYXZDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQge1xuICBASW5wdXQoKSBwdWJsaWMgbmF2RGF0YTogYW55O1xuXG4gIHByaXZhdGUga2VlcE90aGVyU2VjdGlvbnNPcGVuID0gdHJ1ZTtcblxuICBjb25zdHJ1Y3RvcihwdWJsaWMgbGVmdG5hdlNlcnZpY2U6IE53ZkxlZnRuYXZTZXJ2aWNlLCBwcml2YXRlIHRyYW5zaXRpb25TZXJ2aWNlOiBUcmFuc2l0aW9uU2VydmljZSwgcHJpdmF0ZSBzdGF0ZVNlcnZpY2U6IFN0YXRlU2VydmljZSkgeyB9XG5cbiAgcHVibGljIHJlcGFpbnRTdGF0ZUhpZ2hsaWdodCgpIHtcbiAgICBjb25zdCB7IGN1cnJlbnQsIHBhcmFtcyB9ID0gdGhpcy5zdGF0ZVNlcnZpY2U7XG4gICAgc2V0VGltZW91dCgoKSA9PiB7IHRoaXMubWFya0FjdGl2ZVN0YXRlKHRoaXMubmF2RGF0YSwgY3VycmVudCwgcGFyYW1zKTsgfSwgMCk7XG4gIH1cblxuICBwdWJsaWMgbmdPbkluaXQoKSB7XG4gICAgLy8gU2V0IG15IG5hdkRhdGEgb24gdGhlIGxlZnRuYXZTZXJ2aWNlIHNvIG90aGVycyAobGlrZSBmZWF0dXJlIHRvdXIgKSBjYW4gb3BlbiBhIHRyZWUgb2YgaXRlbXMgcHJvZ3JhbWF0aWNhbGx5LlxuICAgIHRoaXMubGVmdG5hdlNlcnZpY2UubmF2RGF0YSA9IHRoaXMubmF2RGF0YTtcbiAgICAvKiBPbiBFbnRlciBJIHJlY3Vyc2UgdG8gZmluZCBvdXQgd2hhdCB0byBoaWdobGlnaHQgKi9cbiAgICB0aGlzLnRyYW5zaXRpb25TZXJ2aWNlLm9uU3VjY2Vzcyh7fSwgKHRyYW5zOiBUcmFuc2l0aW9uKSA9PiB7XG4gICAgICB0aGlzLnJlcGFpbnRTdGF0ZUhpZ2hsaWdodCgpO1xuICAgIH0pO1xuICB9XG5cbiAgcHVibGljIG5nT25DaGFuZ2VzKGNoYW5nZXMpIHtcbiAgICBpZiAoY2hhbmdlcy5uYXZEYXRhICYmIGNoYW5nZXMubmF2RGF0YS5jdXJyZW50VmFsdWUpIHtcbiAgICAgICAgdGhpcy5sb2FkTGVmdE5hdihjaGFuZ2VzLm5hdkRhdGEuY3VycmVudFZhbHVlKTtcbiAgICB9XG4gIH1cblxuICBwdWJsaWMgbG9hZExlZnROYXYobmF2RGF0YTogYW55KTogdm9pZCB7XG4gICAgdGhpcy5jbG9zZUFsbChuYXZEYXRhKTtcbiAgICAvKiBJIGhhdmUgdG8gZmluZCBvdXQgb24gbG9hZCB3aGVyZSBJIGFtIGFzIHdlbGwgKi9cbiAgICB0aGlzLnJlcGFpbnRTdGF0ZUhpZ2hsaWdodCgpO1xuICB9XG5cbiAgLypcbiAgICogUmVjdXJzZSB0aHJvdWdoIHRoZSBuYXZEYXRhLCBtYXJraW5nIHRoZSBhY3RpdmUgc3RhdGUsIGFuZFxuICAgKiBhbGwgaXRzIHBhcmVudHMuIFJldHVybiB0cnVlIGlmIHdlIGZvdW5kIGEgbWF0Y2guXG4gICAqIEFuIGl0ZW0gaXMgYWN0aXZlIGlmIGl0J3MgbmFtZSBhbmQgcGFyYW1zIG1hdGNoZXNcbiAgICogQW4gaXRlbSBpcyBhbHNvIGFjdGl2ZSBpZiBhbnkgb2YgaXQncyBjaGlsZCBpcyBhY3RpdmUuXG4gICAqL1xuICBwdWJsaWMgbWFya0FjdGl2ZVN0YXRlKG5hdkRhdGEsIHN0YXRlOiBTdGF0ZURlY2xhcmF0aW9uLCBwYXJhbXMgPSBudWxsKTogYm9vbGVhbiB7XG4gICAgcmV0dXJuIHJlZHVjZShuYXZEYXRhLCAobWF0Y2hlZCwgaXRlbSkgPT4ge1xuICAgICAgbGV0IG1hdGNoZXNDaGlsZCA9IGZhbHNlO1xuXG4gICAgICBpZiAoaXRlbS5jaGlsZHJlbikge1xuICAgICAgICBtYXRjaGVzQ2hpbGQgPSB0aGlzLm1hcmtBY3RpdmVTdGF0ZShpdGVtLmNoaWxkcmVuLCBzdGF0ZSwgcGFyYW1zKTtcbiAgICAgIH1cblxuICAgICAgaWYgKHRoaXMua2VlcE90aGVyU2VjdGlvbnNPcGVuKSB7XG4gICAgICAgIC8qIElmIGl0J3MgYWxyZWFkeSBvcGVuIGxlYXZlIGlmOyBpZiBpdCBuZWVkcyB0byBiZSBvcGVuLCBkbyBpdCAqL1xuICAgICAgICBpZiAobWF0Y2hlc0NoaWxkKSB7XG4gICAgICAgICAgaXRlbS5pc0NvbGxhcHNlZCA9IGZhbHNlO1xuICAgICAgICB9XG4gICAgICB9IGVsc2Uge1xuICAgICAgICBpdGVtLmlzQ29sbGFwc2VkID0gIW1hdGNoZXNDaGlsZDtcbiAgICAgIH1cblxuICAgICAgY29uc3QgaGFzTmFtZU1hdGNoID0gKGl0ZW0uc3JlZiAhPT0gdW5kZWZpbmVkICYmICgoc3RhdGUubmFtZSA9PT0gaXRlbS5zcmVmKSB8fCAoc3RhdGUucGFyZW50ID09PSBpdGVtLnNyZWYpKSk7XG4gICAgICBjb25zdCBoYXNQYXJhbU1hdGNoID0gaXNNYXRjaChwYXJhbXMsIGl0ZW0uc3JlZlBhcmFtcyB8fCB7fSk7XG4gICAgICBpdGVtLmlzQWN0aXZlID0gbWF0Y2hlc0NoaWxkIHx8IChoYXNOYW1lTWF0Y2ggJiYgaGFzUGFyYW1NYXRjaCk7XG4gICAgICBtYXRjaGVkID0gbWF0Y2hlZCB8fCBpdGVtLmlzQWN0aXZlO1xuICAgICAgcmV0dXJuIG1hdGNoZWQ7XG4gICAgfSwgZmFsc2UpO1xuICB9XG5cbiAgcHVibGljIGNsb3NlQWxsKG5hdkRhdGE6IGFueSkge1xuICAgIGZvckVhY2gobmF2RGF0YSwgKGl0ZW0pID0+IHtcbiAgICAgIGl0ZW0uaXNDb2xsYXBzZWQgPSB0cnVlO1xuICAgICAgaWYgKG5hdkRhdGEuY2hpbGRyZW4pIHtcbiAgICAgICAgdGhpcy5jbG9zZUFsbChuYXZEYXRhLmNoaWxkcmVuKTtcbiAgICAgIH1cbiAgICB9KTtcbiAgfVxuXG59XG4iXX0=