/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { NwfLeftnavService } from '../leftnav/leftnav.service';
var MainbodyComponent = /** @class */ (function () {
    function MainbodyComponent(leftnavService) {
        this.leftnavService = leftnavService;
        this.top = '53px';
        this.asideWidth = '300px';
        this.leftnavWidth = '200px';
        this.isLeftnavVisible = true;
        this.isAsideVisible = false;
        this.leftnavConfig = null;
        this.zeroPx = '0px';
    }
    Object.defineProperty(MainbodyComponent.prototype, "mainPaddingTop", {
        get: /**
         * @private
         * @return {?}
         */
        function () {
            return parseInt(this.top) + 15 + 'px';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MainbodyComponent.prototype, "mainMarginLeft", {
        get: /**
         * @private
         * @return {?}
         */
        function () {
            /** @type {?} */
            var marginLeft = this.zeroPx;
            if (this.isLeftnavVisible) {
                marginLeft = this.leftnavWidth;
            }
            return marginLeft;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MainbodyComponent.prototype, "mainMarginRight", {
        get: /**
         * @private
         * @return {?}
         */
        function () {
            /** @type {?} */
            var marginRight = this.zeroPx;
            if (this.isAsideVisible) {
                marginRight = this.asideWidth;
            }
            return marginRight;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @return {?}
     */
    MainbodyComponent.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        if (this.subscription) {
            this.subscription.unsubscribe();
        }
    };
    /**
     * @return {?}
     */
    MainbodyComponent.prototype.ngOnChanges = /**
     * @return {?}
     */
    function () {
        this.setStyles();
    };
    /**
     * @return {?}
     */
    MainbodyComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        this.setStyles();
        this.subscription = this.leftnavService.leftNav$.subscribe((/**
         * @param {?} hideLeftNav
         * @return {?}
         */
        function (hideLeftNav) {
            /** @type {?} */
            var isLeftnavVisible = true;
            if (hideLeftNav) {
                isLeftnavVisible = false;
            }
            _this.isLeftnavVisible = isLeftnavVisible;
            _this.setStyles();
        }));
    };
    /**
     * @private
     * @return {?}
     */
    MainbodyComponent.prototype.setStyles = /**
     * @private
     * @return {?}
     */
    function () {
        this.mainStyles = { marginLeft: this.mainMarginLeft, marginRight: this.mainMarginRight, paddingTop: this.mainPaddingTop };
        this.sidebarStyles = { paddingTop: this.top, width: this.leftnavWidth };
        this.asideStyles = { paddingTop: this.top, width: this.asideWidth };
    };
    MainbodyComponent.decorators = [
        { type: Component, args: [{
                    template: "\n    <div class=\"l-nwf-mainbody\" [ngClass]=\"{ 'leftnav-is-open': isLeftnavVisible }\">\n      <nwf-page-alert></nwf-page-alert>\n      <nav class=\"nwf-sidebar\" [hidden]=\"!isLeftnavVisible\" [ngStyle]=\"sidebarStyles\">\n        <ng-content *ngIf=\"!leftnavConfig\" select=\"nwf-left-nav\"></ng-content>\n        <nwf-left-nav *ngIf=\"leftnavConfig\" [navData]=\"leftnavConfig\"></nwf-left-nav>\n      </nav>\n      <main class=\"px-4\" [ngStyle]=\"mainStyles\" ui-view></main>\n      <aside class=\"\" [hidden]=\"!isAsideVisible\" [ngStyle]=\"asideStyles\"><ng-content select=\".aside\"></ng-content></aside>\n    </div>\n  ",
                    selector: 'nwf-mainbody',
                    host: {
                        class: 'w-100',
                    },
                    styles: [".nwf-sidebar{position:fixed;top:0;bottom:0;left:0;z-index:100;background-color:#0a2d6c;box-shadow:3px 0 0 0 rgba(0,0,0,.1)}aside{position:fixed;top:0;bottom:0;right:0;background-color:#0a2d6c}[hidden]{display:none!important}"]
                }] }
    ];
    /** @nocollapse */
    MainbodyComponent.ctorParameters = function () { return [
        { type: NwfLeftnavService }
    ]; };
    MainbodyComponent.propDecorators = {
        top: [{ type: Input }],
        asideWidth: [{ type: Input }],
        leftnavWidth: [{ type: Input }],
        isLeftnavVisible: [{ type: Input }],
        isAsideVisible: [{ type: Input }],
        leftnavConfig: [{ type: Input }]
    };
    return MainbodyComponent;
}());
export { MainbodyComponent };
if (false) {
    /** @type {?} */
    MainbodyComponent.prototype.top;
    /** @type {?} */
    MainbodyComponent.prototype.asideWidth;
    /** @type {?} */
    MainbodyComponent.prototype.leftnavWidth;
    /** @type {?} */
    MainbodyComponent.prototype.isLeftnavVisible;
    /** @type {?} */
    MainbodyComponent.prototype.isAsideVisible;
    /** @type {?} */
    MainbodyComponent.prototype.leftnavConfig;
    /** @type {?} */
    MainbodyComponent.prototype.mainStyles;
    /** @type {?} */
    MainbodyComponent.prototype.asideStyles;
    /** @type {?} */
    MainbodyComponent.prototype.sidebarStyles;
    /** @type {?} */
    MainbodyComponent.prototype.subscription;
    /**
     * @type {?}
     * @private
     */
    MainbodyComponent.prototype.zeroPx;
    /** @type {?} */
    MainbodyComponent.prototype.leftnavService;
}
//# sourceMappingURL=data:application/json;base64,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