/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
import { DOCUMENT } from '@angular/common';
import { Inject, Injectable, Optional } from '@angular/core';
import { Title } from '@angular/platform-browser';
import { I18NextPipe } from 'angular-i18next';
import { APP_TITLE_ROOT } from '../../../tokens';
import * as i0 from "@angular/core";
import * as i1 from "angular-i18next";
import * as i2 from "@angular/common";
import * as i3 from "../../../tokens";
var NwfTitleService = /** @class */ (function (_super) {
    tslib_1.__extends(NwfTitleService, _super);
    function NwfTitleService(i18nextPipe, doc, appTitleRoot) {
        var _this = _super.call(this, doc) || this;
        _this.i18nextPipe = i18nextPipe;
        _this.appTitleRoot = appTitleRoot;
        _this.firstTitleSegment = _this.appTitleRoot || '';
        _this.sep = ' | ';
        return _this;
    }
    /**
     * @param {?} title
     * @return {?}
     */
    NwfTitleService.prototype.setTitle = /**
     * @param {?} title
     * @return {?}
     */
    function (title) {
        var _this = this;
        /** @type {?} */
        var titlesPipeSep = '';
        /** @type {?} */
        var titles = [];
        /* If I have a firstTitle, I push it on first */
        if (this.firstTitleSegment != '') {
            titles.push(this.firstTitleSegment);
        }
        /* If I am an array, I concatenate that array, otherwise I am a string and I just push it on */
        if (title instanceof Array) {
            titles = tslib_1.__spread(titles, title);
        }
        else {
            titles.push(title);
        }
        /* finally produce my pipe sep string, passing each over the i18next pipe so they can pass me i18n:keys */
        titlesPipeSep = titles.filter((/**
         * @param {?} item
         * @return {?}
         */
        function (item) { return item !== ''; })).map((/**
         * @param {?} item
         * @return {?}
         */
        function (item) {
            return _this.i18nextPipe.transform(item);
        })).join(this.sep);
        /* Call the regular super for setTitle, now we just have a normal string */
        return _super.prototype.setTitle.call(this, titlesPipeSep);
    };
    NwfTitleService.decorators = [
        { type: Injectable, args: [{
                    providedIn: 'root',
                },] }
    ];
    /** @nocollapse */
    NwfTitleService.ctorParameters = function () { return [
        { type: I18NextPipe },
        { type: undefined, decorators: [{ type: Inject, args: [DOCUMENT,] }] },
        { type: undefined, decorators: [{ type: Optional }, { type: Inject, args: [APP_TITLE_ROOT,] }] }
    ]; };
    /** @nocollapse */ NwfTitleService.ngInjectableDef = i0.ɵɵdefineInjectable({ factory: function NwfTitleService_Factory() { return new NwfTitleService(i0.ɵɵinject(i1.I18NextPipe), i0.ɵɵinject(i2.DOCUMENT), i0.ɵɵinject(i3.APP_TITLE_ROOT, 8)); }, token: NwfTitleService, providedIn: "root" });
    return NwfTitleService;
}(Title));
export { NwfTitleService };
if (false) {
    /** @type {?} */
    NwfTitleService.prototype.firstTitleSegment;
    /**
     * @type {?}
     * @private
     */
    NwfTitleService.prototype.sep;
    /**
     * @type {?}
     * @private
     */
    NwfTitleService.prototype.i18nextPipe;
    /**
     * @type {?}
     * @private
     */
    NwfTitleService.prototype.appTitleRoot;
}
//# sourceMappingURL=data:application/json;base64,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