import { EventEmitter, Component, Input, Output, Injectable, Directive, ElementRef, Renderer2, HostListener, ɵɵdefineInjectable, NgModule, Pipe, ViewChild, forwardRef, Inject, InjectionToken, Optional, ɵɵinject } from '@angular/core';
import { CommonModule, DOCUMENT } from '@angular/common';
import { FormsModule, NG_VALUE_ACCESSOR, FormArray, FormControl, FormBuilder, ReactiveFormsModule } from '@angular/forms';
import { NgbActiveModal, NgbAlertModule, NgbModalModule, NgbPopoverModule, NgbProgressbarModule, NgbDropdownModule, NgbDropdown, NgbDatepickerModule, NgbTimepickerModule, NgbModule, NgbModal, NgbCollapse, NgbCollapseModule } from '@ng-bootstrap/ng-bootstrap';
import { TransitionService, UIRouterModule, StateService as StateService$1 } from '@uirouter/angular';
import { Chart, ChartModule } from 'angular-highcharts';
import { I18NextPipe, I18NextFormatPipe, I18NextModule } from 'angular-i18next';
import { DxLoadIndicatorModule, DxDataGridModule, DxScrollViewModule, DxTemplateModule, DxPopoverModule } from 'devextreme-angular';
import { Subject, BehaviorSubject, merge, interval, zip, of } from 'rxjs';
import { debounceTime, share, takeUntil, delay, first, map, concatMap, filter as filter$1 } from 'rxjs/operators';
import { __values, __read, __spread, __extends, __assign } from 'tslib';
import { StateService, TransitionService as TransitionService$1 } from '@uirouter/core';
import { isUndefined, template, filter, sortBy, find, isEqual, merge as merge$1, reduce, isMatch, forEach, repeat, assign, get } from 'lodash-es';
import { DomSanitizer, BrowserModule, Title } from '@angular/platform-browser';
import { icons } from '@netapp/nwfjs_theme/icons/icons';
import { isPromise } from 'rxjs/internal/util/isPromise';
import DataGrid from 'devextreme/ui/data_grid';
import TreeList from 'devextreme/ui/tree_list';
import { DxiDataGridColumn } from 'devextreme-angular/ui/nested/base/data-grid-column-dxi';

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var AlertComponent = /** @class */ (function () {
    function AlertComponent() {
        this.type = 'warning'; // this matches bootstrap's default which is warning.
        // this matches bootstrap's default which is warning.
        /* I just proxy these straight from ng-bootstrap/alert */
        this.dismissable = false;
        this.level = '';
        this.close = new EventEmitter();
    }
    /**
     * @return {?}
     */
    AlertComponent.prototype.onClose = /**
     * @return {?}
     */
    function () {
        this.close.emit();
    };
    /**
     * @param {?} changes
     * @return {?}
     */
    AlertComponent.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) {
        if (changes.type && changes.type.currentValue === 'error') {
            this.type = 'critical';
        }
    };
    AlertComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-alert',
                    template: "\n    <ngb-alert [dismissible]=\"dismissable\" [type]=\"type\" (close)=\"onClose()\" [ngClass]=\"{ 'is-page-level': level == 'page' }\">\n      <div class=\"d-flex\">\n        <div *ngIf=\"type\">\n          <nwf-icon [severity]=\"type\"></nwf-icon>\n        </div>\n        <div class=\"flex-grow-1 ml-2\">\n          <ng-content></ng-content>\n        </div>\n      </div>\n    </ngb-alert>\n  ",
                    styles: [":host .alert{border:none;color:#252525;border-radius:0;font-size:14px;line-height:1.5;padding:10px 12px}:host .alert.is-page-level{box-shadow:none;border-left:none;border-right:none}:host .alert ::ng-deep h2,:host .alert ::ng-deep h3,:host .alert ::ng-deep h4,:host .alert ::ng-deep h5{font-size:16px;font-weight:600;margin:0}:host .alert ::ng-deep a{color:#252525;text-decoration:underline}:host .alert ::ng-deep .close{font-size:32px;line-height:.5;margin:0;min-height:32px;overflow:hidden;padding:4px 8px;top:4px;right:4px}:host .alert.alert-success ::ng-deep #base-layer{fill:#498128}:host .alert.alert-success ::ng-deep #glyph{fill:#b4e697!important}:host .alert.alert-success ::ng-deep .close:hover{color:#b4e697;background:#498128}:host .alert.alert-info ::ng-deep #base-layer{fill:#2d6dde}:host .alert.alert-info ::ng-deep #glyph{fill:#eff4ff!important}:host .alert.alert-info ::ng-deep .close:hover{color:#eff4ff;background:#252525}:host .alert.alert-error ::ng-deep #base-layer{fill:#da1e21}:host .alert.alert-error ::ng-deep #glyph{fill:#fccdce!important}:host .alert.alert-error ::ng-deep .close:hover{color:#fccdce;background:#da1e21}:host .alert.alert-warning ::ng-deep #base-layer{fill:#f88402}:host .alert.alert-warning ::ng-deep #glyph{fill:#ffe1a1!important}:host .alert.alert-warning ::ng-deep .close:hover{color:#ffe1a1;background:#f88402}:host .alert.alert-critical ::ng-deep #base-layer{fill:#da1e21}:host .alert.alert-critical ::ng-deep #glyph{fill:#fccdce!important}:host .alert.alert-critical ::ng-deep .close:hover{color:#fccdce;background:#da1e21}"]
                }] }
    ];
    /** @nocollapse */
    AlertComponent.ctorParameters = function () { return []; };
    AlertComponent.propDecorators = {
        type: [{ type: Input }],
        dismissable: [{ type: Input }],
        level: [{ type: Input }],
        close: [{ type: Output }]
    };
    return AlertComponent;
}());
if (false) {
    /** @type {?} */
    AlertComponent.prototype.type;
    /** @type {?} */
    AlertComponent.prototype.dismissable;
    /** @type {?} */
    AlertComponent.prototype.level;
    /** @type {?} */
    AlertComponent.prototype.close;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfDismissButton = /** @class */ (function () {
    function NwfDismissButton() {
        this.onClose = new EventEmitter();
    }
    NwfDismissButton.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-dismiss-button',
                    template: "\n    <button type=\"button\" class=\"close\" aria-label=\"Close\" (click)=\"onClose.emit()\">\n        <nwf-icon iconClass=\"icon-action-close\"></nwf-icon>\n    </button>\n    ",
                    styles: [":host ::ng-deep .close{color:#454545;display:flex}:host ::ng-deep .close:hover{color:#000}:host ::ng-deep svg{width:18px;height:18px}"]
                }] }
    ];
    NwfDismissButton.propDecorators = {
        onClose: [{ type: Output }]
    };
    return NwfDismissButton;
}());
if (false) {
    /** @type {?} */
    NwfDismissButton.prototype.onClose;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * This service is for observing column changes of the dxdatagrid through the onColumnsChanging event.
 *
 * Example:
 * onInitialized: (e) => {
 *     e.component.option("onColumnsChanging", (e) => {
 *         this.columnsChangingService.onColumnsChanging(e);
 *     });
 * }
 */
var NwfColumnsChangingService = /** @class */ (function () {
    function NwfColumnsChangingService() {
        this.columnsChanging = new Subject();
        this.columnsChanging$ = this.columnsChanging.asObservable().pipe(debounceTime(10), share());
    }
    /**
     * @param {?} event
     * @return {?}
     */
    NwfColumnsChangingService.prototype.onColumnsChanging = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        this.columnsChanging.next(event);
    };
    NwfColumnsChangingService.decorators = [
        { type: Injectable }
    ];
    return NwfColumnsChangingService;
}());
if (false) {
    /** @type {?} */
    NwfColumnsChangingService.prototype.columnsChanging;
    /** @type {?} */
    NwfColumnsChangingService.prototype.columnsChanging$;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfElipsizerResizeService = /** @class */ (function () {
    function NwfElipsizerResizeService(columnsChangingService) {
        this.columnsChangingService = columnsChangingService;
        this.resizeEvent = new Subject();
        this.resizeEvent$ = this.resizeEvent.asObservable().pipe(share());
        this.columnsChangingService.columnsChanging$.subscribe(this.resizeEvent);
    }
    /**
     * @return {?}
     */
    NwfElipsizerResizeService.prototype.resize = /**
     * @return {?}
     */
    function () {
        this.resizeEvent.next();
    };
    NwfElipsizerResizeService.decorators = [
        { type: Injectable }
    ];
    /** @nocollapse */
    NwfElipsizerResizeService.ctorParameters = function () { return [
        { type: NwfColumnsChangingService }
    ]; };
    return NwfElipsizerResizeService;
}());
if (false) {
    /** @type {?} */
    NwfElipsizerResizeService.prototype.resizeEvent;
    /** @type {?} */
    NwfElipsizerResizeService.prototype.resizeEvent$;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizerResizeService.prototype.columnsChangingService;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfElipsizer = /** @class */ (function () {
    function NwfElipsizer(el, renderer, elipsizerResizeService) {
        this.el = el;
        this.renderer = renderer;
        this.elipsizerResizeService = elipsizerResizeService;
        this.originalText = '';
        this.destroy = new Subject();
    }
    /**
     * @param {?} event
     * @return {?}
     */
    NwfElipsizer.prototype.windowResize = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        this.elipsize(false);
    };
    /**
     * @return {?}
     */
    NwfElipsizer.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        // subscribe to service to get resize calls
        this.elipsizerResizeService.resizeEvent$.pipe(takeUntil(this.destroy)).subscribe((/**
         * @return {?}
         */
        function () {
            _this.elipsize(false);
        }));
    };
    /**
     * @return {?}
     */
    NwfElipsizer.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        // Complete subject
        this.destroy.next();
        this.destroy.complete();
        // Remove element created off screen
        this.renderer.removeChild(document.body, this.tempElement);
    };
    /**
     * @param {?} changes
     * @return {?}
     */
    NwfElipsizer.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) {
        // Create temporary node on intialization
        if (!this.parentNode) {
            this.parentNode = this.renderer.parentNode(this.el.nativeElement);
            // Create element off screen
            this.textElement = this.renderer.createText(this.originalText);
            this.tempElement = this.renderer.createElement(this.el.nativeElement.tagName.toLowerCase());
            this.renderer.appendChild(this.tempElement, this.textElement);
            // Clone styles from native element
            /** @type {?} */
            var elementStyle = window.getComputedStyle(this.el.nativeElement);
            this.tempElement.style = elementStyle.cssText;
            this.renderer.setStyle(this.tempElement, 'width', 'auto');
            this.renderer.setStyle(this.tempElement, 'white-space', 'nowrap');
            this.renderer.setStyle(this.tempElement, 'overflow', 'visible');
            this.renderer.setStyle(this.tempElement, 'position', 'absolute');
            this.renderer.setStyle(this.tempElement, 'left', '-10000px');
            this.renderer.appendChild(document.body, this.tempElement);
        }
        this.elipsize(true);
    };
    // Elipsize text by creating a dom element off screen, measuring it and removing text character by character.
    // ignoreSizeCheck - ignores the optimization that checkes for element size change and doesnt update the elipsized text if the size hasn't changed.
    // Elipsize text by creating a dom element off screen, measuring it and removing text character by character.
    // ignoreSizeCheck - ignores the optimization that checkes for element size change and doesnt update the elipsized text if the size hasn't changed.
    /**
     * @param {?} ignoreSizeCheck
     * @return {?}
     */
    NwfElipsizer.prototype.elipsize = 
    // Elipsize text by creating a dom element off screen, measuring it and removing text character by character.
    // ignoreSizeCheck - ignores the optimization that checkes for element size change and doesnt update the elipsized text if the size hasn't changed.
    /**
     * @param {?} ignoreSizeCheck
     * @return {?}
     */
    function (ignoreSizeCheck) {
        /** @type {?} */
        var computedStyle = window.getComputedStyle(this.parentNode);
        /** @type {?} */
        var myLeftPad = parseInt(computedStyle.getPropertyValue('padding-left'));
        /** @type {?} */
        var myRightPad = parseInt(computedStyle.getPropertyValue('padding-right'));
        /** @type {?} */
        var theBiggestICanBe = this.parentNode.offsetWidth - myLeftPad - myRightPad;
        if (this.originalText !== undefined && theBiggestICanBe !== 0 && (ignoreSizeCheck || this.currentSizeOfElement !== theBiggestICanBe)) {
            this.currentSizeOfElement = theBiggestICanBe;
            // Loop of length of text removing one character at a time until its the proper size
            /** @type {?} */
            var finalName = this.originalText;
            this.textElement.textContent = finalName;
            // Total length of string
            /** @type {?} */
            var index = this.textElement.textContent.length;
            /** @type {?} */
            var start = 0;
            /** @type {?} */
            var end = index;
            if (this.tempElement.offsetWidth > theBiggestICanBe) {
                while (end !== start) {
                    /** @type {?} */
                    var size = Math.floor((start + end) / 2.0);
                    finalName = this.ellipsisString(this.originalText, size);
                    this.textElement.textContent = finalName;
                    /** @type {?} */
                    var width = this.tempElement.offsetWidth;
                    // Text is too big for container
                    if (width > theBiggestICanBe) {
                        end = size;
                    }
                    else {
                        // If text is smaller than container check that the ellipsis text plus one additional character is bigger than container
                        // if it is then we are at the correct size
                        this.textElement.textContent = this.ellipsisString(this.originalText, size + 1);
                        if (this.tempElement.offsetWidth > theBiggestICanBe) {
                            break;
                            // Text is too small for container
                        }
                        else {
                            start = size;
                        }
                    }
                }
            }
            // Set final elipsized text
            this.el.nativeElement.innerText = finalName;
        }
    };
    /**
     * @param {?} text
     * @param {?} size
     * @return {?}
     */
    NwfElipsizer.prototype.ellipsisString = /**
     * @param {?} text
     * @param {?} size
     * @return {?}
     */
    function (text, size) {
        if (text.length !== size) {
            text = text.slice(0, Math.ceil(size / 2.0)) + String.fromCharCode(8230) + text.slice(text.length - Math.floor(size / 2.0));
        }
        return text;
    };
    NwfElipsizer.decorators = [
        { type: Directive, args: [{
                    selector: '[nwfElipsizer]',
                    host: {
                        '[style.white-space]': '"nowrap"',
                        '[style.display]': '"inline-block"',
                    },
                },] }
    ];
    /** @nocollapse */
    NwfElipsizer.ctorParameters = function () { return [
        { type: ElementRef },
        { type: Renderer2 },
        { type: NwfElipsizerResizeService }
    ]; };
    NwfElipsizer.propDecorators = {
        originalText: [{ type: Input, args: ['nwfElipsizer',] }],
        windowResize: [{ type: HostListener, args: ['window:resize', ['$event'],] }]
    };
    return NwfElipsizer;
}());
if (false) {
    /** @type {?} */
    NwfElipsizer.prototype.originalText;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.currentSizeOfElement;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.destroy;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.parentNode;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.textElement;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.tempElement;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.el;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.renderer;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.elipsizerResizeService;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfHelpConfig = /** @class */ (function () {
    function NwfHelpConfig() {
        this.helpBasePath = '/OnCommand/help/netapp';
        this.helpContext = '';
    }
    NwfHelpConfig.decorators = [
        { type: Injectable, args: [{ providedIn: 'root' },] }
    ];
    /** @nocollapse */
    NwfHelpConfig.ctorParameters = function () { return []; };
    /** @nocollapse */ NwfHelpConfig.ngInjectableDef = ɵɵdefineInjectable({ factory: function NwfHelpConfig_Factory() { return new NwfHelpConfig(); }, token: NwfHelpConfig, providedIn: "root" });
    return NwfHelpConfig;
}());
if (false) {
    /** @type {?} */
    NwfHelpConfig.prototype.helpBasePath;
    /** @type {?} */
    NwfHelpConfig.prototype.helpContext;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var HelpService = /** @class */ (function () {
    function HelpService(config) {
        this.config = config;
        /** @type {?} */
        var basePath = this.config.helpBasePath;
        /** @type {?} */
        var context = this.config.helpContext;
        //  Beginning of Webworks help API
        /** @type {?} */
        var WWHAPI_Object = (/**
         * @param {?} ParamHelpURL
         * @param {?} ParamTargetWindow
         * @return {?}
         */
        function (ParamHelpURL, ParamTargetWindow) {
            // Location of the WebWorks Help system to be launched.
            // Location should be an absolute URL.
            //
            this.mAPIURL = ParamHelpURL + '/wwhelp/wwhimpl/api.htm';
            this.mWindow = null;
            this.mTargetWindow = ParamTargetWindow;
            this.fLaunchHelp = WWHAPI_LaunchHelp;
            this.fCloseHelp = WWHAPI_CloseHelp;
            this.fDisplayHelp = WWHAPI_DisplayHelp;
            this.fDisplayHelpWithNavigation = WWHAPI_DisplayHelpWithNavigation;
            this.fDisplayHelpWithContents = WWHAPI_DisplayHelpWithContents;
            this.fDisplayHelpWithIndex = WWHAPI_DisplayHelpWithIndex;
            this.fDisplayHelpWithSearch = WWHAPI_DisplayHelpWithSearch;
            this.fDisplayHelpWithFavorites = WWHAPI_DisplayHelpWithFavorites;
            this.fDisplayHelpNavigation = WWHAPI_DisplayHelpNavigation;
            this.fDisplayHelpContents = WWHAPI_DisplayHelpContents;
            this.fDisplayHelpIndex = WWHAPI_DisplayHelpIndex;
            this.fDisplayHelpSearch = WWHAPI_DisplayHelpSearch;
            this.fDisplayHelpFavorites = WWHAPI_DisplayHelpFavorites;
        });
        /**
         * @param {?} bParamSingle
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @param {?} ParamTab
         * @return {?}
         */
        function WWHAPI_LaunchHelp(bParamSingle, ParamContext, ParamTopic, ParamTab) {
            /** @type {?} */
            var VarParameters;
            /** @type {?} */
            var VarURL;
            /** @type {?} */
            var VarIndex;
            /** @type {?} */
            var VarMaxIndex;
            // Define parameters
            //
            VarParameters = new Array();
            if (bParamSingle) {
                VarParameters[VarParameters.length] = 'single=true';
            }
            if (ParamContext != null) {
                VarParameters[VarParameters.length] = 'context=' + ParamContext;
                // Use the global configuration for the help context if one exists
            }
            else if (context != null) {
                VarParameters[VarParameters.length] = 'context=' + context;
            }
            if (ParamTopic != null) {
                VarParameters[VarParameters.length] = 'topic=' + ParamTopic;
            }
            if (ParamTab) {
                VarParameters[VarParameters.length] = 'tab=' + ParamTab;
            }
            // Create URL
            //
            VarURL = this.mAPIURL;
            for (VarIndex = 0, VarMaxIndex = VarParameters.length; VarIndex < VarMaxIndex; VarIndex++) {
                if (VarIndex == 0) {
                    VarURL += '?' + VarParameters[VarIndex];
                }
                else {
                    VarURL += '&' + VarParameters[VarIndex];
                }
            }
            // Check to see if the window exists.  If it does, make the native call directly.
            // Otherwise, initialize the help system at the topic using URL params.
            //
            if ((this.mWindow != null) &&
                (typeof (this.mWindow) != 'undefined') &&
                (!this.mWindow.closed) &&
                (this.mWindow.WWHHelp != null) &&
                (typeof (this.mWindow.WWHHelp) != 'undefined')) {
                this.mWindow.focus();
                this.mWindow.WWHHelp.fSetContextDocument(VarURL);
            }
            else {
                /* Customized this for our needs ! */
                /** @type {?} */
                var netappDesiredWidthAndHeight = 'height=768, width=1024';
                if ((typeof (this.mTargetWindow) != 'undefined') &&
                    (this.mTargetWindow != null)) {
                    this.mWindow = window.open(VarURL, this.mTargetWindow, netappDesiredWidthAndHeight);
                }
                else {
                    this.mWindow = window.open(VarURL, null, netappDesiredWidthAndHeight);
                }
                // Ensure window is brought to the foreground
                //
                this.mWindow.focus();
            }
        }
        /**
         * @return {?}
         */
        function WWHAPI_CloseHelp() {
            if ((this.mWindow != null) &&
                (typeof (this.mWindow) != 'undefined') &&
                (!this.mWindow.closed) &&
                (this.mWindow.WWHHelp != null) &&
                (typeof (this.mWindow.WWHHelp) != 'undefined')) {
                this.mWindow.close();
            }
        }
        /**
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @return {?}
         */
        function WWHAPI_DisplayHelp(ParamContext, ParamTopic) {
            this.fLaunchHelp(true, ParamContext, ParamTopic, null);
        }
        /**
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @return {?}
         */
        function WWHAPI_DisplayHelpWithNavigation(ParamContext, ParamTopic) {
            this.fLaunchHelp(false, ParamContext, ParamTopic, null);
        }
        /**
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @return {?}
         */
        function WWHAPI_DisplayHelpWithContents(ParamContext, ParamTopic) {
            this.fLaunchHelp(false, ParamContext, ParamTopic, 'contents');
        }
        /**
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @return {?}
         */
        function WWHAPI_DisplayHelpWithIndex(ParamContext, ParamTopic) {
            this.fLaunchHelp(false, ParamContext, ParamTopic, 'index');
        }
        /**
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @return {?}
         */
        function WWHAPI_DisplayHelpWithSearch(ParamContext, ParamTopic) {
            this.fLaunchHelp(false, ParamContext, ParamTopic, 'search');
        }
        /**
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @return {?}
         */
        function WWHAPI_DisplayHelpWithFavorites(ParamContext, ParamTopic) {
            this.fLaunchHelp(false, ParamContext, ParamTopic, 'favorites');
        }
        /**
         * @return {?}
         */
        function WWHAPI_DisplayHelpNavigation() {
            this.fLaunchHelp(false, null, null, null);
        }
        /**
         * @return {?}
         */
        function WWHAPI_DisplayHelpContents() {
            this.fLaunchHelp(false, null, null, 'contents');
        }
        /**
         * @return {?}
         */
        function WWHAPI_DisplayHelpIndex() {
            this.fLaunchHelp(false, null, null, 'index');
        }
        /**
         * @return {?}
         */
        function WWHAPI_DisplayHelpSearch() {
            this.fLaunchHelp(false, null, null, 'search');
        }
        /**
         * @return {?}
         */
        function WWHAPI_DisplayHelpFavorites() {
            this.fLaunchHelp(false, null, null, 'favorites');
        }
        // End of Webworks help API
        /* Now create me , we should not have two things, but one to configure. Fix later. */
        this.helpDirectiveWindow = new WWHAPI_Object(basePath + context, 'help_window');
    }
    HelpService.decorators = [
        { type: Injectable }
    ];
    /** @nocollapse */
    HelpService.ctorParameters = function () { return [
        { type: NwfHelpConfig }
    ]; };
    return HelpService;
}());
if (false) {
    /** @type {?} */
    HelpService.prototype.helpDirectiveWindow;
    /**
     * @type {?}
     * @private
     */
    HelpService.prototype.config;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var HelpDirective = /** @class */ (function () {
    function HelpDirective(element, helpService) {
        this.element = element;
        this.helpService = helpService;
    }
    /**
     * @return {?}
     */
    HelpDirective.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        /** @type {?} */
        var showIcon = this.showIcon == 'false' ? false : true;
        if (showIcon) {
            /** @type {?} */
            var icon = "\n\n<svg width=\"18px\" height=\"18px\" viewBox=\"0 0 18 18\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n    <g id=\"icon-info-help\" stroke=\"none\" stroke-width=\"1\" fill=\"none\" fill-rule=\"evenodd\">\n        <path d=\"M9,1 C4.6,1 1,4.6 1,9 C1,13.4 4.6,17 9,17 C13.4,17 17,13.4 17,9 C17,4.6 13.4,1 9,1 Z\" id=\"base-layer\" fill=\"#0067C5\"></path>\n        <path d=\"M9,2.75 C5.5625,2.75 2.75,5.5625 2.75,9 C2.75,12.4375 5.5625,15.25 9,15.25 C12.4375,15.25 15.25,12.4375 15.25,9 C15.25,5.5625 12.4375,2.75 9,2.75 Z\" id=\"background\" fill=\"#FFFFFF\"></path>\n        <path d=\"M8.204,12.375 L9.946,12.375 L9.946,14 L8.204,14 L8.204,12.375 Z M6.137,7.669 C6.137,7.19233095 6.20849928,6.75900195 6.3515,6.369 C6.49450071,5.97899805 6.70249864,5.64533472 6.9755,5.368 C7.24850137,5.09066528 7.57783141,4.87616743 7.9635,4.7245 C8.3491686,4.57283258 8.78033095,4.497 9.257,4.497 C9.65566866,4.497 10.026165,4.55549941 10.3685,4.6725 C10.710835,4.78950058 11.0098321,4.95849889 11.2655,5.1795 C11.5211679,5.4005011 11.7226659,5.67566502 11.87,6.005 C12.0173341,6.33433498 12.091,6.70699792 12.091,7.123 C12.091,7.42633485 12.0585003,7.6884989 11.9935,7.9095 C11.9284997,8.13050111 11.8418339,8.32116587 11.7335,8.4815 C11.6251661,8.64183414 11.5016674,8.7848327 11.363,8.9105 C11.2243326,9.0361673 11.0856674,9.15966606 10.947,9.281 C10.7823325,9.41966736 10.6306674,9.55399935 10.492,9.684 C10.3533326,9.81400065 10.2320005,9.95916586 10.128,10.1195 C10.0239995,10.2798341 9.94383361,10.4683323 9.8875,10.685 C9.83116638,10.9016678 9.803,11.1659984 9.803,11.478 L8.399,11.478 C8.399,11.0966648 8.41849981,10.7738347 8.4575,10.5095 C8.4965002,10.2451653 8.5593329,10.0133343 8.646,9.814 C8.7326671,9.61466567 8.8388327,9.43916742 8.9645,9.2875 C9.0901673,9.13583257 9.2396658,8.98633407 9.413,8.839 C9.55166736,8.71766606 9.6838327,8.60500052 9.8095,8.501 C9.9351673,8.39699948 10.0478328,8.28216729 10.1475,8.1565 C10.2471672,8.0308327 10.3251664,7.89000078 10.3815,7.734 C10.4378336,7.57799922 10.466,7.39166775 10.466,7.175 C10.466,6.9149987 10.4205005,6.69183427 10.3295,6.5055 C10.2384995,6.31916574 10.1280006,6.16966723 9.998,6.057 C9.86799935,5.94433277 9.72933407,5.86200026 9.582,5.81 C9.43466593,5.75799974 9.30466723,5.732 9.192,5.732 C8.65466398,5.732 8.25816794,5.90749824 8.0025,6.2585 C7.74683205,6.60950175 7.619,7.07966372 7.619,7.669 L6.137,7.669 Z\" id=\"glyph\" fill=\"#0067C5\"></path>\n    </g>\n</svg>\n  ";
            this.element.nativeElement.innerHTML += icon;
        }
    };
    /**
     * @param {?} element
     * @return {?}
     */
    HelpDirective.prototype.onClick = /**
     * @param {?} element
     * @return {?}
     */
    function (element) {
        // element.setAttribute('launchUrl', baseContextId);
        if (typeof (this.guid) != 'undefined' && typeof (this.context) != 'undefined') {
            // Launch context sesitive help topic.
            this.helpService.helpDirectiveWindow.fDisplayHelpWithContents(this.context, this.guid);
        }
        else if (typeof (this.guid) != 'undefined') {
            this.helpService.helpDirectiveWindow.fDisplayHelpWithNavigation(null, this.guid);
        }
        else {
            this.helpService.helpDirectiveWindow.fDisplayHelpContents();
        }
    };
    HelpDirective.decorators = [
        { type: Directive, args: [{
                    selector: '[nwf-help],nwf-help',
                    host: {
                        '(click)': 'onClick($event.target)',
                    },
                    inputs: ['guid', 'context', 'showIcon'],
                    providers: [HelpService],
                },] }
    ];
    /** @nocollapse */
    HelpDirective.ctorParameters = function () { return [
        { type: ElementRef },
        { type: HelpService }
    ]; };
    return HelpDirective;
}());
if (false) {
    /**
     * @type {?}
     * @private
     */
    HelpDirective.prototype.guid;
    /**
     * @type {?}
     * @private
     */
    HelpDirective.prototype.context;
    /**
     * @type {?}
     * @private
     */
    HelpDirective.prototype.showIcon;
    /**
     * @type {?}
     * @private
     */
    HelpDirective.prototype.element;
    /**
     * @type {?}
     * @private
     */
    HelpDirective.prototype.helpService;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfLeftnavService = /** @class */ (function () {
    function NwfLeftnavService() {
        this.navData = [];
        this.leftnavIsCollapsed = false;
        this.leftNav = new BehaviorSubject(false);
        this.leftNav$ = this.leftNav.asObservable();
    }
    /**
     * @return {?}
     */
    NwfLeftnavService.prototype.toggle = /**
     * @return {?}
     */
    function () {
        this.leftnavIsCollapsed = !this.leftnavIsCollapsed;
        this.leftNav.next(this.leftnavIsCollapsed);
        /* This is nasty, but issuing this sends a reflow signal to highcharts that might need to resize when I toggle */
        setTimeout((/**
         * @return {?}
         */
        function () { return window.dispatchEvent(new Event('resize')); }), 500);
    };
    /* This is used in the feature tour */
    /* This is used in the feature tour */
    /**
     * @param {?} callback
     * @return {?}
     */
    NwfLeftnavService.prototype.recurseNavData = /* This is used in the feature tour */
    /**
     * @param {?} callback
     * @return {?}
     */
    function (callback) {
        var e_1, _a;
        /**
         * @param {?} currentNode
         * @return {?}
         */
        function recurse(currentNode) {
            var e_2, _a;
            if (currentNode.children) {
                try {
                    for (var _b = __values(currentNode.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var child = _c.value;
                        recurse(child);
                    }
                }
                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_2) throw e_2.error; }
                }
                callback(currentNode);
            }
        }
        try {
            for (var _b = __values(this.navData), _c = _b.next(); !_c.done; _c = _b.next()) {
                var data = _c.value;
                recurse(data);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    NwfLeftnavService.decorators = [
        { type: Injectable, args: [{
                    providedIn: 'root',
                },] }
    ];
    /** @nocollapse */
    NwfLeftnavService.ctorParameters = function () { return []; };
    /** @nocollapse */ NwfLeftnavService.ngInjectableDef = ɵɵdefineInjectable({ factory: function NwfLeftnavService_Factory() { return new NwfLeftnavService(); }, token: NwfLeftnavService, providedIn: "root" });
    return NwfLeftnavService;
}());
if (false) {
    /** @type {?} */
    NwfLeftnavService.prototype.navData;
    /** @type {?} */
    NwfLeftnavService.prototype.leftnavIsCollapsed;
    /** @type {?} */
    NwfLeftnavService.prototype.leftNav$;
    /**
     * @type {?}
     * @private
     */
    NwfLeftnavService.prototype.leftNav;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var HorizontalBarChartComponent = /** @class */ (function () {
    function HorizontalBarChartComponent(i18next, leftNavService, columnsChangingService, stateService) {
        this.i18next = i18next;
        this.leftNavService = leftNavService;
        this.columnsChangingService = columnsChangingService;
        this.stateService = stateService;
        this.totalValue = 100; // This bar can represent a value out of any totalValue given
        // This bar can represent a value out of any totalValue given
        this.seriesName = 'Value';
        // chart needs a unique identifier when we have multiple charts. This is used for on click navigation
        this.showTooltip = true;
        // @Input() width = 300;
        this.height = 20;
        // Enables color zones for soft/hard limits values given
        this.zones = false;
        // Enables y-axis labels for bar chart to show range info like 25%, 50%, 100%
        this.axisLabels = false;
        this.axisUnit = '';
        this.legendsEnabled = false;
        this.plotLinesConfig = [];
        this.destroy = new Subject();
        this.isUndefined = isUndefined;
        this.className = 'none';
        this.minWidth = 2;
    }
    /**
     * @return {?}
     */
    HorizontalBarChartComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var e_1, _a;
        var _this = this;
        /** @type {?} */
        var scope = this;
        // If soft,hard limits are passed, we show plot lines on the bar chart accordingly
        if (this.softLimit) {
            this.plotLinesConfig.push({
                value: this.softLimit,
                width: 2,
                zIndex: 5,
                className: 'nwf-soft-limit',
            });
        }
        if (this.hardLimit) {
            this.plotLinesConfig.push({
                value: this.hardLimit,
                width: 2,
                zIndex: 5,
                className: 'nwf-hard-limit',
            });
        }
        // If 'zones' is true, we set default, soft & hard limit zones
        if (this.zones && this.softLimit && this.hardLimit) {
            this.zonesConfig = [
                {
                    value: this.softLimit >= this.currentValue ? this.softLimit - 1 : 0,
                    className: 'nwf-default-zone',
                },
                {
                    value: this.hardLimit,
                    className: 'nwf-soft-limit-zone',
                }, {
                    className: 'nwf-hard-limit-zone',
                },
            ];
        }
        // Calculate chart height
        // when axis labels are shown, chart requires additional height i.e. +21 to current value:20
        if (this.axisLabels) {
            this.height += 21;
        }
        if (this.legendsEnabled) {
            this.height += 40;
        }
        // We allow only one bar for now with seriesData
        if (this.seriesData) {
            try {
                for (var _b = __values(this.seriesData), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var series = _c.value;
                    series.pointPadding = 0;
                    series.groupPadding = 0;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        // // when tooltip is formatted by consumer set outside to false
        if (this.onClickFunction) {
            this.className = 'nwf-is-link-like';
        }
        if (this.currentValue === 0) {
            this.minWidth = 0;
        }
        this.chart = new Chart({
            chart: {
                type: 'bar',
                height: this.height,
                spacing: [0, 0, 0, 0],
                styledMode: true,
            },
            tooltip: this.toolTipObj ? this.toolTipObj : {
                outside: true,
                enabled: this.showTooltip,
                useHTML: true,
                formatter: /**
                 * @return {?}
                 */
                function () {
                    if (scope.tooltipFormatter) {
                        return scope.tooltipFormatter(scope, this);
                    }
                    else {
                        /** @type {?} */
                        var templateData = {
                            seriesName: this.series.name,
                            tooltipCurrentValue: this.point['tooltipCurrentValue'],
                            tooltipSoftLimitValue: this.point['tooltipSoftLimitValue'],
                            tooltipHardLimitValue: this.point['tooltipHardLimitValue'],
                            softLimit: this.point['i18nRef'] ? this.point['i18nRef'].transform('nwfjs:softLimit') : '',
                            hardLimit: this.point['i18nRef'] ? this.point['i18nRef'].transform('nwfjs:hardLimit') : '',
                            exceedsHardLimit: this.point['i18nRef'] ? this.point['i18nRef'].transform('nwfjs:exceedsHardLimit') : '',
                            exceedsSoftLimit: this.point['i18nRef'] ? this.point['i18nRef'].transform('nwfjs:exceedsSoftLimit') : '',
                        };
                        /** @type {?} */
                        var tooltipBody = '<span class="tooltip-current-series">\u25CF </span>${seriesName}: ${tooltipCurrentValue}';
                        if (this.point['softLimit'] || this.point['hardLimit']) {
                            // If limits exceeded, show an additional header message about the breach
                            if (this.point.y > this.point['hardLimit']) {
                                tooltipBody = '${seriesName} ${exceedsHardLimit}<br\>' + tooltipBody;
                            }
                            else if (this.point.y > this.point['softLimit']) {
                                tooltipBody = '${seriesName} ${exceedsSoftLimit}<br\>' + tooltipBody;
                            }
                            // Appends Soft Limit, Hard Limit values to the tooltip
                            tooltipBody += '<br><span class="tooltip-soft-limit-series">\u25CF </span>${softLimit}: ${tooltipSoftLimitValue}';
                            tooltipBody += '<br><span class="tooltip-hard-limit-series">\u25CF </span>${hardLimit}: ${tooltipHardLimitValue}';
                        }
                        /** @type {?} */
                        var tooltip = template("<div class=\"nwf-highcharts-tooltip popover uib-popover-bottom\">\n                    <div class=\"arrow\"></div>\n                    <div class=\"popover-body\">" + tooltipBody + "</div>\n                    </div>\n                    ");
                        return tooltip(templateData);
                    }
                },
            },
            title: {
                text: '',
            },
            subtitle: {
                text: '',
            },
            xAxis: {
                gridLineColor: 'transparent',
                visible: false,
                title: {
                    text: null,
                },
                labels: {
                    enabled: false,
                },
            },
            yAxis: {
                max: this.totalValue,
                endOnTick: false,
                visible: true,
                title: {
                    text: null,
                },
                labels: {
                    enabled: this.axisLabels,
                    format: '{value}' + this.axisUnit,
                    style: {
                        textOverflow: 'none',
                    },
                },
                plotLines: !this.zones ? this.plotLinesConfig : undefined,
                reversedStacks: this.seriesData ? false : true,
            },
            plotOptions: {
                bar: {
                    minPointLength: this.minWidth,
                    dataLabels: {
                        enabled: false,
                    },
                    className: this.className,
                    events: {
                        click: /**
                         * @param {?} event
                         * @return {?}
                         */
                        function (event) {
                            if (scope.onClickFunction) {
                                return scope.onClickFunction(scope, event);
                            }
                            else {
                                return false;
                            }
                        },
                    },
                },
                series: {
                    zones: this.zonesConfig,
                    stacking: this.seriesData ? 'normal' : undefined,
                },
            },
            legend: {
                enabled: this.legendsEnabled,
            },
            credits: {
                enabled: false,
            },
            series: this.seriesData ? this.seriesData : [(/** @type {?} */ ({
                    pointPadding: 0,
                    groupPadding: 0,
                    animation: false,
                    name: this.seriesName,
                    data: [{
                            y: this.currentValue,
                            softLimit: this.softLimit,
                            hardLimit: this.hardLimit,
                            // If we need to show custom strings in the tooltip, we use below values
                            tooltipSoftLimitValue: this.tooltipSoftLimitValue ? this.tooltipSoftLimitValue : this.softLimit,
                            tooltipHardLimitValue: this.tooltipHardLimitValue ? this.tooltipHardLimitValue : this.hardLimit,
                            tooltipCurrentValue: this.tooltipCurrentValue ? this.tooltipCurrentValue : this.currentValue,
                            i18nRef: this.i18next,
                        }],
                }))],
        });
        merge(this.leftNavService.leftNav$, this.columnsChangingService.columnsChanging$)
            .pipe(takeUntil(this.destroy), delay(10))
            .subscribe((/**
         * @return {?}
         */
        function () {
            if (_this.chart && _this.chart.ref) {
                _this.chart.ref.reflow();
            }
        }));
    };
    /**
     * @return {?}
     */
    HorizontalBarChartComponent.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        // Signal end of subscription to observables
        this.destroy.next();
        this.destroy.complete();
    };
    HorizontalBarChartComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-horizontal-bar-chart',
                    template: "<div class=\"row no-gutters\">\n\n    <div class=\"col align-middle\" [chart]=\"chart\" [ngClass]=\"{ 'pr-1 col-lg-7 col-sm-12' : !isUndefined(labelPrimary) || !isUndefined(labelSecondary)}\">\n    </div>\n\n    <div class=\"col-lg-5 col-sm-12 d-flex flex-row align-items-center flex-wrap\"\n        *ngIf=\"!isUndefined(labelPrimary) || !isUndefined(labelSecondary)\">\n\n        <div class=\"inline-label pr-1\" [ngClass]=\"{ 'border-right-custom': !isUndefined(labelSecondary)}\"\n            *ngIf=\"!isUndefined(labelPrimary)\">\n            {{labelPrimary}}\n        </div>\n        <div class=\"px-1 inline-label\" *ngIf=\"!isUndefined(labelSecondary)\">\n            {{ labelSecondary}}\n        </div>\n\n    </div>\n</div>",
                    styles: ["::ng-deep .tooltip-current-series{color:#61dce8}::ng-deep .tooltip-soft-limit-series{color:#f88402}::ng-deep .tooltip-hard-limit-series{color:#da1e21}:host ::ng-deep .highcharts-background{fill:none}:host ::ng-deep .highcharts-plot-background{fill:#d7d7d7}:host ::ng-deep .highcharts-plot-line.nwf-soft-limit{stroke:#f88402;stroke-width:2px}:host ::ng-deep .highcharts-plot-line.nwf-hard-limit{stroke:#da1e21;stroke-width:2px}:host ::ng-deep .highcharts-point.nwf-default-zone{fill:#61dce8;stroke:#61dce8}:host ::ng-deep .highcharts-point.nwf-soft-limit-zone{fill:#f88402;stroke:#f88402}:host ::ng-deep .highcharts-point.nwf-hard-limit-zone{fill:#da1e21;stroke:#da1e21}:host ::ng-deep .highcharts-grid-line{stroke:transparent}:host ::ng-deep .highcharts-container{width:100%!important}:host ::ng-deep .highcharts-container>svg:first-child{width:100%!important}:host .inline-label{font-size:12px;font-weight:600}:host .border-right-custom{border-right:1px solid #000}"]
                }] }
    ];
    /** @nocollapse */
    HorizontalBarChartComponent.ctorParameters = function () { return [
        { type: I18NextPipe },
        { type: NwfLeftnavService },
        { type: NwfColumnsChangingService },
        { type: StateService }
    ]; };
    HorizontalBarChartComponent.propDecorators = {
        currentValue: [{ type: Input }],
        totalValue: [{ type: Input }],
        seriesName: [{ type: Input }],
        seriesId: [{ type: Input }],
        showTooltip: [{ type: Input }],
        labelPrimary: [{ type: Input }],
        labelSecondary: [{ type: Input }],
        softLimit: [{ type: Input }],
        hardLimit: [{ type: Input }],
        tooltipSoftLimitValue: [{ type: Input }],
        tooltipHardLimitValue: [{ type: Input }],
        tooltipCurrentValue: [{ type: Input }],
        zones: [{ type: Input }],
        axisLabels: [{ type: Input }],
        axisUnit: [{ type: Input }],
        seriesData: [{ type: Input }],
        legendsEnabled: [{ type: Input }],
        toolTipObj: [{ type: Input }],
        onClickFunction: [{ type: Input }],
        tooltipFormatter: [{ type: Input }]
    };
    return HorizontalBarChartComponent;
}());
if (false) {
    /** @type {?} */
    HorizontalBarChartComponent.prototype.currentValue;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.totalValue;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.seriesName;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.seriesId;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.showTooltip;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.labelPrimary;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.labelSecondary;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.softLimit;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.hardLimit;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.tooltipSoftLimitValue;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.tooltipHardLimitValue;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.tooltipCurrentValue;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.height;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.zones;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.axisLabels;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.axisUnit;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.seriesData;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.legendsEnabled;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.toolTipObj;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.onClickFunction;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.tooltipFormatter;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.chart;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.chartWithPlotLines;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.plotLinesConfig;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.zonesConfig;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.destroy;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.isUndefined;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.className;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.minWidth;
    /**
     * @type {?}
     * @private
     */
    HorizontalBarChartComponent.prototype.i18next;
    /**
     * @type {?}
     * @private
     */
    HorizontalBarChartComponent.prototype.leftNavService;
    /**
     * @type {?}
     * @private
     */
    HorizontalBarChartComponent.prototype.columnsChangingService;
    /**
     * @type {?}
     * @private
     */
    HorizontalBarChartComponent.prototype.stateService;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var IconComponent = /** @class */ (function () {
    function IconComponent(sanitizer) {
        this.sanitizer = sanitizer;
        this.iconClass = ''; // they hand in kabob-case
        // they hand in kabob-case
        this.ontapSeverity = ''; // this flags me as ontap severity style icon.
        this.class = ''; // an optional classname they just want passed through.
        // an optional classname they just want passed through.
        this.hasLoggedDep = false;
        this.ontapSeverityCls = '';
        this.stateMap = {
            ok: 'icon-status-ok-circlecheck',
            success: 'icon-status-ok-circlecheck',
            warning: 'icon-status-warning',
            critical: 'icon-status-critical',
            error: 'icon-status-error-full',
            info: 'icon-status-info',
        };
    }
    Object.defineProperty(IconComponent.prototype, "svgContent", {
        get: /**
         * @return {?}
         */
        function () {
            /* if I have a severity, we load the right one */
            /** @type {?} */
            var isSeverity = false;
            if (this.severity && this.severity.toLowerCase() in this.stateMap) {
                this.iconClass = this.stateMap[this.severity.toLowerCase()];
                isSeverity = true;
            }
            // its possible that we get iconClass null
            if (!this.iconClass) {
                return '';
            }
            /* I set a flag so I don't log over and over */
            if (!this.hasLoggedDep && !isSeverity) {
                /* If they have sent me a key that I don't have warn them */
                if (!(this.iconClass in icons)) {
                    console.error("You tried to load <nwf-icon iconClass=\"" + this.iconClass + "\"> but it has been deprecated.");
                    this.hasLoggedDep = true;
                }
            }
            /* return the actual html from the icons.js */
            return this.sanitizer.bypassSecurityTrustHtml(icons[this.iconClass]);
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @param {?} changes
     * @return {?}
     */
    IconComponent.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) {
        if (changes && changes.ontapSeverity) {
            this.ontapSeverityCls = 'ontap-severity';
        }
        this.processedSvg = this.svgContent;
    };
    IconComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-icon',
                    template: "\n    <div [ngClass]=\"[iconClass, class, ontapSeverityCls]\" class=\"nwf-icon\" [innerHTML]=\"processedSvg\"></div>\n  ",
                    styles: [":host{display:inline-block;line-height:0;pointer-events:none}:host+.nwf-icon-label{display:inline-block;vertical-align:top;margin-left:4px}"]
                }] }
    ];
    /** @nocollapse */
    IconComponent.ctorParameters = function () { return [
        { type: DomSanitizer }
    ]; };
    IconComponent.propDecorators = {
        iconClass: [{ type: Input }],
        ontapSeverity: [{ type: Input }],
        severity: [{ type: Input }],
        class: [{ type: Input }]
    };
    return IconComponent;
}());
if (false) {
    /** @type {?} */
    IconComponent.prototype.iconClass;
    /** @type {?} */
    IconComponent.prototype.ontapSeverity;
    /** @type {?} */
    IconComponent.prototype.severity;
    /** @type {?} */
    IconComponent.prototype.class;
    /** @type {?} */
    IconComponent.prototype.hasLoggedDep;
    /** @type {?} */
    IconComponent.prototype.processedSvg;
    /** @type {?} */
    IconComponent.prototype.ontapSeverityCls;
    /**
     * @type {?}
     * @private
     */
    IconComponent.prototype.stateMap;
    /**
     * @type {?}
     * @private
     */
    IconComponent.prototype.sanitizer;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfLoadIndicatorComponent = /** @class */ (function () {
    function NwfLoadIndicatorComponent() {
        this.visible = true;
    }
    /**
     * @return {?}
     */
    NwfLoadIndicatorComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
    };
    NwfLoadIndicatorComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-load-indicator',
                    template: "<div class=\"d-flex align-items-center my-2\">\n    <div class=\"d-flex mr-4\"><dx-load-indicator [(visible)]=\"visible\" [hint]=\"hint\"></dx-load-indicator></div>\n    <div *ngIf=\"loadingMessage\">{{loadingMessage}}</div>\n</div>\n",
                    styles: [""]
                }] }
    ];
    /** @nocollapse */
    NwfLoadIndicatorComponent.ctorParameters = function () { return []; };
    NwfLoadIndicatorComponent.propDecorators = {
        visible: [{ type: Input }],
        hint: [{ type: Input }],
        loadingMessage: [{ type: Input }]
    };
    return NwfLoadIndicatorComponent;
}());
if (false) {
    /** @type {?} */
    NwfLoadIndicatorComponent.prototype.visible;
    /** @type {?} */
    NwfLoadIndicatorComponent.prototype.hint;
    /** @type {?} */
    NwfLoadIndicatorComponent.prototype.loadingMessage;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfConfirmationModalComponent = /** @class */ (function () {
    function NwfConfirmationModalComponent(activeModal) {
        this.activeModal = activeModal;
        this.status = '';
        this.showCancel = true;
        this.showDimissX = true;
        this.okButtonLabel = 'nwfjs:OK';
    }
    NwfConfirmationModalComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-confirmation-modal',
                    template: "<nwf-modal-header [status]=\"status\" (onDismiss)=\"activeModal.dismiss(false)\" [showDimissX]=\"showDimissX\">\n    {{title | i18next}}\n</nwf-modal-header>\n<div class=\"modal-body\">\n    <ng-template [ngTemplateOutlet]=\"messageTemplate\" *ngIf=\"messageTemplate\"></ng-template>\n    <div *ngIf=\"message\">{{message | i18next}}</div>\n</div>\n<div class=\"modal-footer\">\n    <button data-netapp-id=\"confirmation-modal-cancel-btn\" class=\"btn btn-link\" (click)=\"activeModal.dismiss(false)\" *ngIf=\"showCancel\">{{ 'nwfjs:cancel' | i18next }}</button>\n    <button data-netapp-id=\"confirmation-modal-ok-btn\" class=\"btn btn-primary\" (click)=\"activeModal.close(true)\">{{ okButtonLabel | i18next }}</button>\n</div>"
                }] }
    ];
    /** @nocollapse */
    NwfConfirmationModalComponent.ctorParameters = function () { return [
        { type: NgbActiveModal }
    ]; };
    NwfConfirmationModalComponent.propDecorators = {
        title: [{ type: Input }],
        status: [{ type: Input }],
        message: [{ type: Input }],
        messageTemplate: [{ type: Input }],
        showCancel: [{ type: Input }],
        showDimissX: [{ type: Input }],
        okButtonLabel: [{ type: Input }]
    };
    return NwfConfirmationModalComponent;
}());
if (false) {
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.title;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.status;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.message;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.messageTemplate;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.showCancel;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.showDimissX;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.okButtonLabel;
    /** @type {?} */
    NwfConfirmationModalComponent.prototype.activeModal;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var HeaderComponent = /** @class */ (function () {
    function HeaderComponent(element) {
        this.element = element;
        this.status = '';
        this.showDimissX = true;
        this.onDismiss = new EventEmitter();
    }
    /**
     * @param {?} changes
     * @return {?}
     */
    HeaderComponent.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) {
        /** @type {?} */
        var status = changes.status.currentValue;
        if (status === 'error') {
            status = 'critical';
            this.status = status;
        }
        /** @type {?} */
        var stateCls = status ? "is-" + status : '';
        if (stateCls) {
            this.element.nativeElement.classList.add(stateCls);
        }
    };
    HeaderComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-modal-header',
                    template: "<nwf-icon [severity]=\"status\" *ngIf=\"status\" class=\"mr-1\"></nwf-icon>\n<h4 class=\"modal-title\">\n  <ng-content></ng-content>\n</h4>\n<nwf-dismiss-button *ngIf=\"showDimissX\" (onClose)=\"onDismiss.emit()\"></nwf-dismiss-button>\n",
                    host: { class: 'modal-header' }
                }] }
    ];
    /** @nocollapse */
    HeaderComponent.ctorParameters = function () { return [
        { type: ElementRef }
    ]; };
    HeaderComponent.propDecorators = {
        status: [{ type: Input }],
        showDimissX: [{ type: Input }],
        onDismiss: [{ type: Output }]
    };
    return HeaderComponent;
}());
if (false) {
    /** @type {?} */
    HeaderComponent.prototype.status;
    /** @type {?} */
    HeaderComponent.prototype.showDimissX;
    /** @type {?} */
    HeaderComponent.prototype.onDismiss;
    /**
     * @type {?}
     * @private
     */
    HeaderComponent.prototype.element;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfPageAlertService = /** @class */ (function () {
    function NwfPageAlertService() {
        this.pageAlert = new Subject();
        this.pageAlert$ = this.pageAlert.asObservable();
    }
    // Method to Show Page Alert
    // Method to Show Page Alert
    /**
     * @param {?} message
     * @param {?} severity
     * @param {?=} fade
     * @return {?}
     */
    NwfPageAlertService.prototype.show = 
    // Method to Show Page Alert
    /**
     * @param {?} message
     * @param {?} severity
     * @param {?=} fade
     * @return {?}
     */
    function (message, severity, fade) {
        this.pageAlert.next({ type: 'show', config: { message: message, severity: severity, fade: fade } });
    };
    // Method to Hide Page Alert
    // Method to Hide Page Alert
    /**
     * @return {?}
     */
    NwfPageAlertService.prototype.hide = 
    // Method to Hide Page Alert
    /**
     * @return {?}
     */
    function () {
        this.pageAlert.next({ type: 'hide' });
    };
    NwfPageAlertService.decorators = [
        { type: Injectable }
    ];
    /** @nocollapse */
    NwfPageAlertService.ctorParameters = function () { return []; };
    return NwfPageAlertService;
}());
if (false) {
    /** @type {?} */
    NwfPageAlertService.prototype.pageAlert$;
    /**
     * @type {?}
     * @private
     */
    NwfPageAlertService.prototype.pageAlert;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var PageAlertComponent = /** @class */ (function () {
    function PageAlertComponent(pageAlertService, sanitizer, transitionService) {
        var _this = this;
        this.sanitizer = sanitizer;
        this.transitionService = transitionService;
        this.message = '';
        this.severity = 'success';
        this.isShowing = false;
        this.subscription = pageAlertService.pageAlert$.subscribe((/**
         * @param {?} data
         * @return {?}
         */
        function (data) {
            // TO check whether show is called or hide is called
            if (data.type === 'show') {
                _this.show(data.config);
            }
            else {
                _this.close();
            }
        }));
    }
    /**
     * @return {?}
     */
    PageAlertComponent.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        // unsubscribe to ensure no memory leaks
        this.subscription.unsubscribe();
    };
    /**
     * @param {?} __0
     * @return {?}
     */
    PageAlertComponent.prototype.show = /**
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var _this = this;
        var message = _a.message, severity = _a.severity, fade = _a.fade;
        this.message = this.sanitizer.bypassSecurityTrustHtml(message);
        if (severity == 'ok') {
            severity = 'success';
        }
        if (severity == 'error') {
            severity = 'critical';
        }
        this.severity = severity;
        this.isShowing = true;
        if (fade) {
            setTimeout((/**
             * @return {?}
             */
            function () { return _this.close(); }), fade);
        }
        /* I want to close when I exit this route */
        this._trans = this.transitionService.onBefore({}, this.close.bind(this));
    };
    /**
     * @return {?}
     */
    PageAlertComponent.prototype.close = /**
     * @return {?}
     */
    function () {
        this.isShowing = false;
        if (this._trans) {
            this._trans();
        }
    };
    PageAlertComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-page-alert',
                    template: "\n    <ngb-alert [type]=\"severity\" *ngIf=\"isShowing\" (close)=\"close()\" class=\"is-page-level\">\n      <div class=\"d-flex\">\n        <div *ngIf=\"severity\">\n          <nwf-icon [severity]=\"severity\"></nwf-icon>\n        </div>\n        <div class=\"flex-grow-1 ml-2\" [innerHTML]=\"message\"></div>\n      </div>\n    </ngb-alert>\n  ",
                    styles: [""]
                }] }
    ];
    /** @nocollapse */
    PageAlertComponent.ctorParameters = function () { return [
        { type: NwfPageAlertService },
        { type: DomSanitizer },
        { type: TransitionService }
    ]; };
    PageAlertComponent.propDecorators = {
        message: [{ type: Input }],
        severity: [{ type: Input }]
    };
    return PageAlertComponent;
}());
if (false) {
    /** @type {?} */
    PageAlertComponent.prototype.message;
    /** @type {?} */
    PageAlertComponent.prototype.severity;
    /** @type {?} */
    PageAlertComponent.prototype.isShowing;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype.subscription;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype._trans;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype.sanitizer;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype.transitionService;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfPopoverTitle = /** @class */ (function () {
    function NwfPopoverTitle() {
        this.onDismiss = new EventEmitter();
    }
    NwfPopoverTitle.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-popover-title',
                    template: "\n        <div class=\"d-flex\">\n        <div class=\"popover-title\">\n        <div class=\"popover-title-content\">\n           <ng-content></ng-content>\n           </div>\n           </div>\n           <nwf-dismiss-button (onClose)=\"onDismiss.emit()\"></nwf-dismiss-button>\n        </div>\n    ",
                    styles: [".popover-title{flex-grow:1;line-height:1.5}.popover-title-content{display:inline-flex;height:100%;align-items:flex-end}"]
                }] }
    ];
    NwfPopoverTitle.propDecorators = {
        onDismiss: [{ type: Output }]
    };
    return NwfPopoverTitle;
}());
if (false) {
    /** @type {?} */
    NwfPopoverTitle.prototype.onDismiss;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfProgressBarComponent = /** @class */ (function () {
    function NwfProgressBarComponent() {
        this.type = 'info';
        this.value = 0;
    }
    /**
     * @return {?}
     */
    NwfProgressBarComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
    };
    NwfProgressBarComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-progress-bar',
                    template: "<div class=\"text-center mb-4\">{{labelMap[value]}}</div>\n<ngb-progressbar [value]=\"value\" [type]=\"type\" [animated]=\"true\" [striped]=\"true\"></ngb-progressbar>\n",
                    host: {
                        class: 'd-block',
                    }
                }] }
    ];
    /** @nocollapse */
    NwfProgressBarComponent.ctorParameters = function () { return []; };
    NwfProgressBarComponent.propDecorators = {
        type: [{ type: Input }],
        value: [{ type: Input }],
        labelMap: [{ type: Input }]
    };
    return NwfProgressBarComponent;
}());
if (false) {
    /** @type {?} */
    NwfProgressBarComponent.prototype.type;
    /** @type {?} */
    NwfProgressBarComponent.prototype.value;
    /** @type {?} */
    NwfProgressBarComponent.prototype.labelMap;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfPropertySheet = /** @class */ (function () {
    function NwfPropertySheet() {
    }
    NwfPropertySheet.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-property-sheet',
                    host: {
                        class: 'd-block',
                    },
                    template: "<ng-content></ng-content>",
                    styles: [":host{margin-bottom:-16px}:host ::ng-deep .row{margin-bottom:16px}:host.small ::ng-deep dd{font-size:12px;font-weight:600}"]
                }] }
    ];
    /** @nocollapse */
    NwfPropertySheet.ctorParameters = function () { return []; };
    return NwfPropertySheet;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfProperty = /** @class */ (function () {
    function NwfProperty(self) {
        this.self = self;
    }
    /**
     * @return {?}
     */
    NwfProperty.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
    };
    NwfProperty.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-property',
                    template: "<dl>\n  <ng-content select=\"dt\"></ng-content>\n  <ng-content select=\"dd\"></ng-content>\n  </dl>\n  ",
                    styles: ["dl{margin-bottom:16px}:host ::ng-deep dt{color:#565656;font-size:12px;font-weight:400;text-transform:uppercase}:host ::ng-deep dd{color:#454545;font-weight:400;font-size:18px;line-height:1.3;margin-bottom:0}:host ::ng-deep dd a{color:#2d6dde}:host ::ng-deep dd a:hover{color:#1e4a93}"]
                }] }
    ];
    /** @nocollapse */
    NwfProperty.ctorParameters = function () { return [
        { type: ElementRef }
    ]; };
    return NwfProperty;
}());
if (false) {
    /** @type {?} */
    NwfProperty.prototype.self;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var StackedChartComponent = /** @class */ (function () {
    function StackedChartComponent(stateService, i18next, i18NextFormatPipe) {
        this.stateService = stateService;
        this.i18next = i18next;
        this.i18NextFormatPipe = i18NextFormatPipe;
        this.height = 40;
        this.marginTop = 0;
        this.marginBottom = 0;
        this.max = 100;
        this.chartTitle = '';
        this.legendsEnabled = false;
        this.axisLabelsEnabled = false;
    }
    /**
     * @return {?}
     */
    StackedChartComponent.prototype.reflow = /**
     * @return {?}
     */
    function () {
        this.chart.ref.reflow();
    };
    /**
     * @return {?}
     */
    StackedChartComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        /** @type {?} */
        var scope = this;
        // adjusting the chart configuration according to the legends being enabled or not
        /** @type {?} */
        var noOfSeries = this.axisLabels ? this.axisLabels.length : 1;
        // This sets the default height to 50 pixels in case we have no data so the no data to display label shows
        this.height = noOfSeries === 0 ? 50 : this.height * noOfSeries;
        if (this.chartTitle != '') {
            this.height += 20;
            this.marginTop += 20;
        }
        if (this.legendsEnabled) {
            if (this.legendsLayout === 'horizontal') {
                this.height += 30;
                this.marginBottom += 30;
                this.alignment = 'center';
            }
            else if (this.legendsLayout === 'vertical') {
                this.height += 60;
                this.marginBottom += 60;
            }
        }
        if (this.axisLabelsEnabled) {
            this.max = 120;
        }
        // chart configurations
        this.chartConfig = {
            chart: {
                type: 'bar',
                height: this.height,
                marginTop: this.marginTop,
                marginBottom: this.marginBottom,
                spacing: [0, 0, 0, 0],
                animation: false,
                styledMode: true,
                events: {
                    load: /**
                     * @return {?}
                     */
                    function () {
                        /** @type {?} */
                        var chart = this;
                        chart.series.forEach((/**
                         * @param {?} s
                         * @return {?}
                         */
                        function (s) {
                            s.points.forEach((/**
                             * @param {?} p
                             * @return {?}
                             */
                            function (p) {
                                // update the color of the bar labelled as 'UNASSIGNED'
                                if (p.category.toString().includes('Unassigned')) {
                                    p.update({
                                        colorIndex: 3,
                                    });
                                }
                            }));
                        }));
                    },
                },
            },
            title: {
                text: this.chartTitle,
                align: 'left',
            },
            subtitle: {
                text: '',
            },
            xAxis: {
                visible: this.axisLabelsEnabled,
                categories: this.axisLabels,
                title: {
                    text: null,
                },
                labels: {
                    enabled: true,
                },
            },
            yAxis: {
                visible: this.axisLabelsEnabled,
                min: 0,
                max: this.max,
                endOnTick: false,
                labels: {
                    enabled: false,
                },
                title: {
                    text: null,
                },
                /* Stacklabels are the labels to the right of the charts
                                We want the labels outside the plot area, and crop and overflow should do that according to the api doc.
                                */
                stackLabels: {
                    enabled: true,
                    useHTML: true,
                    allowOverlap: true,
                    overflow: 'allow',
                    crop: false,
                    formatter: /**
                     * @return {?}
                     */
                    function () {
                        return scope.stackLabelsFormatter(scope, this);
                    },
                },
            },
            plotOptions: {
                series: {
                    stacking: 'percent',
                    borderWidth: 0,
                    events: {
                        legendItemClick: /**
                         * @return {?}
                         */
                        function () {
                            return false;
                        },
                    },
                },
                bar: {
                    className: 'nwf-is-link-like',
                    events: {
                        click: /**
                         * @param {?} event
                         * @return {?}
                         */
                        function (event) {
                            return scope.clickEvent(scope, event, this);
                        },
                    },
                },
            },
            legend: {
                enabled: this.legendsEnabled,
                reversed: true,
                useHTML: true,
                align: this.alignment,
                x: 0,
                layout: this.legendsLayout,
                floating: true,
                symbolRadius: 1,
                padding: 0,
                itemDistance: 3,
                itemMarginBottom: 5,
                labelFormatter: /**
                 * @return {?}
                 */
                function () {
                    return scope.legendFormatter(this);
                },
            },
            lang: {
                noData: this.i18next.transform('nwfjs:noData'),
            },
            tooltip: {
                enabled: true,
                outside: true,
                useHTML: true,
                formatter: /**
                 * @return {?}
                 */
                function () {
                    /** @type {?} */
                    var templateData = {
                        seriesName: this.series.name,
                        tooltipCurrentValue: scope.i18NextFormatPipe.transform(this.point.y, 'number'),
                        pointColor: this.point.graphic.getStyle('fill'),
                    };
                    /** @type {?} */
                    var tooltipBody = '${seriesName}: ${tooltipCurrentValue}';
                    /** @type {?} */
                    var tooltip = template("<div class=\"nwf-highcharts-tooltip popover uib-popover-bottom\">\n                    <div class=\"popover-body\">" + tooltipBody + "</div>\n                    </div>\n                    ");
                    if (this.key.toString().includes(scope.i18next.transform('nwfjs:unassigned'))) {
                        return false;
                    }
                    else {
                        return tooltip(templateData);
                    }
                },
            },
            series: this.seriesData ? this.seriesData : [(/** @type {?} */ ({
                    type: 'bar',
                    animation: false,
                    data: this.seriesData,
                }))],
        };
        this.chart = new Chart(this.chartConfig);
    };
    /**
     * @return {?}
     */
    StackedChartComponent.prototype.ngOnChanges = /**
     * @return {?}
     */
    function () {
        if (this.chart) {
            this.chartConfig.series = this.seriesData ? this.seriesData : [(/** @type {?} */ ({
                    type: 'bar',
                    animation: false,
                    data: this.seriesData,
                }))];
            this.chart = new Chart(this.chartConfig);
        }
    };
    /**
     * @param {?} stateParams
     * @return {?}
     */
    StackedChartComponent.prototype.getLink = /**
     * @param {?} stateParams
     * @return {?}
     */
    function (stateParams) {
        var e_1, _a;
        /** @type {?} */
        var stateParamsString = '';
        try {
            for (var _b = __values(Object.keys(stateParams)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var key = _c.value;
                if (key != 'fromState') {
                    stateParamsString = stateParamsString.concat(key + '=' + stateParams[key] + '&');
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        stateParamsString = stateParamsString[stateParamsString.length - 1] === '&' ? stateParamsString.slice(0, -1) : stateParamsString;
        return stateParams['fromState'] + '?' + stateParamsString;
    };
    StackedChartComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-stacked-bar-chart',
                    template: "<div [chart]=\"chart\"></div>",
                    styles: [":host ::ng-deep .highcharts-background{fill:none}:host ::ng-deep .highcharts-axis-line{stroke:transparent}:host ::ng-deep .highcharts-grid-line{stroke:transparent}:host ::ng-deep .highcharts-title{fill:grey;font-family:\"Source Sans Pro\",Arial,\"Helvetica Neue\",Helvetica,sans-serif;font-size:1rem}:host ::ng-deep .highcharts-axis-labels{font-family:\"Source Sans Pro\",Arial,\"Helvetica Neue\",Helvetica,sans-serif;font-size:14px}:host ::ng-deep .highcharts-legend-item.highcharts-color-0 .highcharts-point,:host ::ng-deep .highcharts-point.highcharts-color-0,:host ::ng-deep .highcharts-tooltip .highcharts-color-0{fill:#ff4548;stroke:#fff}:host ::ng-deep .highcharts-legend-item.highcharts-color-1 .highcharts-point,:host ::ng-deep .highcharts-point.highcharts-color-1,:host ::ng-deep .highcharts-tooltip .highcharts-color-1{fill:#ffac00;stroke:#fff}:host ::ng-deep .highcharts-legend-item.highcharts-color-2 .highcharts-point,:host ::ng-deep .highcharts-point.highcharts-color-2,:host ::ng-deep .highcharts-tooltip .highcharts-color-2{fill:#58c27a;stroke:#fff}:host ::ng-deep .highcharts-color-3{fill:#d7d7d7;stroke:#d7d7d7;cursor:default!important}:host .highcharts-legend-item:hover{cursor:default!important}"]
                }] }
    ];
    /** @nocollapse */
    StackedChartComponent.ctorParameters = function () { return [
        { type: StateService },
        { type: I18NextPipe },
        { type: I18NextFormatPipe }
    ]; };
    StackedChartComponent.propDecorators = {
        seriesData: [{ type: Input }],
        chartTitle: [{ type: Input }],
        legendsEnabled: [{ type: Input }],
        legendsLayout: [{ type: Input }],
        legendFormatter: [{ type: Input }],
        stackLabelsFormatter: [{ type: Input }],
        clickEvent: [{ type: Input }],
        axisLabelsEnabled: [{ type: Input }],
        axisLabels: [{ type: Input }],
        stackLabels: [{ type: Input }]
    };
    return StackedChartComponent;
}());
if (false) {
    /** @type {?} */
    StackedChartComponent.prototype.chart;
    /** @type {?} */
    StackedChartComponent.prototype.height;
    /** @type {?} */
    StackedChartComponent.prototype.marginTop;
    /** @type {?} */
    StackedChartComponent.prototype.marginBottom;
    /** @type {?} */
    StackedChartComponent.prototype.max;
    /** @type {?} */
    StackedChartComponent.prototype.chartConfig;
    /** @type {?} */
    StackedChartComponent.prototype.alignment;
    /** @type {?} */
    StackedChartComponent.prototype.seriesData;
    /** @type {?} */
    StackedChartComponent.prototype.chartTitle;
    /** @type {?} */
    StackedChartComponent.prototype.legendsEnabled;
    /** @type {?} */
    StackedChartComponent.prototype.legendsLayout;
    /** @type {?} */
    StackedChartComponent.prototype.legendFormatter;
    /** @type {?} */
    StackedChartComponent.prototype.stackLabelsFormatter;
    /** @type {?} */
    StackedChartComponent.prototype.clickEvent;
    /** @type {?} */
    StackedChartComponent.prototype.axisLabelsEnabled;
    /** @type {?} */
    StackedChartComponent.prototype.axisLabels;
    /** @type {?} */
    StackedChartComponent.prototype.stackLabels;
    /** @type {?} */
    StackedChartComponent.prototype.stateService;
    /**
     * @type {?}
     * @private
     */
    StackedChartComponent.prototype.i18next;
    /**
     * @type {?}
     * @private
     */
    StackedChartComponent.prototype.i18NextFormatPipe;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/** @type {?} */
var allComponents = [
    IconComponent,
    HelpDirective,
    AlertComponent,
    PageAlertComponent,
    NwfElipsizer,
    HeaderComponent,
    NwfPropertySheet,
    NwfDismissButton,
    NwfPopoverTitle,
    NwfProperty,
    HorizontalBarChartComponent,
    NwfConfirmationModalComponent,
    NwfProgressBarComponent,
    NwfLoadIndicatorComponent,
    StackedChartComponent,
];
var NwfjsSharedComponentsModule = /** @class */ (function () {
    function NwfjsSharedComponentsModule() {
    }
    NwfjsSharedComponentsModule.decorators = [
        { type: NgModule, args: [{
                    imports: [
                        CommonModule,
                        ChartModule,
                        FormsModule,
                        DxLoadIndicatorModule,
                        NgbAlertModule,
                        NgbModalModule,
                        NgbPopoverModule,
                        NgbProgressbarModule,
                        I18NextModule,
                        UIRouterModule,
                        NgbDropdownModule,
                    ],
                    declarations: allComponents,
                    entryComponents: [NwfConfirmationModalComponent],
                    providers: [NwfPageAlertService, NwfElipsizerResizeService, NwfHelpConfig, NwfColumnsChangingService],
                    exports: allComponents,
                },] }
    ];
    return NwfjsSharedComponentsModule;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfRoundUnit = /** @class */ (function () {
    function NwfRoundUnit(i18NextPipeFormatPipe) {
        this.i18NextPipeFormatPipe = i18NextPipeFormatPipe;
        this.units = ['bytes', 'KB', 'MB', 'GB', 'TB', 'PB'];
    }
    /**
     * @param {?} value
     * @param {?} config
     * @return {?}
     */
    NwfRoundUnit.prototype.transform = /**
     * @param {?} value
     * @param {?} config
     * @return {?}
     */
    function (value, config) {
        // tslint:disable-next-line: prefer-const
        var unit = config.unit, statType = config.statType;
        /** @type {?} */
        var isPercent = (unit === '%');
        if (this.units.indexOf(unit) >= 0) {
            var _a = this.getReadable(value, unit), newValue = _a.value, newUnit = _a.unit;
            value = newValue;
            unit = newUnit;
        }
        /** @type {?} */
        var text = this.round(value, isPercent, statType);
        if (text) { // parsing through number locale if value is truthy.if (value !== null) {
            if (!isNaN(parseFloat(text))) {
                // Use i18next formatting for number
                text = this.i18NextPipeFormatPipe.transform(parseFloat(text), { format: 'number' });
            }
            if (unit) { // add unit only if unit is not undefined and not null
                text += (isPercent ? '' : ' ') + unit;
            }
            return text;
        }
        else {
            return 'N/A';
        }
    };
    /**
     * @param {?} value
     * @param {?=} isPercent
     * @param {?=} statType
     * @return {?}
     */
    NwfRoundUnit.prototype.round = /**
     * @param {?} value
     * @param {?=} isPercent
     * @param {?=} statType
     * @return {?}
     */
    function (value, isPercent, statType) {
        if (isPercent === void 0) { isPercent = false; }
        if (statType === void 0) { statType = ''; }
        if (value === null) { //  return null if null
            return null;
        }
        else if (value === 0) {
            return '0';
        }
        if (isPercent) {
            if (value < 1) { // "<1" if < 1
                return '< 1';
            }
            else { // Whole number otherwise
                return parseFloat(value).toFixed();
            }
        }
        else {
            if (value < 1) {
                switch (statType) {
                    case 'latency':
                        return parseFloat(value).toFixed(3); // 3 decimal points between 0 and 1 for Latency
                    default:
                        return '< 1'; // "<1" if < 1 for everything else
                }
            }
            else if (value < 10 && value >= 1) { // 2 decimal points between 1 and 10
                return parseFloat(value).toFixed(2);
            }
            else if (value < 100 && value >= 10) { // 1 decimal point between 10 and  100
                return parseFloat(value).toFixed(1);
            }
            else if (value >= 100) { // Whole number if greater than 100
                return parseFloat(value).toFixed();
            }
            else {
                return value;
            }
        }
    };
    /**
     * @param {?} value
     * @param {?} unit
     * @return {?}
     */
    NwfRoundUnit.prototype.getReadable = /**
     * @param {?} value
     * @param {?} unit
     * @return {?}
     */
    function (value, unit) {
        /** @type {?} */
        var idx = this.units.indexOf(unit);
        /** @type {?} */
        var result;
        // we always need a value handling undefined case
        while (value && !(value >= 1 && value < 1024)) {
            if (value < 1) {
                // The current unit is too big
                if (idx > 0) {
                    // Decrease the unit by one level
                    value *= 1024.0;
                    idx -= 1;
                }
                else {
                    // The current unit is KB, there is no smaller unit, we have the result
                    result = { value: value, unit: this.units[idx] };
                    break;
                }
            }
            if (value >= 1024) {
                // The current unit is too small
                if (idx < this.units.length - 1) {
                    // Increase the unit by one level
                    value /= 1024.0;
                    idx += 1;
                }
                else {
                    // The current unit is PB, there is no bigger unit, we have the result
                    result = { value: value, unit: this.units[idx] };
                    break;
                }
            }
        }
        if (!result) {
            // The give arguments are proper value and unit
            result = { value: value, unit: this.units[idx] };
        }
        return result;
    };
    NwfRoundUnit.decorators = [
        { type: Pipe, args: [{ name: 'NwfRoundUnit' },] }
    ];
    /** @nocollapse */
    NwfRoundUnit.ctorParameters = function () { return [
        { type: I18NextFormatPipe }
    ]; };
    return NwfRoundUnit;
}());
if (false) {
    /** @type {?} */
    NwfRoundUnit.prototype.units;
    /**
     * @type {?}
     * @private
     */
    NwfRoundUnit.prototype.i18NextPipeFormatPipe;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var StripWhitespacePipe = /** @class */ (function () {
    function StripWhitespacePipe() {
    }
    /**
     * @param {?} value
     * @return {?}
     */
    StripWhitespacePipe.prototype.transform = /**
     * @param {?} value
     * @return {?}
     */
    function (value) {
        return value.replace(/\s/g, '');
    };
    StripWhitespacePipe.decorators = [
        { type: Pipe, args: [{ name: 'NwfStripWhitespacePipe' },] }
    ];
    /** @nocollapse */
    StripWhitespacePipe.ctorParameters = function () { return []; };
    return StripWhitespacePipe;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfjsSharedPipesModule = /** @class */ (function () {
    function NwfjsSharedPipesModule() {
    }
    NwfjsSharedPipesModule.decorators = [
        { type: NgModule, args: [{
                    imports: [I18NextModule],
                    declarations: [NwfRoundUnit, StripWhitespacePipe],
                    exports: [NwfRoundUnit, StripWhitespacePipe],
                },] }
    ];
    return NwfjsSharedPipesModule;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/** @type {?} */
var currentDate = new Date();
/** @type {?} */
var last13MonthsDate = new Date(currentDate.getTime() - (395 * 24 * 60 * 60 * 1000));
var NwfDatetimePicker = /** @class */ (function () {
    function NwfDatetimePicker() {
        this.minDate = { year: last13MonthsDate.getFullYear(), month: last13MonthsDate.getMonth() + 1, day: last13MonthsDate.getDate() };
        this.maxDate = { year: currentDate.getFullYear(), month: currentDate.getMonth() + 1, day: currentDate.getDate() };
        this.navigation = 'arrows';
    }
    /**
     * @return {?}
     */
    NwfDatetimePicker.prototype.ngOnInit = /**
     * @return {?}
     */
    function () { };
    /**
     * Sets the min and max date for the widget. By default, minDate is the exact 13 months ago date and maxDate is the current date.
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @param changes - SimpleChanges
     * @returns void
     */
    /**
     * Sets the min and max date for the widget. By default, minDate is the exact 13 months ago date and maxDate is the current date.
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @param {?} changes - SimpleChanges
     * @return {?} void
     */
    NwfDatetimePicker.prototype.ngOnChanges = /**
     * Sets the min and max date for the widget. By default, minDate is the exact 13 months ago date and maxDate is the current date.
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @param {?} changes - SimpleChanges
     * @return {?} void
     */
    function (changes) {
        // set maxDate, minDate if it exists in changes object.
        // else it takes default values defined above.
        if (changes.maxDate) {
            // converting string to Date object.
            /** @type {?} */
            var maxDateObject = new Date(changes.maxDate.currentValue);
            // creating NgbDateStruct model representation out of regular js date object.
            this.maxDate = { year: maxDateObject.getFullYear(), month: maxDateObject.getMonth() + 1, day: maxDateObject.getDate() };
        }
        if (changes.minDate) {
            // converting string to Date object.
            /** @type {?} */
            var minDateObject = new Date(changes.minDate.currentValue);
            // creating NgbDateStruct model representation out of regular js date object.
            this.minDate = { year: minDateObject.getFullYear(), month: minDateObject.getMonth() + 1, day: minDateObject.getDate() };
        }
    };
    /**
     *
     * writeValue() - Sets the datepickerModel, timePickerModel and startDate according to the date passed in the argument of the function.
     * @param datetimePickerValue - string
     * @returns void
     */
    /**
     *
     * writeValue() - Sets the datepickerModel, timePickerModel and startDate according to the date passed in the argument of the function.
     * @param {?} datetimePickerValue - string
     * @return {?} void
     */
    NwfDatetimePicker.prototype.writeValue = /**
     *
     * writeValue() - Sets the datepickerModel, timePickerModel and startDate according to the date passed in the argument of the function.
     * @param {?} datetimePickerValue - string
     * @return {?} void
     */
    function (datetimePickerValue) {
        if (datetimePickerValue) {
            // converting string to Date object.
            /** @type {?} */
            var dateObject = new Date(datetimePickerValue);
            // creating NgbDateStruct model representation out of regular js date object.
            // we add +1 to month because NgbDateStruct month property takes in value as ISO format ie. month should be between 1-12,
            // whereas getMonth returns month values from 0-11.
            this.datepickerModel = { year: dateObject.getFullYear(), month: dateObject.getMonth() + 1, day: dateObject.getDate() };
            this.startDate = { year: this.datepickerModel.year, month: this.datepickerModel.month };
            // creating NgbTimeStruct model representation out of regular js date object.
            this.timepickerModel = { hour: dateObject.getHours(), minute: dateObject.getMinutes(), second: 0 };
        }
    };
    /**
     * @param {?} fn
     * @return {?}
     */
    NwfDatetimePicker.prototype.registerOnChange = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { this._onChange = fn; };
    /**
     * @param {?} fn
     * @return {?}
     */
    NwfDatetimePicker.prototype.registerOnTouched = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { };
    /**
     * @return {?}
     */
    NwfDatetimePicker.prototype.setDatetime = /**
     * @return {?}
     */
    function () {
        var _a = this.datepickerModel, year = _a.year, month = _a.month, day = _a.day;
        var _b = this.timepickerModel, hour = _b.hour, minute = _b.minute;
        /** @type {?} */
        var newDate = new Date(year, month - 1, day, hour, minute);
        this._onChange(newDate.toISOString());
    };
    NwfDatetimePicker.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-datetime-picker',
                    template: "\n        <ngb-datepicker [(ngModel)]=\"datepickerModel\" [maxDate]=\"maxDate\" [minDate]=\"minDate\" [startDate]=\"startDate\"\n            [navigation]=\"navigation\" firstDayOfWeek=\"7\" (ngModelChange)=\"setDatetime()\"></ngb-datepicker>\n        <div class=\"col my-2 p-0\">\n            <span class=\"label\">{{'nwfjs:time' | i18next}}:</span>\n            <ngb-timepicker [(ngModel)]=\"timepickerModel\" [meridian]=true (ngModelChange)=\"setDatetime()\"></ngb-timepicker>\n        </div>\n    ",
                    providers: [{
                            provide: NG_VALUE_ACCESSOR,
                            useExisting: NwfDatetimePicker,
                            multi: true,
                        }],
                    styles: [".ngb-tp-input-container{color:red}.ngb-tp-input-container .form-control{width:60px}"]
                }] }
    ];
    NwfDatetimePicker.propDecorators = {
        minDate: [{ type: Input }],
        maxDate: [{ type: Input }]
    };
    return NwfDatetimePicker;
}());
if (false) {
    /** @type {?} */
    NwfDatetimePicker.prototype.minDate;
    /** @type {?} */
    NwfDatetimePicker.prototype.maxDate;
    /** @type {?} */
    NwfDatetimePicker.prototype.datepickerModel;
    /** @type {?} */
    NwfDatetimePicker.prototype.timepickerModel;
    /** @type {?} */
    NwfDatetimePicker.prototype.navigation;
    /** @type {?} */
    NwfDatetimePicker.prototype.startDate;
    /**
     * @type {?}
     * @private
     */
    NwfDatetimePicker.prototype._onChange;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/** @type {?} */
var currentDate$1 = new Date();
/** @type {?} */
var last13MonthsDate$1 = new Date(currentDate$1.getTime() - (395 * 24 * 60 * 60 * 1000));
var NwfDatetimeRangePicker = /** @class */ (function () {
    function NwfDatetimeRangePicker() {
        this.minDate = last13MonthsDate$1.toISOString();
        this.maxDate = currentDate$1.toISOString();
    }
    /**
     * @return {?}
     */
    NwfDatetimeRangePicker.prototype.ngOnInit = /**
     * @return {?}
     */
    function () { };
    /**
     * @param {?} changes
     * @return {?}
     */
    NwfDatetimeRangePicker.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) { };
    /**
     * writeValue() - Sets the fromDate and toDate according to the input.
     * @param datetimeRangeValue - any
     * @returns void
     */
    /**
     * writeValue() - Sets the fromDate and toDate according to the input.
     * @param {?} datetimeRangeValue - any
     * @return {?} void
     */
    NwfDatetimeRangePicker.prototype.writeValue = /**
     * writeValue() - Sets the fromDate and toDate according to the input.
     * @param {?} datetimeRangeValue - any
     * @return {?} void
     */
    function (datetimeRangeValue) {
        var _a;
        if (datetimeRangeValue) {
            _a = __read(datetimeRangeValue.split('~'), 2), this.fromDateISOString = _a[0], this.toDateISOString = _a[1];
            // setting visible value.
            this.setVisibleValue();
        }
    };
    /**
     * @param {?} fn
     * @return {?}
     */
    NwfDatetimeRangePicker.prototype.registerOnChange = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { this._onChange = fn; };
    /**
     * @param {?} fn
     * @return {?}
     */
    NwfDatetimeRangePicker.prototype.registerOnTouched = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { };
    /**
     * setDatetimeRange() - Sets the fromDate and toDate from the ISOStrings
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @param changes - SimpleChanges
     * @returns void
     */
    /**
     * setDatetimeRange() - Sets the fromDate and toDate from the ISOStrings
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @return {?} void
     */
    NwfDatetimeRangePicker.prototype.setDatetimeRange = /**
     * setDatetimeRange() - Sets the fromDate and toDate from the ISOStrings
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @return {?} void
     */
    function () {
        // setting visible value.
        this.setVisibleValue();
        if (!this.emitChangeOnApply) {
            this.emitChange();
        }
    };
    /**
     * @return {?}
     */
    NwfDatetimeRangePicker.prototype.setVisibleValue = /**
     * @return {?}
     */
    function () {
        this.fromDate = new Date(this.fromDateISOString);
        this.toDate = new Date(this.toDateISOString);
    };
    /**
     * Emits the new range on click of apply btn , and close the dropdown
     */
    /**
     * Emits the new range on click of apply btn , and close the dropdown
     * @return {?}
     */
    NwfDatetimeRangePicker.prototype.emitChangeOnApplyClick = /**
     * Emits the new range on click of apply btn , and close the dropdown
     * @return {?}
     */
    function () {
        this.emitChange();
        this.ngbDropDown.close();
    };
    /**
     * Emits the new timerange to the subscriber
     */
    /**
     * Emits the new timerange to the subscriber
     * @private
     * @return {?}
     */
    NwfDatetimeRangePicker.prototype.emitChange = /**
     * Emits the new timerange to the subscriber
     * @private
     * @return {?}
     */
    function () {
        /** @type {?} */
        var newDatetimeRange = this.fromDateISOString + "~" + this.toDateISOString;
        // calling callback with sending the datetime range.
        this._onChange(newDatetimeRange);
    };
    NwfDatetimeRangePicker.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-datetime-range-picker',
                    template: "<div ngbDropdown class=\"d-inline-block\" autoClose=\"outside\" [container]=\"null\" display=\"dynamic\">\n    <button type=\"button\" class=\"btn btn-secondary btn-icon datetime-range-picker-button\" data-netapp-id=\"dateTimePicker-range-btn\"\n        id=\"nwf-grid-filtering\" ngbDropdownToggle>\n        <nwf-icon iconClass=\"icon-action-calendar\"></nwf-icon>\n        <span class=\"btn-icon-label\" data-netapp-id=\"dateTimePicker-widget-label\">\n            {{ fromDate | i18nextFormat: { format: 'datetime' } }} to\n            {{ toDate | i18nextFormat: { format: 'datetime' } }}\n        </span>\n    </button>\n    <div ngbDropdownMenu aria-labelledby=\"nwf-grid-filtering\" class=\"popover-body bg-white\">\n        <nwf-popover-title (onDismiss)=\"ngbDropDown.close()\"></nwf-popover-title>\n        <div class=\"d-flex\" data-netapp-id=\"datetime-range-picker\">\n            <div class=\"p-2 d-flex flex-column\" (click)=\"$event.stopPropagation()\"\n                data-netapp-id=\"datetime-from-picker\">\n                {{'nwfjs:from' | i18next}}\n                <nwf-datetime-picker [(ngModel)]=\"fromDateISOString\" [minDate]=\"minDate\" [maxDate]=\"toDateISOString\"\n                    (ngModelChange)=\"setDatetimeRange()\"></nwf-datetime-picker>\n            </div>\n            <div class=\"p-2 d-flex flex-column\" (click)=\"$event.stopPropagation()\" data-netapp-id=\"datetime-to-picker\">\n                {{'nwfjs:to' | i18next}}\n                <nwf-datetime-picker [(ngModel)]=\"toDateISOString\" [minDate]=\"fromDateISOString\" [maxDate]=\"maxDate\"\n                    (ngModelChange)=\"setDatetimeRange()\"></nwf-datetime-picker>\n            </div>\n        </div>\n        <button *ngIf=\"emitChangeOnApply\" class=\"btn btn-primary float-right\" data-netapp-id=\"datetime-range-picker-apply-btn\" (click)=\"emitChangeOnApplyClick()\">{{'nwfjs:apply' | i18next}}</button>\n    </div>\n</div>",
                    providers: [{
                            provide: NG_VALUE_ACCESSOR,
                            useExisting: NwfDatetimeRangePicker,
                            multi: true,
                        }],
                    styles: [".datetime-range-picker-button{min-width:400px}"]
                }] }
    ];
    /** @nocollapse */
    NwfDatetimeRangePicker.ctorParameters = function () { return []; };
    NwfDatetimeRangePicker.propDecorators = {
        ngbDropDown: [{ type: ViewChild, args: [NgbDropdown, { static: false },] }],
        minDate: [{ type: Input }],
        maxDate: [{ type: Input }],
        emitChangeOnApply: [{ type: Input }]
    };
    return NwfDatetimeRangePicker;
}());
if (false) {
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.ngbDropDown;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.minDate;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.maxDate;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.emitChangeOnApply;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.fromDateISOString;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.toDateISOString;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.fromDate;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.toDate;
    /**
     * @type {?}
     * @private
     */
    NwfDatetimeRangePicker.prototype._onChange;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var MultiselectDropdownComponent = /** @class */ (function () {
    function MultiselectDropdownComponent() {
        this.disabled = false;
        this.required = false;
        this._selectedModel = [];
    }
    /**
     * @return {?}
     */
    MultiselectDropdownComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        /* Clone options array for a private model that represents the internal state */
        this._selectedModel = Object.assign([], this.options);
    };
    /**
     * @param {?} value
     * @return {?}
     */
    MultiselectDropdownComponent.prototype.writeValue = /**
     * @param {?} value
     * @return {?}
     */
    function (value) {
        var e_1, _a;
        if (value !== undefined && value !== null) {
            try {
                for (var _b = __values(this._selectedModel), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var option = _c.value;
                    if (value.includes(option.value)) {
                        option.checked = true;
                    }
                    else {
                        option.checked = false;
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
            this.setLabel();
        }
    };
    /**
     * @param {?} $event
     * @return {?}
     */
    MultiselectDropdownComponent.prototype.onCheckboxChange = /**
     * @param {?} $event
     * @return {?}
     */
    function ($event) {
        var e_2, _a;
        var _b = $event.target, value = _b.value, checked = _b.checked;
        try {
            for (var _c = __values(this._selectedModel), _d = _c.next(); !_d.done; _d = _c.next()) {
                var option = _d.value;
                if (option.value === value) {
                    option.checked = checked;
                    break;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_2) throw e_2.error; }
        }
        /** @type {?} */
        var checkedOpts = this._selectedModel.filter((/**
         * @param {?} option
         * @return {?}
         */
        function (option) { return option.checked; }));
        /** @type {?} */
        var onlyTrueValues = checkedOpts.map((/**
         * @param {?} option
         * @return {?}
         */
        function (option) { return option.value; }));
        this._onChange(onlyTrueValues);
        /* Now set my label */
        this.setLabel();
    };
    /**
     * @return {?}
     */
    MultiselectDropdownComponent.prototype.setLabel = /**
     * @return {?}
     */
    function () {
        /** @type {?} */
        var checkedOpts = this._selectedModel.filter((/**
         * @param {?} option
         * @return {?}
         */
        function (option) { return option.checked; }));
        /** @type {?} */
        var label = 'Select one or more';
        if (checkedOpts.length) {
            label = checkedOpts.map((/**
             * @param {?} option
             * @return {?}
             */
            function (option) { return option.label; })).join(', ');
        }
        this.label = label;
    };
    /**
     * @param {?} fn
     * @return {?}
     */
    MultiselectDropdownComponent.prototype.registerOnChange = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) {
        this._onChange = fn;
    };
    /**
     * @param {?} fn
     * @return {?}
     */
    MultiselectDropdownComponent.prototype.registerOnTouched = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { };
    /**
     * @param {?} isDisabled
     * @return {?}
     */
    MultiselectDropdownComponent.prototype.setDisabledState = /**
     * @param {?} isDisabled
     * @return {?}
     */
    function (isDisabled) {
        this.disabled = isDisabled;
    };
    MultiselectDropdownComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-multiselect-dropdown',
                    template: "<div ngbDropdown placement=\"bottom-left\" autoClose=\"outside\">\n    <button class=\"custom-select\" ngbDropdownToggle [disabled]=\"disabled\">\n      {{label}}\n    </button>\n  <div ngbDropdownMenu style=\"width: 100%\">\n    <div class=\"dropdown-checkbox-item pl-4 mb-1\">\n      <div class=\"custom-control custom-checkbox custom-checkbox-lg\" *ngFor=\"let option of _selectedModel\">\n        <input type=\"checkbox\" (change)=\"onCheckboxChange($event)\" [value]=\"option.value\" [checked]=\"option.checked\" [name]=\"option.label\" [id]=\"option.label | NwfStripWhitespacePipe\" class=\"custom-control-input\">\n        <label class=\"custom-control-label w-100\" [attr.for]=\"option.label | NwfStripWhitespacePipe\">{{option.label}}</label>\n      </div>\n    </div>\n  </div>\n</div>",
                    providers: [
                        {
                            provide: NG_VALUE_ACCESSOR,
                            useExisting: forwardRef((/**
                             * @return {?}
                             */
                            function () { return MultiselectDropdownComponent; })),
                            multi: true,
                        },
                    ],
                    styles: [":host ::ng-deep .dropdown-menu{max-height:calc(100vh - 300px);overflow-y:auto}.custom-select{overflow:hidden;text-overflow:ellipsis;text-align:left}"]
                }] }
    ];
    /** @nocollapse */
    MultiselectDropdownComponent.ctorParameters = function () { return []; };
    MultiselectDropdownComponent.propDecorators = {
        options: [{ type: Input }],
        disabled: [{ type: Input }],
        required: [{ type: Input }]
    };
    return MultiselectDropdownComponent;
}());
if (false) {
    /** @type {?} */
    MultiselectDropdownComponent.prototype.options;
    /** @type {?} */
    MultiselectDropdownComponent.prototype.disabled;
    /** @type {?} */
    MultiselectDropdownComponent.prototype.required;
    /** @type {?} */
    MultiselectDropdownComponent.prototype._selectedModel;
    /** @type {?} */
    MultiselectDropdownComponent.prototype.label;
    /**
     * @type {?}
     * @private
     */
    MultiselectDropdownComponent.prototype._onChange;
}
/**
 * @record
 */
function IMultiSelectOption() { }
if (false) {
    /** @type {?} */
    IMultiSelectOption.prototype.label;
    /** @type {?} */
    IMultiSelectOption.prototype.value;
}
/**
 * @record
 */
function IMultiSelectModelOption() { }
if (false) {
    /** @type {?} */
    IMultiSelectModelOption.prototype.checked;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfFormModule = /** @class */ (function () {
    function NwfFormModule() {
    }
    NwfFormModule.decorators = [
        { type: NgModule, args: [{
                    imports: [
                        CommonModule,
                        I18NextModule,
                        FormsModule,
                        NgbDatepickerModule,
                        NgbDropdownModule,
                        NgbPopoverModule,
                        NgbTimepickerModule,
                        NwfjsSharedComponentsModule,
                        NwfjsSharedPipesModule,
                    ],
                    declarations: [MultiselectDropdownComponent, NwfDatetimePicker, NwfDatetimeRangePicker],
                    exports: [MultiselectDropdownComponent, NwfDatetimePicker, NwfDatetimeRangePicker],
                },] }
    ];
    return NwfFormModule;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var CellHeaderComponent = /** @class */ (function () {
    function CellHeaderComponent() {
    }
    /**
     * @param {?} dataCell
     * @param {?} order
     * @return {?}
     */
    CellHeaderComponent.prototype.sortBy = /**
     * @param {?} dataCell
     * @param {?} order
     * @return {?}
     */
    function (dataCell, order) {
        var dataField = dataCell.column.dataField;
        /** @type {?} */
        var dataGrid = dataCell.component;
        dataGrid.beginUpdate();
        dataGrid.clearSorting();
        dataGrid.columnOption(dataField, 'sortOrder', order);
        dataGrid.endUpdate();
        dataGrid.refresh();
    };
    /**
     * @param {?} data
     * @return {?}
     */
    CellHeaderComponent.prototype.filterBy = /**
     * @param {?} data
     * @return {?}
     */
    function (data) {
        data.component.nwfFilteringWidget.addCriterion(data.column);
    };
    CellHeaderComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-headercell-templates',
                    template: "<div *dxTemplate=\"let data of 'nwfHeaderCellTemplate-viewMenu'\" [attr.title]=\"data.column.caption\"\n     [attr.data-netapp-id]=\"'grid-header-cell-' + data.column.dataField\" ngbDropdown class=\"d-inline-block nwf-header-cell\"\n    container=\"body\" display=\"dynamic\" [placement]=\"data.column.alignment == 'right' ? 'bottom-right bottom-left' : 'bottom-left bottom-right'\"\n    [ngClass]=\"{ 'nwf-header-cell-left': data.column.alignment == 'left', 'nwf-header-cell-right': data.column.alignment == 'right' }\">\n    <span *ngIf=\"data.column.allowSorting || data.column.allowFiltering;else caption_without_link\" ngbDropdownToggle class=\"header-link\" id=\"{{data.column.dataField}}\" (click)=\"$event.stopPropagation()\"\n        [ngClass]=\"{ 'justify-content-center': data.column.alignment == 'center', 'justify-content-end': data.column.alignment == 'right' }\">\n        {{data.column.caption}}\n    </span>\n    \n    <div ngbDropdownMenu [attr.aria-labelledby]=\"data.column.dataField\" *ngIf=\"data.column.allowSorting || data.column.allowFiltering\">\n        <button class=\"dropdown-item\" *ngIf=\"data.column.allowSorting\" (click)=\"sortBy(data, 'asc')\">\n            <nwf-icon iconClass=\"icon-columnsort-up\"></nwf-icon><span class=\"ml-2\">{{'nwfjs:sortAsc' | i18next}}</span>\n        </button>\n        <button class=\"dropdown-item\" *ngIf=\"data.column.allowSorting\" (click)=\"sortBy(data, 'desc')\">\n            <nwf-icon iconClass=\"icon-columnsort-down\"></nwf-icon><span class=\"ml-2\">{{'nwfjs:sortDesc' | i18next}}</span>\n        </button>\n        <button class=\"dropdown-item\" (click)=\"filterBy(data)\" *ngIf=\"data.column.allowFiltering\">\n            <nwf-icon iconClass=\"icon-action-filter\" class=\"text-dark\"></nwf-icon><span class=\"ml-2\">{{'nwfjs:filter' | i18next}}</span>\n        </button>\n    </div>\n\n    <ng-template #caption_without_link>\n        <span id=\"{{data.column.dataField}}\" (click)=\"$event.stopPropagation()\" class=\"header\"\n        [ngClass]=\"{ 'justify-content-center': data.column.alignment == 'center', 'justify-content-end': data.column.alignment == 'right' }\">\n        {{data.column.caption}}\n    </span>\n    </ng-template>\n</div>",
                    styles: [".header-link{display:inline-flex;width:inherit;height:inherit;align-items:center}.header-link:hover{cursor:pointer;text-decoration:underline}.header{display:inline-flex;width:inherit;height:inherit;align-items:center}.nwf-header-cell{height:100%;width:100%}.nwf-header-cell.show{background:#eff4ff}.nwf-header-cell-left .header,.nwf-header-cell-left .header-link{padding-left:12px}.nwf-header-cell-right .header,.nwf-header-cell-right .header-link{padding-right:12px}::ng-deep td[role=columnheader]{padding:0!important;height:42px}::ng-deep td[role=columnheader] .dropdown-toggle::after{display:none}::ng-deep td[role=columnheader] .dx-column-indicators{height:100%;display:inline-flex;align-items:center}::ng-deep td[role=columnheader] .dx-sort-indicator{max-width:calc(100% - 27px)}::ng-deep td[role=columnheader] .dx-datagrid-text-content{width:100%;height:100%;margin:0!important}"]
                }] }
    ];
    return CellHeaderComponent;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/* TODO - the 'nwf*cellTemplate' stuff should really be constants since they are shared in the../schema/schema' */
/* nwf-grid-cell-templates
 this component contains all the templates that are common across all the grids.
 Currently it contains templates for checkboxTemplate, metricCellTemplate, dateCellTemplate, statusCellTemplate, and a headerCell template for the view menu
 metric, date cellTemplates are i18n compliant.
*/
var CellsComponent = /** @class */ (function () {
    function CellsComponent() {
        // Output Event handler. This selects a row on the grid.
        this.onRowSelect = new EventEmitter();
    }
    /**
     * @param {?} data
     * @return {?}
     */
    CellsComponent.prototype.onSelect = /**
     * @param {?} data
     * @return {?}
     */
    function (data) {
        // emit the onRowSelect event containing rowData.
        // This event is handled by the consumer.
        this.onRowSelect.emit(data);
    };
    CellsComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-cell-templates',
                    template: "<div *dxTemplate=\"let cellInfo of 'nwfRadioBoxCellTemplate'\">\n    <div class=\"custom-control custom-radio\">\n        <input type=\"radio\" id=\"dx-data-grid-checkid-{{cellInfo.value}}\" data-netapp-id=\"cell-radiobtn\"\n            class=\"custom-control-input\" [value]=\"cellInfo.value\"\n            [checked]=\"cellInfo.component.isRowSelected(cellInfo.key) ? true : null\" (click)=\"onSelect(cellInfo)\">\n        <label class=\"custom-control-label\" for=\"dx-data-grid-checkid-{{cellInfo.value}}\"></label>\n    </div>\n</div>\n\n<div *dxTemplate=\"let cellInfo of 'nwfNumberCellTemplate'\" [attr.title]=\"cellInfo.value\"\n     attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n    {{cellInfo.value | i18nextFormat : { format: 'number'} }}\n</div>\n\n<div *dxTemplate=\"let cellInfo of 'nwfDateCellTemplate'\" [attr.title]=\"cellInfo.value\"\n     attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n    {{cellInfo.value | i18nextFormat : { format: 'datetime' } }}\n</div>\n\n<div *dxTemplate=\"let cellInfo of 'nwfStatusCellTemplate'\"\n     attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n    <nwf-icon ontapSeverity=\"true\" [severity]=\"cellInfo.value\"></nwf-icon>\n</div>\n\n<div *dxTemplate=\"let cellInfo of 'nwfMetricCellTemplate'\" [attr.title]=\"cellInfo.value\"\n     attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n    {{cellInfo.value | NwfRoundUnit : {unit: cellInfo.column.unit, statType: cellInfo.column.name} }}\n</div>\n\n<div *dxTemplate=\"let cellInfo of 'nwfDefaultCellTemplate'\" [attr.title]=\"cellInfo.value\"\n    attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n    {{cellInfo.value}}\n</div>\n"
                }] }
    ];
    /** @nocollapse */
    CellsComponent.ctorParameters = function () { return []; };
    CellsComponent.propDecorators = {
        onRowSelect: [{ type: Output }]
    };
    return CellsComponent;
}());
if (false) {
    /** @type {?} */
    CellsComponent.prototype.onRowSelect;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var ColumnVisibilityComponent = /** @class */ (function () {
    function ColumnVisibilityComponent() {
        this.orderedColumns = []; // our array of the columns in asc order
        // our array of the columns in asc order
        this.visible = {}; // our map of visiblity true / false
    }
    /**
     * @return {?}
     */
    ColumnVisibilityComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
    };
    /**
     * @return {?}
     */
    ColumnVisibilityComponent.prototype.ngAfterViewInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        this.myDrop.openChange.subscribe((/**
         * @param {?} dropdownState
         * @return {?}
         */
        function (dropdownState) {
            // dropdownState = true means dropdown is open.
            if (dropdownState) {
                _this.gridInstance = _this.dataGrid.instance;
                _this.setColumns();
            }
        }));
    };
    /**
     * @return {?}
     */
    ColumnVisibilityComponent.prototype.setColumns = /**
     * @return {?}
     */
    function () {
        var _this = this;
        /** @type {?} */
        var columns = this.getAllColumnsOnDxGrid();
        // Remove all columns that are not shown in the column chooser
        /** @type {?} */
        var shownColumns = filter(columns, (/**
         * @param {?} col
         * @return {?}
         */
        function (col) { return col.hasOwnProperty('showInColumnChooser') ? col.showInColumnChooser : true; }));
        // we sort columns alphabettically for display.
        /** @type {?} */
        var columnsInVisibleIndexOrder = sortBy(shownColumns, [(/**
             * @param {?} dxColumn
             * @return {?}
             */
            function (dxColumn) { return dxColumn.caption; })]);
        columnsInVisibleIndexOrder.forEach((/**
         * @param {?} __0
         * @param {?} index
         * @return {?}
         */
        function (_a, index) {
            var dataField = _a.dataField;
            /** @type {?} */
            var colObj = _this.gridInstance.columnOption(dataField);
            _this.visible[dataField] = colObj.visible;
            /*
            we update visibleIndex to actual index of columns in visibleIndex order.
            this ensures we dont have holes in between as shownColumns might contain columns not in order.
            */
            colObj.visibleIndex = index;
            _this.orderedColumns[colObj.visibleIndex] = colObj;
        }));
        // Below updated required to reset column width if its changed by user
        this.gridInstance.beginUpdate();
        shownColumns.forEach((/**
         * @param {?} colItem
         * @return {?}
         */
        function (colItem) {
            _this.gridInstance.columnOption(colItem.dataField, 'width', null);
        }));
        this.gridInstance.endUpdate();
    };
    /**
     * @param {?} event
     * @param {?} col
     * @return {?}
     */
    ColumnVisibilityComponent.prototype.notify = /**
     * @param {?} event
     * @param {?} col
     * @return {?}
     */
    function (event, col) {
        // we filter out command(eg checkbox column) columns as visibility only operates on non-command columns.
        // This ensures we dont toggle the visibility of checkbox column.
        /** @type {?} */
        var visibleColumns = this.gridInstance.getVisibleColumns().filter((/**
         * @param {?} item
         * @return {?}
         */
        function (item) { return !item.command; }));
        /*
        if we have more than one visible column, or we are showing a column,
        only then we toggle the visibility of the column.
        this ensures we never run into case of having all hidden columns.
        */
        if (visibleColumns.length > 1 || event.target.checked) {
            this.gridInstance.beginUpdate();
            this.gridInstance.columnOption(col, 'visible', event.target.checked);
            this.gridInstance.endUpdate();
        }
        else {
            // this ensures the last checkbox remains checked.
            // so that we can never have all checkbox as unchecked i.e. all columns are unselected/hidden.
            event.target.checked = true;
        }
    };
    /*** We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
       * gridInstance.columnOption gives a complete column object (including default column settings),
       * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
       */
    /**
     * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
     * gridInstance.columnOption gives a complete column object (including default column settings),
     * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
     * @private
     * @return {?}
     */
    ColumnVisibilityComponent.prototype.getAllColumnsOnDxGrid = /**
     * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
     * gridInstance.columnOption gives a complete column object (including default column settings),
     * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
     * @private
     * @return {?}
     */
    function () {
        /** @type {?} */
        var gridInstance = this.gridInstance;
        /** @type {?} */
        var columnsViaOptions = gridInstance && gridInstance.state().columns;
        if (columnsViaOptions) {
            return columnsViaOptions.map((/**
             * @param {?} __0
             * @return {?}
             */
            function (_a) {
                var dataField = _a.dataField;
                return gridInstance.columnOption(dataField);
            }));
        }
        else {
            return;
        }
    };
    ColumnVisibilityComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-column-visibility',
                    template: "<div ngbDropdown class=\"d-inline-block\" placement=\"bottom-right\" display=\"dynamic\" autoClose=\"outside\">\n  <button type=\"button\" class=\"btn btn-flat btn-sm btn-icon\" ngbDropdownToggle>\n    <nwf-icon iconClass=\"icon-view-visible\"></nwf-icon><span\n      class=\"btn-icon-label\">{{'nwfjs:showHide' | i18next}}</span>\n  </button>\n  <div ngbDropdownMenu>\n    <dx-scroll-view>\n      <div class=\"dropdown-checkbox-item pl-4 mb-1\" *ngFor=\"let column of orderedColumns\">\n        <div class=\"custom-control custom-checkbox\" *ngIf=\"column.allowHiding !== false\">\n          <input type=\"checkbox\" [name]=\"column.dataField\" [id]=\"column.dataField\" class=\"custom-control-input\"\n            [(ngModel)]=\"visible[column.dataField]\" (change)=\"notify($event, column.dataField)\">\n          <label class=\"custom-control-label w-100\" [attr.for]=\"column.dataField\" data-netapp-id=\"nwf-column-visibility-option-label\">{{column.caption}}</label>\n        </div>\n      </div>\n    </dx-scroll-view>\n  </div>\n</div>",
                    styles: [":host ::ng-deep .dx-scrollable-container{max-height:50vh}.dropdown-menu{padding-top:20px;padding-bottom:20px;max-height:60vh}.dropdown-checkbox-item{margin-right:20px}.custom-control-label{cursor:pointer;white-space:nowrap}"]
                }] }
    ];
    /** @nocollapse */
    ColumnVisibilityComponent.ctorParameters = function () { return []; };
    ColumnVisibilityComponent.propDecorators = {
        myDrop: [{ type: ViewChild, args: [NgbDropdown, { static: false },] }],
        dataGrid: [{ type: Input }]
    };
    return ColumnVisibilityComponent;
}());
if (false) {
    /** @type {?} */
    ColumnVisibilityComponent.prototype.myDrop;
    /** @type {?} */
    ColumnVisibilityComponent.prototype.gridInstance;
    /** @type {?} */
    ColumnVisibilityComponent.prototype.orderedColumns;
    /** @type {?} */
    ColumnVisibilityComponent.prototype.visible;
    /** @type {?} */
    ColumnVisibilityComponent.prototype.dataGrid;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/** @type {?} */
var containsOptions = [{
        name: 'nwfjs:contains', value: 'contains',
    }, {
        name: 'nwfjs:startsWith', value: 'startswith',
    }];
/** @type {?} */
var resourceContainsOptions = [{
        name: 'nwfjs:nameContains', value: 'contains',
    }, {
        name: 'nwfjs:nameStartsWith', value: 'startswith',
    }];
/** @type {?} */
var isOption = { name: 'nwfjs:is', value: '=' };
/** @type {?} */
var booleanOptions = [
    isOption,
    { name: 'nwfjs:isNot', value: '<>' },
];
/** @type {?} */
var numericOptions = [{
        name: 'nwfjs:greaterThan', value: '>',
    }, {
        name: 'nwfjs:lessThan', value: '<',
    }];
var FilterConfig = {
    'string': {
        inputType: 'text',
        options: containsOptions,
    },
    'associatedobjects': {
        inputType: 'text',
        options: containsOptions,
    },
    'volumetype': {
        inputType: 'select',
        options: [
            isOption,
        ],
    },
    'resource': {
        inputType: 'text',
        options: resourceContainsOptions,
    },
    'resource_null': {
        inputType: 'text',
        options: __spread(resourceContainsOptions, [{ name: 'nwfjs:is', value: '=', default: 'null' },
            { name: 'nwfjs:isNot', value: '<>', default: 'null' },]),
    },
    'metric': {
        inputType: 'number',
        options: numericOptions,
    },
    'enum': {
        inputType: 'select',
        options: booleanOptions,
    },
    'enum-single': {
        inputType: 'select',
        options: [
            isOption,
        ],
    },
    'enum-multiple': {
        inputType: 'multiselect',
        options: booleanOptions,
    },
    'number': {
        inputType: 'number',
        options: numericOptions,
    },
    'datetime': {
        inputType: 'dateTime',
        options: [{
                name: 'nwfjs:inTheLast', value: 'lst',
            }, {
                name: 'nwfjs:between', value: 'between',
            }, {
                name: 'nwfjs:greaterThan', value: '>=',
            }, {
                name: 'nwfjs:lessThan', value: '<=',
            }],
    },
};

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * A filter criterion consist of filter property, operator and a value.
 * Each filter-property have a list of operators.
 * Filter criterion row gets a critierion(filter) from parent filterGroup, and it breaks that criterion down into property, operator and a value.
 * Filter property and type means same thing and are interchangeable
 */
var FilterCriterionRowComponent = /** @class */ (function () {
    function FilterCriterionRowComponent() {
        this.deleteCriterion = new EventEmitter();
        this.config = FilterConfig;
    }
    /**
     * @return {?}
     */
    FilterCriterionRowComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        // on birth, we set the operator and value based on incoming filter property.
        this.setColumnBasedOnCriteria();
    };
    /**
     * @description method to set the operator and value of a particular criterion when property dropdown value is changed.
     * Whenever we change the filter property, we update the operator and reset the value associated with the filter, so that we can start fresh for the new filter.
     * @param id
     */
    /**
     * \@description method to set the operator and value of a particular criterion when property dropdown value is changed.
     * Whenever we change the filter property, we update the operator and reset the value associated with the filter, so that we can start fresh for the new filter.
     * @return {?}
     */
    FilterCriterionRowComponent.prototype.updateCriterion = /**
     * \@description method to set the operator and value of a particular criterion when property dropdown value is changed.
     * Whenever we change the filter property, we update the operator and reset the value associated with the filter, so that we can start fresh for the new filter.
     * @return {?}
     */
    function () {
        // updating the new criterion.
        this.setColumnBasedOnCriteria();
        // resetting the form group with default criteria.
        this.criteria.reset(this.initCriterion(this.selectedColumn));
    };
    /**
     * @param {?} change
     * @return {?}
     */
    FilterCriterionRowComponent.prototype.updateOperator = /**
     * @param {?} change
     * @return {?}
     */
    function (change) {
        var _this = this;
        /** @type {?} */
        var selectedOperator = change.target.value;
        // If there is a default value associate with the selected operator we want to set the criteria to have that value
        /** @type {?} */
        var defaultValue = find(this.config[this.selectedColumn.dataType].options, (/**
         * @param {?} option
         * @return {?}
         */
        function (option) { return option.value === selectedOperator; })).default;
        if (defaultValue) {
            this.criteria.reset({ property: this.selectedColumn.dataField, operator: selectedOperator, value: defaultValue });
            // If the current value of the criteria is the same as the default value associated with the previous operator we want to clear it away
        }
        else if (this.previousOperator &&
            find(this.config[this.selectedColumn.dataType].options, (/**
             * @param {?} option
             * @return {?}
             */
            function (option) { return option.value === _this.previousOperator; })).default === this.criteria.controls.value.value) {
            this.criteria.reset({ property: this.selectedColumn.dataField, operator: selectedOperator, value: '' });
        }
        this.previousOperator = selectedOperator;
    };
    /**
     * Method to get the default filter critierion based on filter property.
     * @param property Filter property (type)
     */
    /**
     * Method to get the default filter critierion based on filter property.
     * @private
     * @param {?} __0
     * @return {?}
     */
    FilterCriterionRowComponent.prototype.initCriterion = /**
     * Method to get the default filter critierion based on filter property.
     * @private
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var dataField = _a.dataField, dataType = _a.dataType;
        this.previousOperator = this.config[dataType].options[0].value;
        return {
            property: dataField,
            operator: this.config[dataType].options[0].value,
            value: '',
        };
    };
    /**
     * This method finds the property to be set to individual criterion
     * from properties passed-in.
     */
    /**
     * This method finds the property to be set to individual criterion
     * from properties passed-in.
     * @private
     * @return {?}
     */
    FilterCriterionRowComponent.prototype.setColumnBasedOnCriteria = /**
     * This method finds the property to be set to individual criterion
     * from properties passed-in.
     * @private
     * @return {?}
     */
    function () {
        var _this = this;
        // update property based on new selection.
        this.selectedColumn = this.dxColumns.filter((/**
         * @param {?} prop
         * @return {?}
         */
        function (prop) {
            return prop.dataField === _this.criteria.value.property;
        }))[0];
        // update prevoious operator based on criteria
        this.previousOperator = this.criteria.controls.operator.value;
        // updating operator list based on new filter property.
        this.propertyTypeConfig = this.config[this.selectedColumn.dataType];
    };
    FilterCriterionRowComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-filter-criterion-row',
                    template: "<div [formGroup]=\"criteria\" class=\"d-flex mb-2 w-100\">\n\n    <!-- Property -->\n    <div class=\"filter-criterion-control mr-2\">\n        <select class=\"custom-select\" data-netapp-id=\"filter-widget-select-type\" (change)=\"updateCriterion()\"\n            formControlName=\"property\">\n            <option *ngFor=\"let dxColumn of dxColumns\" [value]=\"dxColumn.dataField\">{{dxColumn.caption}}</option>\n        </select>\n    </div>\n\n    <!-- Operator -->\n    <div class=\"filter-criterion-control mr-2\">\n        <select class=\"custom-select\" data-netapp-id=\"filter-widget-select-operator\" (change)=\"updateOperator($event)\"\n            formControlName=\"operator\">\n            <option *ngFor=\"let operator of propertyTypeConfig.options\" [value]=\"operator.value\">\n                {{operator.name | i18next}}\n            </option>\n        </select>\n    </div>\n\n    <!-- Value -->\n    <div class=\"filter-criterion-control mr-2\" [ngSwitch]=\"propertyTypeConfig.inputType\">\n        <div *ngSwitchCase=\"'text'\" class=\"align-items-center\">\n            <input type=\"text\"\n                [hidden]=\"criteria.controls.operator.value === '<>' || criteria.controls.operator.value === '='\"\n                class=\"form-control filter-criterion-control\" required data-netapp-id=\"filter-searchText\"\n                formControlName=\"value\">\n            <div *ngIf=\"criteria.controls.operator.value === '<>' || criteria.controls.operator.value === '='\"\n                class=\"form-control\">\n                {{'nwfjs:empty' | i18next}}\n            </div>\n        </div>\n\n        <div *ngSwitchCase=\"'number'\" class=\"d-flex align-items-center\">\n            <input type=\"number\" *ngSwitchCase=\"'number'\" class=\"form-control filter-criterion-control\" required\n                data-netapp-id=\"filter-searchText\" formControlName=\"value\" step=\"any\">\n            <!-- unit -->\n            <div class=\"px-2\" *ngIf=\"selectedColumn.unit\" data-netapp-id=\"filter-widget-unit\">{{selectedColumn.unit}}\n            </div>\n        </div>\n        <select class=\"custom-select filter-criterion-control\" data-netapp-id=\"filter-widget-property-options\" required\n            formControlName=\"value\" *ngSwitchCase=\"'select'\">\n            <option [selected]=\"!criteria.value\" value>{{'nwfjs:choose' | i18next}}</option>\n            <option [selected]=\"criteria.value.value == option.id\" *ngFor=\"let option of selectedColumn.editorOptions\"\n                [value]=\"option.id\">{{option.label}}\n            </option>\n        </select>\n\n        <nwf-grid-filter-multiselect [options]=\"selectedColumn.editorOptions\" required *ngSwitchCase=\"'multiselect'\"\n            formControlName=\"value\">\n        </nwf-grid-filter-multiselect>\n\n        <nwf-grid-filter-criterion-date [operator]=\"criteria.controls.operator.value\" *ngSwitchCase=\"'dateTime'\"\n            formControlName=\"value\"></nwf-grid-filter-criterion-date>\n\n        <div *ngIf=\"criteria.invalid && (criteria.controls.value.touched || criteria.controls.value.dirty)\"\n            class=\"invalid-feedback\">\n            <span *ngSwitchCase=\"'select'\">{{'nwfjs:isRequiredInvalidMessage' | i18next}}</span>\n            <span *ngSwitchCase=\"'multiselect'\">{{'nwfjs:isRequiredAtLeastOne' | i18next}}</span>\n            <span *ngSwitchCase=\"'dateTime'\">{{'nwfjs:isInvalidTimeMessage' | i18next}}</span>\n            <span *ngSwitchCase=\"'text'\">{{'nwfjs:isRequiredInvalidMessage' | i18next}}</span>\n            <span *ngSwitchCase=\"'number'\">{{'nwfjs:isNumberInvalidMessage' | i18next}}</span>\n        </div>\n    </div>\n\n    <!-- remove button -->\n    <div class=\"d-flex flex-fill justify-content-end\">\n        <button type=\"button\" class=\"btn btn-icon btn-flat btn-delete-criterion\"\n            data-netapp-id=\"filter-widget-remove-criteria-btn\"\n            (click)=\"deleteCriterion.emit();$event.stopPropagation();\">\n            <nwf-icon iconClass=\"icon-action-delete\"></nwf-icon>\n        </button>\n    </div>\n</div>",
                    styles: ["\n        .filter-criterion-control {\n            min-width: 200px;\n        }\n        .custom-select {\n            width: 200px;\n        }\n        "]
                }] }
    ];
    /** @nocollapse */
    FilterCriterionRowComponent.ctorParameters = function () { return []; };
    FilterCriterionRowComponent.propDecorators = {
        dxColumns: [{ type: Input }],
        criteria: [{ type: Input }],
        deleteCriterion: [{ type: Output }]
    };
    return FilterCriterionRowComponent;
}());
if (false) {
    /** @type {?} */
    FilterCriterionRowComponent.prototype.dxColumns;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.criteria;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.deleteCriterion;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.selectedColumn;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.propertyTypeConfig;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.config;
    /**
     * Track operator changes to set default and remove defaults based on changes
     * @type {?}
     */
    FilterCriterionRowComponent.prototype.previousOperator;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfFilterCriterionDateComponent = /** @class */ (function () {
    function NwfFilterCriterionDateComponent(i18NextPipe) {
        var e_1, _a;
        this.datetime = '';
        // List of default date selections for the user
        this.dateRangeList = [
            { id: 'LAST_1h', label: '' },
            { id: 'LAST_24h', label: '' },
            { id: 'LAST_72h', label: '' },
            { id: 'LAST_7d', label: '' },
            { id: 'LAST_30d', label: '' },
            { id: 'LAST_390d', label: '' },
        ];
        try {
            // i18n the values (displayed label in the drop down)
            for (var _b = __values(this.dateRangeList), _c = _b.next(); !_c.done; _c = _b.next()) {
                var dateRangeList = _c.value;
                // pop in the the label translated (the key is e.g. last_1h)
                dateRangeList.label = i18NextPipe.transform("nwfjs:" + dateRangeList.id.toLowerCase());
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    /**
     * @param {?} changes
     * @return {?}
     */
    NwfFilterCriterionDateComponent.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) {
        // on every operator change, we set the dateTime, dateTimeVisibleValue based on operator value.
        // we can have 3 types of operator.
        // 1. <=, >=, 2. between, 3. in the last(last)
        if (!changes.operator.isFirstChange()) {
            // if current value is <=, >=, we set dateTimeVisibleValue to current Date
            if (['<=', '>='].indexOf(changes.operator.currentValue) !== -1) {
                this.datetime = new Date().toISOString();
                this.datetimeVisibleValue = new Date();
            }
            else if (changes.operator.currentValue === 'between') {
                this.datetime = new Date().toISOString() + "~" + new Date().toISOString();
            }
            else {
                this.datetime = '';
            }
            // sending out new value.
            this.onValueModelChange(this.datetime);
        }
    };
    /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component.This value is pre-set value to datetime widget.
     * @param value
     */
    /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component.This value is pre-set value to datetime widget.
     * @param {?} value
     * @return {?}
     */
    NwfFilterCriterionDateComponent.prototype.writeValue = /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component.This value is pre-set value to datetime widget.
     * @param {?} value
     * @return {?}
     */
    function (value) {
        // we default datetime to last_72h, in case there is no value set.
        this.datetime = value;
        this.datetimeVisibleValue = new Date(this.datetime);
    };
    /**
     * @param {?} fn
     * @return {?}
     */
    NwfFilterCriterionDateComponent.prototype.registerOnChange = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { this._onChange = fn; };
    /**
     * @param {?} fn
     * @return {?}
     */
    NwfFilterCriterionDateComponent.prototype.registerOnTouched = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { };
    /**
     * This method is called whenever model tied to the component changes.
     * This is outgoing value from this widget.
     * @param newModelValue
     */
    /**
     * This method is called whenever model tied to the component changes.
     * This is outgoing value from this widget.
     * @param {?} newDateValue
     * @return {?}
     */
    NwfFilterCriterionDateComponent.prototype.onValueModelChange = /**
     * This method is called whenever model tied to the component changes.
     * This is outgoing value from this widget.
     * @param {?} newDateValue
     * @return {?}
     */
    function (newDateValue) {
        this.datetimeVisibleValue = new Date(newDateValue);
        this._onChange(newDateValue);
    };
    NwfFilterCriterionDateComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-filter-criterion-date',
                    template: "\n    <select class=\"form-control custom-select mr-2\" required data-netapp-id=\"filter-widget-select-operator\" *ngIf=\"operator === 'lst'\"\n    (change)=\"onValueModelChange($event.target.value)\" [(ngModel)]=\"datetime\">\n        <option [selected]=\"!datetime\" value>{{'nwfjs:choose' | i18next}}</option>\n        <option [selected]=\"datetime == dateRange.id\" *ngFor=\"let dateRange of dateRangeList\" [value]=\"dateRange.id\">{{dateRange.label}}</option>\n    </select>\n\n    <div *ngIf=\"operator === 'between'\" (click)=\"$event.stopPropagation()\">\n        <nwf-datetime-range-picker [(ngModel)]=\"datetime\" (ngModelChange)=\"onValueModelChange($event)\"></nwf-datetime-range-picker>\n    </div>\n\n    <div *ngIf=\"operator === '>=' || operator === '<='\" (click)=\"$event.stopPropagation()\">\n        <ng-template #datetimePickerTemplate>\n            <nwf-datetime-picker [(ngModel)]=\"datetime\" (ngModelChange)=\"onValueModelChange($event)\"></nwf-datetime-picker>\n        </ng-template>\n        <button type=\"button\" class=\"d-flex align-items-center form-control\" [ngbPopover]=\"datetimePickerTemplate\" [popoverClass]=\"'max-width-none is-arrowless'\" placement=\"bottom\" data-netapp-id=\"filter-widget-btn\">\n            <nwf-icon iconClass=\"icon-action-calendar\"></nwf-icon>\n            <label data-netapp-id=\"dateTimePicker-widget-label\">{{ datetimeVisibleValue | i18nextFormat: { format: 'datetime' } }}</label>\n        </button>\n    </div>\n    ",
                    providers: [{
                            provide: NG_VALUE_ACCESSOR,
                            useExisting: NwfFilterCriterionDateComponent,
                            multi: true,
                        }]
                }] }
    ];
    /** @nocollapse */
    NwfFilterCriterionDateComponent.ctorParameters = function () { return [
        { type: I18NextPipe }
    ]; };
    NwfFilterCriterionDateComponent.propDecorators = {
        operator: [{ type: Input }]
    };
    return NwfFilterCriterionDateComponent;
}());
if (false) {
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.operator;
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.datetime;
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.datetimeVisibleValue;
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.dateRangeList;
    /**
     * @type {?}
     * @private
     */
    NwfFilterCriterionDateComponent.prototype._onChange;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/** @type {?} */
var nextId = 0;
var FilterMultiselectComponent = /** @class */ (function () {
    function FilterMultiselectComponent() {
        this.id = "nwf-filter-multiselect-" + nextId++;
        this.valueModel = {};
        // the private data used within
        this._optionsIconClasses = [
            'ok',
            'warning',
            'critical',
            'error',
            'information',
        ];
        this._valDelimiter = '|';
    }
    /**
     * @param {?} changes
     * @return {?}
     */
    FilterMultiselectComponent.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) {
        if (changes.options) {
            // I need to intitalize my options
            this.setOptionIcons();
        }
    };
    /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component. This value is pre-set value to multiselect.
     * @param value
     */
    /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component. This value is pre-set value to multiselect.
     * @param {?} value
     * @return {?}
     */
    FilterMultiselectComponent.prototype.writeValue = /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component. This value is pre-set value to multiselect.
     * @param {?} value
     * @return {?}
     */
    function (value) {
        var _this = this;
        if (value) {
            // each multiselect is a string separated by a '|'. So we split the string on '|' to get individual values selected on a multiselect.
            // eg: a|b|c. This translates to a b c should be selected in multiselect widget, hence setting them to true.
            value.split(this._valDelimiter).forEach((/**
             * @param {?} iValue
             * @return {?}
             */
            function (iValue) { return _this.valueModel[iValue] = true; }));
        }
    };
    /**
     * @param {?} fn
     * @return {?}
     */
    FilterMultiselectComponent.prototype.registerOnChange = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { this._onChange = fn; };
    /**
     * @param {?} fn
     * @return {?}
     */
    FilterMultiselectComponent.prototype.registerOnTouched = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { };
    /**
     * This method is called whenever model tied to the component changes. This invoked change handler on the component
     * that can be handled by the widget's consumer.
     * This is outgoing value from this widget.
     */
    /**
     * This method is called whenever model tied to the component changes. This invoked change handler on the component
     * that can be handled by the widget's consumer.
     * This is outgoing value from this widget.
     * @return {?}
     */
    FilterMultiselectComponent.prototype.onValueModelChange = /**
     * This method is called whenever model tied to the component changes. This invoked change handler on the component
     * that can be handled by the widget's consumer.
     * This is outgoing value from this widget.
     * @return {?}
     */
    function () {
        /** @type {?} */
        var vArr = [];
        // looping over the entire object and pulling out keys that have true value
        for (var val in this.valueModel) {
            // filter out keys whose value is false.
            if (!this.valueModel[val]) {
                continue;
            }
            vArr.push(val);
        }
        // joining keys by '|' delimiter.
        this._onChange(vArr.join(this._valDelimiter));
    };
    /**
     * This method sets the icon next to option label.
     * It also sets all checkboxes to false initially.
     */
    /**
     * This method sets the icon next to option label.
     * It also sets all checkboxes to false initially.
     * @return {?}
     */
    FilterMultiselectComponent.prototype.setOptionIcons = /**
     * This method sets the icon next to option label.
     * It also sets all checkboxes to false initially.
     * @return {?}
     */
    function () {
        var _this = this;
        // reset model if options are set.
        this.valueModel = {};
        this.options.map((/**
         * @param {?} option
         * @return {?}
         */
        function (option) {
            /** @type {?} */
            var optionLowercase = option.id.toLowerCase();
            // setting all checkboxes as unchecked initially.
            _this.valueModel[option.id] = false;
            if (_this._optionsIconClasses.indexOf(optionLowercase) !== -1) {
                option.iconClass = optionLowercase;
            }
        }));
    };
    FilterMultiselectComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-filter-multiselect',
                    template: "\n    <div class=\"border border-secondary filter-multiselect-list w-100\">\n        <div data-netapp-id=\"filter-multiselect-list-option\" class=\"d-flex align-items-center p-1 filter-multiselect-list-option\" *ngFor=\"let option of options; let i = index\">\n            <div class=\"custom-control custom-checkbox text-nowrap mt-0\">\n                <input type=\"checkbox\" id=\"{{id}}-{{i}}\" data-netapp-id=\"filter-multiselect-list-option-checkbox\" class=\"custom-control-input p-2\" name=\"filter-multiselect-list-option-checkbox\"  [(ngModel)]=\"valueModel[option.id]\" (change)=\"onValueModelChange()\">\n                <label class=\"custom-control-label d-flex align-items-center\" for=\"{{id}}-{{i}}\">\n                    <nwf-icon ontapSeverity=\"true\" *ngIf=\"option.iconClass\" severity=\"{{option.iconClass}}\" class=\"option-icon\"></nwf-icon>\n                    <span class=\"pl-2\">{{ option.label ? option.label : option.id }}</span>\n                </label>\n            </div>\n        </div>\n    </div>\n    ",
                    providers: [{
                            provide: NG_VALUE_ACCESSOR,
                            useExisting: FilterMultiselectComponent,
                            multi: true,
                        }],
                    styles: [".filter-multiselect-list{max-height:100px;overflow-y:auto}.filter-multiselect-list-option:hover{cursor:pointer}.filter-multiselect-list-option-label{width:170px}"]
                }] }
    ];
    FilterMultiselectComponent.propDecorators = {
        options: [{ type: Input }],
        id: [{ type: Input }]
    };
    return FilterMultiselectComponent;
}());
if (false) {
    /** @type {?} */
    FilterMultiselectComponent.prototype.options;
    /** @type {?} */
    FilterMultiselectComponent.prototype.id;
    /** @type {?} */
    FilterMultiselectComponent.prototype.valueModel;
    /**
     * @type {?}
     * @private
     */
    FilterMultiselectComponent.prototype._optionsIconClasses;
    /**
     * @type {?}
     * @private
     */
    FilterMultiselectComponent.prototype._onChange;
    /**
     * @type {?}
     * @private
     */
    FilterMultiselectComponent.prototype._valDelimiter;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * @record
 */
function ICriterion() { }
if (false) {
    /** @type {?} */
    ICriterion.prototype.property;
    /** @type {?} */
    ICriterion.prototype.operator;
    /** @type {?} */
    ICriterion.prototype.value;
}
var NwfFilterComponent = /** @class */ (function () {
    function NwfFilterComponent(_fb) {
        this._fb = _fb;
        this.nwfFilters = [];
        this.config = FilterConfig;
        this.initialColumns = [];
    }
    /**
     * @return {?}
     */
    NwfFilterComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        this.dataGrid.onContentReady.subscribe((/**
         * @param {?} data
         * @return {?}
         */
        function (data) {
            _this.gridInstance = data.component.instance();
            // I store a reference on the instance so cells/cells-header.ts can find it without another painful binding. Probably useful later.
            _this.gridInstance.nwfFilteringWidget = _this;
            // getting new columns.
            /** @type {?} */
            var columnOnDxGrid = _this.getAllColumnsOnDxGrid().map((/**
             * @param {?} col
             * @return {?}
             */
            function (col) { return col.dataField; }));
            // when intialColumns is set, we compare it with columnsOnDxGrid and
            // and only update intialColumns when its different than columnsOnDxGrid.
            // This happens when we reset the columns on the grid.
            if (_this.initialColumns.length !== 0) {
                /** @type {?} */
                var areColumnsEqual = isEqual(columnOnDxGrid, _this.initialColumns);
                // if new columns different than initialColumns, we reset the filter widget.
                if (!areColumnsEqual) {
                    _this.initialColumns = columnOnDxGrid;
                    // setting the filter widget if columns are not same.
                    _this.setDxGridFilterOnNwfFilterWidget();
                }
            }
            else {
                // setting the initialColumns.
                _this.initialColumns = columnOnDxGrid;
                // setting the filter widget for the first time.
                _this.setDxGridFilterOnNwfFilterWidget();
            }
        }));
    };
    /**
     * @return {?}
     */
    NwfFilterComponent.prototype.ngAfterViewInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        /* I listen for the dropdown opening in order to initialize it lazily, only the first time we are opened. The subscription is cleaned up automatically. */
        this.ngbDropDown.openChange.pipe(first()).subscribe((/**
         * @param {?} isOpen
         * @return {?}
         */
        function (isOpen) {
            if (isOpen) {
                _this.initPopover();
            }
        }));
    };
    /**
     * @description adds a new default criterion on click of "Add Filter" button, or being called externally
     */
    /**
     * \@description adds a new default criterion on click of "Add Filter" button, or being called externally
     * @param {?=} schemaColumnObject
     * @return {?}
     */
    NwfFilterComponent.prototype.addCriterion = /**
     * \@description adds a new default criterion on click of "Add Filter" button, or being called externally
     * @param {?=} schemaColumnObject
     * @return {?}
     */
    function (schemaColumnObject) {
        // we dont have filterFormGrp, if there is no filter applied, and we open the filter from a column header.
        if (!this.filterFormGrp) {
            /** @type {?} */
            var tempFormArray = [];
            // filterFormGrp consists of array of criterions.
            this.setFilterFormGrp(tempFormArray);
        }
        // we get reference of criterions array.
        /** @type {?} */
        var formArray = this.getCriterionsArray();
        /** @type {?} */
        var criterion;
        // if we send schemaColumnObject, we create a criterion and add that criterion to formArray.
        if (schemaColumnObject) {
            criterion = {
                property: schemaColumnObject.dataField,
                operator: this.getOperatorOptions(schemaColumnObject.dataType)[0].value,
                value: '',
            };
        }
        formArray.push(this.initCriterion(criterion));
        // I open the popover if its closed.
        if (!this.ngbDropDown.isOpen()) {
            this.ngbDropDown.open();
        }
    };
    /**
     * @description deletes a criterion from current criterion, else deletes all the applied criterion. Invoked on clicking Trash icon.
     * @param id
     */
    /**
     * \@description deletes a criterion from current criterion, else deletes all the applied criterion. Invoked on clicking Trash icon.
     * @param {?} criterionIndex
     * @return {?}
     */
    NwfFilterComponent.prototype.deleteCriterion = /**
     * \@description deletes a criterion from current criterion, else deletes all the applied criterion. Invoked on clicking Trash icon.
     * @param {?} criterionIndex
     * @return {?}
     */
    function (criterionIndex) {
        // delete criterion from formArray.
        /** @type {?} */
        var formArray = this.getCriterionsArray();
        // when we have more than 1 criteria, this means we only delete the criterion at that index passed-in
        if (formArray.length > 1) {
            // deleting criterion from fromArray (formArray is array of criterion)
            formArray.removeAt(criterionIndex);
        }
        else {
            // this case applies, when we delete the only available criterion in the filter.
            // this means delete single/last criterion = filter reset.
            this.reset();
        }
    };
    /**
     * @description deletes all the criterion.
     */
    /**
     * \@description deletes all the criterion.
     * @return {?}
     */
    NwfFilterComponent.prototype.reset = /**
     * \@description deletes all the criterion.
     * @return {?}
     */
    function () {
        // reset the formArray, so that form will come fresh on hitting filter button again.
        this.filterFormGrp = this._fb.group({
            criterion: new FormArray([]),
        });
        // clear existing filters and update it on gridInstance.
        this.apply();
        // We are done with this formGroup, so we set it to null.
        // On reopening this filter widget -  we set the formGroup again.
        this.filterFormGrp = null;
        // re-initialize the popover.
        this.initPopover();
    };
    /**
     * @description applies the filter on dx grid instance on hitting Apply button.
     */
    /**
     * \@description applies the filter on dx grid instance on hitting Apply button.
     * @return {?}
     */
    NwfFilterComponent.prototype.apply = /**
     * \@description applies the filter on dx grid instance on hitting Apply button.
     * @return {?}
     */
    function () {
        // We touch all formGroups to ensure validation is invoked without manually touching them.
        this.validateAllFormFields(this.filterFormGrp.controls.criterion['controls']);
        // When we click on the submit button, we want to submit the form only if it is valid.
        // To validate all form fields, we need to iterate throughout all form controls and mark them as touched.
        if (this.filterFormGrp.valid) {
            // set new filters on the grid.
            this.setFiltersOnDxGridInstance();
            // closing the popover.
            this.ngbDropDown.close();
        }
    };
    /**
     * @description cancel on hitting 'Cancel' button.
     */
    /**
     * \@description cancel on hitting 'Cancel' button.
     * @return {?}
     */
    NwfFilterComponent.prototype.cancel = /**
     * \@description cancel on hitting 'Cancel' button.
     * @return {?}
     */
    function () {
        // we want to reset the filter widget to the previous state, without submitting any pending changes.
        // we leverage 'createFormGroup' method to set filterWidget state.
        this.createFormGroup();
        // closing the popover.
        this.ngbDropDown.close();
        // We are done with this formGroup, so we set it to null.
        // On reopening this filter widget -  we set the formGroup again.
        this.filterFormGrp = null;
    };
    /**
     * @private
     * @return {?}
     */
    NwfFilterComponent.prototype.initPopover = /**
     * @private
     * @return {?}
     */
    function () {
        // when we initialize the popover, and we dont have any filters applied, we create a new filterForm and add an initial criteria to it.
        if (this.nwfFilters.length === 0 && !this.filterFormGrp) {
            /** @type {?} */
            var tempFormArray = [];
            // add default criterion.
            tempFormArray.push(this.initCriterion());
            // filterFormGrp consists of array of criterions.
            this.setFilterFormGrp(tempFormArray);
        }
    };
    /**
     * @private
     * @return {?}
     */
    NwfFilterComponent.prototype.setDxGridFilterOnNwfFilterWidget = /**
     * @private
     * @return {?}
     */
    function () {
        // get columns from gridInstance.
        /** @type {?} */
        var gridDxColumns = this.getAllColumnsOnDxGrid();
        // columns having allowFiltering as true are only allowed in the filter widget. they are sorted alphabettically by caption field.
        this.filterableColumns = sortBy(gridDxColumns.filter((/**
         * @param {?} dxColumn
         * @return {?}
         */
        function (dxColumn) { return (dxColumn.allowFiltering && dxColumn.showInColumnChooser); })), [(/**
             * @param {?} dxColumn
             * @return {?}
             */
            function (dxColumn) { return dxColumn.caption; })]);
        /** @type {?} */
        var dxGridFilter = this.gridInstance.state().filterValue || [];
        // set value on filter widget.
        this.dxToNwfFilterConverter(dxGridFilter);
        // create the filter form group - its a group of filter criterion.
        this.createFormGroup();
    };
    /**
     * Creates the form that holds all the filter criterion as formControl inside it.
     * FormGroup holds the state of the filter widget.
     */
    /**
     * Creates the form that holds all the filter criterion as formControl inside it.
     * FormGroup holds the state of the filter widget.
     * @private
     * @return {?}
     */
    NwfFilterComponent.prototype.createFormGroup = /**
     * Creates the form that holds all the filter criterion as formControl inside it.
     * FormGroup holds the state of the filter widget.
     * @private
     * @return {?}
     */
    function () {
        var _this = this;
        /** @type {?} */
        var tempFormArray = [];
        // if  nwfFilters, that means filter is preset,
        if (this.nwfFilters.length > 0) {
            // each nwf filter is represented as a criterion in filter widget.
            // so now, we loop over all nwfFilters and create criterion for each of them,
            // and push them into formArray.
            this.nwfFilters.forEach((/**
             * @param {?} c
             * @return {?}
             */
            function (c) {
                tempFormArray.push(_this.initCriterion(c));
            }));
            // filterFormGrp consists of array of criterions.
            this.setFilterFormGrp(tempFormArray);
        }
    };
    /**
     * @private
     * @param {?} formArray
     * @return {?}
     */
    NwfFilterComponent.prototype.setFilterFormGrp = /**
     * @private
     * @param {?} formArray
     * @return {?}
     */
    function (formArray) {
        // filterFormGrp consists of array of crtierions.
        this.filterFormGrp = this._fb.group({
            criterion: new FormArray(formArray),
        });
    };
    /**
     * Method to create a new filter criterion. Each filter criterion is form group of 3 form controls.
     * 1. property, 2. operator, 3. value.
     * @param criterion new filter criterion
     */
    /**
     * Method to create a new filter criterion. Each filter criterion is form group of 3 form controls.
     * 1. property, 2. operator, 3. value.
     * @private
     * @param {?=} criterion new filter criterion
     * @return {?}
     */
    NwfFilterComponent.prototype.initCriterion = /**
     * Method to create a new filter criterion. Each filter criterion is form group of 3 form controls.
     * 1. property, 2. operator, 3. value.
     * @private
     * @param {?=} criterion new filter criterion
     * @return {?}
     */
    function (criterion) {
        if (criterion === void 0) { criterion = this.getCriterionObject(); }
        // creating a form group that contains formControl for filter-criterion-row component.
        return this._fb.group({
            property: new FormControl(criterion.property),
            operator: new FormControl(criterion.operator),
            value: new FormControl(criterion.value),
        });
    };
    /**
     * @private
     * @return {?}
     */
    NwfFilterComponent.prototype.getCriterionsArray = /**
     * @private
     * @return {?}
     */
    function () {
        return (/** @type {?} */ (this.filterFormGrp.get('criterion')));
    };
    /**
     * @private
     * @param {?} formControls
     * @return {?}
     */
    NwfFilterComponent.prototype.validateAllFormFields = /**
     * @private
     * @param {?} formControls
     * @return {?}
     */
    function (formControls) {
        // We mark all formControl as 'touched' programatically,
        // This makes sure Angular validation is triggered for every formControl without
        // touching it manually.
        formControls.forEach((/**
         * @param {?} formGroup
         * @return {?}
         */
        function (formGroup) {
            for (var field in formGroup.controls) {
                if (formGroup.controls.hasOwnProperty(field)) {
                    /** @type {?} */
                    var control = formGroup.get(field);
                    if (control instanceof FormControl) {
                        control.markAsTouched({ onlySelf: true });
                    }
                }
            }
        }));
    };
    /**
     * @private
     * @return {?}
     */
    NwfFilterComponent.prototype.setFiltersOnDxGridInstance = /**
     * @private
     * @return {?}
     */
    function () {
        var _this = this;
        // set new filters on gridInstance.
        /** @type {?} */
        var dxFilters = [];
        // start updating the grid instance.
        this.dataGrid.instance.beginUpdate();
        // clearing the existing filters(if any).
        this.dataGrid.instance.option('filterValue', null);
        // this.dataGrid.instance.clearFilter();
        // we loop over filter form group and create an array containing filters in dx compatible format.
        this.filterFormGrp.get('criterion').value.forEach((/**
         * @param {?} criterion
         * @param {?} index
         * @param {?} array
         * @return {?}
         */
        function (criterion, index, array) {
            // tslint:disable-next-line: prefer-const
            var property = criterion.property, operator = criterion.operator, value = criterion.value;
            /** @type {?} */
            var column = _this.getPropertyById(property);
            switch (column.dataType.toLowerCase()) {
                case 'datetime':
                case 'date':
                    switch (operator) {
                        case 'between':
                            var _a = __read(value.split('~'), 2), fromDateISOString = _a[0], toDateISOString = _a[1];
                            value = [new Date(fromDateISOString), new Date(toDateISOString)];
                            break;
                        case '<=':
                        case '>=':
                            // we convert the value into JS date object, because in this case the value returned from datetime widget is an ISO string.
                            value = new Date(value);
                            break;
                        default:
                            break;
                    }
                    break;
                case 'enum-multiple':
                    /** @type {?} */
                    var possibleValues = value.split('|');
                    if (operator === '<>') {
                        operator = 'noneof';
                    }
                    else {
                        operator = 'anyof';
                    }
                    value = possibleValues;
                    break;
                default:
                    break;
            }
            //
            if (array.length === 1) {
                dxFilters.push(property);
                dxFilters.push(operator);
                dxFilters.push(value);
            }
            else {
                dxFilters.push([property, operator, value]);
                if (index < array.length - 1) {
                    dxFilters.push('and');
                }
            }
        }));
        // set filters on gridInstance.
        this.dataGrid.instance.option('filterValue', dxFilters);
        // update nwfFilters with new filters applied.
        // this ensures count shown on filter widget is updated, when new filters are applied.
        this.dxToNwfFilterConverter(dxFilters);
        // end update. this is now gonna fire loadOptions call with new filters.
        this.dataGrid.instance.endUpdate();
    };
    /**
     * @private
     * @return {?}
     */
    NwfFilterComponent.prototype.getCriterionObject = /**
     * @private
     * @return {?}
     */
    function () {
        /** @type {?} */
        var firstParam = this.filterableColumns[0];
        return {
            property: firstParam.dataField,
            operator: this.getOperatorOptions(firstParam.dataType)[0].value,
            value: '',
        };
    };
    /**
     * @description fetch the property from the original params passed into the widget.
     * @param id
     */
    /**
     * \@description fetch the property from the original params passed into the widget.
     * @private
     * @param {?} id
     * @return {?}
     */
    NwfFilterComponent.prototype.getPropertyById = /**
     * \@description fetch the property from the original params passed into the widget.
     * @private
     * @param {?} id
     * @return {?}
     */
    function (id) {
        return this.filterableColumns.filter((/**
         * @param {?} property
         * @return {?}
         */
        function (property) { return property.dataField === id; }))[0];
    };
    /**
     * @description method that return the options from filter config bundle based on the type passed, returns an object containing inputType and options.
     * @param paramType
     */
    /**
     * \@description method that return the options from filter config bundle based on the type passed, returns an object containing inputType and options.
     * @private
     * @param {?} paramType
     * @return {?}
     */
    NwfFilterComponent.prototype.getOperatorOptions = /**
     * \@description method that return the options from filter config bundle based on the type passed, returns an object containing inputType and options.
     * @private
     * @param {?} paramType
     * @return {?}
     */
    function (paramType) {
        return this.config[paramType].options;
    };
    /**
     * @description: method to create the applied criteria from appliedFilters coming from filter widget consumer.
     * This allows to preset the filterWidget this it he VALUE of the filter widget.
     * @param
     */
    /**
     * \@description: method to create the applied criteria from appliedFilters coming from filter widget consumer.
     * This allows to preset the filterWidget this it he VALUE of the filter widget.
     * @private
     * @param {?} dxGridFilters
     * @return {?}
     */
    NwfFilterComponent.prototype.dxToNwfFilterConverter = /**
     * \@description: method to create the applied criteria from appliedFilters coming from filter widget consumer.
     * This allows to preset the filterWidget this it he VALUE of the filter widget.
     * @private
     * @param {?} dxGridFilters
     * @return {?}
     */
    function (dxGridFilters) {
        var _this = this;
        if (dxGridFilters.length == 3 && this.getPropertyById(dxGridFilters[0])) {
            this.nwfFilters = [this.getFilterCriterionFromDxFilter(dxGridFilters)];
        }
        else {
            // multiple filters are connected by an 'and'. So we remove 'and' from dxGridFilter
            // to get actual filters, and then create filter crtierion from each filter in dxGridFilter.
            this.nwfFilters = dxGridFilters.filter((/**
             * @param {?} filter
             * @return {?}
             */
            function (filter) { return filter !== 'and'; })).map((/**
             * @param {?} filter
             * @return {?}
             */
            function (filter) {
                return _this.getFilterCriterionFromDxFilter(filter);
            }));
        }
    };
    /**
     * @private
     * @param {?} filter
     * @return {?}
     */
    NwfFilterComponent.prototype.getFilterCriterionFromDxFilter = /**
     * @private
     * @param {?} filter
     * @return {?}
     */
    function (filter) {
        // tslint:disable-next-line: prefer-const
        var _a = __read(filter, 3), filterName = _a[0], operator = _a[1], value = _a[2];
        // get schema column object based on filterName(id).
        /** @type {?} */
        var schemaColumnObject = this.getPropertyById(filterName);
        // get filter operator options.
        /** @type {?} */
        var operatorOptions = this.getOperatorOptions(schemaColumnObject.dataType);
        // For 'anyof' operator, this means we are in multiselect list case.
        if (operator === 'anyof') {
            operator = '=';
            value = value.join('|');
        }
        if (operator === 'noneof') {
            operator = '<>';
            value = value.join('|');
        }
        // For 'between' operator we convert the date to ISOString and join the value using '~' sign.
        // This format is required by 'nwf-datetime-range-picker' component
        if (operator === 'between') {
            value = value.map((/**
             * @param {?} val
             * @return {?}
             */
            function (val) { return val.toISOString(); })).join('~');
        }
        // we return property, operator, value which is the format required by filterCriterionRow.
        return {
            property: schemaColumnObject.dataField,
            operator: operator,
            value: value,
        };
    };
    /**
     * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
     * gridInstance.columnOption gives a complete column object (including default column settings),
     * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
     * gridInstance.getVisibleColumns() method gives us the complete object but it only works for visible columns.
     */
    /**
     * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
     * gridInstance.columnOption gives a complete column object (including default column settings),
     * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
     * gridInstance.getVisibleColumns() method gives us the complete object but it only works for visible columns.
     * @private
     * @return {?}
     */
    NwfFilterComponent.prototype.getAllColumnsOnDxGrid = /**
     * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
     * gridInstance.columnOption gives a complete column object (including default column settings),
     * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
     * gridInstance.getVisibleColumns() method gives us the complete object but it only works for visible columns.
     * @private
     * @return {?}
     */
    function () {
        /** @type {?} */
        var gridInstance = this.gridInstance;
        /** @type {?} */
        var columnsViaOptions = gridInstance && gridInstance.state().columns;
        if (columnsViaOptions) {
            return columnsViaOptions.map((/**
             * @param {?} __0
             * @return {?}
             */
            function (_a) {
                var dataField = _a.dataField;
                return gridInstance.columnOption(dataField);
            }));
        }
        else {
            return;
        }
    };
    NwfFilterComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-filter',
                    template: "<div ngbDropdown class=\"d-inline-block\" autoClose=\"outside\">\n    <button type=\"button\" class=\"btn btn-sm btn-flat btn-icon is-caretless\" id=\"nwf-grid-filtering\" ngbDropdownToggle>\n        <nwf-icon iconClass=\"icon-action-filter\"></nwf-icon>\n        <span class=\"btn-icon-label\">{{'nwfjs:filterWidgetButtonLabel' | i18next}}</span>\n        <span class=\"badge badge-info ml-1\" *ngIf=\"nwfFilters.length > 0\">\n            {{nwfFilters.length}}\n        </span>\n    </button>\n    <div ngbDropdownMenu aria-labelledby=\"nwf-grid-filtering\" class=\"popover-body bg-white\">\n        <nwf-popover-title (onDismiss)=\"ngbDropDown.close()\"></nwf-popover-title>\n        <!-- begin filter popover -->\n        <div *ngIf=\"!filterableColumns\">\n            <div class=\"m-3\">{{'nwfjs:filterWidgetError' | i18next}}</div>\n        </div>\n        <form novalidate autocomplete=\"off\" *ngIf=\"filterableColumns && ngbDropDown.isOpen()\"\n            [formGroup]=\"filterFormGrp\" (ngSubmit)=\"apply()\">\n            <div formArrayName=\"criterion\" class=\"my-2\">\n                <nwf-grid-filter-criterion-row\n                    *ngFor=\"let criteria of filterFormGrp.get('criterion')['controls']; let i=index\"\n                    [dxColumns]=\"filterableColumns\" [criteria]=\"criteria\" (deleteCriterion)=\"deleteCriterion(i)\">\n                </nwf-grid-filter-criterion-row>\n            </div>\n\n            <button type=\"button\" *ngIf=\"filterFormGrp.get('criterion')['controls'].length < 4\"\n                class=\"btn btn-flat btn-icon\" (click)=\"addCriterion();$event.stopPropagation();\"\n                data-netapp-id=\"filter-widget-add-filter-btn\">\n                <nwf-icon iconClass=\"icon-action-add\"></nwf-icon>\n                <span class=\"btn-icon-label\">{{'nwfjs:filterWidgetAddFilter' | i18next}}</span>\n            </button>\n\n            <div class=\"d-flex mt-4\">\n                <button type=\"button\" data-netapp-id=\"filter-widget-remove-btn\" class=\"btn btn-link mr-auto\"\n                    (click)=\"reset()\" [disabled]=\"nwfFilters.length <= 0\"\n                    data-netapp-id=\"filter-widget-reset-btn\">{{'nwfjs:reset' | i18next}}\n                </button>\n\n                <button class=\"btn btn-primary\" type=\"submit\"\n                    data-netapp-id=\"filter-widget-apply-btn\">{{'nwfjs:filterWidgetApplyFilter' | i18next}}</button>\n            </div>\n        </form>\n        <!-- end filter popover -->\n    </div>\n</div>",
                    styles: [".filter-badge-light{background:#1e4a93;color:#fff;font-weight:700}.btn-delete-criterion{height:35px}"]
                }] }
    ];
    /** @nocollapse */
    NwfFilterComponent.ctorParameters = function () { return [
        { type: FormBuilder }
    ]; };
    NwfFilterComponent.propDecorators = {
        ngbDropDown: [{ type: ViewChild, args: [NgbDropdown, { static: false },] }],
        dataGrid: [{ type: Input }]
    };
    return NwfFilterComponent;
}());
if (false) {
    /** @type {?} */
    NwfFilterComponent.prototype.ngbDropDown;
    /** @type {?} */
    NwfFilterComponent.prototype.dataGrid;
    /** @type {?} */
    NwfFilterComponent.prototype.nwfFilters;
    /** @type {?} */
    NwfFilterComponent.prototype.filterableColumns;
    /** @type {?} */
    NwfFilterComponent.prototype.filterFormGrp;
    /**
     * @type {?}
     * @private
     */
    NwfFilterComponent.prototype.config;
    /**
     * @type {?}
     * @private
     */
    NwfFilterComponent.prototype.gridInstance;
    /**
     * @type {?}
     * @private
     */
    NwfFilterComponent.prototype.initialColumns;
    /**
     * @type {?}
     * @private
     */
    NwfFilterComponent.prototype._fb;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var FooterComponent = /** @class */ (function () {
    function FooterComponent(i18NextPipe) {
        this.i18NextPipe = i18NextPipe;
        this.usePagination = true;
        this.isSelectionEnabled = false;
        this.isFiltered = false;
    }
    /**
     * @return {?}
     */
    FooterComponent.prototype.ngOnChanges = /**
     * @return {?}
     */
    function () {
        this.setPaginatorI18n();
    };
    /**
     * @return {?}
     */
    FooterComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        this.dataGrid.onContentReady.subscribe((/**
         * @param {?} data
         * @return {?}
         */
        function (data) {
            /** @type {?} */
            var gridInstance = data.component.instance();
            /** @type {?} */
            var pageIndex = gridInstance.pageIndex();
            _this.currentPage = pageIndex + 1;
            _this.limit = gridInstance.pageSize();
            _this.offset = _this.limit * pageIndex;
            _this.totalRecords = gridInstance.totalCount();
            _this.isFiltered = !!gridInstance.getCombinedFilter();
            _this.setPaginatorI18n();
            _this.setSelectedI18n(data);
        }));
        // we listen to onSelectionChanged event and update the selected rows count based on that.
        this.dataGrid.onSelectionChanged.subscribe((/**
         * @param {?} data
         * @return {?}
         */
        function (data) {
            _this.setSelectedI18n(data);
        }));
    };
    /**
     * @param {?} newPageNumber
     * @return {?}
     */
    FooterComponent.prototype.pageChangeHandler = /**
     * @param {?} newPageNumber
     * @return {?}
     */
    function (newPageNumber) {
        this.dataGrid.instance.pageIndex(newPageNumber - 1);
    };
    /**
     * @private
     * @return {?}
     */
    FooterComponent.prototype.setPaginatorI18n = /**
     * @private
     * @return {?}
     */
    function () {
        /** @type {?} */
        var title = this.getTitle(this.totalRecords);
        this.isFilteredI18n = { totalRecords: this.totalRecords, title: title };
        /** @type {?} */
        var offLimit = this.offset + this.limit;
        this.paginatorI18n = {
            pageStart: this.offset + 1,
            pageEnd: offLimit > this.totalRecords ? this.totalRecords : offLimit,
            totalRecords: this.totalRecords,
            title: title,
        };
    };
    /**
     * @private
     * @param {?} data
     * @return {?}
     */
    FooterComponent.prototype.setSelectedI18n = /**
     * @private
     * @param {?} data
     * @return {?}
     */
    function (data) {
        var _this = this;
        /** @type {?} */
        var getSelectedRows = data.component.instance().getSelectedRowKeys();
        /** @type {?} */
        var setRows = (/**
         * @param {?} count
         * @return {?}
         */
        function (count) {
            _this.selectedRowsCount = count;
            _this.selectedI18n = { title: _this.getTitle(count), count: count };
        });
        if (isPromise(getSelectedRows)) {
            getSelectedRows.then((/**
             * @param {?} rows
             * @return {?}
             */
            function (rows) {
                setRows(rows.length);
            }));
        }
        else {
            setRows(getSelectedRows.length);
        }
    };
    /**
     * @private
     * @param {?} count
     * @return {?}
     */
    FooterComponent.prototype.getTitle = /**
     * @private
     * @param {?} count
     * @return {?}
     */
    function (count) {
        return this.i18NextPipe.transform(this.titleKey, { count: count });
    };
    FooterComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-footer',
                    template: "\n    <nav class=\"navbar navbar-expand-lg pt-2 pb-2 px-0\" *ngIf=\"totalRecords\">\n      <div class=\"w-100 navbar-text\" *ngIf=\"isSelectionEnabled\">\n        <div data-netapp-id=\"grid-footer-row-selected-count\" *ngIf=\"selectedRowsCount\">\n          {{ \"nwfjs:gridFooterSelectedCount\" | i18next: selectedI18n }}\n        </div>\n      </div>\n      <div class=\"w-100 navbar-text\" [ngClass]=\"{ 'text-center': isSelectionEnabled }\">\n        <div *ngIf=\"usePagination\" class=\"paginator-page-info\" data-netapp-id=\"paginator-count-message\">\n          {{ \"nwfjs:paginatorShowRecords\" | i18next: paginatorI18n }}\n        </div>\n      </div>\n      <div class=\"w-100 d-flex justify-content-end navbar-text\">\n        <ng-content *ngIf=\"!usePagination\"></ng-content>\n        <div *ngIf=\"!usePagination\" class=\"paginator-page-info\" data-netapp-id=\"paginator-count-message\">\n          <span *ngIf=\"!isFiltered\">{{ \"nwfjs:paginatorShowRecordsNoPagination\" | i18next: isFilteredI18n }}</span>\n          <span *ngIf=\"isFiltered\">{{ \"nwfjs:paginatorShowRecordsNoPaginationFiltered\" | i18next: isFilteredI18n }}</span>\n        </div>\n        <ngb-pagination\n          *ngIf=\"usePagination && totalRecords > 0\"\n          [maxSize]=\"5\"\n          [pageSize]=\"limit\"\n          (pageChange)=\"pageChangeHandler($event)\"\n          [collectionSize]=\"totalRecords\"\n          [(page)]=\"currentPage\"\n          class=\"pagination\"\n        >\n          <ng-template ngbPaginationPrevious>\n            <nwf-icon [iconClass]=\"'icon-misc-arrowleft'\"></nwf-icon><span class=\"ml-1\">{{ \"nwfjs:previous\" | i18next }}</span>\n          </ng-template>\n          <ng-template ngbPaginationNext>\n            <span class=\"mr-1\">{{ \"nwfjs:next\" | i18next }}</span\n            ><nwf-icon [iconClass]=\"'icon-misc-arrowright'\"></nwf-icon>\n          </ng-template>\n        </ngb-pagination>\n      </div>\n    </nav>\n  ",
                    styles: [".paginator-page-info{white-space:nowrap}:host ::ng-deep .pagination{align-items:center;color:#454545;display:flex;font-size:16px;list-style:none;padding:0;margin-bottom:0}:host ::ng-deep .page-link{background:0 0!important;border:none;align-items:center;display:flex;padding:8px 12px}:host ::ng-deep .page-item.active>.page-link{color:#454545;font-weight:700;pointer-events:none;background:0 0}:host ::ng-deep .page-item.disabled{color:#c2c2c2;pointer-events:none}:host ::ng-deep .page-item.disabled:hover{color:#c2c2c2;text-decoration:none}:host ::ng-deep .page-item.disabled:hover nwf-icon{color:#c2c2c2}:host ::ng-deep .navbar-text{padding:0 0 8px}"]
                }] }
    ];
    /** @nocollapse */
    FooterComponent.ctorParameters = function () { return [
        { type: I18NextPipe }
    ]; };
    FooterComponent.propDecorators = {
        dataGrid: [{ type: Input }],
        titleKey: [{ type: Input }],
        usePagination: [{ type: Input }],
        isSelectionEnabled: [{ type: Input }]
    };
    return FooterComponent;
}());
if (false) {
    /** @type {?} */
    FooterComponent.prototype.dataGrid;
    /** @type {?} */
    FooterComponent.prototype.titleKey;
    /** @type {?} */
    FooterComponent.prototype.usePagination;
    /** @type {?} */
    FooterComponent.prototype.isSelectionEnabled;
    /** @type {?} */
    FooterComponent.prototype.currentPage;
    /** @type {?} */
    FooterComponent.prototype.limit;
    /** @type {?} */
    FooterComponent.prototype.offset;
    /** @type {?} */
    FooterComponent.prototype.totalRecords;
    /** @type {?} */
    FooterComponent.prototype.selectedRowsCount;
    /** @type {?} */
    FooterComponent.prototype.isFiltered;
    /** @type {?} */
    FooterComponent.prototype.isFilteredI18n;
    /** @type {?} */
    FooterComponent.prototype.paginatorI18n;
    /** @type {?} */
    FooterComponent.prototype.selectedI18n;
    /** @type {?} */
    FooterComponent.prototype.i18NextPipe;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfGridOptionsService = /** @class */ (function () {
    function NwfGridOptionsService(columnsChangingService) {
        this.columnsChangingService = columnsChangingService;
    }
    /**
     * Set the global options on the DxDataGrid with defaults from nwfjs and passed in values
     * @param options for overriding the default options
     */
    /**
     * Set the global options on the DxDataGrid with defaults from nwfjs and passed in values
     * @param {?=} dataGridOptions
     * @return {?}
     */
    NwfGridOptionsService.prototype.setGridDefaultOptions = /**
     * Set the global options on the DxDataGrid with defaults from nwfjs and passed in values
     * @param {?=} dataGridOptions
     * @return {?}
     */
    function (dataGridOptions) {
        var _this = this;
        if (dataGridOptions === void 0) { dataGridOptions = {}; }
        // TreeList Options
        TreeList.defaultOptions({
            options: {
                // This disables right click context menus.
                onContextMenuPreparing: 
                // This disables right click context menus.
                /**
                 * @param {?} e
                 * @return {?}
                 */
                function (e) {
                    e.items = [];
                },
                scrolling: {
                    useNative: false,
                },
            },
        });
        // DataGrid Options
        DataGrid.defaultOptions(merge$1({
            options: {
                // following options are standard for all nwfjs grids.
                allowColumnResizing: true,
                allowColumnReordering: true,
                showColumnLines: false,
                showRowLines: true,
                hoverStateEnabled: true,
                // this property synchronize the filter row, header filter, and filter builder.
                // The synchronized filter expression is stored in the filterValue option.
                filterSyncEnabled: true,
                // This disables right click context menus.
                onContextMenuPreparing: 
                // This disables right click context menus.
                /**
                 * @param {?} e
                 * @return {?}
                 */
                function (e) {
                    e.items = [];
                },
                onInitialized: (/**
                 * @param {?} e
                 * @return {?}
                 */
                function (e) {
                    // Wire onColumnsChanging event to service observable
                    e.component.option('onColumnsChanging', (/**
                     * @param {?} columnChangeEvent
                     * @return {?}
                     */
                    function (columnChangeEvent) {
                        _this.columnsChangingService.onColumnsChanging(columnChangeEvent);
                    }));
                }),
                pager: {
                    visible: false,
                },
                scrolling: {
                    useNative: false,
                },
            },
        }, dataGridOptions));
    };
    NwfGridOptionsService.decorators = [
        { type: Injectable }
    ];
    /** @nocollapse */
    NwfGridOptionsService.ctorParameters = function () { return [
        { type: NwfColumnsChangingService }
    ]; };
    return NwfGridOptionsService;
}());
if (false) {
    /**
     * @type {?}
     * @private
     */
    NwfGridOptionsService.prototype.columnsChangingService;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var SearchComponent = /** @class */ (function () {
    function SearchComponent(i18NextPipe) {
        this.i18NextPipe = i18NextPipe;
        this.keyUp = new Subject();
        this.value = '';
    }
    /**
     * @return {?}
     */
    SearchComponent.prototype.ngOnChanges = /**
     * @return {?}
     */
    function () {
        this.type = this.i18NextPipe.transform(this.typeKey);
    };
    /**
     * @return {?}
     */
    SearchComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        this.dataGrid.onContentReady.subscribe((/**
         * @param {?} data
         * @return {?}
         */
        function (data) {
            /** @type {?} */
            var gridInstance = data.component.instance();
            _this.value = gridInstance.state().searchText;
            _this.setSearchOnDxGrid();
        }));
        // on keyUp, we get the value of the event,
        // wait for 3s, and then set the search on dxGridInstance.
        this.keyUp
            .pipe(map((/**
         * @param {?} event
         * @return {?}
         */
        function (event) { return event.target.value; })))
            .pipe(debounceTime(1000))
            .subscribe((/**
         * @return {?}
         */
        function () { return _this.setSearchOnDxGrid(); }));
    };
    /**
     * Method to reset the input to empty, and update dxGrid instance.
     */
    /**
     * Method to reset the input to empty, and update dxGrid instance.
     * @return {?}
     */
    SearchComponent.prototype.resetInput = /**
     * Method to reset the input to empty, and update dxGrid instance.
     * @return {?}
     */
    function () {
        this.value = '';
        this.setSearchOnDxGrid();
    };
    /**
     * @return {?}
     */
    SearchComponent.prototype.setSearchOnDxGrid = /**
     * @return {?}
     */
    function () {
        // apply search text.
        this.dataGrid.instance.searchByText(this.value);
    };
    SearchComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-search',
                    template: "\n    <label class=\"sr-only\" for=\"grid-search\"></label>\n    <div class=\"position-relative\">\n      <input\n        id=\"grid-search\"\n        #searchInput\n        class=\"form-control form-control-sm grid-search-input\"\n        type=\"text\"\n        (keyup)=\"keyUp.next($event)\"\n        [placeholder]=\"'nwfjs:searchPlaceholderText' | i18next: { type: type }\"\n        [(ngModel)]=\"value\"\n        data-netapp-id=\"grid-search\"\n        name=\"grid-search\"\n      />\n      <div class=\"search-actions h-100 d-inline-flex align-items-center pr-2\">\n        <div class=\"d-inline-flex pr-1 border-0\" [ngClass]=\"{ invisible: !value }\" (click)=\"resetInput()\">\n          <nwf-icon iconClass=\"icon-action-close\"></nwf-icon>\n        </div>\n        <div class=\"d-inline-flex mag-icon\" (click)=\"searchInput.focus()\">\n          <nwf-icon iconClass=\"icon-view-search\"></nwf-icon>\n        </div>\n      </div>\n    </div>\n  ",
                    host: {
                        class: 'text-nowrap',
                    },
                    styles: [".search-actions{position:absolute;right:0;top:0;color:#2d6dde}:host .grid-search-input{padding-right:45px}:host .grid-search-input[placeholder]{text-overflow:ellipsis}"]
                }] }
    ];
    /** @nocollapse */
    SearchComponent.ctorParameters = function () { return [
        { type: I18NextPipe }
    ]; };
    SearchComponent.propDecorators = {
        typeKey: [{ type: Input }],
        dataGrid: [{ type: Input }]
    };
    return SearchComponent;
}());
if (false) {
    /** @type {?} */
    SearchComponent.prototype.typeKey;
    /** @type {?} */
    SearchComponent.prototype.dataGrid;
    /** @type {?} */
    SearchComponent.prototype.keyUp;
    /** @type {?} */
    SearchComponent.prototype.placeholderText;
    /** @type {?} */
    SearchComponent.prototype.value;
    /** @type {?} */
    SearchComponent.prototype.type;
    /**
     * @type {?}
     * @private
     */
    SearchComponent.prototype.i18NextPipe;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/** @type {?} */
var allComponents$1 = [
    SearchComponent, ColumnVisibilityComponent,
    NwfFilterComponent, FilterMultiselectComponent, FilterCriterionRowComponent,
    NwfFilterCriterionDateComponent, FooterComponent, CellsComponent, CellHeaderComponent,
];
var NwfGridModule = /** @class */ (function () {
    function NwfGridModule() {
    }
    NwfGridModule.decorators = [
        { type: NgModule, args: [{
                    imports: [
                        NgbModule,
                        CommonModule,
                        BrowserModule,
                        ReactiveFormsModule,
                        FormsModule,
                        NwfFormModule,
                        I18NextModule,
                        NwfjsSharedComponentsModule,
                        DxDataGridModule,
                        DxScrollViewModule,
                        NwfjsSharedPipesModule,
                    ],
                    providers: [NwfGridOptionsService],
                    declarations: allComponents$1,
                    exports: allComponents$1,
                },] }
    ];
    /** @nocollapse */
    NwfGridModule.ctorParameters = function () { return []; };
    return NwfGridModule;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfBeaconConfig = /** @class */ (function () {
    function NwfBeaconConfig() {
    }
    NwfBeaconConfig.decorators = [
        { type: Injectable, args: [{ providedIn: 'root' },] }
    ];
    /** @nocollapse */
    NwfBeaconConfig.ctorParameters = function () { return []; };
    /** @nocollapse */ NwfBeaconConfig.ngInjectableDef = ɵɵdefineInjectable({ factory: function NwfBeaconConfig_Factory() { return new NwfBeaconConfig(); }, token: NwfBeaconConfig, providedIn: "root" });
    return NwfBeaconConfig;
}());
if (false) {
    /** @type {?} */
    NwfBeaconConfig.prototype.interval;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfBeaconService = /** @class */ (function () {
    function NwfBeaconService(transitionService, config) {
        var _this = this;
        this.transitionService = transitionService;
        this.config = config;
        // Reset beacon on transition
        this.transitionService.onBefore({}, (/**
         * @return {?}
         */
        function () {
            _this.ngOnDestroy();
            _this.ngOnInit();
        }));
        // Initial construction of the beacon service
        this.ngOnInit();
    }
    /**
     * @param {?} pollInterval
     * @return {?}
     */
    NwfBeaconService.prototype.setInterval = /**
     * @param {?} pollInterval
     * @return {?}
     */
    function (pollInterval) {
        var _this = this;
        this.resetTrigger();
        this.pollingInterval = pollInterval;
        // Polling interval and signal to start the next request
        /** @type {?} */
        var pollIntervalObs = interval(pollInterval);
        // Wait for previous poll to complete before starting another poll
        /** @type {?} */
        var polling = zip(pollIntervalObs, this.nextPoll.pipe(takeUntil(this.destroyTrigger)));
        // triggerLoad is a subject that subscribes to polling as a way to pipe polling to triggerLoad
        // the reason we use function call to next is because we dont want the observables error and complete to leak through
        polling.pipe(takeUntil(this.destroyTrigger)).subscribe((/**
         * @return {?}
         */
        function () { return _this.triggerLoad.next(); }));
    };
    /**
     * @param {?} trigger
     * @return {?}
     */
    NwfBeaconService.prototype.setTrigger = /**
     * @param {?} trigger
     * @return {?}
     */
    function (trigger) {
        var _this = this;
        this.resetTrigger();
        this.trigger = trigger;
        trigger.pipe(takeUntil(this.destroyTrigger), takeUntil(this.destroy)).subscribe((/**
         * @return {?}
         */
        function () { return _this.triggerLoad.next(); }));
    };
    // Trigger interval data request
    // Trigger interval data request
    /**
     * @return {?}
     */
    NwfBeaconService.prototype.start = 
    // Trigger interval data request
    /**
     * @return {?}
     */
    function () {
        this.triggerLoad.next();
    };
    /**
     * @return {?}
     */
    NwfBeaconService.prototype.stop = /**
     * @return {?}
     */
    function () {
        if (this.trigger) {
            this.setTrigger(this.trigger);
        }
        else if (this.pollingInterval) {
            this.setInterval(this.pollingInterval);
        }
    };
    // Trigger manual data request
    // Trigger manual data request
    /**
     * @return {?}
     */
    NwfBeaconService.prototype.refresh = 
    // Trigger manual data request
    /**
     * @return {?}
     */
    function () {
        this.manualLoad.next();
    };
    // Register service call to load data and return observable that emits the data
    // Register service call to load data and return observable that emits the data
    /**
     * @template T
     * @param {?} serviceCall
     * @return {?}
     */
    NwfBeaconService.prototype.register = 
    // Register service call to load data and return observable that emits the data
    /**
     * @template T
     * @param {?} serviceCall
     * @return {?}
     */
    function (serviceCall) {
        // load data observable emission gets mapped to the service method call
        // the emmission of serviceCall observable gets emmited in the serviceObservable stream
        /**
         * This is the middle of the cycle of the beacon
         * @type {?}
         */
        var serviceObservable = this.loadData.pipe(takeUntil(this.destroy), concatMap(serviceCall), share());
        // save the service call into the services list for checking complete
        this.services.push(serviceObservable);
        // the return is the serviceCalls data as an observable
        return serviceObservable;
    };
    /**
     * @private
     * @return {?}
     */
    NwfBeaconService.prototype.ngOnInit = /**
     * @private
     * @return {?}
     */
    function () {
        var _this = this;
        this.services = [];
        this.destroy = new Subject();
        this.manualLoad = new Subject();
        this.nextPoll = new Subject();
        this.triggerLoad = new Subject();
        this.destroyTrigger = new Subject();
        /** @type {?} */
        var beaconInterval = this.config.interval;
        if (beaconInterval) {
            this.setInterval(beaconInterval);
        }
        /**
         * This is the beggining cycle of the beacon
         */
        // Load data triggers all the service calls
        this.loadData = merge(this.triggerLoad.pipe(map((/**
         * @return {?}
         */
        function () { return NwfBeaconService.TRIGGER; }))), this.manualLoad.pipe(map((/**
         * @return {?}
         */
        function () { return NwfBeaconService.MANUAL; }))))
            .pipe(takeUntil(this.destroy), // complete all subscriptions on destroy
        share());
        /**
         * This is the end cycle of the beacon
         */
        // We want to wait until all request are complete before firing off the next poll request
        this.loadComplete = this.loadData.pipe(concatMap((/**
         * @param {?} value
         * @return {?}
         */
        function (value) { return zip.apply(void 0, __spread([of(value)], _this.services)); })), share());
        this.loadComplete.pipe(filter$1((/**
         * @param {?} __0
         * @return {?}
         */
        function (_a) {
            var _b = __read(_a, 1), val = _b[0];
            return val === NwfBeaconService.TRIGGER;
        }))).subscribe(this.nextPoll);
    };
    /**
     * @private
     * @return {?}
     */
    NwfBeaconService.prototype.resetTrigger = /**
     * @private
     * @return {?}
     */
    function () {
        if (this.destroyTrigger) {
            this.destroyTrigger.next();
            this.destroyTrigger.complete();
        }
        this.destroyTrigger = new Subject();
    };
    // Clean up subjects
    // Clean up subjects
    /**
     * @private
     * @return {?}
     */
    NwfBeaconService.prototype.ngOnDestroy = 
    // Clean up subjects
    /**
     * @private
     * @return {?}
     */
    function () {
        this.destroy.next();
        this.destroy.complete();
        this.destroyTrigger.next();
        this.destroyTrigger.complete();
        this.nextPoll.complete();
        this.manualLoad.complete();
        this.triggerLoad.complete();
    };
    // Types of triggers to trigger is the automatic one and manual is a method call
    NwfBeaconService.MANUAL = 'manual';
    NwfBeaconService.TRIGGER = 'trigger';
    NwfBeaconService.decorators = [
        { type: Injectable }
    ];
    /** @nocollapse */
    NwfBeaconService.ctorParameters = function () { return [
        { type: TransitionService$1 },
        { type: NwfBeaconConfig }
    ]; };
    return NwfBeaconService;
}());
if (false) {
    /** @type {?} */
    NwfBeaconService.MANUAL;
    /** @type {?} */
    NwfBeaconService.TRIGGER;
    /** @type {?} */
    NwfBeaconService.prototype.loadData;
    /** @type {?} */
    NwfBeaconService.prototype.loadComplete;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.triggerLoad;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.manualLoad;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.trigger;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.nextPoll;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.destroyTrigger;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.destroy;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.services;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.pollingInterval;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.transitionService;
    /**
     * @type {?}
     * @private
     */
    NwfBeaconService.prototype.config;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * @record
 */
function INwfTakeoverModalOptions() { }
if (false) {
    /** @type {?|undefined} */
    INwfTakeoverModalOptions.prototype.style;
    /** @type {?|undefined} */
    INwfTakeoverModalOptions.prototype.confirmation;
}
var NwfTakeoverModalService = /** @class */ (function () {
    function NwfTakeoverModalService(ngbModal, stateService, document, transitionService) {
        this.ngbModal = ngbModal;
        this.stateService = stateService;
        this.document = document;
        this.transitionService = transitionService;
    }
    /**
     * @param {?} content
     * @param {?=} options
     * @return {?}
     */
    NwfTakeoverModalService.prototype.open = /**
     * @param {?} content
     * @param {?=} options
     * @return {?}
     */
    function (content, options) {
        var _this = this;
        /** @type {?} */
        var modalOptions = { style: '', confirmation: true };
        if (options) {
            modalOptions = Object.assign({}, modalOptions, options);
        }
        /** @type {?} */
        var takoverModalCls = 'nwf-takeover-modal';
        /** @type {?} */
        var contain = 'main';
        /** @type {?} */
        var fullCls = 'is-full';
        /** @type {?} */
        var doc = this.document.body;
        /** @type {?} */
        var ngbTakeoverCls = takoverModalCls;
        if (modalOptions.style == 'full') {
            ngbTakeoverCls += " " + fullCls;
        }
        doc.classList.add(takoverModalCls);
        /** @type {?} */
        var takeoverModalOptions = {
            windowClass: ngbTakeoverCls,
            backdrop: false,
            container: contain,
        };
        /** @type {?} */
        var tearDown = (/**
         * @return {?}
         */
        function () {
            doc.classList.remove(takoverModalCls);
            window.scrollTo(0, 0);
            exitTrans();
        });
        /* I only do the exit transition trap if they haven't explicitly set the option to false */
        /** @type {?} */
        var exitTrans = this.transitionService.onBefore({}, (/**
         * @param {?} trans
         * @return {?}
         */
        function (trans) {
            if (modalOptions.confirmation !== false) {
                /** @type {?} */
                var confirmModalRef = _this.ngbModal.open(NwfConfirmationModalComponent, { backdrop: 'static', container: contain, windowClass: 'nwf-confirmation-modal-dialog' });
                confirmModalRef.componentInstance.title = 'nwfjs:areYouSure';
                confirmModalRef.componentInstance.message = 'nwfjs:loseProgress';
                confirmModalRef.result
                    .then((/**
                 * @return {?}
                 */
                function () {
                    /* Go ahead and dismiss the takeover, snip the transition */
                    exitTrans();
                    modalRef.dismiss();
                    var _a = trans.to(), name = _a.name, params = _a.params;
                    _this.stateService.go(name, params);
                }))
                    .catch((/**
                 * @return {?}
                 */
                function () {
                    /* Just swallow the cancel action */
                }));
                /* Returning false, prevents the transition, this is the trap. */
                return false;
            }
            else {
                /* we have no confirmation trap, but we are transitioning out */
                modalRef.dismiss();
            }
        }));
        /** @type {?} */
        var modalRef = this.ngbModal.open(content, takeoverModalOptions);
        modalRef.result.then(tearDown).catch(tearDown);
        return modalRef;
    };
    /** @nocollapse */
    NwfTakeoverModalService.ctorParameters = function () { return [
        { type: NgbModal },
        { type: StateService },
        { type: Document, decorators: [{ type: Inject, args: [DOCUMENT,] }] },
        { type: TransitionService$1 }
    ]; };
    return NwfTakeoverModalService;
}());
if (false) {
    /**
     * @type {?}
     * @private
     */
    NwfTakeoverModalService.prototype.ngbModal;
    /**
     * @type {?}
     * @private
     */
    NwfTakeoverModalService.prototype.stateService;
    /**
     * @type {?}
     * @private
     */
    NwfTakeoverModalService.prototype.document;
    /**
     * @type {?}
     * @private
     */
    NwfTakeoverModalService.prototype.transitionService;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfServicesModule = /** @class */ (function () {
    function NwfServicesModule() {
    }
    NwfServicesModule.decorators = [
        { type: NgModule, args: [{
                    imports: [
                        NwfjsSharedComponentsModule,
                    ],
                    providers: [NwfTakeoverModalService, NwfBeaconService],
                    exports: [],
                },] }
    ];
    return NwfServicesModule;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var AboutModalComponent = /** @class */ (function () {
    function AboutModalComponent(activeModal) {
        this.activeModal = activeModal;
    }
    /**
     * @return {?}
     */
    AboutModalComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
    };
    AboutModalComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-about-modal',
                    template: "\n  <div class=\"modal-header\">\n    <h5 class=\"modal-title\">{{ 'nwfjs:aboutProduct' | i18next: {productName: productName} }}</h5>\n</div>\n<div class=\"modal-body\">\n    <div class=\"nwf-about-main-panel\">\n\n        <!-- First row -->\n        <div class=\"nwf-about-row\">\n            <div class=\"nwf-about-cell\">\n                <div class=\"nwf-about-logo-panel\">\n                    <!-- Application logo-->\n                    <div class=\"nwf-about-row\">\n                        <div class=\"nwf-about-logo\"></div>\n                    </div>\n                </div>\n            </div>\n            <div class=\"nwf-about-cell\">\n                <div class=\"nwf-about-form-panel\">\n                    <!-- Product name -->\n                    <div class=\"nwf-about-row\" *ngIf=\"productName\">\n                        <p class=\"nwf-about-product-name\" data-netapp-id=\"aboutDialog-product-name\">\n                            {{productName}}\n                        </p>\n                    </div>\n\n                    <!-- Version number -->\n                    <div class=\"nwf-about-row\" *ngIf=\"version\">\n                        <p class=\"nwf-about-version-number\" data-netapp-id=\"aboutDialog-version\">\n                            {{'nwfjs:version' | i18next:{version: version} }}\n                        </p>\n                    </div>\n\n                    <!-- System ID -->\n                    <div class=\"nwf-about-row\" *ngIf=\"systemId\">\n                        <p class=\"nwf-about-systemID\" data-netapp-id=\"aboutDialog-UUID\">\n                            {{'nwfjs:systemId' | i18next:{systemId: systemId} }}\n                        </p>\n                    </div>\n\n                    <!-- Session ID -->\n                    <div class=\"nwf-about-row\" *ngIf=\"sessionId\">\n                        <p class=\"nwf-about-sessionId\" data-netapp-id=\"aboutDialog-sessionID\">\n                            {{'nwfjs:sessionId' | i18next:{sessionId: sessionId} }}\n                        </p>\n                    </div>\n\n                    <!-- Confidentiality text -->\n                    <div class=\"nwf-about-row\">\n                        <p class=\"nwf-about-confidentiality-text\" data-netapp-id=\"aboutDialog-conftext\">\n                            {{confText}}\n                        </p>\n                    </div>\n\n                    <!-- Copyright information  -->\n                    <div class=\"nwf-about-row\">\n                        <p class=\"nwf-about-copyright-info\">\n                            <span class=\"copyright-symbol\">&copy; &nbsp;</span>{{copyright}}\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n<div class=\"modal-footer\">\n    <button class=\"btn btn-primary\" (click)=\"activeModal.close()\" data-netapp-id=\"aboutDialog-ok-button\" ngbAutofocus>{{'nwfjs:OK' | i18next}}</button>\n</div>\n\n  ",
                    styles: [".nwf-about-row{font-size:12px}.nwf-about-main-panel{padding:20px}.nwf-about-logo{background-image:url(data:image/png;base64,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);background-repeat:no-repeat;width:77px;height:89px;margin-top:6px}.nwf-about-brand-logo{vertical-align:middle;display:inline-block}.nwf-about-form-panel{padding-left:25px}.nwf-about-product-name{font-size:20px}.nwf-about-confidentiality-text{text-transform:uppercase}.copyright-symbol{font-family:Arial,\"Helvetica Neue\",Helvetica,sans-serif}"]
                }] }
    ];
    /** @nocollapse */
    AboutModalComponent.ctorParameters = function () { return [
        { type: NgbActiveModal }
    ]; };
    return AboutModalComponent;
}());
if (false) {
    /** @type {?} */
    AboutModalComponent.prototype.productName;
    /** @type {?} */
    AboutModalComponent.prototype.version;
    /** @type {?} */
    AboutModalComponent.prototype.systemId;
    /** @type {?} */
    AboutModalComponent.prototype.sessionId;
    /** @type {?} */
    AboutModalComponent.prototype.confText;
    /** @type {?} */
    AboutModalComponent.prototype.copyright;
    /** @type {?} */
    AboutModalComponent.prototype.activeModal;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var AboutComponent = /** @class */ (function () {
    function AboutComponent(modalService) {
        this.modalService = modalService;
    }
    /**
     * @param {?} e
     * @return {?}
     */
    AboutComponent.prototype.onClick = /**
     * @param {?} e
     * @return {?}
     */
    function (e) {
        /** @type {?} */
        var modalRef = this.modalService.open(AboutModalComponent);
        /** @type {?} */
        var ci = modalRef.componentInstance;
        /* I'd like a cleaner way to do this, but this works for now */
        ci.productName = this.productName;
        ci.version = this.version;
        ci.systemId = this.systemId;
        ci.confText = this.confText;
        ci.copyright = this.copyright;
    };
    /**
     * @return {?}
     */
    AboutComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
    };
    AboutComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-about',
                    host: {
                        class: 'dropdown-item',
                    },
                    template: "{{\"nwfjs:about\" | i18next}}"
                }] }
    ];
    /** @nocollapse */
    AboutComponent.ctorParameters = function () { return [
        { type: NgbModal }
    ]; };
    AboutComponent.propDecorators = {
        productName: [{ type: Input }],
        version: [{ type: Input }],
        systemId: [{ type: Input }],
        confText: [{ type: Input }],
        copyright: [{ type: Input }],
        onClick: [{ type: HostListener, args: ['click', ['$event'],] }]
    };
    return AboutComponent;
}());
if (false) {
    /** @type {?} */
    AboutComponent.prototype.productName;
    /** @type {?} */
    AboutComponent.prototype.version;
    /** @type {?} */
    AboutComponent.prototype.systemId;
    /** @type {?} */
    AboutComponent.prototype.confText;
    /** @type {?} */
    AboutComponent.prototype.copyright;
    /** @type {?} */
    AboutComponent.prototype.modalService;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var AppTitleComponent = /** @class */ (function () {
    function AppTitleComponent() {
        this.showLogo = true;
    }
    AppTitleComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-app-title',
                    host: {
                        class: 'navbar-brand mr-auto ml-2 p-0',
                    },
                    template: "\n    <div class=\"d-inline-flex align-items-center\">\n    <nwf-icon *ngIf=\"showLogo\" iconClass=\"icon-nav-ngraphic-titlebar\"></nwf-icon>\n    <div class=\"nwf-app-title\">\n    {{title}}\n      <span class=\"pl-2\" *ngIf=\"extraHref && extraHrefLabel\"><a class=\"nwf-app-title-extra\" href=\"{{extraHref}}\">{{extraHrefLabel}}</a></span>\n    </div>\n    </div>\n  ",
                    styles: [":host{color:#fff}.nwf-app-title{font-size:24px;font-weight:400}.l-nwf-app-title-extra{vertical-align:middle}.nwf-app-title-extra{color:inherit;font-size:12px}"]
                }] }
    ];
    /** @nocollapse */
    AppTitleComponent.ctorParameters = function () { return []; };
    AppTitleComponent.propDecorators = {
        title: [{ type: Input }],
        extraHref: [{ type: Input }],
        extraHrefLabel: [{ type: Input }],
        showLogo: [{ type: Input }]
    };
    return AppTitleComponent;
}());
if (false) {
    /** @type {?} */
    AppTitleComponent.prototype.title;
    /** @type {?} */
    AppTitleComponent.prototype.extraHref;
    /** @type {?} */
    AppTitleComponent.prototype.extraHrefLabel;
    /** @type {?} */
    AppTitleComponent.prototype.showLogo;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var GlobalSearchComponent = /** @class */ (function () {
    function GlobalSearchComponent(i18nextFormat) {
        this.i18nextFormat = i18nextFormat;
        this.value = '';
        this.subjectLabel = '';
        this.focusOnSearchClick = true;
        this.change = new EventEmitter();
        this.focus = new EventEmitter();
        this.blur = new EventEmitter();
        this.enter = new EventEmitter();
        this.submit = new EventEmitter();
    }
    /**
     * Event emit on search button click.
     */
    /**
     * Event emit on search button click.
     * @return {?}
     */
    GlobalSearchComponent.prototype.onSubmit = /**
     * Event emit on search button click.
     * @return {?}
     */
    function () {
        this.submit.emit(this.value);
        if (this.focusOnSearchClick) {
            this.inputEl.nativeElement.focus();
        }
    };
    /**
     * @return {?}
     */
    GlobalSearchComponent.prototype.clear = /**
     * @return {?}
     */
    function () {
        this.value = '';
        this.change.emit(this.value);
        this.inputEl.nativeElement.focus();
    };
    /**
     * @return {?}
     */
    GlobalSearchComponent.prototype.ngOnChanges = /**
     * @return {?}
     */
    function () {
        this.completeSubjectLabel = this.i18nextFormat.transform('nwfjs:searchPlaceholderText', { type: this.subjectLabel });
    };
    GlobalSearchComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-global-search-input',
                    template: "<div class=\"input-group\">\n  <label class=\"sr-only\" for=\"global-search\">{{completeSubjectLabel}}</label>\n  <div class=\"input-container\">\n    <input class=\"form-control py-2 border-0 nwf-global-search-input\" [(ngModel)]=\"value\" type=\"text\"\n      [placeholder]=\"completeSubjectLabel\" id=\"global-search\" autocomplete=\"off\" (input)=\"change.emit(value)\"\n      (keydown.enter)=\"enter.emit(value)\" (focus)=\"focus.emit(value)\" (blur)=\"blur.emit(value)\" #globalSearch>\n    <div class=\"row icon-container\">\n      <div [hidden]=\"!value\" class=\"border-0 close-icon\" (click)=\"clear()\">\n        <nwf-icon iconClass=\"icon-action-close\"></nwf-icon>\n      </div>\n      <div class=\"border-0\" (click)=\"onSubmit()\">\n        <nwf-icon iconClass=\"icon-view-search\"></nwf-icon>\n      </div>\n    </div>\n  </div>\n</div>\n",
                    styles: [".nwf-global-search-input{width:340px!important;color:#fff!important;background-color:#173e77!important;border-color:#173e77!important;padding-right:55px}.input-container{position:relative;width:340px!important}.icon-container{position:absolute;right:25px;top:7px;background-color:transparent;cursor:pointer;color:#fff}.close-icon{padding-right:7px}input[type=text]::-ms-clear{display:none}"]
                }] }
    ];
    /** @nocollapse */
    GlobalSearchComponent.ctorParameters = function () { return [
        { type: I18NextPipe }
    ]; };
    GlobalSearchComponent.propDecorators = {
        inputEl: [{ type: ViewChild, args: ['globalSearch', { static: false },] }],
        value: [{ type: Input }],
        subjectLabel: [{ type: Input }],
        focusOnSearchClick: [{ type: Input }],
        change: [{ type: Output }],
        focus: [{ type: Output }],
        blur: [{ type: Output }],
        enter: [{ type: Output }],
        submit: [{ type: Output }]
    };
    return GlobalSearchComponent;
}());
if (false) {
    /** @type {?} */
    GlobalSearchComponent.prototype.inputEl;
    /** @type {?} */
    GlobalSearchComponent.prototype.value;
    /** @type {?} */
    GlobalSearchComponent.prototype.subjectLabel;
    /** @type {?} */
    GlobalSearchComponent.prototype.focusOnSearchClick;
    /** @type {?} */
    GlobalSearchComponent.prototype.change;
    /** @type {?} */
    GlobalSearchComponent.prototype.focus;
    /** @type {?} */
    GlobalSearchComponent.prototype.blur;
    /** @type {?} */
    GlobalSearchComponent.prototype.enter;
    /** @type {?} */
    GlobalSearchComponent.prototype.submit;
    /** @type {?} */
    GlobalSearchComponent.prototype.completeSubjectLabel;
    /**
     * @type {?}
     * @private
     */
    GlobalSearchComponent.prototype.i18nextFormat;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var GlobalnavPrimaryCenterComponent = /** @class */ (function () {
    function GlobalnavPrimaryCenterComponent() {
    }
    GlobalnavPrimaryCenterComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-globalnav-primary-center',
                    host: {
                        class: 'd-flex justify-content-center flex-grow-1',
                    },
                    template: "\n  <ng-content></ng-content>\n  ",
                    styles: [""]
                }] }
    ];
    /** @nocollapse */
    GlobalnavPrimaryCenterComponent.ctorParameters = function () { return []; };
    return GlobalnavPrimaryCenterComponent;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var GlobalnavPrimaryToolsComponent = /** @class */ (function () {
    function GlobalnavPrimaryToolsComponent() {
        this.isCollapsed = true;
    }
    GlobalnavPrimaryToolsComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-globalnav-primary-tools',
                    host: {
                        class: 'text-nowrap h-100',
                    },
                    template: "\n\n\n<ng-content></ng-content>\n\n\n  ",
                    styles: [":host ::ng-deep .nwf-admin-nav-menu{display:flex;margin:0;padding-left:0;align-items:center;height:100%}:host ::ng-deep .nwf-admin-nav-menu>li{height:100%;width:100%;color:#fff;list-style-type:none}:host ::ng-deep .nwf-admin-nav-menu>li:hover{color:#4faaff}:host ::ng-deep .nwf-admin-nav-menu .dropdown-toggle::after{display:none}:host ::ng-deep .nwf-admin-nav-menu-item{height:100%;color:inherit;display:flex;padding-left:15px;padding-right:15px;align-content:center;align-items:center;cursor:pointer}:host ::ng-deep .nwf-admin-nav-menu-item[aria-expanded=true]{background-color:#0a2d6c}"]
                }] }
    ];
    return GlobalnavPrimaryToolsComponent;
}());
if (false) {
    /** @type {?} */
    GlobalnavPrimaryToolsComponent.prototype.isCollapsed;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var GlobalnavPrimaryComponent = /** @class */ (function () {
    function GlobalnavPrimaryComponent(leftnavService) {
        this.leftnavService = leftnavService;
        this.showLeftNavToggle = true;
    }
    GlobalnavPrimaryComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-globalnav-primary',
                    host: {
                        class: 'navbar navbar-expand-md flex-nowrap p-0',
                    },
                    template: "\n  <button *ngIf=\"showLeftNavToggle\" class=\"btn leftnav-toggler rounded-0 h-100 p-0 shadow-none\" type=\"button\" (click)=\"leftnavService.toggle()\">\n  <nwf-icon iconClass=\"icon-nav-menu\"></nwf-icon>\n  </button>\n  <ng-content></ng-content>\n  ",
                    styles: [":host{height:53px;background-color:#1e4a93;box-shadow:0 3px 0 0 rgba(0,0,0,.08)}.leftnav-toggler{color:#fff;width:53px;min-width:53px;background-color:#0a2d6c}.leftnav-toggler:focus{box-shadow:none!important}.leftnav-toggler:hover{color:#4faaff}"]
                }] }
    ];
    /** @nocollapse */
    GlobalnavPrimaryComponent.ctorParameters = function () { return [
        { type: NwfLeftnavService }
    ]; };
    GlobalnavPrimaryComponent.propDecorators = {
        showLeftNavToggle: [{ type: Input }]
    };
    return GlobalnavPrimaryComponent;
}());
if (false) {
    /** @type {?} */
    GlobalnavPrimaryComponent.prototype.showLeftNavToggle;
    /** @type {?} */
    GlobalnavPrimaryComponent.prototype.leftnavService;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var GlobalnavComponent = /** @class */ (function () {
    function GlobalnavComponent() {
    }
    /**
     * @return {?}
     */
    GlobalnavComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () { };
    GlobalnavComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-globalnav',
                    host: {
                        class: 'fixed-top',
                    },
                    template: "<ng-content></ng-content>",
                    styles: [":host{z-index:1031}"]
                }] }
    ];
    /** @nocollapse */
    GlobalnavComponent.ctorParameters = function () { return []; };
    return GlobalnavComponent;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var LeftnavItemComponent = /** @class */ (function () {
    function LeftnavItemComponent(stateService) {
        this.stateService = stateService;
        this.isTopLevel = false;
    }
    /**
     * @return {?}
     */
    LeftnavItemComponent.prototype.toggleCollapsed = /**
     * @return {?}
     */
    function () {
        this.item.isCollapsed = !this.item.isCollapsed;
    };
    /**
     * @return {?}
     */
    LeftnavItemComponent.prototype.ngOnChanges = /**
     * @return {?}
     */
    function () {
        this.itemNtapId = "leftnav-item-" + this.item.label.toLowerCase() + "-link";
    };
    /**
     * @return {?}
     */
    LeftnavItemComponent.prototype.onClick = /**
     * @return {?}
     */
    function () {
        if (this.item.children) {
            this.toggleCollapsed();
        }
        else if (this.stateService.$current.parent.name === this.item.sref) {
            this.stateService.go('^', {}, { reload: true });
        }
        else {
            this.stateService.go(this.item.sref, this.item.srefParams);
        }
    };
    LeftnavItemComponent.decorators = [
        { type: Component, args: [{
                    selector: '[nwfLeftnavItem]',
                    template: "<!-- header has a label, no sref, and no children -->\n<div *ngIf=\"item.label && !item.sref && !item.children\" class=\"nwf-leftnav-item-header flex-grow-1\">{{item.label | i18next}}</div>\n\n<!-- item link has a label -->\n<a *ngIf=\"item.label && item.children || item.label && item.sref\" class=\"nwf-leftnav-item-link flex-grow-1\" (click)=\"onClick()\"\n    [attr.data-netapp-id]=\"itemNtapId\" \n    [ngClass]=\"{'is-active': item.isActive, 'is-toplevel': isTopLevel, 'is-open': !item.isCollapsed }\">\n    <span class=\"nwf-leftnav-item-label\">{{item.label | i18next }}</span>\n    <nwf-icon class=\"nwf-leftnav-item-toggler\" *ngIf=\"item.children && item.children.length\"\n        [iconClass]=\"item.isCollapsed ? 'icon-misc-chevrondown' : 'icon-misc-chevronup'\"></nwf-icon>\n</a>\n<!-- submenus have optional children -->\n<ul *ngIf=\"item.children && item.children.length\" class=\"nwf-leftnav-items pl-0\" [ngbCollapse]=\"item.isCollapsed\"\n    [attr.data-netapp-id]=\"'leftnav-item-group-' + item.label | lowercase\">\n    <li *ngFor=\"let child of item.children\" nwfLeftnavItem [item]=\"child\"\n        class=\"nwf-leftnav-item is-submenu d-block flex-grow-1\"\n    ></li>\n</ul>\n",
                    providers: [NgbCollapse],
                    styles: [":host{color:#fff;line-height:16px}:host:hover{color:#fff}:host[istoplevel]:first-child{border-top:1px solid #08214b}:host[istoplevel] ul{border-bottom:1px solid #08214b}.nwf-leftnav-item-header{display:flex;margin-top:30px;border-bottom:1px solid #08214b;color:#a5bfed;align-items:center;padding:8px 8px 8px 24px;text-transform:uppercase;font-size:12px;font-weight:400;letter-spacing:0}.nwf-leftnav-item-link{display:flex;align-items:center;padding:8px 8px 8px 12px;text-transform:capitalize;font-weight:400;letter-spacing:0}.nwf-leftnav-item-link:hover{background:#7ba1e5}.nwf-leftnav-item-link:hover ::ng-deep #base-layer{fill:#fff}.nwf-leftnav-item-link.is-active{background-color:#a5bfed;color:#131313}.nwf-leftnav-item-link.is-open{border-bottom:none!important}.nwf-leftnav-item-link.is-toplevel{border-bottom:1px solid #08214b;padding:12px;border-left:4px solid transparent;letter-spacing:1px;font-weight:700;text-transform:uppercase}.nwf-leftnav-item-link.is-toplevel.is-active{color:#fff;background-color:#08214b;border-left-color:#a5bfed}.nwf-leftnav-item-link.is-toplevel.is-active:hover{background-color:#030d1d}.nwf-leftnav-item-link:not([href]){cursor:pointer}nwf-icon.nwf-leftnav-item-toggler{margin-right:12px}nwf-icon.nwf-leftnav-item-toggler ::ng-deep #base-layer{fill:#a5bfed}.nwf-leftnav-item-label{margin-left:12px;flex-grow:1}.is-submenu .nwf-leftnav-item-label{margin-left:16px}"]
                }] }
    ];
    /** @nocollapse */
    LeftnavItemComponent.ctorParameters = function () { return [
        { type: StateService }
    ]; };
    LeftnavItemComponent.propDecorators = {
        item: [{ type: Input }],
        isTopLevel: [{ type: Input }]
    };
    return LeftnavItemComponent;
}());
if (false) {
    /** @type {?} */
    LeftnavItemComponent.prototype.item;
    /** @type {?} */
    LeftnavItemComponent.prototype.isTopLevel;
    /** @type {?} */
    LeftnavItemComponent.prototype.itemNtapId;
    /**
     * @type {?}
     * @private
     */
    LeftnavItemComponent.prototype.stateService;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var LeftnavComponent = /** @class */ (function () {
    function LeftnavComponent(leftnavService, transitionService, stateService) {
        this.leftnavService = leftnavService;
        this.transitionService = transitionService;
        this.stateService = stateService;
        this.keepOtherSectionsOpen = true;
    }
    /**
     * @return {?}
     */
    LeftnavComponent.prototype.repaintStateHighlight = /**
     * @return {?}
     */
    function () {
        var _this = this;
        var _a = this.stateService, current = _a.current, params = _a.params;
        setTimeout((/**
         * @return {?}
         */
        function () { _this.markActiveState(_this.navData, current, params); }), 0);
    };
    /**
     * @return {?}
     */
    LeftnavComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        // Set my navData on the leftnavService so others (like feature tour ) can open a tree of items programatically.
        this.leftnavService.navData = this.navData;
        /* On Enter I recurse to find out what to highlight */
        this.transitionService.onSuccess({}, (/**
         * @param {?} trans
         * @return {?}
         */
        function (trans) {
            _this.repaintStateHighlight();
        }));
    };
    /**
     * @param {?} changes
     * @return {?}
     */
    LeftnavComponent.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) {
        if (changes.navData && changes.navData.currentValue) {
            this.loadLeftNav(changes.navData.currentValue);
        }
    };
    /**
     * @param {?} navData
     * @return {?}
     */
    LeftnavComponent.prototype.loadLeftNav = /**
     * @param {?} navData
     * @return {?}
     */
    function (navData) {
        this.closeAll(navData);
        /* I have to find out on load where I am as well */
        this.repaintStateHighlight();
    };
    /*
     * Recurse through the navData, marking the active state, and
     * all its parents. Return true if we found a match.
     * An item is active if it's name and params matches
     * An item is also active if any of it's child is active.
     */
    /*
       * Recurse through the navData, marking the active state, and
       * all its parents. Return true if we found a match.
       * An item is active if it's name and params matches
       * An item is also active if any of it's child is active.
       */
    /**
     * @param {?} navData
     * @param {?} state
     * @param {?=} params
     * @return {?}
     */
    LeftnavComponent.prototype.markActiveState = /*
       * Recurse through the navData, marking the active state, and
       * all its parents. Return true if we found a match.
       * An item is active if it's name and params matches
       * An item is also active if any of it's child is active.
       */
    /**
     * @param {?} navData
     * @param {?} state
     * @param {?=} params
     * @return {?}
     */
    function (navData, state, params) {
        var _this = this;
        if (params === void 0) { params = null; }
        return reduce(navData, (/**
         * @param {?} matched
         * @param {?} item
         * @return {?}
         */
        function (matched, item) {
            /** @type {?} */
            var matchesChild = false;
            if (item.children) {
                matchesChild = _this.markActiveState(item.children, state, params);
            }
            if (_this.keepOtherSectionsOpen) {
                /* If it's already open leave if; if it needs to be open, do it */
                if (matchesChild) {
                    item.isCollapsed = false;
                }
            }
            else {
                item.isCollapsed = !matchesChild;
            }
            /** @type {?} */
            var hasNameMatch = (item.sref !== undefined && ((state.name === item.sref) || (state.parent === item.sref)));
            /** @type {?} */
            var hasParamMatch = isMatch(params, item.srefParams || {});
            item.isActive = matchesChild || (hasNameMatch && hasParamMatch);
            matched = matched || item.isActive;
            return matched;
        }), false);
    };
    /**
     * @param {?} navData
     * @return {?}
     */
    LeftnavComponent.prototype.closeAll = /**
     * @param {?} navData
     * @return {?}
     */
    function (navData) {
        var _this = this;
        forEach(navData, (/**
         * @param {?} item
         * @return {?}
         */
        function (item) {
            item.isCollapsed = true;
            if (navData.children) {
                _this.closeAll(navData.children);
            }
        }));
    };
    LeftnavComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-left-nav',
                    template: "\n  <dx-scroll-view>\n  <nav class=\"leftnav\" role=\"navigation\">\n  <ul class=\"nwf-leftnav-items p-0 m-0\">\n      <li class=\"nwf-leftnav-item d-block\" *ngFor=\"let item of navData\" nwfLeftnavItem isTopLevel=\"true\" [item]=\"item\" [attr.data-netapp-id]=\"'leftnav-item-' + item.label | lowercase\"></li>\n  </ul>\n  </nav>\n  </dx-scroll-view>\n  ",
                    styles: ["nav.leftnav{display:flex;flex-direction:column;font-size:90%;top:0;padding-top:25px;overflow-x:hidden;overflow-y:auto;position:-webkit-sticky;position:sticky}"]
                }] }
    ];
    /** @nocollapse */
    LeftnavComponent.ctorParameters = function () { return [
        { type: NwfLeftnavService },
        { type: TransitionService$1 },
        { type: StateService }
    ]; };
    LeftnavComponent.propDecorators = {
        navData: [{ type: Input }]
    };
    return LeftnavComponent;
}());
if (false) {
    /** @type {?} */
    LeftnavComponent.prototype.navData;
    /**
     * @type {?}
     * @private
     */
    LeftnavComponent.prototype.keepOtherSectionsOpen;
    /** @type {?} */
    LeftnavComponent.prototype.leftnavService;
    /**
     * @type {?}
     * @private
     */
    LeftnavComponent.prototype.transitionService;
    /**
     * @type {?}
     * @private
     */
    LeftnavComponent.prototype.stateService;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/** @type {?} */
var APP_TITLE_ROOT = new InjectionToken('NwfAppTitleRoot');

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfTitleService = /** @class */ (function (_super) {
    __extends(NwfTitleService, _super);
    function NwfTitleService(i18nextPipe, doc, appTitleRoot) {
        var _this = _super.call(this, doc) || this;
        _this.i18nextPipe = i18nextPipe;
        _this.appTitleRoot = appTitleRoot;
        _this.firstTitleSegment = _this.appTitleRoot || '';
        _this.sep = ' | ';
        return _this;
    }
    /**
     * @param {?} title
     * @return {?}
     */
    NwfTitleService.prototype.setTitle = /**
     * @param {?} title
     * @return {?}
     */
    function (title) {
        var _this = this;
        /** @type {?} */
        var titlesPipeSep = '';
        /** @type {?} */
        var titles = [];
        /* If I have a firstTitle, I push it on first */
        if (this.firstTitleSegment != '') {
            titles.push(this.firstTitleSegment);
        }
        /* If I am an array, I concatenate that array, otherwise I am a string and I just push it on */
        if (title instanceof Array) {
            titles = __spread(titles, title);
        }
        else {
            titles.push(title);
        }
        /* finally produce my pipe sep string, passing each over the i18next pipe so they can pass me i18n:keys */
        titlesPipeSep = titles.filter((/**
         * @param {?} item
         * @return {?}
         */
        function (item) { return item !== ''; })).map((/**
         * @param {?} item
         * @return {?}
         */
        function (item) {
            return _this.i18nextPipe.transform(item);
        })).join(this.sep);
        /* Call the regular super for setTitle, now we just have a normal string */
        return _super.prototype.setTitle.call(this, titlesPipeSep);
    };
    NwfTitleService.decorators = [
        { type: Injectable, args: [{
                    providedIn: 'root',
                },] }
    ];
    /** @nocollapse */
    NwfTitleService.ctorParameters = function () { return [
        { type: I18NextPipe },
        { type: undefined, decorators: [{ type: Inject, args: [DOCUMENT,] }] },
        { type: undefined, decorators: [{ type: Optional }, { type: Inject, args: [APP_TITLE_ROOT,] }] }
    ]; };
    /** @nocollapse */ NwfTitleService.ngInjectableDef = ɵɵdefineInjectable({ factory: function NwfTitleService_Factory() { return new NwfTitleService(ɵɵinject(I18NextPipe), ɵɵinject(DOCUMENT), ɵɵinject(APP_TITLE_ROOT, 8)); }, token: NwfTitleService, providedIn: "root" });
    return NwfTitleService;
}(Title));
if (false) {
    /** @type {?} */
    NwfTitleService.prototype.firstTitleSegment;
    /**
     * @type {?}
     * @private
     */
    NwfTitleService.prototype.sep;
    /**
     * @type {?}
     * @private
     */
    NwfTitleService.prototype.i18nextPipe;
    /**
     * @type {?}
     * @private
     */
    NwfTitleService.prototype.appTitleRoot;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var LoginComponent = /** @class */ (function () {
    function LoginComponent(NwfAuthService, $state, modalService, titleService, i18NextPipe) {
        var _this = this;
        this.NwfAuthService = NwfAuthService;
        this.$state = $state;
        this.modalService = modalService;
        this.titleService = titleService;
        this.i18NextPipe = i18NextPipe;
        this.showHelp = true;
        this.authToken = null;
        this.resetUsername = null;
        this.isOemVendor = false;
        this.titleElement = null;
        this.username = null;
        this.password = null;
        // Forgot Password is off by default and enabled when I have provided it
        this.hasForgotPassword = false;
        this.hasResetPassword = false;
        this.forgotPasswordMode = false;
        // Reset Password
        this.resetPasswordMode = false;
        this.resetPasswordMatch = true;
        this.cnter = 0;
        this.loadingObs = interval(1000).pipe(map((/**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            _this.cnter++;
            if (_this.cnter > 3) {
                _this.cnter = 0;
            }
            return repeat('.', _this.cnter);
        })));
        this.creds = { username: '', password: '' };
        this.resetCreds = { username: '', newPassword: '', confirmNewPassword: '', authToken: '' };
        this.forgotCreds = { username: '' };
        /* I detect the presence of a forgotPassword and resetPassword methods in the strategy */
        if (NwfAuthService.forgotPassword) {
            this.hasForgotPassword = true;
        }
        if (NwfAuthService.resetPassword) {
            this.hasResetPassword = true;
        }
        this.titleService.setTitle('nwfjs:login');
    }
    /**
     * @return {?}
     */
    LoginComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        // If the server sends a user and authToken, the only use case we have is that user has send a request to reset the password with this URL.
        // Set the boolean to reset password to be true.
        if (this.hasResetPassword && this.resetUsername !== null && this.authToken !== null) {
            this.resetPasswordMode = true;
            this.forgotPasswordMode = false;
            this.resetCreds.authToken = this.authToken;
            this.resetCreds.username = this.resetUsername;
        }
        this.updateHrefs();
    };
    /**
     * @return {?}
     */
    LoginComponent.prototype.authenticate = /**
     * @return {?}
     */
    function () {
        var _this = this;
        this.inFlight = true;
        /** @type {?} */
        var returnToOriginalState = (/**
         * @return {?}
         */
        function () {
            /** @type {?} */
            var state = _this.returnTo.state();
            /** @type {?} */
            var params = _this.returnTo.params();
            /** @type {?} */
            var options = __assign({}, _this.returnTo.options(), { reload: true });
            _this.$state.go(state, params, options);
        });
        /** @type {?} */
        var showError = (/**
         * @param {?} error
         * @return {?}
         */
        function (error) {
            _this.inFlight = false;
            /** @type {?} */
            var errorCode = error.status;
            /** @type {?} */
            var failedModal = _this.modalService.open(NwfConfirmationModalComponent).componentInstance;
            failedModal.title = _this.i18NextPipe.transform('nwfjs:error');
            if (errorCode !== 0) {
                failedModal.message = _this.i18NextPipe.transform('nwfjs:loginFailedAuthenticationFailed');
            }
            else {
                failedModal.message = _this.i18NextPipe.transform('nwfjs:loginFailedUnableAccessServer');
            }
            failedModal.showCancel = false;
            failedModal.status = 'error';
        });
        var _a = this.creds, username = _a.username, password = _a.password;
        this.NwfAuthService.authenticate(username, password)
            .then(returnToOriginalState)
            .catch(showError)
            .then();
    };
    /*
    responsible for having the right links and determining if this is vendorized or not
    */
    /*
        responsible for having the right links and determining if this is vendorized or not
        */
    /**
     * @return {?}
     */
    LoginComponent.prototype.updateHrefs = /*
        responsible for having the right links and determining if this is vendorized or not
        */
    /**
     * @return {?}
     */
    function () {
        /** @type {?} */
        var netappHome = 'http://netapp.com';
        if (!this.homeHref) {
            this.homeHref = netappHome;
        }
        if (!this.supportHref) {
            this.supportHref = 'http://mysupport.netapp.com';
        }
        this.isOemVendor = false;
        if (this.homeHref !== netappHome) {
            this.isOemVendor = true;
        }
    };
    // forgot password on submit.
    // forgot password on submit.
    /**
     * @return {?}
     */
    LoginComponent.prototype.forgotPasswordSubmit = 
    // forgot password on submit.
    /**
     * @return {?}
     */
    function () {
        var _this = this;
        var username = this.forgotCreds.username;
        this.inFlight = true;
        /** @type {?} */
        var showConfirm = (/**
         * @return {?}
         */
        function () {
            _this.inFlight = false;
            /** @type {?} */
            var confirmModalInstance = _this.modalService.open(NwfConfirmationModalComponent).componentInstance;
            confirmModalInstance.title = _this.i18NextPipe.transform('nwfjs:info');
            confirmModalInstance.message = _this.i18NextPipe.transform('nwfjs:loginForgetPasswordResetEmailSent', { username: username });
            confirmModalInstance.showCancel = false;
            confirmModalInstance.status = 'info';
        });
        this.NwfAuthService.forgotPassword(username)
            .then(showConfirm)
            .then(stop, stop);
    };
    // Reset password on submit.
    // Reset password on submit.
    /**
     * @return {?}
     */
    LoginComponent.prototype.resetPasswordSubmit = 
    // Reset password on submit.
    /**
     * @return {?}
     */
    function () {
        var _this = this;
        // Check if passwords match
        this.resetPasswordMatch = true;
        if (this.resetCreds.newPassword !== this.resetCreds.confirmNewPassword) {
            this.resetPasswordMatch = false;
            return;
        }
        this.inFlight = true;
        /** @type {?} */
        var showConfirm = (/**
         * @return {?}
         */
        function () {
            _this.inFlight = false;
            /** @type {?} */
            var resetPasswordConformationModelRef = _this.modalService.open(NwfConfirmationModalComponent);
            resetPasswordConformationModelRef.result.then((/**
             * @return {?}
             */
            function () {
                // after user clicks ok, redirect to home page
                window.location.replace('/');
            }));
            /** @type {?} */
            var confirmModalInstance = resetPasswordConformationModelRef.componentInstance;
            confirmModalInstance.title = _this.i18NextPipe.transform('nwfjs:info');
            confirmModalInstance.message = _this.i18NextPipe.transform('nwfjs:resetPasswordSucceed');
            confirmModalInstance.showCancel = false;
            confirmModalInstance.status = 'info';
        });
        /** @type {?} */
        var showError = (/**
         * @param {?} error
         * @return {?}
         */
        function (error) {
            _this.inFlight = false;
            /** @type {?} */
            var failedModal = _this.modalService.open(NwfConfirmationModalComponent).componentInstance;
            failedModal.title = _this.i18NextPipe.transform('nwfjs:error');
            failedModal.message = _this.i18NextPipe.transform('nwfjs:resetPasswordFailed');
            failedModal.showCancel = false;
            failedModal.status = 'error';
        });
        var _a = this.resetCreds, username = _a.username, newPassword = _a.newPassword;
        this.NwfAuthService.resetPassword(username, newPassword, this.authToken)
            .then(showConfirm)
            .catch(showError)
            .then(stop, stop);
    };
    // Reset password on cancel.
    // Reset password on cancel.
    /**
     * @return {?}
     */
    LoginComponent.prototype.resetPasswordCancelFn = 
    // Reset password on cancel.
    /**
     * @return {?}
     */
    function () {
        window.location.href = document.location.origin;
    };
    /**
     * @return {?}
     */
    LoginComponent.prototype.forgotPasswordClick = /**
     * @return {?}
     */
    function () {
        this.forgotPasswordMode = !this.forgotPasswordMode;
        this.forgotCreds.username = this.creds.username;
    };
    LoginComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-login',
                    template: "<div class=\"nwf-login-overlay\">\n    <div class=\"nwf-login-dialog\">\n    <header class=\"nwf-login-banner-logo\"></header>\n    <div class=\"nwf-login-body\">\n        <h2 class=\"nwf-login-dialog-title-primary\">{{appTitle}}</h2>\n        <h3 class=\"nwf-login-dialog-title-secondary\"></h3>\n        <h5>{{message}}</h5>\n        <!-- Login form -->\n        <form #authForm=\"ngForm\" (ngSubmit)=\"authForm.valid && authenticate()\" *ngIf=\"!forgotPasswordMode && !resetPasswordMode\"\n            id=\"nwf-login-form\" class=\"nwf-validatable\" [ngClass]=\"{'ng-submitted': authForm.submitted }\">\n            <div class=\"form-group l-username\">\n                    <input class=\"nwf-login-input form-control form-control-lg\" name=\"username\" #username=\"ngModel\" [(ngModel)]=\"creds.username\"\n                       [attr.readonly]=\"inFlight || null\" data-netapp-id=\"loginPage-username-input\" autocomplete=\"off\" autofocus required placeholder=\"{{'nwfjs:username' | i18next}}\">\n                    <div *ngIf=\"username.invalid && (authForm.submitted || username.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next}}\n                    </div>\n            </div>\n            <div class=\"form-group\">\n                    <input class=\"nwf-login-input form-control form-control-lg\" type=\"password\" name=\"password\" #password=\"ngModel\" [(ngModel)]=\"creds.password\"\n                        [attr.readonly]=\"inFlight || null\" data-netapp-id=\"loginPage-password-input\" autocomplete=\"off\" placeholder=\"{{'nwfjs:password' | i18next}}\"\n                        required>\n                    <div *ngIf=\"password.invalid && (authForm.submitted || password.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next}}\n                    </div>\n            </div>\n            <div class=\"form-group l-submit-btn mb-0\">\n                <button [attr.type]=\"inFlight ? 'button': 'submit'\" class=\"nwf-login-input btn btn-primary btn-lg position-relative d-inline-block\"\n                    data-netapp-id=\"loginPage-signIn-button\">\n                    <div>{{'nwfjs:signIn' | i18next}} <span class=\"loading position-absolute\" [hidden]=\"!inFlight\">{{loadingObs | async}}</span></div>\n                </button>\n            </div>\n            <p *ngIf=\"hasForgotPassword\" class=\"nwf-login-forgot\">\n                <a class=\"nwf-is-link-like\" (click)=\"forgotPasswordClick()\" data-netapp-id=\"loginPage-forgot-password-link\">{{'nwfjs:forgetPassword' | i18next}}</a>\n            </p>\n        </form>\n\n        <!-- Forgot Password Form -->\n        <form #forgotFrm=\"ngForm\" class=\"nwf-validatable\" *ngIf=\"forgotPasswordMode\" (ngSubmit)=\"forgotFrm.valid && forgotPasswordSubmit()\" [ngClass]=\"{'ng-submitted': forgotFrm.submitted }\">\n\n            <div class=\"nwf-forgot-password-title-panel\">\n                <div class=\"nwf-forgot-password-text\" data-netapp-id=\"loginPage-forgot-password-text\">\n                    <h4>{{'nwfjs:enterResetUsername' | i18next}}</h4>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                    <input class=\"nwf-login-input form-control form-control-lg\" name=\"username\" #username=\"ngModel\" [(ngModel)]=\"forgotCreds.username\"\n                        data-netapp-id=\"loginPage-username-input\" autocomplete=\"off\" placeholder=\"{{'nwfjs:usernameToReset' | i18next}}\"\n                        required>\n                    <div *ngIf=\"username.invalid && (forgotFrm.submitted || username.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n            </div>\n            <div class=\"form-group\">\n            <!-- Submit/Cancel for Forgot Password  -->\n            <div class=\"nwf-login-row\">\n                <div class=\"nwf-login-button-panel\">\n                    <button class=\"btn btn-primary mr-2\" data-netapp-id=\"forgotPassword-submit-button\">{{'nwfjs:submit' | i18next}}</button>\n                    <button class=\"btn btn-secondary\" (click)=\"forgotPasswordMode = false\" data-netapp-id=\"forgotPassword-cancel-button\" type=\"button\">{{'nwfjs:cancel' | i18next}}</button>\n                </div>\n            </div>\n            </div>\n        </form>\n\n        <!-- Reset password Form -->\n        <form #resetFrm=\"ngForm\"  *ngIf=\"resetPasswordMode\" (ngSubmit)=\"resetFrm.valid && resetPasswordSubmit()\" [ngClass]=\"{'ng-submitted': resetFrm.submitted }\">\n\n            <dl>\n                <dt>{{'nwfjs:currentUsername' | i18next}}</dt>\n                <dd>\n                    <input class=\"nwf-login-input form-control form-control-lg\" name=\"username\" #username=\"ngModel\" autocomplete=\"off\" [(ngModel)]=\"resetCreds.username\"\n                        data-netapp-id=\"loginPage-username-input\" title=\"{{'nwfjs:usernameCannotChange' | i18next}}\" required disabled=\"true\">\n                    <div *ngIf=\"username.invalid && (resetFrm.submitted || username.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n                </dd>\n                <dt>{{'nwfjs:newPassword' | i18next}}</dt>\n                <dd>\n                    <input class=\"nwf-login-input form-control form-control-lg\" autocomplete=\"off\" name=\"newPassword\" #newPassword=\"ngModel\"\n                        type=\"password\" [(ngModel)]=\"resetCreds.newPassword\" data-netapp-id=\"loginPage-new-password-input\" placeholder=\"{{'nwfjs:typeNewPassword' | i18next}}\" required>\n                    <div *ngIf=\"newPassword.invalid && (resetFrm.submitted || newPassword.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n                </dd>\n                <dt>{{'nwfjs:confirmNewPassword' | i18next}}</dt>\n                <dd>\n                    <input class=\"nwf-login-input form-control form-control-lg\" autocomplete=\"off\" name=\"confirmNewPassword\" #confirmNewPassword=\"ngModel\"\n                        type=\"password\" [(ngModel)]=\"resetCreds.confirmNewPassword\" name=\"confirmNewPassword\" data-netapp-id=\"loginPage-confirm-new-password-input\"\n                        placeholder=\"{{'nwfjs:typeNewPasswordAgain' | i18next}}\" required>\n                    <div *ngIf=\"confirmNewPassword.invalid && (resetFrm.submitted || confirmNewPassword.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n                    <div *ngIf=\"!resetPasswordMatch\" class=\"invalid-feedback\">\n                        {{'nwfjs:changePasswordNotMatch' | i18next}}\n                    </div>\n                </dd>\n            </dl>\n\n            <div class=\"nwf-login-button-panel\">\n                <button class=\"btn btn-primary mr-2\" data-netapp-id=\"resetPassword-submit-button\">{{'nwfjs:submit' | i18next}}</button>\n                <button class=\"btn btn-secondary\" data-netapp-id=\"resetPassword-cancel-button\" (click)=\"resetPasswordCancelFn()\" type=\"button\">{{'nwfjs:cancel' | i18next}}</button>\n            </div>\n        </form>\n    </div>\n    <footer class=\"nwf-login-links\">\n        <!-- support -->\n        <a *ngIf=\"!isOemVendor\" [href]=\"supportHref\" target=\"_blank\" data-netapp-id=\"support-link\">{{'nwfjs:netappSupport' | i18next}}</a>\n        <a *ngIf=\"isOemVendor\" [href]=\"supportHref\" target=\"_blank\" data-netapp-id=\"support-link\">{{supportLabel}}</a>\n        <span *ngIf=\"showHelp\">&nbsp;|&nbsp;</span>\n        <!-- help -->\n        <a *ngIf=\"showHelp\" nwf-help showIcon=\"false\" class=\"nwf-is-link-like\" data-netapp-id=\"help-link\">{{'nwfjs:help' | i18next}}</a>\n        <!-- home -->\n        &nbsp;|&nbsp;\n        <a *ngIf=\"!isOemVendor\" href=\"http://netapp.com\" target=\"_blank\" data-netapp-id=\"home-link\">{{'nwfjs:netapp' | i18next}}</a>\n        <a *ngIf=\"isOemVendor\" [href]=\"homeHref\" target=\"_blank\"  data-netapp-id=\"home-link\">{{homeLabel}}</a>\n    </footer>\n    </div>\n</div>",
                    styles: ["nwf-login{width:100%;height:100%;top:0;background-repeat:no-repeat;background-size:cover;display:flex;justify-content:center;align-items:flex-start}.nwf-login-dialog{padding:40px 40px 25px}.l-username{margin-top:2rem}.l-submit-btn{margin-top:2.5rem}h2{font-size:26px;color:#131313}#nwf-login-form[ng-reflect-klass]{margin-top:20px}#nwf-login-form[ng-reflect-klass] dd{margin-bottom:1.2rem}.nwf-login-banner-logo{background-image:url(data:image/png;base64,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);width:100%;background-repeat:no-repeat;height:24px;align-self:flex-start;margin-bottom:10px}.nwf-login-dialog-title-primary{font-size:24px;margin-top:0;margin-bottom:10px}.nwf-login-input{width:100%;margin:5px 0}.nwf-login-forgot{margin:5px 0;align-self:flex-end}.nwf-login-links{margin-top:10px;text-align:center}.nwf-login-overlay{width:100%;position:fixed;left:0;top:0;z-index:1049;height:100%}.nwf-login-button-panel{display:block;text-align:right}"]
                }] }
    ];
    /** @nocollapse */
    LoginComponent.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: Inject, args: ['NwfAuthService',] }] },
        { type: StateService },
        { type: NgbModal },
        { type: NwfTitleService },
        { type: I18NextPipe }
    ]; };
    LoginComponent.propDecorators = {
        returnTo: [{ type: Input }],
        appTitle: [{ type: Input }],
        supportHref: [{ type: Input }],
        supportLabel: [{ type: Input }],
        helpHref: [{ type: Input }],
        helpLabel: [{ type: Input }],
        homeHref: [{ type: Input }],
        homeLabel: [{ type: Input }],
        showHelp: [{ type: Input }],
        authToken: [{ type: Input }],
        resetUsername: [{ type: Input }]
    };
    return LoginComponent;
}());
if (false) {
    /** @type {?} */
    LoginComponent.prototype.returnTo;
    /** @type {?} */
    LoginComponent.prototype.appTitle;
    /** @type {?} */
    LoginComponent.prototype.supportHref;
    /** @type {?} */
    LoginComponent.prototype.supportLabel;
    /** @type {?} */
    LoginComponent.prototype.helpHref;
    /** @type {?} */
    LoginComponent.prototype.helpLabel;
    /** @type {?} */
    LoginComponent.prototype.homeHref;
    /** @type {?} */
    LoginComponent.prototype.homeLabel;
    /** @type {?} */
    LoginComponent.prototype.showHelp;
    /** @type {?} */
    LoginComponent.prototype.authToken;
    /** @type {?} */
    LoginComponent.prototype.resetUsername;
    /** @type {?} */
    LoginComponent.prototype.isOemVendor;
    /** @type {?} */
    LoginComponent.prototype.homeVendorHref;
    /** @type {?} */
    LoginComponent.prototype.titleElement;
    /** @type {?} */
    LoginComponent.prototype.username;
    /** @type {?} */
    LoginComponent.prototype.password;
    /** @type {?} */
    LoginComponent.prototype.hasForgotPassword;
    /** @type {?} */
    LoginComponent.prototype.hasResetPassword;
    /** @type {?} */
    LoginComponent.prototype.forgotPasswordMode;
    /** @type {?} */
    LoginComponent.prototype.newPassword;
    /** @type {?} */
    LoginComponent.prototype.confirmPassword;
    /** @type {?} */
    LoginComponent.prototype.confirmNewPassword;
    /** @type {?} */
    LoginComponent.prototype.message;
    /** @type {?} */
    LoginComponent.prototype.success;
    /** @type {?} */
    LoginComponent.prototype.resetPasswordMode;
    /** @type {?} */
    LoginComponent.prototype.resetPasswordMatch;
    /** @type {?} */
    LoginComponent.prototype.cnter;
    /** @type {?} */
    LoginComponent.prototype.loadingObs;
    /** @type {?} */
    LoginComponent.prototype.errorCode;
    /** @type {?} */
    LoginComponent.prototype.inFlight;
    /** @type {?} */
    LoginComponent.prototype.creds;
    /** @type {?} */
    LoginComponent.prototype.resetCreds;
    /** @type {?} */
    LoginComponent.prototype.forgotCreds;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.NwfAuthService;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.$state;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.modalService;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.titleService;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.i18NextPipe;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var LogoutComponent = /** @class */ (function () {
    function LogoutComponent(NwfAuthService, modalService, $state, i18NextPipe) {
        this.NwfAuthService = NwfAuthService;
        this.modalService = modalService;
        this.$state = $state;
        this.i18NextPipe = i18NextPipe;
    }
    /**
     * @return {?}
     */
    LogoutComponent.prototype.logout = /**
     * @return {?}
     */
    function () {
        var _this = this;
        /** @type {?} */
        var showError = (/**
         * @return {?}
         */
        function () {
            /** @type {?} */
            var failedModal = _this.modalService.open(NwfConfirmationModalComponent).componentInstance;
            failedModal.title = _this.i18NextPipe.transform('nwfjs:error');
            failedModal.messageTemplate = _this.failedMsg;
            failedModal.showCancel = false;
            failedModal.status = 'error';
        });
        /** @type {?} */
        var returnToOriginalState = (/**
         * @return {?}
         */
        function () {
            _this.$state.go(_this.returnState, undefined, { location: false });
        });
        return this.NwfAuthService.logout().then(returnToOriginalState).catch(showError);
    };
    LogoutComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-logout',
                    host: {
                        'class': 'dropdown-item',
                        'data-netapp-id': 'nav-logOut-link',
                    },
                    template: "\n{{'nwfjs:logout' | i18next}}\n<ng-template #failedMsg>\n<strong>{{'nwfjs:logoutFailed' | i18next}}</strong>\n<br>\n<p>{{'nwfjs:logoutSignOutNow' | i18next}}</p>\n</ng-template>\n  "
                }] }
    ];
    /** @nocollapse */
    LogoutComponent.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: Inject, args: ['NwfAuthService',] }] },
        { type: NgbModal },
        { type: StateService$1 },
        { type: I18NextPipe }
    ]; };
    LogoutComponent.propDecorators = {
        returnState: [{ type: Input }],
        failedMsg: [{ type: ViewChild, args: ['failedMsg', { static: false },] }],
        logout: [{ type: HostListener, args: ['click',] }]
    };
    return LogoutComponent;
}());
if (false) {
    /** @type {?} */
    LogoutComponent.prototype.returnState;
    /** @type {?} */
    LogoutComponent.prototype.failedMsg;
    /**
     * @type {?}
     * @private
     */
    LogoutComponent.prototype.NwfAuthService;
    /**
     * @type {?}
     * @private
     */
    LogoutComponent.prototype.modalService;
    /**
     * @type {?}
     * @private
     */
    LogoutComponent.prototype.$state;
    /**
     * @type {?}
     * @private
     */
    LogoutComponent.prototype.i18NextPipe;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var MainbodyComponent = /** @class */ (function () {
    function MainbodyComponent(leftnavService) {
        this.leftnavService = leftnavService;
        this.top = '53px';
        this.asideWidth = '300px';
        this.leftnavWidth = '200px';
        this.isLeftnavVisible = true;
        this.isAsideVisible = false;
        this.leftnavConfig = null;
        this.zeroPx = '0px';
    }
    Object.defineProperty(MainbodyComponent.prototype, "mainPaddingTop", {
        get: /**
         * @private
         * @return {?}
         */
        function () {
            return parseInt(this.top) + 15 + 'px';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MainbodyComponent.prototype, "mainMarginLeft", {
        get: /**
         * @private
         * @return {?}
         */
        function () {
            /** @type {?} */
            var marginLeft = this.zeroPx;
            if (this.isLeftnavVisible) {
                marginLeft = this.leftnavWidth;
            }
            return marginLeft;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MainbodyComponent.prototype, "mainMarginRight", {
        get: /**
         * @private
         * @return {?}
         */
        function () {
            /** @type {?} */
            var marginRight = this.zeroPx;
            if (this.isAsideVisible) {
                marginRight = this.asideWidth;
            }
            return marginRight;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @return {?}
     */
    MainbodyComponent.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        if (this.subscription) {
            this.subscription.unsubscribe();
        }
    };
    /**
     * @return {?}
     */
    MainbodyComponent.prototype.ngOnChanges = /**
     * @return {?}
     */
    function () {
        this.setStyles();
    };
    /**
     * @return {?}
     */
    MainbodyComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        this.setStyles();
        this.subscription = this.leftnavService.leftNav$.subscribe((/**
         * @param {?} hideLeftNav
         * @return {?}
         */
        function (hideLeftNav) {
            /** @type {?} */
            var isLeftnavVisible = true;
            if (hideLeftNav) {
                isLeftnavVisible = false;
            }
            _this.isLeftnavVisible = isLeftnavVisible;
            _this.setStyles();
        }));
    };
    /**
     * @private
     * @return {?}
     */
    MainbodyComponent.prototype.setStyles = /**
     * @private
     * @return {?}
     */
    function () {
        this.mainStyles = { marginLeft: this.mainMarginLeft, marginRight: this.mainMarginRight, paddingTop: this.mainPaddingTop };
        this.sidebarStyles = { paddingTop: this.top, width: this.leftnavWidth };
        this.asideStyles = { paddingTop: this.top, width: this.asideWidth };
    };
    MainbodyComponent.decorators = [
        { type: Component, args: [{
                    template: "\n    <div class=\"l-nwf-mainbody\" [ngClass]=\"{ 'leftnav-is-open': isLeftnavVisible }\">\n      <nwf-page-alert></nwf-page-alert>\n      <nav class=\"nwf-sidebar\" [hidden]=\"!isLeftnavVisible\" [ngStyle]=\"sidebarStyles\">\n        <ng-content *ngIf=\"!leftnavConfig\" select=\"nwf-left-nav\"></ng-content>\n        <nwf-left-nav *ngIf=\"leftnavConfig\" [navData]=\"leftnavConfig\"></nwf-left-nav>\n      </nav>\n      <main class=\"px-4\" [ngStyle]=\"mainStyles\" ui-view></main>\n      <aside class=\"\" [hidden]=\"!isAsideVisible\" [ngStyle]=\"asideStyles\"><ng-content select=\".aside\"></ng-content></aside>\n    </div>\n  ",
                    selector: 'nwf-mainbody',
                    host: {
                        class: 'w-100',
                    },
                    styles: [".nwf-sidebar{position:fixed;top:0;bottom:0;left:0;z-index:100;background-color:#0a2d6c;box-shadow:3px 0 0 0 rgba(0,0,0,.1)}aside{position:fixed;top:0;bottom:0;right:0;background-color:#0a2d6c}[hidden]{display:none!important}"]
                }] }
    ];
    /** @nocollapse */
    MainbodyComponent.ctorParameters = function () { return [
        { type: NwfLeftnavService }
    ]; };
    MainbodyComponent.propDecorators = {
        top: [{ type: Input }],
        asideWidth: [{ type: Input }],
        leftnavWidth: [{ type: Input }],
        isLeftnavVisible: [{ type: Input }],
        isAsideVisible: [{ type: Input }],
        leftnavConfig: [{ type: Input }]
    };
    return MainbodyComponent;
}());
if (false) {
    /** @type {?} */
    MainbodyComponent.prototype.top;
    /** @type {?} */
    MainbodyComponent.prototype.asideWidth;
    /** @type {?} */
    MainbodyComponent.prototype.leftnavWidth;
    /** @type {?} */
    MainbodyComponent.prototype.isLeftnavVisible;
    /** @type {?} */
    MainbodyComponent.prototype.isAsideVisible;
    /** @type {?} */
    MainbodyComponent.prototype.leftnavConfig;
    /** @type {?} */
    MainbodyComponent.prototype.mainStyles;
    /** @type {?} */
    MainbodyComponent.prototype.asideStyles;
    /** @type {?} */
    MainbodyComponent.prototype.sidebarStyles;
    /** @type {?} */
    MainbodyComponent.prototype.subscription;
    /**
     * @type {?}
     * @private
     */
    MainbodyComponent.prototype.zeroPx;
    /** @type {?} */
    MainbodyComponent.prototype.leftnavService;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfShellModule = /** @class */ (function () {
    function NwfShellModule() {
    }
    NwfShellModule.decorators = [
        { type: NgModule, args: [{
                    imports: [
                        DxTemplateModule,
                        DxPopoverModule,
                        DxScrollViewModule,
                        CommonModule,
                        FormsModule,
                        NgbCollapseModule,
                        NgbModalModule,
                        NwfjsSharedComponentsModule,
                        I18NextModule,
                        UIRouterModule,
                    ],
                    providers: [NwfLeftnavService, NwfTitleService],
                    declarations: [
                        GlobalnavComponent,
                        AppTitleComponent,
                        GlobalnavPrimaryComponent,
                        GlobalnavPrimaryCenterComponent,
                        GlobalnavPrimaryToolsComponent,
                        GlobalSearchComponent,
                        AboutComponent,
                        AboutModalComponent,
                        LeftnavComponent,
                        LeftnavItemComponent,
                        LoginComponent,
                        LogoutComponent,
                        MainbodyComponent,
                    ],
                    entryComponents: [
                        AboutModalComponent,
                        MainbodyComponent,
                        LeftnavComponent,
                    ],
                    exports: [
                        GlobalnavComponent,
                        AppTitleComponent,
                        GlobalnavPrimaryComponent,
                        GlobalnavPrimaryCenterComponent,
                        GlobalnavPrimaryToolsComponent,
                        GlobalSearchComponent,
                        AboutComponent,
                        LeftnavComponent,
                        LoginComponent,
                        LogoutComponent,
                        MainbodyComponent,
                    ],
                },] }
    ];
    return NwfShellModule;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfjsConfigService = /** @class */ (function () {
    function NwfjsConfigService(config) {
        this.appTitle = '';
        if (config) {
            this.appTitle = config.appTitle || this.appTitle;
            this.beaconInterval = config.beaconInterval || this.beaconInterval;
        }
    }
    /** @nocollapse */
    NwfjsConfigService.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: Optional }] }
    ]; };
    return NwfjsConfigService;
}());
if (false) {
    /** @type {?} */
    NwfjsConfigService.prototype.appTitle;
    /** @type {?} */
    NwfjsConfigService.prototype.beaconInterval;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfjsComponentsModule = /** @class */ (function () {
    function NwfjsComponentsModule() {
    }
    /**
     * @param {?} config
     * @return {?}
     */
    NwfjsComponentsModule.forRoot = /**
     * @param {?} config
     * @return {?}
     */
    function (config) {
        return {
            ngModule: NwfServicesModule,
            providers: [
                { provide: NwfjsConfigService, useValue: config },
            ],
        };
    };
    NwfjsComponentsModule.decorators = [
        { type: NgModule, args: [{
                    imports: [
                        NwfShellModule,
                        NwfGridModule,
                        NwfServicesModule,
                        NwfFormModule,
                        NwfjsSharedComponentsModule,
                        NwfjsSharedPipesModule,
                    ],
                    exports: [
                        NwfShellModule,
                        NwfGridModule,
                        NwfServicesModule,
                        NwfFormModule,
                        NwfjsSharedComponentsModule,
                        NwfjsSharedPipesModule,
                    ],
                },] }
    ];
    return NwfjsComponentsModule;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/** @type {?} */
var ANALYTICS_CONFIG = new InjectionToken('nwfAnalyticsConfig');
var AnalyticsInjectorService = /** @class */ (function () {
    function AnalyticsInjectorService(config, authService) {
        var _this = this;
        this.config = config;
        if (authService) {
            ((/** @type {?} */ (authService.isAuthenticated$()))).pipe(filter$1((/**
             * @param {?} value
             * @return {?}
             */
            function (value) { return value; })), first()).subscribe((/**
             * @return {?}
             */
            function () {
                _this.injectMatomo();
            }));
        }
        else {
            this.injectMatomo();
        }
    }
    /**
     * @private
     * @return {?}
     */
    AnalyticsInjectorService.prototype.injectMatomo = /**
     * @private
     * @return {?}
     */
    function () {
        var _a = this.config, url = _a.url, src = _a.src;
        window['_paq'] = window['_paq'] || [];
        window['_paq'].push(['enableLinkTracking']);
        ((/**
         * @return {?}
         */
        function () {
            /** @type {?} */
            var d = document;
            window['_paq'].push(['setTrackerUrl', url]);
            window['_paq'].push(['setSiteId', 1]);
            /** @type {?} */
            var g = d.createElement('script');
            /** @type {?} */
            var s = d.getElementsByTagName('script')[0];
            g.type = 'text/javascript';
            g.async = true;
            g.defer = true;
            g.src = src;
            s.parentNode.insertBefore(g, s);
        }))();
    };
    AnalyticsInjectorService.decorators = [
        { type: Injectable }
    ];
    /** @nocollapse */
    AnalyticsInjectorService.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: Inject, args: [ANALYTICS_CONFIG,] }] },
        { type: undefined, decorators: [{ type: Optional }, { type: Inject, args: ['NwfAuthService',] }] }
    ]; };
    return AnalyticsInjectorService;
}());
if (false) {
    /**
     * @type {?}
     * @private
     */
    AnalyticsInjectorService.prototype.config;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfjsAnalyticsModule = /** @class */ (function () {
    function NwfjsAnalyticsModule(analyticsInjectorService) {
    }
    /**
     * @param {?} config
     * @return {?}
     */
    NwfjsAnalyticsModule.forRoot = /**
     * @param {?} config
     * @return {?}
     */
    function (config) {
        return {
            ngModule: NwfjsAnalyticsModule,
            providers: [
                {
                    provide: ANALYTICS_CONFIG,
                    useValue: config,
                },
                AnalyticsInjectorService,
            ],
        };
    };
    NwfjsAnalyticsModule.decorators = [
        { type: NgModule, args: [{},] }
    ];
    /** @nocollapse */
    NwfjsAnalyticsModule.ctorParameters = function () { return [
        { type: AnalyticsInjectorService }
    ]; };
    return NwfjsAnalyticsModule;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
var NwfGridSchemaProcessor = /** @class */ (function () {
    function NwfGridSchemaProcessor(schemaObject, schemaIdToDxColumn, customSchemaTypeToDxColumn) {
        /* First, we take the schemaIdToDxColumn and mix it over our own standard definition ,
            so we allow the user to provide us with custom schemaType to DxColumns,
            but we also handle a standard dataType provided by nwf, to make it easy.
            Note: this schemaTypeToDxColumn we have in this class is married to um's ftm.
        */
        if (schemaIdToDxColumn === void 0) { schemaIdToDxColumn = {}; }
        this.columns = [];
        this.filterableColumns = [];
        this.schemaTypeToDxColumn = {
            dateTime: NwfDateColumn,
            metric: NwfMetricColumn,
            number: NwfNumberColumn,
        };
        for (var columnId in schemaObject) {
            if (schemaObject.hasOwnProperty(columnId)) {
                /** @type {?} */
                var schemaProp = schemaObject[columnId];
                /** @type {?} */
                var hasMatchingId = columnId in schemaIdToDxColumn ? true : false;
                // updating schemaTypeToDxColumn mapping.
                this.schemaTypeToDxColumn = assign({}, this.schemaTypeToDxColumn, customSchemaTypeToDxColumn);
                /** @type {?} */
                var hasMatchingType = schemaProp.type in this.schemaTypeToDxColumn ? true : false;
                /** @type {?} */
                var dxColumnObject = void 0;
                /* First I see if the id has an associated columnId from the caller's schemaIdToDxColumn map.
                    This is because I want to allow the user to easily customize the cell based on the id.
                    for example, they tell me how to render a clusterObject. If it has a matching id, it wins over the nwf
                    mapped type.
                */
                if (hasMatchingId) {
                    dxColumnObject = new schemaIdToDxColumn[schemaProp.id](schemaProp);
                }
                else if (hasMatchingType) {
                    /* There is no matching Id, so I next try to create a column based on the schemaProp's type.
                        This is so I can best render a column's value based on the type (date, number) to a nice i18n default.
                    */
                    dxColumnObject = new this.schemaTypeToDxColumn[schemaProp.type](schemaProp);
                }
                else {
                    /* now I dont know */
                    dxColumnObject = new NwfSchemaColumn(schemaProp);
                }
                this.columns.push(dxColumnObject);
                // finding all filterable properties.
                if (schemaProp.filterable) {
                    this.filterableColumns.push(schemaProp);
                }
            }
        }
    }
    return NwfGridSchemaProcessor;
}());
if (false) {
    /** @type {?} */
    NwfGridSchemaProcessor.prototype.columns;
    /** @type {?} */
    NwfGridSchemaProcessor.prototype.filterableColumns;
    /**
     * @type {?}
     * @private
     */
    NwfGridSchemaProcessor.prototype.schemaTypeToDxColumn;
}
var NwfSchemaColumn = /** @class */ (function (_super) {
    __extends(NwfSchemaColumn, _super);
    function NwfSchemaColumn(schemaProp) {
        var _this = _super.call(this) || this;
        _this.allowHeaderFiltering = false;
        _this.visible = true;
        _this.allowFiltering = true;
        _this.allowSorting = true;
        _this.allowHiding = true;
        _this.allowReordering = true;
        _this.cellTemplate = 'nwfDefaultCellTemplate';
        var id = schemaProp.id, label = schemaProp.label, type = schemaProp.type, options = schemaProp.options, visible = schemaProp.visible;
        // the dataField is how dx identifies the column, for us it is the same as the id, name is needed because that is how
        // we identify the column by name later to set options.
        _this.name = _this.dataField = id;
        // set a descriptive or friendly name for the column.
        _this.caption = label;
        // our type field is pretty close to the default dataTypes (which are just lowercased strings)
        // this can be improved if we have other types, but I bet it will work.
        _this.dataType = type.toLowerCase();
        // we allow search only for columns having 'resource','string', or associatedObjects dataType;
        _this.allowSearch = ['resource', 'string', 'associatedObjects'].indexOf(_this.dataType) !== -1;
        _this.allowFiltering = get(schemaProp, 'filterable', _this.allowFiltering);
        _this.allowSorting = get(schemaProp, 'sortable', _this.allowSorting);
        _this.allowReordering = get(schemaProp, 'allowReordering', _this.allowReordering);
        // editorOptions becomes options for 'enum-single' and 'enum-multiple' values.
        _this.editorOptions = options;
        _this.showInColumnChooser = visible;
        return _this;
    }
    return NwfSchemaColumn;
}(DxiDataGridColumn));
if (false) {
    /** @type {?} */
    NwfSchemaColumn.prototype.allowHeaderFiltering;
    /** @type {?} */
    NwfSchemaColumn.prototype.visible;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowFiltering;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowSorting;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowHiding;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowReordering;
    /** @type {?} */
    NwfSchemaColumn.prototype.cellTemplate;
    /** @type {?} */
    NwfSchemaColumn.prototype._optionPath;
}
var NwfNumberColumn = /** @class */ (function (_super) {
    __extends(NwfNumberColumn, _super);
    function NwfNumberColumn(schemaProp) {
        var _this = _super.call(this, schemaProp) || this;
        _this.cellTemplate = 'nwfNumberCellTemplate';
        return _this;
    }
    return NwfNumberColumn;
}(NwfSchemaColumn));
if (false) {
    /** @type {?} */
    NwfNumberColumn.prototype.cellTemplate;
}
var NwfMetricColumn = /** @class */ (function (_super) {
    __extends(NwfMetricColumn, _super);
    function NwfMetricColumn(schemaProp) {
        var _this = _super.call(this, schemaProp) || this;
        _this.cellTemplate = 'nwfMetricCellTemplate';
        _this.unit = schemaProp.unit;
        return _this;
    }
    return NwfMetricColumn;
}(NwfSchemaColumn));
if (false) {
    /** @type {?} */
    NwfMetricColumn.prototype.cellTemplate;
    /** @type {?} */
    NwfMetricColumn.prototype.unit;
}
var NwfDateColumn = /** @class */ (function (_super) {
    __extends(NwfDateColumn, _super);
    function NwfDateColumn(schemaProp) {
        var _this = _super.call(this, schemaProp) || this;
        _this.cellTemplate = 'nwfDateCellTemplate';
        return _this;
    }
    return NwfDateColumn;
}(NwfSchemaColumn));
if (false) {
    /** @type {?} */
    NwfDateColumn.prototype.cellTemplate;
}
var NwfStatusColumn = /** @class */ (function (_super) {
    __extends(NwfStatusColumn, _super);
    // creating a cell template based on UX requirements.
    function NwfStatusColumn(schemaProp) {
        var _this = _super.call(this, schemaProp) || this;
        _this.alignment = 'center';
        _this.width = 80;
        _this.cellTemplate = 'nwfStatusCellTemplate';
        _this.calculateSortValue = (/**
         * @param {?} __0
         * @return {?}
         */
        function (_a) {
            var status = _a.status;
            // we assign 'z' to critical so that it shows as first,last when sorted alphabettically
            // for possible status values.
            if (status.toLowerCase() === 'critical') {
                status = 'z'; // Critical are always displayed at the top
            }
            return status;
        });
        return _this;
    }
    return NwfStatusColumn;
}(NwfSchemaColumn));
if (false) {
    /** @type {?} */
    NwfStatusColumn.prototype.alignment;
    /** @type {?} */
    NwfStatusColumn.prototype.width;
    /** @type {?} */
    NwfStatusColumn.prototype.cellTemplate;
    /** @type {?} */
    NwfStatusColumn.prototype.calculateSortValue;
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */

export { APP_TITLE_ROOT, LoginComponent, NwfBeaconConfig, NwfBeaconService, NwfColumnsChangingService, NwfConfirmationModalComponent, NwfDateColumn, NwfElipsizerResizeService, NwfFilterComponent, NwfGridOptionsService, NwfGridSchemaProcessor, NwfHelpConfig, LeftnavComponent as NwfLeftnavComponent, NwfLeftnavService, MainbodyComponent as NwfMainbodyComponent, NwfMetricColumn, NwfNumberColumn, NwfPageAlertService, NwfRoundUnit, NwfSchemaColumn, NwfStatusColumn, NwfTakeoverModalService, NwfTitleService, NwfjsAnalyticsModule, NwfjsComponentsModule, NwfjsConfigService, NwfShellModule as ɵa, NwfjsSharedComponentsModule as ɵb, LogoutComponent as ɵba, NwfGridModule as ɵbb, NwfFormModule as ɵbc, NwfjsSharedPipesModule as ɵbd, StripWhitespacePipe as ɵbe, MultiselectDropdownComponent as ɵbf, NwfDatetimePicker as ɵbg, NwfDatetimeRangePicker as ɵbh, SearchComponent as ɵbi, ColumnVisibilityComponent as ɵbj, FilterMultiselectComponent as ɵbk, FilterCriterionRowComponent as ɵbl, NwfFilterCriterionDateComponent as ɵbm, FooterComponent as ɵbn, CellsComponent as ɵbo, CellHeaderComponent as ɵbp, NwfServicesModule as ɵbq, ANALYTICS_CONFIG as ɵbr, AnalyticsInjectorService as ɵbs, IconComponent as ɵc, HelpDirective as ɵd, HelpService as ɵe, AlertComponent as ɵf, PageAlertComponent as ɵg, NwfElipsizer as ɵh, HeaderComponent as ɵi, NwfPropertySheet as ɵj, NwfDismissButton as ɵk, NwfPopoverTitle as ɵl, NwfProperty as ɵm, HorizontalBarChartComponent as ɵn, NwfProgressBarComponent as ɵo, NwfLoadIndicatorComponent as ɵp, StackedChartComponent as ɵq, GlobalnavComponent as ɵr, AppTitleComponent as ɵs, GlobalnavPrimaryComponent as ɵt, GlobalnavPrimaryCenterComponent as ɵu, GlobalnavPrimaryToolsComponent as ɵv, GlobalSearchComponent as ɵw, AboutComponent as ɵx, AboutModalComponent as ɵy, LeftnavItemComponent as ɵz };
//# sourceMappingURL=netapp-nwfjs_angular_components.js.map
