/**
 * Sets the date and time value as provided by the user.
 * When the user selects a date or time using this datetimepicker, setDateTime is called and the value is setted.
 */
import { OnChanges, OnInit, SimpleChanges } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { NgbDateStruct, NgbTimeStruct } from '@ng-bootstrap/ng-bootstrap';
export declare class NwfDatetimePicker implements OnInit, OnChanges, ControlValueAccessor {
    minDate?: NgbDateStruct;
    maxDate?: NgbDateStruct;
    datepickerModel: NgbDateStruct;
    timepickerModel: NgbTimeStruct;
    navigation: string;
    startDate: any;
    private _onChange;
    ngOnInit(): void;
    /**
     * Sets the min and max date for the widget. By default, minDate is the exact 13 months ago date and maxDate is the current date.
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @param changes - SimpleChanges
     * @returns void
     */
    ngOnChanges(changes: SimpleChanges): void;
    /**
     *
     * writeValue() - Sets the datepickerModel, timePickerModel and startDate according to the date passed in the argument of the function.
     * @param datetimePickerValue - string
     * @returns void
     */
    writeValue(datetimePickerValue: string): void;
    registerOnChange(fn: any): void;
    registerOnTouched(fn: any): void;
    setDatetime(): void;
}
